﻿using System;
using Ivi.Driver;
using Vitrek.DLSeries;

namespace DLSeriesDLSeriesExampleApp
{
    class Program
    {
        public static void Main(string[] args)
        {
            using (var driver = new DLSeries(
                resourceName: "<TODO - your resource name>",
                idQuery: true,
                reset: true,
                options: "QueryInstrStatus=true, Simulate=false, DriverSetup= Model=DLSeries"))

            {
                // Print driver identity information
                //
                Console.WriteLine("Identifier: {0}", driver.Identity.Identifier);
                Console.WriteLine("Revision: {0}", driver.Identity.Revision);
                Console.WriteLine("Vendor: {0}", driver.Identity.Vendor);
                Console.WriteLine("InstrumentModel: {0}", driver.Identity.InstrumentModel);
                Console.WriteLine("InstrumentFirmwareRevision: {0}", driver.Identity.InstrumentFirmwareRevision);
                Console.WriteLine("InstrumentManufacturer: {0}", driver.Identity.InstrumentManufacturer);

                //
                // TODO: Exercise the driver here.
                //

                // Check instrument for errors
                //
                ErrorQueryResult result;
                Console.WriteLine();
                do
                {
                    result = driver.Utility.ErrorQuery();
                    Console.WriteLine("ErrorQuery: {0}, {1}", result.Code, result.Message);
                } while (result.Code != 0);
            }

            Console.WriteLine("Done - Press Enter to Exit");
            Console.ReadLine();
        }
    }
}
