/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class V7xTesterSettings_Edit {
    private static Group grpx;
    private static Button btnArcDetect;
    private static Text txtArcLevel;
    private static Label lblArcMa;
    private static Combo comboAcFrequency;
    private static Combo comboRampDown;
    private static Combo comboOnFail;
    private static Combo comboIrEndOn;

    public static Composite editor(Composite parent, V7xTesterSettings settings) {
        Composite edit_space = new Composite(parent, 0);
        edit_space.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpx = new Group(edit_space, 0);
        grpx.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpx.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpx.setText("V7x Settiings");
        grpx.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpx.setBounds(26, 10, 501, 287);
        Label lblAcFrequency = new Label((Composite)grpx, 0);
        lblAcFrequency.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        lblAcFrequency.setBounds(10, 42, 97, 27);
        lblAcFrequency.setText("AC Frequency");
        comboAcFrequency = new Combo((Composite)grpx, 0);
        comboAcFrequency.setToolTipText("Configures the AC frequency; applies to all ACW and GB test steps.");
        comboAcFrequency.setItems(new String[]{"60Hz", "50Hz"});
        comboAcFrequency.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        comboAcFrequency.setBounds(119, 39, 91, 23);
        if (settings.ac_frequency == 60) {
            comboAcFrequency.setText("60Hz");
        } else {
            comboAcFrequency.setText("50Hz");
        }
        Label lblRampDown = new Label((Composite)grpx, 0);
        lblRampDown.setText("Ramp Down");
        lblRampDown.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        lblRampDown.setBounds(10, 87, 97, 27);
        comboRampDown = new Combo((Composite)grpx, 0);
        comboRampDown.setToolTipText("Determines the discharge rate:\r\nFAST - the DUT is discharged as fast as possible.\r\nAS RAMP - the DUT is discharged using the same time/rate as defined for the ramp period.\r\nApplies to All ACW/DCW test steps.\r\n\r\n");
        comboRampDown.setItems(new String[]{"Fast", "As Ramp"});
        comboRampDown.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        comboRampDown.setBounds(119, 84, 91, 28);
        if (settings.ramp_down == V7xTesterSettings.ramp_down_t.fast) {
            comboRampDown.setText("Fast");
        } else {
            comboRampDown.setText("As Ramp");
        }
        btnArcDetect = new Button((Composite)grpx, 32);
        btnArcDetect.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        btnArcDetect.setBounds(10, 134, 97, 27);
        btnArcDetect.setToolTipText("If checked - Arc detection causes the test step to fail at the specified level.\r\nIf not checked - Arc detection does not cause the test step to fail.\r\n");
        btnArcDetect.setText("Arc Detect");
        btnArcDetect.setSelection(settings.enable_arc_detect);
        btnArcDetect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnArcDetect.getSelection()) {
                    txtArcLevel.setVisible(true);
                    lblArcMa.setVisible(true);
                } else {
                    txtArcLevel.setVisible(false);
                    lblArcMa.setVisible(false);
                }
            }
        });
        txtArcLevel = new Text((Composite)grpx, 133120);
        txtArcLevel.setToolTipText("Sets the Arc level above which will incur failure; applies to all ACW and DCW test steps. Adjustable from 1-30m.\r\n");
        txtArcLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        txtArcLevel.setBounds(119, 140, 91, 21);
        txtArcLevel.setText(Integer.toString(settings.arc_level));
        lblArcMa = new Label((Composite)grpx, 0);
        lblArcMa.setText("mA");
        lblArcMa.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        lblArcMa.setBounds(216, 140, 34, 21);
        if (settings.enable_arc_detect) {
            btnArcDetect.setSelection(true);
        } else {
            btnArcDetect.setSelection(false);
            txtArcLevel.setVisible(false);
            lblArcMa.setVisible(false);
        }
        Label lblOnFail = new Label((Composite)grpx, 0);
        lblOnFail.setText("On Fail");
        lblOnFail.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        lblOnFail.setBounds(10, 184, 97, 27);
        comboOnFail = new Combo((Composite)grpx, 0);
        comboOnFail.setToolTipText("Determines how the unit handles a failure in a sequence:\r\nSTOP: Stops running the sequence upon failure.\r\nCONTINUE: Continues running the sequence upon failure.");
        comboOnFail.setItems(new String[]{"Stop", "Continue"});
        comboOnFail.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        comboOnFail.setBounds(119, 181, 91, 28);
        if (settings.on_fail == V7xTesterSettings.on_fail_t.stop) {
            comboOnFail.setText("Stop");
        } else {
            comboOnFail.setText("Continue");
        }
        Label lblIrEndOn = new Label((Composite)grpx, 0);
        lblIrEndOn.setText("IR End On");
        lblIrEndOn.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        lblIrEndOn.setBounds(10, 224, 97, 27);
        comboIrEndOn = new Combo((Composite)grpx, 0);
        comboIrEndOn.setToolTipText("Configures when to terminate the dwell period for IR test steps:\r\nFAIL - dwell is terminated as soon as a FAIL status occurs (if the time expires then it is a PASS).\r\nPASS - dwell is terminated as soon as a PASS status occurs (if the time expires then it is a FAIL).\r\nTIME - dwell is terminated when the time expires, the PASS/FAIL is checked using the last measurement taken.\r\nSTEADY - dwell is terminated as soon as a PASS status occurs and the load is steady or improving (if the time expires then it is a FAIL).");
        comboIrEndOn.setItems(new String[]{"Fail", "Pass", "Time", "Steady"});
        comboIrEndOn.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        comboIrEndOn.setBounds(119, 221, 91, 28);
        switch (settings.ir_end_on) {
            case fail: {
                comboIrEndOn.setText("Fail");
                break;
            }
            case pass: {
                comboIrEndOn.setText("Pass");
                break;
            }
            case time: {
                comboIrEndOn.setText("Time");
                break;
            }
            case steady: {
                comboIrEndOn.setText("Steady");
            }
        }
        return edit_space;
    }

    public static void fetch(V7xTesterSettings settings) {
        switch (comboAcFrequency.getText()) {
            case "60Hz": {
                settings.ac_frequency = 60;
                break;
            }
            case "50Hz": {
                settings.ac_frequency = 50;
            }
        }
        settings.enable_arc_detect = btnArcDetect.getSelection();
        settings.arc_level = Integer.valueOf(txtArcLevel.getText());
        btnArcDetect.setSelection(settings.enable_arc_detect);
        txtArcLevel.setText(Integer.toString(settings.arc_level));
        switch (comboIrEndOn.getText()) {
            case "Fail": {
                settings.ir_end_on = V7xTesterSettings.ir_end_on_t.fail;
                break;
            }
            case "Pass": {
                settings.ir_end_on = V7xTesterSettings.ir_end_on_t.pass;
                break;
            }
            case "Time": {
                settings.ir_end_on = V7xTesterSettings.ir_end_on_t.time;
                break;
            }
            case "Steady": {
                settings.ir_end_on = V7xTesterSettings.ir_end_on_t.steady;
            }
        }
        switch (comboRampDown.getText()) {
            case "60Hz": {
                settings.ramp_down = V7xTesterSettings.ramp_down_t.fast;
                break;
            }
            case "50Hz": {
                settings.ramp_down = V7xTesterSettings.ramp_down_t.as_ramp;
            }
        }
        switch (comboOnFail.getText()) {
            case "Stop": {
                settings.on_fail = V7xTesterSettings.on_fail_t.stop;
                break;
            }
            case "Continue": {
                settings.on_fail = V7xTesterSettings.on_fail_t.cont;
            }
        }
    }
}

