/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V7xTesterSettings
extends TesterSettings {
    int ac_frequency = 60;
    boolean enable_arc_detect = false;
    int arc_level = 10;
    ir_end_on_t ir_end_on = ir_end_on_t.fail;
    ramp_down_t ramp_down = ramp_down_t.fast;
    on_fail_t on_fail = on_fail_t.stop;

    @Override
    public Composite editor(Composite parent) {
        return V7xTesterSettings_Edit.editor(parent, this);
    }

    @Override
    public void fetch() {
        V7xTesterSettings_Edit.fetch(this);
    }

    @Override
    public String configurationCommands() {
        return "freq," + this.ac_frequency + ";" + "arc," + (this.enable_arc_detect ? this.arc_level : 0) + ";" + "irend," + this.ir_end_on.ordinal() + ";" + "rampdown," + (this.ramp_down == ramp_down_t.fast ? "0" : "1") + ";" + "contfail," + (this.on_fail == on_fail_t.stop ? "0" : "1");
    }

    @Override
    public String[] report() {
        String[] rpt = new String[5];
        rpt[0] = "AC Frequency at " + this.ac_frequency + "Hz";
        rpt[1] = this.enable_arc_detect ? "Arc detection fails at " + this.arc_level + "mA" : "Arc detection disabled";
        switch (this.ir_end_on) {
            case fail: {
                rpt[2] = "IR Ends upon Failure";
                break;
            }
            case pass: {
                rpt[2] = "IR Ends upon Pass";
                break;
            }
            case time: {
                rpt[2] = "IR Ends upon Time Expiration";
                break;
            }
            case steady: {
                rpt[2] = "IR Ends upon Pass, Steady, or Increasing";
            }
        }
        rpt[3] = "Ramp down " + (this.ramp_down == ramp_down_t.fast ? "fast" : "as ramp");
        rpt[4] = "Sequence " + (this.on_fail == on_fail_t.stop ? "stops" : "continues") + " on failure";
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.enable_arc_detect = settings[10].equals("Y");
        this.ac_frequency = settings[11].equals("Y") ? 50 : 60;
        this.arc_level = Integer.valueOf(settings[12]);
        switch (Integer.valueOf(settings[13])) {
            default: {
                this.ir_end_on = ir_end_on_t.fail;
                break;
            }
            case 1: {
                this.ir_end_on = ir_end_on_t.pass;
                break;
            }
            case 2: {
                this.ir_end_on = ir_end_on_t.time;
                break;
            }
            case 3: {
                this.ir_end_on = ir_end_on_t.steady;
            }
        }
        this.ramp_down = settings[10].equals("Y") ? ramp_down_t.as_ramp : ramp_down_t.fast;
        this.on_fail = settings[10].equals("Y") ? on_fail_t.cont : on_fail_t.stop;
    }

    public static enum ir_end_on_t {
        fail,
        pass,
        time,
        steady;

    }

    public static enum on_fail_t {
        stop,
        cont;

    }

    public static enum ramp_down_t {
        fast,
        as_ramp;

    }
}

