/*
 * Decompiled with CFR 0.152.
 */
public class V7xTester
extends Tester {
    @Override
    void configureRemoteStart(Interface io_handle, boolean flag) {
    }

    @Override
    int pollRemoteStart(Interface io_handle) {
        return 0;
    }

    @Override
    String configureSwitches(SystemConfiguration config) {
        String sw_command = "vicl,0";
        if (config.use_switches && config.switch_control != switch_control_t.switch_control_computer && !config.switches[0].model.equals("V75/V76/V77")) {
            sw_command = "vicl," + config.num_switches;
        }
        return sw_command;
    }

    @Override
    String clearSequence() {
        return "noseq";
    }

    @Override
    String runSequence() {
        return "run";
    }

    @Override
    String continueSequence() {
        return "cont";
    }

    @Override
    String saveSequence(String name, String slot) {
        if (name.isEmpty()) {
            return "save," + slot;
        }
        return "name," + name + "\n" + "save," + slot;
    }

    @Override
    String strerror(int err) {
        String s = "";
        switch (err) {
            case 1: {
                s = "Could not be decoded at this time";
                break;
            }
            case 2: {
                s = "Not compatible";
                break;
            }
            case 3: {
                s = "Parameter out of range";
                break;
            }
            case 4: {
                s = "Invalid syntax";
                break;
            }
            case 5: {
                s = "Missing field";
                break;
            }
            case 6: {
                s = "Too many fields";
                break;
            }
            case 7: {
                s = "Unecognized command";
                break;
            }
            case 8: {
                s = "Response busy";
                break;
            }
            case 9: {
                s = "Command too long";
                break;
            }
            default: {
                s = "Error code " + err;
            }
        }
        return s;
    }

    @Override
    String[] decodeStatusFlags(int status_flags) {
        if (status_flags == 0) {
            return null;
        }
        if ((status_flags & 0x40000000) != 0) {
            return new String[]{"Query error"};
        }
        if ((status_flags & 0x3FFFFF) == 0) {
            return new String[]{"Error fault"};
        }
        int num_flags = 0;
        int f = 0;
        while (f <= 21) {
            if ((status_flags & 1 << f) != 0) {
                ++num_flags;
            }
            ++f;
        }
        String[] hr = new String[]{"V7X Internal Fault", "Over voltage output", "Line too low", "DUT Breakdown detected", "HOLD step timeout occurred", "User aborted the sequence", "GB step was over-compliance", "Arc detected", "check < minimum limit", "check > maximum limit", "IR Unsteady", "INTERLOCK failure", "Switch Matrix error", "V7X Overheated", "DUT voltage or current could not be controlled", "Wiring error", "Unstable load"};
        String[] fs = new String[num_flags];
        int si = 0;
        int di = 0;
        int f2 = 0;
        while (f2 <= 21) {
            if ((status_flags & 1 << f2) != 0) {
                fs[di++] = hr[si];
            }
            ++si;
            ++f2;
        }
        return fs;
    }

    @Override
    String addHoldStep(double hold_time, String message, boolean disable_local) {
        int num_lines = 2;
        String cmd = "add,hold," + hold_time;
        String[] lines = message.split("\r\n");
        int i = 0;
        while (i < num_lines) {
            cmd = String.valueOf(cmd) + ",";
            if (i < lines.length) {
                String l = lines[i];
                l = l.replaceAll(",", "");
                l = l.replaceAll(";", "");
                cmd = String.valueOf(cmd) + l;
            }
            ++i;
        }
        if (disable_local) {
            cmd = String.valueOf(cmd) + ",Y";
        }
        return cmd;
    }

    @Override
    String addPauseStep(double pause_time, String message) {
        return "add,pause," + pause_time;
    }

    @Override
    String csvStepHeading() {
        return "Step Type,Status Flag,Attempted?,Dwell Time (s),Test Drive Level (V/A),Actual Drive Level (V/A),Test Frequency (Hz),Min Limit (A/\u2126),Max Limit (A/\u2126),Final Measurement (A/\u2126),Highest BKDN (Apk),ARC Limit (A),Highest ARC (A)";
    }

    @Override
    public boolean switchingValid(String model, SystemConfiguration config) {
        boolean v = true;
        if ((model.equals("V75") || model.equals("V76") || model.equals("V77")) && !config.switches[0].model.equals("V75/V76/V77")) {
            v = false;
        }
        return v;
    }
}

