/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;

public class V7xStepFactory
extends StepFactory {
    @Override
    public String getSeriesName() {
        return "V7x";
    }

    @Override
    public String[] getStepTypes() {
        return new String[]{"ACW", "CONT", "DCW", "GB", "IR"};
    }

    @Override
    public TestStep newStep(String name) {
        TestStep s = null;
        switch (name) {
            case "ACW": {
                s = new V7xACW();
                break;
            }
            case "CONT": {
                s = new V7xCONT();
                break;
            }
            case "DCW": {
                s = new V7xDCW();
                break;
            }
            case "GB": {
                s = new V7xGB();
                break;
            }
            case "IR": {
                s = new V7xIR();
            }
        }
        return s;
    }

    @Override
    public TestStep loadStep(String id, String json, byte[] im) {
        TestStep s = null;
        switch (id) {
            case "ACW": {
                s = (TestStep)new Gson().fromJson(json, V7xACW.class);
                break;
            }
            case "CONT": {
                s = (TestStep)new Gson().fromJson(json, V7xCONT.class);
                break;
            }
            case "DCW": {
                s = (TestStep)new Gson().fromJson(json, V7xDCW.class);
                break;
            }
            case "GB": {
                s = (TestStep)new Gson().fromJson(json, V7xGB.class);
                break;
            }
            case "IR": {
                s = (TestStep)new Gson().fromJson(json, V7xIR.class);
            }
        }
        return s;
    }

    @Override
    public TestStep loadStep(String csv) {
        TestStep s = null;
        String[] f = csv.split(",");
        switch (f[0]) {
            case "ACW": {
                s = new V7xACW();
                s.importQt(csv);
                break;
            }
            case "CONT": {
                s = new V7xCONT();
                s.importQt(csv);
                break;
            }
            case "DCW": {
                s = new V7xDCW();
                s.importQt(csv);
                break;
            }
            case "GB": {
                s = new V7xGB();
                s.importQt(csv);
                break;
            }
            case "IR": {
                s = new V7xIR();
                s.importQt(csv);
            }
        }
        return s;
    }
}

