/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class V7xIR_Edit {
    static Text textLevel;
    static Text txtUserName;
    static Text textDwellTime;
    static Text textTestDelay;
    static Button btnUser;
    static Text textMinimumLeakage;
    static Text textMaximumLeakage;
    static Label lblS_1;
    static Label lblMinimumLeakagePrefix;
    static Label lblMaximumLeakagePrefix;
    static Label lblTo;
    static Button btnLeakageNoMax;
    static Button btnDutGrounded;
    static Button btnIsCapacitive;

    public static Composite editor(Composite parent, TesterSettings tester, V7xIR settings) {
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpLevel = new Group(edit_space, 0);
        grpLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLevel.setText("Level");
        grpLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLevel.setBounds(10, 0, 253, 60);
        textLevel = new Text((Composite)grpLevel, 133120);
        textLevel.setToolTipText("Specifies the voltage level for the test.");
        textLevel.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textLevel.setBounds(60, 15, 105, 35);
        textLevel.setText(Double.toString(settings.test_voltage));
        Label lblVolts = new Label((Composite)grpLevel, 0);
        lblVolts.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblVolts.setBounds(166, 15, 52, 35);
        lblVolts.setText("Volts");
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(270, 0, 270, 60);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(32, 25, 208, 21);
        Group groupTiming = new Group(edit_space, 0);
        groupTiming.setToolTipText("");
        groupTiming.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        groupTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupTiming.setText("Timing");
        groupTiming.setBounds(10, 66, 253, 197);
        Label lblDwell = new Label((Composite)groupTiming, 0);
        lblDwell.setBounds(10, 59, 55, 15);
        lblDwell.setText("Dwell");
        Label lblTestDelay = new Label((Composite)groupTiming, 0);
        lblTestDelay.setBounds(10, 80, 55, 15);
        lblTestDelay.setText("Test Delay");
        textDwellTime = new Text((Composite)groupTiming, 133120);
        textDwellTime.setToolTipText("Specifies the dwell time for the test.");
        textDwellTime.setBounds(72, 56, 65, 21);
        textDwellTime.setText(Double.toString(settings.dwell_time));
        btnUser = new Button((Composite)groupTiming, 32);
        btnUser.setBounds(204, 60, 39, 16);
        btnUser.setToolTipText("Allows the test to dwell until ended by the user.");
        btnUser.setText("User");
        btnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUser.getSelection()) {
                    textDwellTime.setEnabled(false);
                    lblS_1.setEnabled(false);
                } else {
                    textDwellTime.setEnabled(true);
                    lblS_1.setEnabled(true);
                }
            }
        });
        lblS_1 = new Label((Composite)groupTiming, 0);
        lblS_1.setText("seconds");
        lblS_1.setBounds(143, 58, 55, 15);
        if (settings.user_terminated) {
            btnUser.setSelection(true);
            textDwellTime.setEnabled(false);
            lblS_1.setEnabled(false);
        }
        textTestDelay = new Text((Composite)groupTiming, 133120);
        textTestDelay.setBounds(72, 80, 65, 21);
        textTestDelay.setText(Double.toString(settings.pre_check_delay));
        Label lblS_2 = new Label((Composite)groupTiming, 0);
        lblS_2.setText("seconds");
        lblS_2.setBounds(143, 79, 55, 15);
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setText("Test Limits");
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLimits.setBounds(269, 66, 270, 197);
        Label lblLeakage = new Label((Composite)grpLimits, 0);
        lblLeakage.setBounds(10, 58, 55, 21);
        lblLeakage.setText("Leakage");
        lblTo = new Label((Composite)grpLimits, 0);
        lblTo.setText("to");
        lblTo.setBounds(66, 83, 11, 15);
        String leakage_units = "\u2126";
        textMinimumLeakage = new Text((Composite)grpLimits, 133120);
        textMinimumLeakage.setToolTipText("Specifies the lower leakage limit.");
        textMinimumLeakage.setBounds(81, 58, 74, 21);
        textMinimumLeakage.setText(SiTools.toString(settings.minimum_leakage_limit));
        lblMinimumLeakagePrefix = new Label((Composite)grpLimits, 2048);
        lblMinimumLeakagePrefix.setToolTipText("Double click to change the prefix.");
        lblMinimumLeakagePrefix.setText(String.valueOf(SiTools.prefix(settings.minimum_leakage_limit)) + leakage_units);
        lblMinimumLeakagePrefix.setBounds(161, 58, 46, 19);
        lblMinimumLeakagePrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumLeakagePrefix);
            }
        });
        textMaximumLeakage = new Text((Composite)grpLimits, 133120);
        textMaximumLeakage.setToolTipText("Specifies the upper leakage limit.");
        textMaximumLeakage.setBounds(81, 80, 76, 21);
        textMaximumLeakage.setText(SiTools.toString(settings.maximum_leakage_limit));
        lblMaximumLeakagePrefix = new Label((Composite)grpLimits, 2048);
        lblMaximumLeakagePrefix.setToolTipText("Double click to change the prefix.");
        lblMaximumLeakagePrefix.setBounds(161, 83, 46, 19);
        lblMaximumLeakagePrefix.setText(String.valueOf(SiTools.prefix(settings.maximum_leakage_limit)) + leakage_units);
        lblMaximumLeakagePrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumLeakagePrefix);
            }
        });
        btnLeakageNoMax = new Button((Composite)grpLimits, 32);
        btnLeakageNoMax.setToolTipText("Check to disable the maximum leakage limit.");
        btnLeakageNoMax.setText("No maximum");
        btnLeakageNoMax.setSelection(true);
        btnLeakageNoMax.setBounds(81, 107, 95, 16);
        btnLeakageNoMax.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnLeakageNoMax.getSelection()) {
                    textMaximumLeakage.setEnabled(false);
                    lblMaximumLeakagePrefix.setEnabled(false);
                } else {
                    textMaximumLeakage.setEnabled(true);
                    lblMaximumLeakagePrefix.setEnabled(true);
                }
            }
        });
        btnLeakageNoMax.setSelection(settings.no_maximum_limit);
        if (settings.no_maximum_limit) {
            textMaximumLeakage.setEnabled(false);
            lblMaximumLeakagePrefix.setEnabled(false);
        }
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 530, 51);
        btnDutGrounded = new Button((Composite)grpOptions, 32);
        btnDutGrounded.setToolTipText("Set when the DUT is grounded, (only valid if option HSS or HSS-2 is fitted).");
        btnDutGrounded.setBounds(258, 25, 121, 16);
        btnDutGrounded.setText("DUT Grounded");
        if (settings.grounding == 1) {
            btnDutGrounded.setSelection(true);
        }
        btnIsCapacitive = new Button((Composite)grpOptions, 32);
        btnIsCapacitive.setToolTipText("The sequence continues even if this step fails.");
        btnIsCapacitive.setBounds(10, 25, 142, 16);
        btnIsCapacitive.setText("DUT Is Capacitive");
        if (settings.is_capacitive) {
            btnIsCapacitive.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(V7xIR settings) {
        settings.name = txtUserName.getText();
        settings.test_voltage = Double.parseDouble(textLevel.getText());
        settings.dwell_time = Double.parseDouble(textDwellTime.getText());
        settings.user_terminated = btnUser.getSelection();
        settings.pre_check_delay = Double.parseDouble(textTestDelay.getText());
        settings.no_maximum_limit = btnLeakageNoMax.getSelection();
        settings.minimum_leakage_limit = SiTools.toReal(textMinimumLeakage.getText(), lblMinimumLeakagePrefix.getText());
        settings.maximum_leakage_limit = SiTools.toReal(textMaximumLeakage.getText(), lblMaximumLeakagePrefix.getText());
        settings.grounding = btnDutGrounded.getSelection() ? 1 : 2;
        settings.is_capacitive = btnIsCapacitive.getSelection();
    }
}

