/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V7xIR
extends TestStep {
    String id = "IR";
    double test_voltage = 1000.0;
    double dwell_time = 60.0;
    boolean user_terminated = false;
    double pre_check_delay = 0.0;
    boolean no_maximum_limit = false;
    double minimum_leakage_limit = 1.0E8;
    double maximum_leakage_limit = 1.0E10;
    double lead_compensation;
    int grounding = 2;
    boolean is_capacitive = false;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V7xIR_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V7xIR_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String command = "add,IR," + this.test_voltage + "," + (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.pre_check_delay + "," + this.minimum_leakage_limit + "," + (this.no_maximum_limit ? "" : Double.valueOf(this.maximum_leakage_limit)) + "," + (this.grounding == 2 ? "" : "gnd") + "," + (this.is_capacitive ? "cap" : "");
        return command;
    }

    @Override
    public String stepSummary() {
        return "IR:" + this.test_voltage + "V";
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Drive", "Volts", "V"}, {"Leakage", "Ohms", "\u2126"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[3]);
        rslts[1] = Float.parseFloat(f[5]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("measrslt?,volts;measrslt?,ohms;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(",");
            int reported_step = Integer.parseInt(f[2]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double total_step_time = this.user_terminated ? 9999.0 : this.dwell_time;
                double p = 100.0 * (double)i / (total_step_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                r.metrics = new float[2];
                r.metrics[0] = Float.parseFloat(f[0]);
                r.metrics[1] = Float.parseFloat(f[1]);
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String r_5;
        String r_4;
        String r_3;
        String r_1;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            r_1 = rslts[1];
            r_3 = rslts[3];
            r_4 = rslts[4];
            r_5 = rslts[5];
        } else {
            r_1 = "";
            r_3 = "";
            r_4 = "";
            r_5 = "";
        }
        String csv = (this.user_terminated ? r_1 : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + r_3 + "," + "," + this.minimum_leakage_limit + "," + (this.no_maximum_limit ? "" : Double.valueOf(this.maximum_leakage_limit)) + "," + r_5 + "," + r_4 + "," + ",";
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        String delay = this.pre_check_delay > 0.0 ? "  Delay " + this.pre_check_delay + "s" : "";
        rpt[0] = !this.user_terminated ? "IR @ " + this.test_voltage + "V for " + this.dwell_time + "s" + delay : "IR @ " + this.test_voltage + "V for " + rslts[1] + "s" + delay;
        String limits = this.no_maximum_limit ? String.valueOf(SiTools.toString(this.minimum_leakage_limit, "\u2126")) + " minimum limit" : String.valueOf(SiTools.toString(this.minimum_leakage_limit, "\u2126")) + " to " + SiTools.toString(this.maximum_leakage_limit, "\u2126");
        switch (level) {
            case brief: {
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                rpt[1] = "Leakage: " + SiTools.toString(rslts[5], "\u2126") + " (" + limits + ")";
            }
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        String delay = this.pre_check_delay > 0.0 ? "  Delay " + this.pre_check_delay + "s" : "";
        rpt[0] = !this.user_terminated ? "IR @ " + this.test_voltage + "V for " + this.dwell_time + "s" + delay : "IR @ " + this.test_voltage + "V user terminated" + delay;
        if (level != ReportSettings.detail_level_t.brief) {
            String limits;
            if (this.no_maximum_limit) {
                limits = String.valueOf(SiTools.toString(this.minimum_leakage_limit, "\u2126")) + " minimum limit";
                limits = "No limits";
            } else {
                limits = String.valueOf(SiTools.toString(this.minimum_leakage_limit, "\u2126")) + " to " + SiTools.toString(this.maximum_leakage_limit, "\u2126");
            }
            rpt[1] = "Load: " + limits;
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_voltage = Double.parseDouble(settings[1]);
        this.dwell_time = Double.parseDouble(settings[2]);
        this.pre_check_delay = Double.parseDouble(settings[3]);
        this.minimum_leakage_limit = Double.parseDouble(settings[4]) * Math.pow(10.0, Double.parseDouble(settings[6]));
        this.maximum_leakage_limit = Double.parseDouble(settings[5]) * Math.pow(10.0, Double.parseDouble(settings[6]));
        this.no_maximum_limit = settings[7].equals("Y");
        this.grounding = settings[8].equals("Y") ? 1 : 2;
        boolean bl = this.is_capacitive = settings[9].equals("Y");
        if (settings.length > 10) {
            this.name = settings[10];
        }
    }
}

