/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V7xGB
extends TestStep {
    String id = "GB";
    double test_level = 10.0;
    double dwell_time = 10.0;
    boolean user_terminated = false;
    double minimum_limit = 0.0;
    double maximum_limit = 0.1;
    boolean no_minimum_limit = false;
    double fixture_offset = 0.0;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V7xGB_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V7xGB_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String command = "add,GB," + this.test_level + "," + (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + (this.no_minimum_limit ? "" : Double.valueOf(this.minimum_limit + this.fixture_offset)) + "," + (this.maximum_limit + this.fixture_offset);
        return command;
    }

    @Override
    public String stepSummary() {
        return "GB:" + this.test_level + "A";
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Drive", "Amps", "A"}, {"Resistance", "Ohms", "\u2126"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[3]);
        rslts[1] = Float.parseFloat(f[5]) - (float)this.fixture_offset;
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("measrslt?,amps;measrslt?,ohms;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(",");
            int reported_step = Integer.parseInt(f[2]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double total_step_time = this.user_terminated ? 9999.0 : this.dwell_time;
                double p = 100.0 * (double)i / (total_step_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                r.metrics = new float[2];
                r.metrics[0] = Float.parseFloat(f[0]);
                r.metrics[1] = Float.parseFloat(f[1]) - (float)this.fixture_offset;
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String r_5;
        String r_3;
        String r_1;
        V7xTesterSettings v_settings = (V7xTesterSettings)ts;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            r_1 = rslts[1];
            r_3 = rslts[3];
            r_5 = String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[5]) - (float)this.fixture_offset));
        } else {
            r_1 = "";
            r_3 = "";
            r_5 = "";
        }
        String csv = (this.user_terminated ? r_1 : Double.valueOf(this.dwell_time)) + "," + this.test_level + "," + r_3 + "," + v_settings.ac_frequency + "," + (this.no_minimum_limit ? "" : Double.valueOf(this.minimum_limit)) + "," + this.maximum_limit + "," + r_5 + "," + "," + ",";
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        V7xTesterSettings v_settings = (V7xTesterSettings)ts;
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = !this.user_terminated ? "GB @ " + this.test_level + "A/" + v_settings.ac_frequency + "Hz for " + this.dwell_time + "s" : "GB @ " + this.test_level + "A/" + v_settings.ac_frequency + "Hz for " + rslts[1] + "s";
        switch (level) {
            case brief: {
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                float am = Float.parseFloat(rslts[5]) - (float)this.fixture_offset;
                rpt[1] = "Load: " + SiTools.toString(am, "\u2126") + " (" + SiTools.toString(this.minimum_limit, "\u2126") + " to " + (this.no_minimum_limit ? "\u221e" : SiTools.toString(this.maximum_limit, "\u2126")) + " limits)";
            }
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        V7xTesterSettings v_settings = (V7xTesterSettings)ts;
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = !this.user_terminated ? "GB @ " + this.test_level + "A/" + v_settings.ac_frequency + "Hz for " + this.dwell_time + "s" : "GB @ " + this.test_level + "A/" + v_settings.ac_frequency + "Hz user terminated";
        if (level != ReportSettings.detail_level_t.brief) {
            rpt[1] = " Load: " + (this.no_minimum_limit ? "No-minimum" : SiTools.toString(this.minimum_limit, "\u2126")) + " to " + SiTools.toString(this.maximum_limit, "\u2126") + (this.fixture_offset != 0.0 ? " (Fixture offset " + this.fixture_offset + "\u2126)" : "");
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_level = Double.parseDouble(settings[1]);
        this.dwell_time = Double.parseDouble(settings[2]);
        this.minimum_limit = Double.parseDouble(settings[3]) * Math.pow(10.0, Double.parseDouble(settings[5]));
        this.maximum_limit = Double.parseDouble(settings[4]) * Math.pow(10.0, Double.parseDouble(settings[5]));
        this.fixture_offset = Double.parseDouble(settings[6]);
        if (settings.length > 7) {
            this.name = settings[7];
        }
    }
}

