/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V7xCONT
extends TestStep {
    String id = "CONT";
    double test_time = 5.0;
    boolean user_terminated = false;
    double minimum_resistance = 0.0;
    double maximum_resistance = 1.0;
    boolean no_minimum_limit = false;
    boolean no_maximum_limit = false;
    double fixture_offset = 0.0;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V7xCONT_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V7xCONT_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String command = "add,CONT," + (this.user_terminated ? "" : Double.valueOf(this.test_time)) + "," + (this.no_minimum_limit ? "" : Double.valueOf(this.minimum_resistance + this.fixture_offset)) + "," + (this.no_maximum_limit ? "" : Double.valueOf(this.maximum_resistance + this.fixture_offset));
        return command;
    }

    @Override
    public String stepSummary() {
        return "CONTinuity";
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Load", "Ohms", "\u2126"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[1];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[5]) - (float)this.fixture_offset;
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("measrslt?,ohms;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            String[] f = response.split(",");
            int reported_step = Integer.parseInt(f[1]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double total_step_time = this.user_terminated ? 9999.0 : this.test_time;
                double p = 100.0 * (double)i / (total_step_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                r.metrics = new float[1];
                r.metrics[0] = Float.parseFloat(f[0]) - (float)this.fixture_offset;
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String r_5;
        String r_1;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            r_1 = rslts[1];
            r_5 = String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[5]) - (float)this.fixture_offset));
        } else {
            r_1 = "";
            r_5 = "";
        }
        String csv = (this.user_terminated ? r_1 : Double.valueOf(this.test_time)) + "," + "," + "," + "," + (this.no_minimum_limit ? "" : Double.valueOf(this.minimum_resistance)) + "," + (this.no_maximum_limit ? "" : Double.valueOf(this.maximum_resistance)) + "," + r_5 + "," + "," + ",";
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = !this.user_terminated ? "CONTinuity for " + this.test_time + "s" : "CONTinuity for " + rslts[1] + "s";
        String limits = this.no_minimum_limit && this.no_maximum_limit ? "No limits" : (this.no_minimum_limit ? String.valueOf(SiTools.toString(this.maximum_resistance, "\u2126")) + " maximum limit" : (this.no_maximum_limit ? String.valueOf(SiTools.toString(this.minimum_resistance, "\u2126")) + " minimum limit" : String.valueOf(SiTools.toString(this.minimum_resistance, "\u2126")) + " to " + SiTools.toString(this.maximum_resistance, "\u2126")));
        switch (level) {
            case brief: {
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                float am = Float.parseFloat(rslts[5]) - (float)this.fixture_offset;
                rpt[1] = "Load: " + SiTools.toString(am, "\u2126") + " (" + limits + ")";
            }
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = !this.user_terminated ? "CONTinuity for " + this.test_time + "s" : "CONTinuity user terminated";
        if (level != ReportSettings.detail_level_t.brief) {
            String limits = this.no_minimum_limit && this.no_maximum_limit ? "No limits" : (this.no_minimum_limit ? String.valueOf(SiTools.toString(this.maximum_resistance, "A")) + " maximum limit" : (this.no_maximum_limit ? String.valueOf(SiTools.toString(this.minimum_resistance, "A")) + " minimum limit" : String.valueOf(SiTools.toString(this.minimum_resistance, "A")) + " to " + SiTools.toString(this.maximum_resistance, "A")));
            rpt[1] = "Load: " + limits + (this.fixture_offset != 0.0 ? " (Fixture offset " + this.fixture_offset + "\u2126)" : "");
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_time = Double.parseDouble(settings[1]);
        this.minimum_resistance = Double.parseDouble(settings[2]) * Math.pow(10.0, Double.parseDouble(settings[5]));
        this.maximum_resistance = Double.parseDouble(settings[3]) * Math.pow(10.0, Double.parseDouble(settings[5]));
        this.no_maximum_limit = settings[4].equals("Y");
        this.fixture_offset = Double.parseDouble(settings[6]);
        if (settings.length > 7) {
            this.name = settings[7];
        }
    }
}

