/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class V7xACW_Edit {
    private static Text textLevel;
    private static Text txtUserName;
    private static Text textRampTime;
    private static Text textRampVoltsSec;
    private static Text textDwellTime;
    private static Button btnUser;
    private static Label lblS_1;
    private static Button buttonRampTime;
    private static Button buttonRampVoltsSec;
    private static Label lblRampSeconds;
    private static Label lblRampVsec;
    private static Label lblMinimumLeakagePrefix;
    private static Label lblMaximumLeakagePrefix;
    private static Text textMinimumLeakage;
    private static Text textMaximumLeakage;
    private static Button btnNoMin;
    private static Button btnNoMax;
    private static Button btnDutGrounded;
    private static Label lblMinimum;
    private static Label lblMaximum;

    public static Composite editor(Composite parent, TesterSettings tester, final V7xACW settings) {
        final DecimalFormat df3 = new DecimalFormat("0.000");
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpLevel = new Group(edit_space, 0);
        grpLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLevel.setText("Level");
        grpLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLevel.setBounds(10, 0, 320, 60);
        textLevel = new Text((Composite)grpLevel, 133120);
        textLevel.setToolTipText("Specifies the voltage level for the test.");
        textLevel.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textLevel.setBounds(82, 15, 73, 35);
        textLevel.setText(Double.toString(settings.test_voltage));
        Label lblVolts = new Label((Composite)grpLevel, 0);
        lblVolts.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblVolts.setBounds(161, 15, 53, 35);
        lblVolts.setText("Volts");
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(336, 0, 210, 60);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(10, 25, 184, 21);
        Group groupTiming = new Group(edit_space, 0);
        groupTiming.setToolTipText("");
        groupTiming.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        groupTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupTiming.setText("Timing");
        groupTiming.setBounds(10, 66, 246, 197);
        Label lblRamp = new Label((Composite)groupTiming, 0);
        lblRamp.setBounds(10, 33, 38, 15);
        lblRamp.setText("Ramp");
        buttonRampTime = new Button((Composite)groupTiming, 16);
        buttonRampTime.setToolTipText("Chooses the ramp to be in terms of time.");
        buttonRampTime.setBounds(46, 22, 21, 16);
        buttonRampTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 1;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampVoltsSec.getText());
                    if (t2 < 0.1) {
                        t2 = 0.1;
                    }
                    textRampTime.setText(df3.format(t1 / t2));
                    textRampVoltsSec.setEnabled(false);
                    textRampTime.setEnabled(true);
                    lblRampVsec.setEnabled(false);
                    lblRampSeconds.setEnabled(true);
                    textRampTime.setFocus();
                }
            }
        });
        buttonRampVoltsSec = new Button((Composite)groupTiming, 16);
        buttonRampVoltsSec.setToolTipText("Chooses the ramp to be in terms of volts/second.");
        buttonRampVoltsSec.setBounds(46, 51, 21, 16);
        buttonRampVoltsSec.setText("");
        buttonRampVoltsSec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 2;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampTime.getText());
                    if (t2 < 0.001) {
                        t2 = 0.001;
                    }
                    textRampVoltsSec.setText(df3.format(t1 / t2));
                    textRampTime.setEnabled(false);
                    textRampVoltsSec.setEnabled(true);
                    lblRampSeconds.setEnabled(false);
                    lblRampVsec.setEnabled(true);
                    textRampVoltsSec.setFocus();
                }
            }
        });
        textRampTime = new Text((Composite)groupTiming, 133120);
        textRampTime.setToolTipText("Specifies the voltage ramp in terms of time.");
        textRampTime.setBounds(72, 22, 65, 21);
        textRampVoltsSec = new Text((Composite)groupTiming, 133120);
        textRampVoltsSec.setToolTipText("Specifies the voltage ramp in terms of volts/second.");
        textRampVoltsSec.setBounds(72, 49, 65, 21);
        lblRampSeconds = new Label((Composite)groupTiming, 0);
        lblRampSeconds.setBounds(143, 22, 55, 15);
        lblRampSeconds.setText("seconds");
        lblRampVsec = new Label((Composite)groupTiming, 0);
        lblRampVsec.setEnabled(false);
        lblRampVsec.setText("V/sec");
        lblRampVsec.setBounds(143, 51, 55, 15);
        if (settings.ramp_units == 1) {
            textRampTime.setText(Double.toString(settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setEnabled(false);
            textRampTime.setEnabled(true);
            lblRampVsec.setEnabled(false);
            lblRampSeconds.setEnabled(true);
            buttonRampTime.setSelection(true);
        } else {
            textRampTime.setText(Double.toString(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.ramp_setting));
            textRampTime.setEnabled(false);
            textRampVoltsSec.setEnabled(true);
            lblRampSeconds.setEnabled(false);
            lblRampVsec.setEnabled(true);
            buttonRampVoltsSec.setSelection(true);
        }
        Label lblDwell = new Label((Composite)groupTiming, 0);
        lblDwell.setBounds(10, 91, 55, 15);
        lblDwell.setText("Dwell");
        textDwellTime = new Text((Composite)groupTiming, 133120);
        textDwellTime.setToolTipText("Specifies the dwell time for the test.");
        textDwellTime.setBounds(72, 88, 65, 21);
        textDwellTime.setText(Double.toString(settings.dwell_time));
        btnUser = new Button((Composite)groupTiming, 32);
        btnUser.setBounds(199, 92, 44, 16);
        btnUser.setToolTipText("Allows the test to dwell until ended by the user.");
        btnUser.setText("User");
        btnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUser.getSelection()) {
                    textDwellTime.setEnabled(false);
                    lblS_1.setEnabled(false);
                } else {
                    textDwellTime.setEnabled(true);
                    lblS_1.setEnabled(true);
                }
            }
        });
        lblS_1 = new Label((Composite)groupTiming, 0);
        lblS_1.setText("seconds");
        lblS_1.setBounds(143, 90, 55, 15);
        if (settings.user_terminated) {
            btnUser.setSelection(true);
            textDwellTime.setEnabled(false);
            lblS_1.setEnabled(false);
        }
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setText("Leakage Limits");
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLimits.setBounds(262, 66, 283, 197);
        lblMinimum = new Label((Composite)grpLimits, 0);
        lblMinimum.setBounds(10, 55, 55, 15);
        lblMinimum.setText("Minimum");
        textMinimumLeakage = new Text((Composite)grpLimits, 133120);
        textMinimumLeakage.setToolTipText("Specifies the first lower leakage limit.");
        textMinimumLeakage.setBounds(73, 55, 60, 21);
        textMinimumLeakage.setText(SiTools.toString(settings.minimum_leakage_limit));
        lblMinimumLeakagePrefix = new Label((Composite)grpLimits, 2048);
        lblMinimumLeakagePrefix.setToolTipText("Double click to change the prefix.");
        lblMinimumLeakagePrefix.setText(String.valueOf(SiTools.prefix(settings.minimum_leakage_limit)) + "A");
        lblMinimumLeakagePrefix.setBounds(139, 55, 30, 19);
        lblMinimumLeakagePrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumLeakagePrefix);
            }
        });
        btnNoMin = new Button((Composite)grpLimits, 32);
        btnNoMin.setBounds(181, 57, 93, 16);
        btnNoMin.setText("No minimum");
        btnNoMin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnNoMin.getSelection()) {
                    textMinimumLeakage.setEnabled(false);
                    lblMinimumLeakagePrefix.setEnabled(false);
                } else {
                    textMinimumLeakage.setEnabled(true);
                    lblMinimumLeakagePrefix.setEnabled(true);
                }
            }
        });
        btnNoMin.setSelection(settings.no_minimum_limit);
        lblMaximum = new Label((Composite)grpLimits, 0);
        lblMaximum.setText("Maximum");
        lblMaximum.setBounds(10, 93, 55, 15);
        textMaximumLeakage = new Text((Composite)grpLimits, 133120);
        textMaximumLeakage.setToolTipText("Specifies the first upper leakage limit.");
        textMaximumLeakage.setBounds(73, 93, 60, 21);
        textMaximumLeakage.setText(SiTools.toString(settings.maximum_leakage_limit));
        lblMaximumLeakagePrefix = new Label((Composite)grpLimits, 2048);
        lblMaximumLeakagePrefix.setToolTipText("Double click to change the prefix.");
        lblMaximumLeakagePrefix.setBounds(139, 96, 30, 19);
        lblMaximumLeakagePrefix.setText(String.valueOf(SiTools.prefix(settings.maximum_leakage_limit)) + "A");
        lblMaximumLeakagePrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumLeakagePrefix);
            }
        });
        btnNoMax = new Button((Composite)grpLimits, 32);
        btnNoMax.setBounds(181, 95, 93, 16);
        btnNoMax.setText("No maximum");
        btnNoMax.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnNoMax.getSelection()) {
                    textMaximumLeakage.setEnabled(false);
                    lblMaximumLeakagePrefix.setEnabled(false);
                } else {
                    textMaximumLeakage.setEnabled(true);
                    lblMaximumLeakagePrefix.setEnabled(true);
                }
            }
        });
        btnNoMax.setSelection(settings.no_maximum_limit);
        if (settings.no_minimum_limit) {
            textMinimumLeakage.setEnabled(false);
            lblMinimumLeakagePrefix.setEnabled(false);
        }
        if (settings.no_maximum_limit) {
            textMaximumLeakage.setEnabled(false);
            lblMaximumLeakagePrefix.setEnabled(false);
        }
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 536, 51);
        btnDutGrounded = new Button((Composite)grpOptions, 32);
        btnDutGrounded.setToolTipText("Set when the DUT is grounded, (only valid if option HSS or HSS-2 is fitted).");
        btnDutGrounded.setBounds(247, 25, 154, 16);
        btnDutGrounded.setText("DUT Grounded");
        if (settings.grounding == 1) {
            btnDutGrounded.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(V7xACW settings) {
        settings.name = txtUserName.getText();
        settings.test_voltage = Double.parseDouble(textLevel.getText());
        settings.ramp_setting = settings.ramp_units == 1 ? Double.parseDouble(textRampTime.getText()) : Double.parseDouble(textRampVoltsSec.getText());
        settings.dwell_time = Double.parseDouble(textDwellTime.getText());
        settings.user_terminated = btnUser.getSelection();
        settings.minimum_leakage_limit = SiTools.toReal(textMinimumLeakage.getText(), lblMinimumLeakagePrefix.getText());
        settings.maximum_leakage_limit = SiTools.toReal(textMaximumLeakage.getText(), lblMaximumLeakagePrefix.getText());
        settings.no_minimum_limit = btnNoMin.getSelection();
        settings.no_maximum_limit = btnNoMax.getSelection();
        settings.grounding = btnDutGrounded.getSelection() ? 1 : 2;
    }
}

