/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V7xACW
extends TestStep {
    String id = "ACW";
    double test_voltage = 1000.0;
    double ramp_setting = 1.5;
    int ramp_units = 1;
    double dwell_time = 60.0;
    boolean user_terminated = false;
    double minimum_leakage_limit = 0.0;
    double maximum_leakage_limit = 0.001;
    boolean no_minimum_limit = false;
    boolean no_maximum_limit = false;
    int grounding = 2;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V7xACW_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V7xACW_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        double ramp_time = this.ramp_units == 1 ? this.ramp_setting : this.test_voltage / this.ramp_setting;
        String command = "add,ACW," + this.test_voltage + "," + ramp_time + "," + (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + (this.no_minimum_limit ? "" : Double.valueOf(this.minimum_leakage_limit)) + "," + (this.no_maximum_limit ? "" : Double.valueOf(this.maximum_leakage_limit)) + "," + (this.grounding == 2 ? "" : "gnd");
        return command;
    }

    @Override
    public String stepSummary() {
        return "ACW:" + this.test_voltage + "V";
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Drive", "Volts", "V"}, {"Leakage", "Amps", "A"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[3]);
        rslts[1] = Float.parseFloat(f[5]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("measrslt?,volts;measrslt?,amps;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(",");
            int reported_step = Integer.parseInt(f[2]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                double total_step_time;
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double d = total_step_time = this.user_terminated ? 9999.0 : this.dwell_time;
                total_step_time = this.ramp_units == 1 ? (total_step_time += this.ramp_setting) : (total_step_time += this.test_voltage / this.ramp_setting);
                double p = 100.0 * (double)i / (total_step_time *= 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                r.metrics = new float[2];
                r.metrics[0] = Float.parseFloat(f[0]);
                r.metrics[1] = Float.parseFloat(f[1]);
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String r_6;
        String r_5;
        String r_4;
        String r_3;
        String r_1;
        V7xTesterSettings v_settings = (V7xTesterSettings)ts;
        double arc = (double)v_settings.arc_level / 1000.0;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            r_1 = rslts[1];
            r_3 = rslts[3];
            r_4 = rslts[4];
            r_5 = rslts[5];
            r_6 = rslts[6];
        } else {
            r_1 = "";
            r_3 = "";
            r_4 = "";
            r_5 = "";
            r_6 = "";
        }
        String csv = (this.user_terminated ? r_1 : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + r_3 + "," + v_settings.ac_frequency + "," + (this.no_minimum_limit ? "" : Double.valueOf(this.minimum_leakage_limit)) + "," + (this.no_maximum_limit ? "" : Double.valueOf(this.maximum_leakage_limit)) + "," + r_5 + "," + r_4 + "," + (v_settings.enable_arc_detect ? Double.valueOf(arc) : "") + "," + (v_settings.enable_arc_detect ? r_6 : "");
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        V7xTesterSettings v_settings = (V7xTesterSettings)ts;
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: {
                num_lines = 2;
                if (!v_settings.enable_arc_detect) break;
                do_arc = 1;
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 4;
                if (!v_settings.enable_arc_detect) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        rpt[0] = !this.user_terminated ? "ACW @ " + this.test_voltage + "V/" + v_settings.ac_frequency + "Hz for " + this.dwell_time + "s" : "ACW @ " + this.test_voltage + "V/" + v_settings.ac_frequency + "Hz for " + rslts[1] + "s";
        String limits = this.no_minimum_limit && this.no_maximum_limit ? "No limits" : (this.no_minimum_limit ? String.valueOf(SiTools.toString(this.maximum_leakage_limit, "A")) + " maximum limit" : (this.no_maximum_limit ? String.valueOf(SiTools.toString(this.minimum_leakage_limit, "A")) + " minimum limit" : String.valueOf(SiTools.toString(this.minimum_leakage_limit, "A")) + " to " + SiTools.toString(this.maximum_leakage_limit, "A")));
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                do_arc *= 2;
                rpt[1] = "Leakage: " + SiTools.toString(rslts[5], "A") + " (" + limits + ")";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                do_arc *= 4;
                rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s");
                rpt[2] = "Leakage: " + SiTools.toString(rslts[5], "A") + " (" + limits + ")";
                rpt[3] = "Highest breakdown: " + SiTools.toString(rslts[4], "Apk");
            }
        }
        if (do_arc != 0) {
            rpt[do_arc] = "Highest ARC detected: " + SiTools.toString(rslts[6], "A") + "(" + v_settings.arc_level + "mA limit)";
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        V7xTesterSettings v_settings = (V7xTesterSettings)ts;
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 3;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = !this.user_terminated ? "ACW @ " + this.test_voltage + "V/" + v_settings.ac_frequency + "Hz for " + this.dwell_time + "s" : "ACW @ " + this.test_voltage + "V/" + v_settings.ac_frequency + "Hz user terminated";
        if (level != ReportSettings.detail_level_t.brief) {
            rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s");
            rpt[2] = this.no_minimum_limit && this.no_maximum_limit ? "Leakage: no limits" : (this.no_minimum_limit ? "Leakage: " + SiTools.toString(this.maximum_leakage_limit, "A") + " maximum limit" : (this.no_maximum_limit ? "Leakage: " + SiTools.toString(this.minimum_leakage_limit, "A") + " minimum limit" : "Leakage: " + SiTools.toString(this.minimum_leakage_limit, "A") + " to " + SiTools.toString(this.maximum_leakage_limit, "A")));
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_voltage = Double.parseDouble(settings[1]);
        this.ramp_units = settings[2].equals("Y") ? 1 : 2;
        this.ramp_setting = Double.parseDouble(settings[3]);
        this.dwell_time = Double.parseDouble(settings[4]);
        this.minimum_leakage_limit = Double.parseDouble(settings[5]) * Math.pow(10.0, Double.parseDouble(settings[8]));
        this.maximum_leakage_limit = Double.parseDouble(settings[6]) * Math.pow(10.0, Double.parseDouble(settings[8]));
        this.no_maximum_limit = settings[7].equals("Y");
        int n = this.grounding = settings[9].equals("Y") ? 1 : 2;
        if (settings.length > 10) {
            this.name = settings[10];
        }
    }
}

