/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V10xTesterSettings
extends TesterSettings {
    boolean arc_detect_only;
    boolean enable_dc_min_load;
    boolean check_chassis_continuity;
    boolean enable_hv_safety_trip;
    double max_dc_discharge;

    public V10xTesterSettings() {
        this.enable_tester_start = false;
        this.arc_detect_only = false;
        this.enable_dc_min_load = false;
        this.check_chassis_continuity = false;
        this.enable_hv_safety_trip = false;
        this.max_dc_discharge = 0.2;
    }

    @Override
    public Composite editor(Composite parent) {
        return V10xTesterSettings_Edit.editor(parent, this);
    }

    @Override
    public void fetch() {
        V10xTesterSettings_Edit.fetch(this);
    }

    @Override
    public String configurationCommands() {
        return "contsense," + (this.check_chassis_continuity ? "y" : "n") + ";" + "failarc," + (!this.arc_detect_only ? "y" : "n") + ";" + "hvsafety," + (this.enable_hv_safety_trip ? "y" : "n") + ";" + "minload," + (this.enable_dc_min_load ? "y" : "n") + ";" + "maxdischarge," + this.max_dc_discharge;
    }

    @Override
    public String[] report() {
        String[] rpt = new String[]{this.enable_tester_start ? "User can Start at the computer or tester" : "User can only Start at the computer", this.check_chassis_continuity ? "Chassis continuity testing is enabled" : "Chassis continuity testing is disabled", this.arc_detect_only ? "Arc detection never causes a failure" : "Arc detection causes a failure (if enabled in a step)", this.enable_hv_safety_trip ? "HV Safety Trip is enabled" : "HV Safety Trip is disabled", this.enable_dc_min_load ? "DCW/DCIR minimum loading is enabled" : "DCW/DCIR minimum loading is disabled", "DCW/DCIR maximum discharge: " + Double.toString(this.max_dc_discharge * 1000.0) + "mA"};
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.enable_tester_start = settings[10].equals("Y");
        this.check_chassis_continuity = settings[11].equals("Y");
        this.arc_detect_only = settings[12].equals("Y");
        this.enable_hv_safety_trip = settings[13].equals("Y");
        this.enable_dc_min_load = settings[14].equals("Y");
        this.max_dc_discharge = Double.parseDouble(settings[15]) / 1000.0;
    }
}

