/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;

public class V10xStepFactory
extends StepFactory {
    @Override
    public String getSeriesName() {
        return "V10x";
    }

    @Override
    public String[] getStepTypes() {
        return new String[]{"ACW", "ACCAP", "DCW", "DCIR", "GB", "LowOhms", "ACI", "DCI", "Pulse", "BRKDN"};
    }

    @Override
    public TestStep newStep(String name) {
        TestStep s = null;
        switch (name) {
            case "ACW": {
                s = new V10xACW();
                break;
            }
            case "ACCAP": {
                s = new V10xACCAP();
                break;
            }
            case "DCW": {
                s = new V10xDCW();
                break;
            }
            case "DCIR": {
                s = new V10xDCIR();
                break;
            }
            case "GB": {
                s = new V10xGB();
                break;
            }
            case "LowOhms": {
                s = new V10xLowOhms();
                break;
            }
            case "ACI": {
                s = new V10xACI();
                break;
            }
            case "DCI": {
                s = new V10xDCI();
                break;
            }
            case "Pulse": {
                s = new V10xPulse();
                break;
            }
            case "BRKDN": {
                s = new V10xBRKDN();
            }
        }
        return s;
    }

    @Override
    public TestStep loadStep(String id, String json, byte[] im) {
        TestStep s = null;
        switch (id) {
            case "ACW": {
                s = (TestStep)new Gson().fromJson(json, V10xACW.class);
                break;
            }
            case "ACCAP": {
                s = (TestStep)new Gson().fromJson(json, V10xACCAP.class);
                break;
            }
            case "DCW": {
                s = (TestStep)new Gson().fromJson(json, V10xDCW.class);
                break;
            }
            case "DCIR": {
                s = (TestStep)new Gson().fromJson(json, V10xDCIR.class);
                break;
            }
            case "GB": {
                s = (TestStep)new Gson().fromJson(json, V10xGB.class);
                break;
            }
            case "LowOhms": {
                s = (TestStep)new Gson().fromJson(json, V10xLowOhms.class);
                break;
            }
            case "ACI": {
                s = (TestStep)new Gson().fromJson(json, V10xACI.class);
                break;
            }
            case "DCI": {
                s = (TestStep)new Gson().fromJson(json, V10xDCI.class);
                break;
            }
            case "Pulse": {
                s = (TestStep)new Gson().fromJson(json, V10xPulse.class);
                break;
            }
            case "BRKDN": {
                s = (TestStep)new Gson().fromJson(json, V10xBRKDN.class);
            }
        }
        return s;
    }

    @Override
    public TestStep loadStep(String csv) {
        TestStep s = null;
        String[] f = csv.split(",");
        switch (f[0]) {
            case "ACW": {
                s = new V10xACW();
                s.importQt(csv);
                break;
            }
            case "BRKDN": {
                s = new V10xBRKDN();
                s.importQt(csv);
                break;
            }
            case "DCIR": {
                s = new V10xDCIR();
                s.importQt(csv);
                break;
            }
            case "DCW": {
                s = new V10xDCW();
                s.importQt(csv);
                break;
            }
            case "GB": {
                s = new V10xGB();
                s.importQt(csv);
                break;
            }
            case "GNDLEAKAGE": {
                s = f[1].equals("Y") ? new V10xACI() : new V10xDCI();
                s.importQt(csv);
                break;
            }
            case "LOWOHMS": {
                s = new V10xLowOhms();
                s.importQt(csv);
                break;
            }
            case "PULSE": {
                s = new V10xPulse();
                s.importQt(csv);
            }
        }
        return s;
    }
}

