/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class V10xPulse_Edit {
    static Text txtUserName;
    static Text textLevel;
    static Combo comboPolarity;
    static Text textRampTime;
    static Text textHoldTime;
    static Text textBreakdown;
    static Label lblBreakdownPrefix;
    static Button btnArcDetect;
    static Text textArcLimit;
    static Combo comboArcTimePeriod;
    static Label lblArcLimitMa;
    static Button btnContinueOnFailure;

    public static Composite editor(Composite parent, TesterSettings tester, V10xPulse settings) {
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpLevel = new Group(edit_space, 0);
        grpLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLevel.setText("Level");
        grpLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLevel.setBounds(10, 0, 253, 76);
        textLevel = new Text((Composite)grpLevel, 133120);
        textLevel.setToolTipText("Specifies the voltage level for the test.");
        textLevel.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textLevel.setBounds(10, 27, 78, 33);
        textLevel.setText(Double.toString(settings.level));
        Label lblVolts = new Label((Composite)grpLevel, 0);
        lblVolts.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblVolts.setBounds(94, 27, 45, 33);
        lblVolts.setText("Volts");
        comboPolarity = new Combo((Composite)grpLevel, 0);
        comboPolarity.setItems(new String[]{"Unipolar+", "Unipolar-", "Bipolar"});
        comboPolarity.setBounds(152, 32, 91, 23);
        switch (settings.test_polarity) {
            case 0: {
                comboPolarity.setText("Unipolar+");
                break;
            }
            case 1: {
                comboPolarity.setText("Unipolar-");
                break;
            }
            case 2: {
                comboPolarity.setText("Bipolar");
            }
        }
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(270, 0, 270, 76);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(32, 34, 208, 21);
        Group groupTiming = new Group(edit_space, 0);
        groupTiming.setToolTipText("");
        groupTiming.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        groupTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupTiming.setText("Timing");
        groupTiming.setBounds(10, 94, 253, 169);
        Label lblRamp = new Label((Composite)groupTiming, 0);
        lblRamp.setBounds(10, 30, 38, 15);
        lblRamp.setText("Ramp");
        textRampTime = new Text((Composite)groupTiming, 133120);
        textRampTime.setToolTipText("Specifies the voltage ramp in terms of time.");
        textRampTime.setBounds(72, 27, 65, 21);
        textRampTime.setText(Double.toString(settings.ramp_time * 1000.0));
        Label lblRampMs = new Label((Composite)groupTiming, 0);
        lblRampMs.setBounds(143, 30, 55, 15);
        lblRampMs.setText("ms");
        Label lblHold = new Label((Composite)groupTiming, 0);
        lblHold.setBounds(10, 91, 55, 15);
        lblHold.setText("Hold");
        textHoldTime = new Text((Composite)groupTiming, 133120);
        textHoldTime.setToolTipText("Specifies the dwell time for the test.");
        textHoldTime.setBounds(72, 88, 65, 21);
        textHoldTime.setText(Double.toString(settings.hold_time * 1000.0));
        Label lblms_1 = new Label((Composite)groupTiming, 0);
        lblms_1.setText("ms");
        lblms_1.setBounds(143, 91, 55, 15);
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setText("Test Limits");
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLimits.setBounds(269, 94, 270, 169);
        Label lblBreakdown = new Label((Composite)grpLimits, 0);
        lblBreakdown.setBounds(10, 29, 65, 15);
        lblBreakdown.setText("Breakdown");
        textBreakdown = new Text((Composite)grpLimits, 133120);
        textBreakdown.setToolTipText("Specifies the instantaneous breakdown current limit.");
        textBreakdown.setText(Double.toString(settings.breakdown_limit * 1000.0));
        textBreakdown.setBounds(81, 29, 74, 21);
        lblBreakdownPrefix = new Label((Composite)grpLimits, 2048);
        lblBreakdownPrefix.setToolTipText("Double click to change the prefix.");
        lblBreakdownPrefix.setBounds(161, 31, 46, 19);
        lblBreakdownPrefix.setText("mA");
        lblBreakdownPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (lblBreakdownPrefix.getText().equals("uA")) {
                    lblBreakdownPrefix.setText("mA");
                } else {
                    lblBreakdownPrefix.setText("uA");
                }
            }
        });
        btnArcDetect = new Button((Composite)grpLimits, 32);
        btnArcDetect.setToolTipText("Check to enable Arc detection.");
        btnArcDetect.setBounds(10, 123, 46, 16);
        btnArcDetect.setText("Arc");
        btnArcDetect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnArcDetect.getSelection()) {
                    textArcLimit.setEnabled(true);
                    lblArcLimitMa.setEnabled(true);
                    comboArcTimePeriod.setEnabled(true);
                } else {
                    textArcLimit.setEnabled(false);
                    lblArcLimitMa.setEnabled(false);
                    comboArcTimePeriod.setEnabled(false);
                }
            }
        });
        textArcLimit = new Text((Composite)grpLimits, 133120);
        textArcLimit.setToolTipText("Arc current limit, 1mA to 30mA.");
        textArcLimit.setText(Integer.toString(settings.arc_settings.arc_detection_limit));
        textArcLimit.setBounds(81, 123, 65, 20);
        lblArcLimitMa = new Label((Composite)grpLimits, 0);
        lblArcLimitMa.setToolTipText("");
        lblArcLimitMa.setText("mA");
        lblArcLimitMa.setBounds(152, 124, 29, 19);
        comboArcTimePeriod = new Combo((Composite)grpLimits, 0);
        comboArcTimePeriod.setToolTipText("Arc time period.");
        comboArcTimePeriod.setItems(new String[]{"4us", "10us", "15us", "20us", "30us", "40us"});
        comboArcTimePeriod.setBounds(206, 121, 54, 23);
        comboArcTimePeriod.setText(String.valueOf(Integer.toString(settings.arc_settings.arc_detection_period)) + "us");
        if (settings.arc_settings.enabled) {
            btnArcDetect.setSelection(true);
            textArcLimit.setEnabled(true);
            lblArcLimitMa.setEnabled(true);
            comboArcTimePeriod.setEnabled(true);
        } else {
            btnArcDetect.setSelection(false);
            textArcLimit.setEnabled(false);
            lblArcLimitMa.setEnabled(false);
            comboArcTimePeriod.setEnabled(false);
        }
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 530, 51);
        btnContinueOnFailure = new Button((Composite)grpOptions, 32);
        btnContinueOnFailure.setToolTipText("The sequence continues even if this step fails.");
        btnContinueOnFailure.setBounds(10, 25, 142, 16);
        btnContinueOnFailure.setText("Continue On Failure");
        if (settings.continue_on_failure) {
            btnContinueOnFailure.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(V10xPulse settings) {
        settings.name = txtUserName.getText();
        settings.level = Double.parseDouble(textLevel.getText());
        settings.ramp_time = Double.parseDouble(textRampTime.getText()) / 1000.0;
        settings.hold_time = Double.parseDouble(textHoldTime.getText()) / 1000.0;
        switch (comboPolarity.getText()) {
            case "Unipolar+": {
                settings.test_polarity = 0;
                break;
            }
            case "Unipolar-": {
                settings.test_polarity = 1;
                break;
            }
            case "Bipolar": {
                settings.test_polarity = 2;
            }
        }
        settings.breakdown_limit = SiTools.toReal(textBreakdown.getText(), lblBreakdownPrefix.getText());
        settings.arc_settings.enabled = btnArcDetect.getSelection();
        settings.arc_settings.arc_detection_limit = Integer.valueOf(textArcLimit.getText());
        switch (comboArcTimePeriod.getText()) {
            case "4us": {
                settings.arc_settings.arc_detection_period = 4;
                break;
            }
            case "10us": {
                settings.arc_settings.arc_detection_period = 10;
                break;
            }
            case "15us": {
                settings.arc_settings.arc_detection_period = 15;
                break;
            }
            case "20us": {
                settings.arc_settings.arc_detection_period = 20;
                break;
            }
            case "30us": {
                settings.arc_settings.arc_detection_period = 30;
                break;
            }
            case "40us": {
                settings.arc_settings.arc_detection_period = 40;
                break;
            }
            default: {
                settings.arc_settings.arc_detection_period = 4;
            }
        }
        settings.continue_on_failure = btnContinueOnFailure.getSelection();
    }
}

