/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V10xPulse
extends TestStep {
    static final int PULSE_POSITIVE = 0;
    static final int PULSE_NEGATIVE = 1;
    static final int PULSE_BIPOLAR = 2;
    String id = "Pulse";
    double level = 250.0;
    double ramp_time = 0.001;
    double hold_time = 0.01;
    double breakdown_limit = 0.05;
    TestStep.ArcSettings arc_settings = new TestStep.ArcSettings();
    int test_polarity = 0;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V10xPulse_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V10xPulse_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String arc = this.arc_settings.enabled ? String.valueOf(this.arc_settings.arc_detection_period) + "," + this.arc_settings.arc_detection_limit : ",";
        String wf = this.test_polarity == 0 ? "positive," : (this.test_polarity == 1 ? "negative," : "bipolar,");
        String command = "add,PULSE," + this.level + "," + wf + this.ramp_time + "," + this.hold_time + "," + this.breakdown_limit + "," + arc + "," + this.abortKeyword();
        return command;
    }

    @Override
    public String stepSummary() {
        return "Pulse:" + this.level;
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Drive", "Volts", "V"}, {"Current", "Amps", "Apk"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[6]);
        rslts[1] = Float.parseFloat(f[5]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("measrslt?,volts;measrslt?,brkdn;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(";");
            int reported_step = Integer.parseInt(f[2]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                r.metrics = new float[3];
                r.metrics[0] = Float.parseFloat(f[0]);
                r.metrics[1] = Float.parseFloat(f[1]);
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double p = 100.0 * (double)i / ((this.ramp_time + this.hold_time) * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + rslts[15] + "," + rslts[16] + "," + rslts[17] + "," + rslts[18] : ",,,,,";
            csv = String.valueOf(this.hold_time) + "," + this.level + "," + rslts[3] + "," + "," + this.breakdown_limit + "," + rslts[5] + "," + "Amps," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        } else {
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + "," + "," + "," : ",,,,,";
            csv = String.valueOf(this.hold_time) + "," + this.level + "," + "," + "," + this.breakdown_limit + "," + "," + "Amps," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t dlevel) {
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (dlevel) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 2;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        String pol = this.test_polarity == 0 ? "Positive" : (this.test_polarity == 1 ? "Negative" : "Bipolar");
        rpt[0] = String.valueOf(pol) + " Pulse @ " + this.level + "V";
        switch (dlevel) {
            case brief: {
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                do_arc *= 2;
                rpt[1] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " at " + SiTools.toString(rslts[6], "V");
            }
        }
        if (do_arc != 0) {
            rpt[do_arc] = "ARC: " + SiTools.toString(rslts[17], "A") + " to " + SiTools.toString(rslts[16], "A") + ", Avg:" + SiTools.toString(rslts[17], "A") + ", Final:" + SiTools.toString(rslts[18], "A") + " (Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us)";
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t dlevel) {
        String pol = this.test_polarity == 0 ? "Positive" : (this.test_polarity == 1 ? "Negative" : "Bipolar");
        return new String[]{String.valueOf(pol) + " Pulse @ " + this.level + "V"};
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.level = Double.parseDouble(settings[1]);
        switch (settings[2]) {
            case "BIPOLAR": {
                this.test_polarity = 2;
                break;
            }
            case "NEGATIVE": {
                this.test_polarity = 1;
                break;
            }
            case "POSITIVE": {
                this.test_polarity = 0;
            }
        }
        this.ramp_time = Double.parseDouble(settings[3]);
        this.hold_time = Double.parseDouble(settings[4]);
        this.breakdown_limit = Double.parseDouble(settings[5]);
        this.arc_settings.enabled = settings[6].equals("Y");
        this.arc_settings.arc_detection_limit = Integer.valueOf(settings[7]);
        this.arc_settings.arc_detection_period = Integer.valueOf(settings[8]);
        boolean bl = this.continue_on_failure = settings[9].equals("Y");
        if (settings.length > 10) {
            this.name = settings[10];
        }
    }
}

