/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V10xLowOhms
extends TestStep {
    String id = "LowOhms";
    int test_mode = 2;
    double test_time = 5.0;
    boolean user_terminated = false;
    double check_delay = 0.0;
    double minimum_resistance = 0.0;
    double maximum_resistance = 1.0;
    double fixture_offset = 0.0;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V10xLowOhms_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V10xLowOhms_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String command = "add,LOWOHM," + (this.test_mode == 2 ? "1" : "0") + "," + (this.user_terminated ? "" : Double.valueOf(this.test_time)) + "," + this.check_delay + "," + this.minimum_resistance + "," + this.maximum_resistance + "," + this.abortKeyword();
        if (this.fixture_offset != 0.0) {
            command = String.valueOf(command) + "," + this.fixture_offset;
        }
        return command;
    }

    @Override
    public String stepSummary() {
        return "Low Ohms:" + this.test_mode + "-wire";
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Load", "Ohms", "\u2126"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[1];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[9]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("phase?;measrslt?,ohms;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(";");
            int reported_step = Integer.parseInt(f[2]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                int phase;
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double total_step_time = (this.user_terminated ? 9999.0 : this.test_time) + this.check_delay;
                double p = 100.0 * (double)i / (total_step_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                if ((phase = Integer.parseInt(f[0])) >= 2 && phase <= 3) {
                    r.metrics = new float[1];
                    r.metrics[0] = Float.parseFloat(f[1]);
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            csv = (this.user_terminated ? rslts[1] : Double.valueOf(this.test_time)) + "," + "," + "," + "," + "," + "," + "Ohms," + this.maximum_resistance + "," + this.minimum_resistance + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[7]))) + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[8]))) + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[9]))) + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[10])));
        } else {
            csv = (this.user_terminated ? "" : Double.valueOf(this.test_time)) + "," + "," + "," + "," + "," + "," + "Ohms," + this.maximum_resistance + "," + this.minimum_resistance + "," + "," + "," + ",";
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        String delay = this.check_delay > 0.0 ? "  Delay " + this.check_delay + "s" : "";
        rpt[0] = !this.user_terminated ? "LowOhms " + this.test_mode + "-wire for " + this.test_time + "s" + delay : "LowOhms " + this.test_mode + "-wire for " + rslts[1] + "s" + delay;
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                rpt[1] = "Load: " + SiTools.toString(Float.parseFloat(rslts[8]), "\u2126") + " to " + SiTools.toString(Float.parseFloat(rslts[7]), "\u2126") + " (" + SiTools.toString(this.minimum_resistance, "\u2126") + " to " + SiTools.toString(this.maximum_resistance, "\u2126") + " limits)";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                rpt[1] = "Load: " + SiTools.toString(Float.parseFloat(rslts[8]), "\u2126") + " to " + SiTools.toString(Float.parseFloat(rslts[7]), "\u2126") + ", Avg:" + SiTools.toString(Float.parseFloat(rslts[9]), "\u2126") + ", Final:" + SiTools.toString(Float.parseFloat(rslts[10]), "\u2126") + " (" + SiTools.toString(this.minimum_resistance, "\u2126") + " to " + SiTools.toString(this.maximum_resistance, "\u2126") + " limits)";
            }
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        String delay = this.check_delay > 0.0 ? "  Delay " + this.check_delay + "s" : "";
        rpt[0] = !this.user_terminated ? "LowOhms " + this.test_mode + "-wire for " + this.test_time + "s" + delay : "LowOhms " + this.test_mode + "-wire user terminated" + delay;
        if (level != ReportSettings.detail_level_t.brief) {
            rpt[1] = "Load: " + SiTools.toString(this.minimum_resistance, "\u2126") + " to " + SiTools.toString(this.maximum_resistance, "\u2126") + (this.fixture_offset != 0.0 ? " (Fixture offset " + this.fixture_offset + "\u2126)" : "");
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_mode = settings[1].equals("Y") ? 2 : 4;
        this.test_time = Double.parseDouble(settings[2]);
        this.check_delay = Double.parseDouble(settings[3]);
        this.minimum_resistance = Double.parseDouble(settings[4]) * Math.pow(10.0, Double.parseDouble(settings[6]));
        this.maximum_resistance = Double.parseDouble(settings[5]) * Math.pow(10.0, Double.parseDouble(settings[6]));
        this.continue_on_failure = settings[7].equals("Y");
        this.fixture_offset = Double.parseDouble(settings[8]);
        if (settings.length > 9) {
            this.name = settings[9];
        }
    }
}

