/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class V10xGB_Edit {
    private static Text textLevel;
    private static Text textFrequency;
    private static Text txtUserName;
    private static Text textRampTime;
    private static Text textRampAmpsSec;
    private static Text textDwellTime;
    private static Button btnUser;
    private static Label lblS_1;
    private static Button buttonRampTime;
    private static Button buttonRampVoltsSec;
    private static Label lblRampSeconds;
    private static Label lblRampAsec;
    private static Combo comboDischarge;
    private static Label lblDriveLimit;
    private static Text textDriveLimit;
    private static Label lblDriveVolts;
    private static Label lblCheck;
    private static Combo comboCheckValue;
    private static Label lblTo;
    private static Label lblMinimumPrefix;
    private static Label lblMaximumPrefix;
    private static Text textMinimumLimit;
    private static Text textMaximumLimit;
    private static Button btnContinueOnFailure;
    private static Label lblFixtureComp;
    private static Text textFixtureCompensation;
    private static Label lblCompensationUnits;

    private static void checkLevelTranslate(Text w_min_limit, Text w_max_limit, Label w_min_prefix, Label w_max_prefix, String u) {
        double lvl = Double.parseDouble(textLevel.getText());
        String min = w_min_limit.getText();
        String max = w_max_limit.getText();
        String min_prefix = w_min_prefix.getText();
        String max_prefix = w_max_prefix.getText();
        if (u.equals("V")) {
            double v = lvl * SiTools.toReal(min, min_prefix);
            String nt = SiTools.toString(v);
            w_min_limit.setText(nt);
            String p = SiTools.prefix(v);
            w_min_prefix.setText(String.valueOf(p) + u);
            v = lvl * SiTools.toReal(max, max_prefix);
            nt = SiTools.toString(v);
            w_max_limit.setText(nt);
            p = SiTools.prefix(v);
            w_max_prefix.setText(String.valueOf(p) + u);
        } else if (lvl > 1.0E-12) {
            double v = SiTools.toReal(min, min_prefix) / lvl;
            String nt = SiTools.toString(v);
            w_min_limit.setText(nt);
            String p = SiTools.prefix(v);
            w_min_prefix.setText(String.valueOf(p) + u);
            v = SiTools.toReal(max, max_prefix) / lvl;
            nt = SiTools.toString(v);
            w_max_limit.setText(nt);
            p = SiTools.prefix(v);
            w_max_prefix.setText(String.valueOf(p) + u);
        }
    }

    private static String checkToUnits(TestStep.hipot_check_t code) {
        String units = "";
        switch (code) {
            default: {
                units = "V";
                break;
            }
            case check_INPHSV: {
                units = "V";
                break;
            }
            case check_QUADV: {
                units = "V";
                break;
            }
            case check_RMSO: {
                units = "\u2126";
                break;
            }
            case check_INPHSO: {
                units = "\u2126";
                break;
            }
            case check_QUADO: {
                units = "\u2126";
            }
        }
        return units;
    }

    private static String checkToHuman(TestStep.hipot_check_t code) {
        String label = "";
        switch (code) {
            default: {
                label = "RMSV";
                break;
            }
            case check_INPHSV: {
                label = "INPHSV";
                break;
            }
            case check_QUADV: {
                label = "QUADV";
                break;
            }
            case check_RMSO: {
                label = "RMSO";
                break;
            }
            case check_INPHSO: {
                label = "INPHSO";
                break;
            }
            case check_QUADO: {
                label = "QUADO";
            }
        }
        return label;
    }

    private static TestStep.hipot_check_t toCheckCode(String human) {
        TestStep.hipot_check_t code = TestStep.hipot_check_t.check_NONE;
        switch (human) {
            case "None": {
                code = TestStep.hipot_check_t.check_NONE;
                break;
            }
            case "RMSV": {
                code = TestStep.hipot_check_t.check_RMSV;
                break;
            }
            case "INPHSV": {
                code = TestStep.hipot_check_t.check_INPHSV;
                break;
            }
            case "QUADV": {
                code = TestStep.hipot_check_t.check_QUADV;
                break;
            }
            case "RMSO": {
                code = TestStep.hipot_check_t.check_RMSO;
                break;
            }
            case "INPHSO": {
                code = TestStep.hipot_check_t.check_INPHSO;
                break;
            }
            case "QUADO": {
                code = TestStep.hipot_check_t.check_QUADO;
            }
        }
        return code;
    }

    public static Composite editor(Composite parent, TesterSettings tester, final V10xGB settings) {
        final DecimalFormat df3 = new DecimalFormat("0.000");
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpLevel = new Group(edit_space, 0);
        grpLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLevel.setText("Levels");
        grpLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLevel.setBounds(10, 0, 320, 60);
        textLevel = new Text((Composite)grpLevel, 133120);
        textLevel.setToolTipText("Specifies the current level for the test.");
        textLevel.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textLevel.setBounds(82, 15, 73, 35);
        textLevel.setText(Double.toString(settings.test_level));
        Label lblAmps = new Label((Composite)grpLevel, 0);
        lblAmps.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblAmps.setBounds(161, 15, 53, 35);
        lblAmps.setText("Amps");
        textFrequency = new Text((Composite)grpLevel, 133120);
        textFrequency.setToolTipText("Specifies the test frequency.");
        textFrequency.setText(Double.toString(settings.test_frequency));
        textFrequency.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textFrequency.setBounds(220, 15, 53, 35);
        Label lblHz = new Label((Composite)grpLevel, 0);
        lblHz.setText("Hz");
        lblHz.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblHz.setBounds(279, 15, 31, 35);
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(336, 0, 210, 60);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(10, 25, 184, 21);
        Group groupTiming = new Group(edit_space, 0);
        groupTiming.setToolTipText("");
        groupTiming.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        groupTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupTiming.setText("Timing");
        groupTiming.setBounds(10, 66, 246, 197);
        Label lblRamp = new Label((Composite)groupTiming, 0);
        lblRamp.setBounds(10, 33, 38, 15);
        lblRamp.setText("Ramp");
        buttonRampTime = new Button((Composite)groupTiming, 16);
        buttonRampTime.setToolTipText("Chooses the ramp to be in terms of time.");
        buttonRampTime.setBounds(46, 22, 21, 16);
        buttonRampTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 1;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampAmpsSec.getText());
                    if (t2 < 0.1) {
                        t2 = 0.1;
                    }
                    textRampTime.setText(df3.format(t1 / t2));
                    textRampAmpsSec.setEnabled(false);
                    textRampTime.setEnabled(true);
                    lblRampAsec.setEnabled(false);
                    lblRampSeconds.setEnabled(true);
                    textRampTime.setFocus();
                }
            }
        });
        buttonRampVoltsSec = new Button((Composite)groupTiming, 16);
        buttonRampVoltsSec.setToolTipText("Chooses the ramp to be in terms of amps/second.");
        buttonRampVoltsSec.setBounds(46, 51, 21, 16);
        buttonRampVoltsSec.setText("");
        buttonRampVoltsSec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 2;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampTime.getText());
                    if (t2 < 0.001) {
                        t2 = 0.001;
                    }
                    textRampAmpsSec.setText(df3.format(t1 / t2));
                    textRampTime.setEnabled(false);
                    textRampAmpsSec.setEnabled(true);
                    lblRampSeconds.setEnabled(false);
                    lblRampAsec.setEnabled(true);
                    textRampAmpsSec.setFocus();
                }
            }
        });
        textRampTime = new Text((Composite)groupTiming, 133120);
        textRampTime.setToolTipText("Specifies the current ramp in terms of time.");
        textRampTime.setBounds(72, 22, 65, 21);
        textRampAmpsSec = new Text((Composite)groupTiming, 133120);
        textRampAmpsSec.setToolTipText("Specifies the current ramp in terms of amps/second.");
        textRampAmpsSec.setBounds(72, 49, 65, 21);
        lblRampSeconds = new Label((Composite)groupTiming, 0);
        lblRampSeconds.setBounds(143, 22, 55, 15);
        lblRampSeconds.setText("seconds");
        lblRampAsec = new Label((Composite)groupTiming, 0);
        lblRampAsec.setEnabled(false);
        lblRampAsec.setText("A/sec");
        lblRampAsec.setBounds(143, 51, 55, 15);
        if (settings.ramp_units == 1) {
            textRampTime.setText(Double.toString(settings.ramp_setting));
            textRampAmpsSec.setText(df3.format(settings.test_level / settings.ramp_setting));
            textRampAmpsSec.setEnabled(false);
            textRampTime.setEnabled(true);
            lblRampAsec.setEnabled(false);
            lblRampSeconds.setEnabled(true);
            buttonRampTime.setSelection(true);
        } else {
            textRampTime.setText(Double.toString(settings.test_level / settings.ramp_setting));
            textRampAmpsSec.setText(df3.format(settings.ramp_setting));
            textRampTime.setEnabled(false);
            textRampAmpsSec.setEnabled(true);
            lblRampSeconds.setEnabled(false);
            lblRampAsec.setEnabled(true);
            buttonRampVoltsSec.setSelection(true);
        }
        Label lblDwell = new Label((Composite)groupTiming, 0);
        lblDwell.setBounds(10, 91, 55, 15);
        lblDwell.setText("Dwell");
        textDwellTime = new Text((Composite)groupTiming, 133120);
        textDwellTime.setToolTipText("Specifies the dwell time for the test.");
        textDwellTime.setBounds(72, 88, 65, 21);
        textDwellTime.setText(Double.toString(settings.dwell_time));
        btnUser = new Button((Composite)groupTiming, 32);
        btnUser.setBounds(199, 92, 44, 16);
        btnUser.setToolTipText("Allows the test to dwell until ended by the user.");
        btnUser.setText("User");
        btnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUser.getSelection()) {
                    textDwellTime.setEnabled(false);
                    lblS_1.setEnabled(false);
                } else {
                    textDwellTime.setEnabled(true);
                    lblS_1.setEnabled(true);
                }
            }
        });
        lblS_1 = new Label((Composite)groupTiming, 0);
        lblS_1.setText("seconds");
        lblS_1.setBounds(143, 90, 55, 15);
        if (settings.user_terminated) {
            btnUser.setSelection(true);
            textDwellTime.setEnabled(false);
            lblS_1.setEnabled(false);
        }
        Label lblDischarge = new Label((Composite)groupTiming, 0);
        lblDischarge.setBounds(9, 167, 55, 15);
        lblDischarge.setText("Discharge");
        comboDischarge = new Combo((Composite)groupTiming, 0);
        comboDischarge.setToolTipText("Specifies how discharge is processed.");
        comboDischarge.setItems(new String[]{"None", "Fast", "As Ramp"});
        comboDischarge.setBounds(71, 164, 77, 23);
        switch (settings.discharge_ramp_type) {
            case 0: {
                comboDischarge.setText("None");
                break;
            }
            case 1: {
                comboDischarge.setText("Fast");
                break;
            }
            case 2: {
                comboDischarge.setText("As Ramp");
            }
        }
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setText("Test Limits");
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLimits.setBounds(262, 66, 283, 197);
        lblDriveLimit = new Label((Composite)grpLimits, 0);
        lblDriveLimit.setText("Drive Limit");
        lblDriveLimit.setBounds(10, 27, 65, 15);
        textDriveLimit = new Text((Composite)grpLimits, 133120);
        textDriveLimit.setToolTipText("Specifies the maximum open circuit drive (in Vrms).");
        textDriveLimit.setText(Double.toString(settings.maximum_drive));
        textDriveLimit.setBounds(162, 27, 60, 21);
        lblDriveVolts = new Label((Composite)grpLimits, 0);
        lblDriveVolts.setText("Volts");
        lblDriveVolts.setBounds(230, 27, 33, 15);
        lblCheck = new Label((Composite)grpLimits, 0);
        lblCheck.setText("Check");
        lblCheck.setBounds(10, 80, 65, 15);
        lblTo = new Label((Composite)grpLimits, 0);
        lblTo.setText("to");
        lblTo.setBounds(139, 117, 19, 15);
        comboCheckValue = new Combo((Composite)grpLimits, 0);
        comboCheckValue.setItems(new String[]{"RMSV", "INPHSV", "QUADV", "RMSO", "INPHSO", "QUADO"});
        comboCheckValue.setBounds(75, 76, 73, 23);
        String limit_units = V10xGB_Edit.checkToUnits(settings.test_check);
        comboCheckValue.setText(V10xGB_Edit.checkToHuman(settings.test_check));
        comboCheckValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestStep.hipot_check_t code = V10xGB_Edit.toCheckCode(comboCheckValue.getText());
                String to_units = V10xGB_Edit.checkToUnits(code);
                if (to_units != V10xGB_Edit.checkToUnits(settings.test_check)) {
                    V10xGB_Edit.checkLevelTranslate(textMinimumLimit, textMaximumLimit, lblMinimumPrefix, lblMaximumPrefix, to_units);
                }
                settings.test_check = code;
                if (to_units.equals("V")) {
                    lblCompensationUnits.setText("Volts");
                } else {
                    lblCompensationUnits.setText("\u2126");
                }
            }
        });
        textMinimumLimit = new Text((Composite)grpLimits, 133120);
        textMinimumLimit.setToolTipText("Specifies the lower check limit.");
        textMinimumLimit.setBounds(162, 76, 60, 21);
        textMinimumLimit.setText(SiTools.toString(settings.minimum_limit));
        lblMinimumPrefix = new Label((Composite)grpLimits, 2048);
        lblMinimumPrefix.setToolTipText("Double click to change the prefix.");
        lblMinimumPrefix.setText(String.valueOf(SiTools.prefix(settings.minimum_limit)) + limit_units);
        lblMinimumPrefix.setBounds(230, 76, 46, 19);
        lblMinimumPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumPrefix);
            }
        });
        textMaximumLimit = new Text((Composite)grpLimits, 133120);
        textMaximumLimit.setToolTipText("Specifies the upper check limit.");
        textMaximumLimit.setBounds(159, 114, 60, 21);
        textMaximumLimit.setText(SiTools.toString(settings.maximum_limit));
        lblMaximumPrefix = new Label((Composite)grpLimits, 2048);
        lblMaximumPrefix.setToolTipText("Double click to change the prefix.");
        lblMaximumPrefix.setBounds(227, 117, 46, 19);
        lblMaximumPrefix.setText(String.valueOf(SiTools.prefix(settings.maximum_limit)) + limit_units);
        lblMaximumPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumPrefix);
            }
        });
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 536, 51);
        btnContinueOnFailure = new Button((Composite)grpOptions, 32);
        btnContinueOnFailure.setToolTipText("The sequence continues even if this step fails.");
        btnContinueOnFailure.setBounds(10, 25, 154, 16);
        btnContinueOnFailure.setText("Continue On Failure");
        lblFixtureComp = new Label((Composite)grpOptions, 0);
        lblFixtureComp.setText("Fixture Compensation");
        lblFixtureComp.setBounds(273, 20, 123, 15);
        textFixtureCompensation = new Text((Composite)grpOptions, 133120);
        textFixtureCompensation.setToolTipText("Allows compensation for the test fixture.");
        textFixtureCompensation.setText(Double.toString(settings.fixture_offset));
        textFixtureCompensation.setBounds(425, 20, 60, 21);
        lblCompensationUnits = new Label((Composite)grpOptions, 0);
        if (V10xGB_Edit.checkToUnits(settings.test_check).equals("V")) {
            lblCompensationUnits.setText("Volts");
        } else {
            lblCompensationUnits.setText("\u2126");
        }
        lblCompensationUnits.setBounds(493, 23, 33, 15);
        if (settings.continue_on_failure) {
            btnContinueOnFailure.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(V10xGB settings) {
        settings.name = txtUserName.getText();
        settings.test_level = Double.parseDouble(textLevel.getText());
        settings.test_frequency = Double.parseDouble(textFrequency.getText());
        settings.ramp_setting = settings.ramp_units == 1 ? Double.parseDouble(textRampTime.getText()) : Double.parseDouble(textRampAmpsSec.getText());
        settings.dwell_time = Double.parseDouble(textDwellTime.getText());
        settings.user_terminated = btnUser.getSelection();
        switch (comboDischarge.getText()) {
            case "None": {
                settings.discharge_ramp_type = 0;
                break;
            }
            case "Fast": {
                settings.discharge_ramp_type = 1;
                break;
            }
            case "As Ramp": {
                settings.discharge_ramp_type = 2;
            }
        }
        settings.maximum_drive = Double.parseDouble(textDriveLimit.getText());
        settings.minimum_limit = SiTools.toReal(textMinimumLimit.getText(), lblMinimumPrefix.getText());
        settings.maximum_limit = SiTools.toReal(textMaximumLimit.getText(), lblMaximumPrefix.getText());
        settings.fixture_offset = Double.parseDouble(textFixtureCompensation.getText());
        settings.continue_on_failure = btnContinueOnFailure.getSelection();
    }
}

