/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V10xGB
extends TestStep {
    String id = "GB";
    double test_level = 10.0;
    double test_frequency = 60.0;
    double maximum_drive = 8.0;
    double ramp_setting = 1.0;
    int ramp_units = 1;
    double dwell_time = 10.0;
    boolean user_terminated = false;
    double discharge_setting = 2.0;
    int discharge_ramp_type = 1;
    TestStep.hipot_check_t test_check = TestStep.hipot_check_t.check_RMSO;
    double minimum_limit = 0.0;
    double maximum_limit = 0.1;
    double fixture_offset = 0.0;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V10xGB_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V10xGB_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String command = "add,GB," + this.test_level + "," + this.test_frequency + "," + this.maximum_drive + "," + (this.ramp_units == 1 ? this.ramp_setting : this.test_level / this.ramp_setting) + "," + (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.checkKeyword(this.test_check) + "," + (this.minimum_limit + this.fixture_offset) + "," + (this.maximum_limit + this.fixture_offset) + "," + this.dischargeKeyword(this.discharge_ramp_type) + "," + this.abortKeyword();
        return command;
    }

    @Override
    public String stepSummary() {
        return "GB:" + this.test_level + "A @ " + this.test_frequency + "Hz";
    }

    @Override
    public String[][] labels() {
        String cu;
        String cl;
        switch (this.test_check) {
            case check_RMSV: {
                cl = "RMS";
                cu = "V";
                break;
            }
            case check_INPHSV: {
                cl = "INPHS";
                cu = "V";
                break;
            }
            case check_QUADV: {
                cl = "QUAD";
                cu = "V";
                break;
            }
            default: {
                cl = "RMS";
                cu = "\u2126";
                break;
            }
            case check_INPHSO: {
                cl = "INPHS";
                cu = "\u2126";
                break;
            }
            case check_QUADO: {
                cl = "QUAD";
                cu = "\u2126";
            }
        }
        return new String[][]{{"Drive", "Amps", "A"}, {"Check", cl, cu}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[3]);
        rslts[1] = Float.parseFloat(f[9]) - (float)this.fixture_offset;
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        String m2;
        TestStep.StepStatus r = new TestStep.StepStatus();
        switch (this.test_check) {
            case check_RMSV: {
                m2 = "VOLTS";
                break;
            }
            case check_INPHSV: {
                m2 = "INPHSV";
                break;
            }
            case check_QUADV: {
                m2 = "QUADV";
                break;
            }
            default: {
                m2 = "OHMS";
                break;
            }
            case check_INPHSO: {
                m2 = "INPHSO";
                break;
            }
            case check_QUADO: {
                m2 = "QUADO";
            }
        }
        io_handle.sendCommand("phase?;measrslt?,amps;measrslt?," + m2 + ";step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(";");
            int reported_step = Integer.parseInt(f[3]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                int phase;
                double total_step_time;
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double d = total_step_time = this.user_terminated ? 9999.0 : this.dwell_time;
                total_step_time = this.ramp_units == 1 ? (total_step_time += this.ramp_setting) : (total_step_time += this.test_level / this.ramp_setting);
                double p = 100.0 * (double)i / (total_step_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                if ((phase = Integer.parseInt(f[0])) >= 1 && phase <= 3) {
                    r.metrics = new float[2];
                    r.metrics[0] = Float.parseFloat(f[1]);
                    r.metrics[1] = Float.parseFloat(f[2]) - (float)this.fixture_offset;
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            csv = (this.user_terminated ? rslts[1] : Double.valueOf(this.dwell_time)) + "," + this.test_level + "," + rslts[3] + "," + this.test_frequency + "," + "," + "," + this.checkKeyword(this.test_check) + "," + this.maximum_limit + "," + this.minimum_limit + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[7]) - (float)this.fixture_offset)) + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[8]) - (float)this.fixture_offset)) + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[9]) - (float)this.fixture_offset)) + "," + String.format("%6.3e", Float.valueOf(Float.parseFloat(rslts[10]) - (float)this.fixture_offset)) + ",";
        } else {
            csv = (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.test_level + "," + "," + this.test_frequency + "," + "," + "," + this.checkKeyword(this.test_check) + "," + this.maximum_limit + "," + this.minimum_limit + "," + "," + "," + "," + ",";
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String cu;
        String cl;
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: {
                num_lines = 2;
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 3;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = !this.user_terminated ? "GB @ " + this.test_level + "A/" + this.test_frequency + "Hz for " + this.dwell_time + "s" : "GB @ " + this.test_level + "A/" + this.test_frequency + "Hz for " + rslts[1] + "s";
        switch (this.test_check) {
            case check_RMSV: {
                cl = "RMS";
                cu = "V";
                break;
            }
            case check_INPHSV: {
                cl = "INPHS";
                cu = "V";
                break;
            }
            case check_QUADV: {
                cl = "QUAD";
                cu = "V";
                break;
            }
            default: {
                cl = "RMS";
                cu = "\u2126";
                break;
            }
            case check_INPHSO: {
                cl = "INPHS";
                cu = "\u2126";
                break;
            }
            case check_QUADO: {
                cl = "QUAD";
                cu = "\u2126";
            }
        }
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                rpt[1] = String.valueOf(cl) + " Load: " + SiTools.toString(Float.parseFloat(rslts[8]) - (float)this.fixture_offset, cu) + " to " + SiTools.toString(Float.parseFloat(rslts[7]) - (float)this.fixture_offset, cu) + " (" + SiTools.toString(this.minimum_limit, cu) + " to " + SiTools.toString(this.maximum_limit, cu) + " limits)";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
                rpt[2] = String.valueOf(cl) + " Load: " + SiTools.toString(Float.parseFloat(rslts[8]) - (float)this.fixture_offset, cu) + " to " + SiTools.toString(Float.parseFloat(rslts[7]) - (float)this.fixture_offset, cu) + ", Avg:" + SiTools.toString(Float.parseFloat(rslts[9]) - (float)this.fixture_offset, cu) + ", Final:" + SiTools.toString(Float.parseFloat(rslts[10]) - (float)this.fixture_offset, cu) + " (" + SiTools.toString(this.minimum_limit, cu) + " to " + SiTools.toString(this.maximum_limit, cu) + " limits)";
            }
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String cu;
        String cl;
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 3;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = !this.user_terminated ? "GB @ " + this.test_level + "A/" + this.test_frequency + "Hz for " + this.dwell_time + "s" : "GB @ " + this.test_level + "A/" + this.test_frequency + "Hz user terminated";
        switch (this.test_check) {
            case check_RMSV: {
                cl = "RMS";
                cu = "V";
                break;
            }
            case check_INPHSV: {
                cl = "INPHS";
                cu = "V";
                break;
            }
            case check_QUADV: {
                cl = "QUAD";
                cu = "V";
                break;
            }
            default: {
                cl = "RMS";
                cu = "\u2126";
                break;
            }
            case check_INPHSO: {
                cl = "INPHS";
                cu = "\u2126";
                break;
            }
            case check_QUADO: {
                cl = "QUAD";
                cu = "\u2126";
            }
        }
        if (level != ReportSettings.detail_level_t.brief) {
            rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
            rpt[2] = String.valueOf(cl) + " Load: " + SiTools.toString(this.minimum_limit, cu) + " to " + SiTools.toString(this.maximum_limit, cu) + (this.fixture_offset != 0.0 ? " (Fixture offset " + this.fixture_offset + "\u2126)" : "");
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_level = Double.parseDouble(settings[1]);
        this.test_frequency = Double.parseDouble(settings[2]);
        this.maximum_drive = Double.parseDouble(settings[3]);
        this.ramp_units = settings[4].equals("Y") ? 1 : 2;
        this.ramp_setting = Double.parseDouble(settings[5]);
        this.dwell_time = Double.parseDouble(settings[6]);
        switch (settings[7]) {
            case "NONE": {
                this.discharge_ramp_type = 0;
                break;
            }
            case "FAST": {
                this.discharge_ramp_type = 1;
                break;
            }
            case "AS RAMP": {
                this.discharge_ramp_type = 2;
            }
        }
        switch (settings[8]) {
            case "VRMSV": {
                this.test_check = TestStep.hipot_check_t.check_RMSV;
                break;
            }
            case "VINPHS": {
                this.test_check = TestStep.hipot_check_t.check_INPHSV;
                break;
            }
            case "VQUAD": {
                this.test_check = TestStep.hipot_check_t.check_QUADV;
                break;
            }
            case "ORMS": {
                this.test_check = TestStep.hipot_check_t.check_RMSO;
                break;
            }
            case "OINPHS": {
                this.test_check = TestStep.hipot_check_t.check_INPHSO;
                break;
            }
            case "OQUAD": {
                this.test_check = TestStep.hipot_check_t.check_QUADO;
            }
        }
        this.minimum_limit = Double.parseDouble(settings[9]) * Math.pow(10.0, Double.parseDouble(settings[11]));
        this.maximum_limit = Double.parseDouble(settings[10]) * Math.pow(10.0, Double.parseDouble(settings[11]));
        this.continue_on_failure = settings[12].equals("Y");
        this.fixture_offset = Double.parseDouble(settings[13]);
        if (settings.length > 14) {
            this.name = settings[14];
        }
    }
}

