/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class V10xDCI_Edit {
    private static Text txtUserName;
    private static Text textTestTime;
    private static Text textTestDelay;
    private static Button btnUser;
    private static Label lblS_1;
    private static Label lblMinimumPrefix;
    private static Label lblMaximumPrefix;
    private static Text txtMaximumLimit;
    private static Text txtMinimumLimit;
    private static Button btnArcDetect;
    private static Combo comboArcTimePeriod;
    private static Text textArcLimit;
    private static Label lblArcLimitMa;
    private static Button btnContinueOnFailure;

    public static Composite editor(Composite parent, TesterSettings tester, V10xDCI settings) {
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(10, 0, 524, 60);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(32, 25, 208, 21);
        Group grpTiming = new Group(edit_space, 0);
        grpTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpTiming.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpTiming.setText("Timing");
        grpTiming.setBounds(10, 105, 253, 139);
        Label lblTestTime = new Label((Composite)grpTiming, 0);
        lblTestTime.setBounds(10, 37, 55, 15);
        lblTestTime.setText("Test Time");
        Label lblTestDelay = new Label((Composite)grpTiming, 0);
        lblTestDelay.setBounds(10, 58, 55, 15);
        lblTestDelay.setText("Test Delay");
        textTestTime = new Text((Composite)grpTiming, 133120);
        textTestTime.setToolTipText("Specifies the dwell time for the test.");
        textTestTime.setBounds(72, 34, 65, 21);
        textTestTime.setText(Double.toString(settings.test_time));
        btnUser = new Button((Composite)grpTiming, 32);
        btnUser.setBounds(204, 38, 39, 16);
        btnUser.setToolTipText("Allows the test to dwell until ended by the user.");
        btnUser.setText("User");
        btnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUser.getSelection()) {
                    textTestTime.setEnabled(false);
                    lblS_1.setEnabled(false);
                } else {
                    textTestTime.setEnabled(true);
                    lblS_1.setEnabled(true);
                }
            }
        });
        lblS_1 = new Label((Composite)grpTiming, 0);
        lblS_1.setText("seconds");
        lblS_1.setBounds(143, 36, 55, 15);
        if (settings.user_terminated) {
            btnUser.setSelection(true);
            textTestTime.setEnabled(false);
            lblS_1.setEnabled(false);
        }
        textTestDelay = new Text((Composite)grpTiming, 133120);
        textTestDelay.setBounds(72, 58, 65, 21);
        textTestDelay.setText(Double.toString(settings.delay_time));
        Label lblS_2 = new Label((Composite)grpTiming, 0);
        lblS_2.setText("seconds");
        lblS_2.setBounds(143, 57, 55, 15);
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setText("Test Limits");
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpLimits.setBounds(270, 105, 270, 158);
        Label lblLeakage = new Label((Composite)grpLimits, 0);
        lblLeakage.setText("Leakage");
        lblLeakage.setBounds(10, 29, 46, 15);
        Label lblTo_1 = new Label((Composite)grpLimits, 0);
        lblTo_1.setText("to");
        lblTo_1.setBounds(120, 54, 11, 15);
        txtMinimumLimit = new Text((Composite)grpLimits, 133120);
        txtMinimumLimit.setToolTipText("Specifies the lower leakage current limit.");
        txtMinimumLimit.setText(SiTools.toString(settings.minimum_leakage_current_limit));
        txtMinimumLimit.setBounds(137, 29, 74, 21);
        txtMaximumLimit = new Text((Composite)grpLimits, 133120);
        txtMaximumLimit.setToolTipText("Specifies the upper leakage current limit.");
        txtMaximumLimit.setText(SiTools.toString(settings.maximum_leakage_current_limit));
        txtMaximumLimit.setBounds(137, 51, 76, 21);
        lblMinimumPrefix = new Label((Composite)grpLimits, 2048);
        lblMinimumPrefix.setToolTipText("Double click to change the prefix.");
        lblMinimumPrefix.setText(String.valueOf(SiTools.prefix(settings.minimum_leakage_current_limit)) + "A");
        lblMinimumPrefix.setBounds(217, 29, 46, 19);
        lblMinimumPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumPrefix, true);
            }
        });
        lblMaximumPrefix = new Label((Composite)grpLimits, 2048);
        lblMaximumPrefix.setToolTipText("Double click to change the prefix.");
        lblMaximumPrefix.setText(String.valueOf(SiTools.prefix(settings.maximum_leakage_current_limit)) + "A");
        lblMaximumPrefix.setBounds(217, 54, 46, 19);
        lblMaximumPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumPrefix, true);
            }
        });
        btnArcDetect = new Button((Composite)grpLimits, 32);
        btnArcDetect.setToolTipText("Check to enable Arc detection.");
        btnArcDetect.setText("Arc");
        btnArcDetect.setBounds(13, 115, 46, 16);
        btnArcDetect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnArcDetect.getSelection()) {
                    textArcLimit.setEnabled(true);
                    lblArcLimitMa.setEnabled(true);
                    comboArcTimePeriod.setEnabled(true);
                } else {
                    textArcLimit.setEnabled(false);
                    lblArcLimitMa.setEnabled(false);
                    comboArcTimePeriod.setEnabled(false);
                }
            }
        });
        textArcLimit = new Text((Composite)grpLimits, 133120);
        textArcLimit.setToolTipText("Arc current limit, 1mA to 30mA.");
        textArcLimit.setText(Integer.toString(settings.arc_settings.arc_detection_limit));
        textArcLimit.setBounds(84, 115, 65, 20);
        lblArcLimitMa = new Label((Composite)grpLimits, 0);
        lblArcLimitMa.setToolTipText("");
        lblArcLimitMa.setText("mA");
        lblArcLimitMa.setBounds(155, 116, 29, 19);
        comboArcTimePeriod = new Combo((Composite)grpLimits, 0);
        comboArcTimePeriod.setToolTipText("Arc time period.");
        comboArcTimePeriod.setItems(new String[]{"4us", "10us", "15us", "20us", "30us", "40us"});
        comboArcTimePeriod.setBounds(209, 113, 54, 23);
        comboArcTimePeriod.setText(String.valueOf(Integer.toString(settings.arc_settings.arc_detection_period)) + "us");
        if (settings.arc_settings.enabled) {
            btnArcDetect.setSelection(true);
            textArcLimit.setEnabled(true);
            lblArcLimitMa.setEnabled(true);
            comboArcTimePeriod.setEnabled(true);
        } else {
            btnArcDetect.setSelection(false);
            textArcLimit.setEnabled(false);
            lblArcLimitMa.setEnabled(false);
            comboArcTimePeriod.setEnabled(false);
        }
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 530, 51);
        btnContinueOnFailure = new Button((Composite)grpOptions, 32);
        btnContinueOnFailure.setToolTipText("The sequence continues even if this step fails.");
        btnContinueOnFailure.setBounds(10, 25, 142, 16);
        btnContinueOnFailure.setText("Continue On Failure");
        if (settings.continue_on_failure) {
            btnContinueOnFailure.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(V10xDCI settings) {
        settings.name = txtUserName.getText();
        settings.test_time = Double.parseDouble(textTestTime.getText());
        settings.user_terminated = btnUser.getSelection();
        settings.delay_time = Double.parseDouble(textTestDelay.getText());
        settings.minimum_leakage_current_limit = SiTools.toReal(txtMinimumLimit.getText(), lblMinimumPrefix.getText());
        settings.maximum_leakage_current_limit = SiTools.toReal(txtMaximumLimit.getText(), lblMaximumPrefix.getText());
        settings.arc_settings.enabled = btnArcDetect.getSelection();
        settings.arc_settings.arc_detection_limit = Integer.valueOf(textArcLimit.getText());
        switch (comboArcTimePeriod.getText()) {
            case "4us": {
                settings.arc_settings.arc_detection_period = 4;
                break;
            }
            case "10us": {
                settings.arc_settings.arc_detection_period = 10;
                break;
            }
            case "15us": {
                settings.arc_settings.arc_detection_period = 15;
                break;
            }
            case "20us": {
                settings.arc_settings.arc_detection_period = 20;
                break;
            }
            case "30us": {
                settings.arc_settings.arc_detection_period = 30;
                break;
            }
            case "40us": {
                settings.arc_settings.arc_detection_period = 40;
                break;
            }
            default: {
                settings.arc_settings.arc_detection_period = 4;
            }
        }
        settings.continue_on_failure = btnContinueOnFailure.getSelection();
    }
}

