/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V10xDCIR
extends TestStep {
    static final int DCIR_TERM_PASS = 0;
    static final int DCIR_TERM_FAIL = 1;
    static final int DCIR_TERM_TIME = 2;
    static final int DCIR_TERM_STDY = 3;
    String id = "DCIR";
    double test_voltage = 1000.0;
    double breakdown_limit = 0.015;
    double ramp_setting = 1.5;
    int ramp_units = 1;
    double dwell_time = 60.0;
    boolean user_terminated = false;
    double pre_check_delay = 0.0;
    double discharge_setting = 1.5;
    int discharge_ramp_type = 1;
    int end_on = 1;
    TestStep.hipot_check_t leakage_check = TestStep.hipot_check_t.check_DC_Z;
    boolean no_maximum_limit = false;
    double minimum_leakage_limit = 1.0E8;
    double maximum_leakage_limit = 1.0E10;
    boolean use_min_load = false;
    double minimum_load = 0.0;
    TestStep.ArcSettings arc_settings = new TestStep.ArcSettings();
    double lead_compensation;
    int grounding = 2;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V10xDCIR_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V10xDCIR_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String end_on_keyword;
        V10xTesterSettings my_settings = (V10xTesterSettings)settings;
        switch (this.end_on) {
            default: {
                end_on_keyword = "Pass,";
                break;
            }
            case 1: {
                end_on_keyword = "Fail,";
                break;
            }
            case 2: {
                end_on_keyword = "Time,";
                break;
            }
            case 3: {
                end_on_keyword = "Steady,";
            }
        }
        double ramp_time = this.ramp_units == 1 ? this.ramp_setting : this.test_voltage / this.ramp_setting;
        String min = Double.toString(this.minimum_leakage_limit);
        String max = this.leakage_check == TestStep.hipot_check_t.check_DC_A ? Double.toString(this.maximum_leakage_limit) : (this.no_maximum_limit ? "" : Double.toString(this.maximum_leakage_limit));
        String arc = this.arc_settings.enabled ? String.valueOf(this.arc_settings.arc_detection_period) + "," + this.arc_settings.arc_detection_limit : ",";
        String command = "add,DCIR," + this.test_voltage + "," + this.breakdown_limit + "," + ramp_time + "," + (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.pre_check_delay + "," + end_on_keyword + this.checkKeyword(this.leakage_check) + "," + min + "," + max + "," + arc + "," + this.dischargeKeyword(this.discharge_ramp_type) + "," + this.abortKeyword() + "," + (my_settings.enable_dc_min_load && this.use_min_load ? "" : Double.valueOf(this.minimum_load)) + "," + (this.grounding == 2 ? "iso" : "gnd");
        return command;
    }

    @Override
    public String stepSummary() {
        return "DCIR:" + this.test_voltage + "V";
    }

    @Override
    public String[][] labels() {
        String lu;
        String ll;
        if (this.leakage_check == TestStep.hipot_check_t.check_DC_A) {
            ll = "Amps";
            lu = "A";
        } else {
            ll = "Ohms";
            lu = "\u2126";
        }
        return new String[][]{{"Drive", "Volts", "V"}, {"Max Apk", "Apk", "Apk"}, {"Leakage", ll, lu}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[3];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[3]);
        rslts[1] = Float.parseFloat(f[5]);
        rslts[2] = Float.parseFloat(f[9]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        String lv = this.leakage_check == TestStep.hipot_check_t.check_DC_A ? "amps" : "ohms";
        io_handle.sendCommand("phase?;measrslt?,volts;measrslt?,brkdn;measrslt?," + lv + ";step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(";");
            int reported_step = Integer.parseInt(f[4]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                int phase;
                double total_step_time;
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double d = total_step_time = this.user_terminated ? 9999.0 : this.dwell_time;
                total_step_time = this.ramp_units == 1 ? (total_step_time += this.ramp_setting) : (total_step_time += this.test_voltage / this.ramp_setting);
                double p = 100.0 * (double)i / (total_step_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                if ((phase = Integer.parseInt(f[0])) >= 1 && phase <= 3) {
                    r.metrics = new float[3];
                    r.metrics[0] = Float.parseFloat(f[1]);
                    r.metrics[1] = Float.parseFloat(f[2]);
                    r.metrics[2] = Float.parseFloat(f[3]);
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        String min = Double.toString(this.minimum_leakage_limit);
        String max = this.leakage_check == TestStep.hipot_check_t.check_DC_A ? Double.toString(this.maximum_leakage_limit) : (this.no_maximum_limit ? "" : Double.toString(this.maximum_leakage_limit));
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + rslts[15] + "," + rslts[16] + "," + rslts[17] + "," + rslts[18] : ",,,,,";
            csv = (this.user_terminated ? rslts[1] : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + rslts[3] + "," + "," + this.breakdown_limit + "," + rslts[5] + "," + this.checkKeyword(this.leakage_check) + "," + max + "," + min + "," + rslts[7] + "," + rslts[8] + "," + rslts[9] + "," + rslts[10] + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        } else {
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + "," + "," + "," : ",,,,,";
            csv = (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + "," + "," + this.breakdown_limit + "," + "," + this.checkKeyword(this.leakage_check) + "," + max + "," + min + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: {
                num_lines = 3;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 4;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        String delay = this.pre_check_delay > 0.0 ? "  Delay " + this.pre_check_delay + "s" : "";
        rpt[0] = !this.user_terminated ? "DCIR @ " + this.test_voltage + "V for " + this.dwell_time + "s" + delay : "DCIR @ " + this.test_voltage + "V for " + rslts[1] + "s" + delay;
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                do_arc *= 3;
                rpt[1] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " @ " + SiTools.toString(rslts[3], "V") + " (" + SiTools.toString(this.breakdown_limit, "A") + " limit)";
                String lu = "\u2126";
                String min = SiTools.toString(this.minimum_leakage_limit, lu);
                String max = this.no_maximum_limit ? "\u221e" : SiTools.toString(this.maximum_leakage_limit, lu);
                rpt[2] = "Leakage: " + SiTools.toString(rslts[8], lu) + " to " + SiTools.toString(rslts[7], lu) + " (" + min + " to " + max + " limits)";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                do_arc *= 4;
                rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
                rpt[2] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " @ " + SiTools.toString(rslts[3], "V") + " (" + SiTools.toString(this.breakdown_limit, "A") + " limit)";
                String lu = "\u2126";
                String min = SiTools.toString(this.minimum_leakage_limit, lu);
                String max = this.no_maximum_limit ? "\u221e" : SiTools.toString(this.maximum_leakage_limit, lu);
                rpt[3] = "Leakage: " + SiTools.toString(rslts[8], lu) + " to " + SiTools.toString(rslts[7], lu) + ", Avg:" + SiTools.toString(rslts[9], lu) + ", Final:" + SiTools.toString(rslts[10], lu) + " (" + min + " to " + max + " limits)";
            }
        }
        if (do_arc != 0) {
            rpt[do_arc] = "ARC: " + SiTools.toString(rslts[17], "A") + " to " + SiTools.toString(rslts[16], "A") + ", Avg:" + SiTools.toString(rslts[17], "A") + ", Final:" + SiTools.toString(rslts[18], "A") + " (Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us)";
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 4;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        String delay = this.pre_check_delay > 0.0 ? "  Delay " + this.pre_check_delay + "s" : "";
        rpt[0] = !this.user_terminated ? "DCIR @ " + this.test_voltage + "V for " + this.dwell_time + "s" + delay : "DCIR @ " + this.test_voltage + "V user terminated" + delay;
        if (level != ReportSettings.detail_level_t.brief) {
            do_arc *= 4;
            rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
            rpt[2] = "Breakdown: " + SiTools.toString(this.breakdown_limit, "A") + " limit";
            String lu = "\u2126";
            String min = SiTools.toString(this.minimum_leakage_limit, lu);
            String max = this.no_maximum_limit ? "\u221e" : SiTools.toString(this.maximum_leakage_limit, lu);
            rpt[3] = "Leakage: " + min + " to " + max;
            if (do_arc != 0) {
                rpt[do_arc] = "ARC: Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us)";
            }
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_voltage = Double.parseDouble(settings[1]);
        this.ramp_units = settings[2].equals("Y") ? 1 : 2;
        this.ramp_setting = Double.parseDouble(settings[3]);
        this.dwell_time = Double.parseDouble(settings[4]);
        this.pre_check_delay = Double.parseDouble(settings[5]);
        switch (settings[6]) {
            case "PASS": {
                this.end_on = 0;
                break;
            }
            case "FAIL": {
                this.end_on = 1;
                break;
            }
            case "TIME": {
                this.end_on = 2;
                break;
            }
            case "STDY": {
                this.end_on = 3;
            }
        }
        switch (settings[7]) {
            case "NONE": {
                this.discharge_ramp_type = 0;
                break;
            }
            case "FAST": {
                this.discharge_ramp_type = 1;
                break;
            }
            case "AS RAMP": {
                this.discharge_ramp_type = 2;
            }
        }
        this.breakdown_limit = Double.parseDouble(settings[8]);
        this.minimum_leakage_limit = Double.parseDouble(settings[9]) * Math.pow(10.0, Double.parseDouble(settings[11]));
        this.maximum_leakage_limit = Double.parseDouble(settings[10]) * Math.pow(10.0, Double.parseDouble(settings[11]));
        this.no_maximum_limit = settings[12].equals("Y");
        this.arc_settings.enabled = settings[13].equals("Y");
        this.arc_settings.arc_detection_limit = Integer.valueOf(settings[14]);
        this.arc_settings.arc_detection_period = Integer.valueOf(settings[15]);
        this.continue_on_failure = settings[16].equals("Y");
        this.use_min_load = settings[17].equals("Y");
        this.minimum_load = Double.parseDouble(settings[18]) / 1000000.0;
        int n = this.grounding = settings[19].equals("Y") ? 1 : 2;
        if (settings.length > 20) {
            this.name = settings[20];
        }
    }
}

