/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class V10xBRKDN
extends TestStep {
    String id = "BRKDN";
    double test_current_level = 0.001;
    double initial_ramp_rate = 1000.0;
    double minimum_breakdown_voltage = 500.0;
    double maximum_breakdown_voltage = 600.0;
    int grounding = 2;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return V10xBRKDN_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        V10xBRKDN_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String command = "add,BRKDN," + this.test_current_level + "," + this.initial_ramp_rate + "," + this.minimum_breakdown_voltage + "," + this.maximum_breakdown_voltage + "," + this.abortKeyword() + "," + (this.grounding == 2 ? "iso" : "gnd");
        return command;
    }

    @Override
    public String stepSummary() {
        return "BRKDN:" + this.minimum_breakdown_voltage + "V - " + this.maximum_breakdown_voltage + "V " + SiTools.toString(this.test_current_level, "A");
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Drive", "Volts", "V"}, {"Current", "Amps", "Apk"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",");
        rslts[0] = Float.parseFloat(f[6]);
        rslts[1] = Float.parseFloat(f[5]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("phase?;measrslt?,volts;measrslt?,brkdn;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(";");
            int reported_step = Integer.parseInt(f[3]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                int phase = Integer.parseInt(f[0]);
                double endv = this.maximum_breakdown_voltage + (this.maximum_breakdown_voltage - this.minimum_breakdown_voltage);
                double period = endv / this.initial_ramp_rate * 1000.0;
                long i = System.currentTimeMillis() - start_time;
                double p = 100.0 * (double)i / period;
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                if (phase >= 1 && phase <= 3) {
                    r.metrics = new float[3];
                    r.metrics[0] = Float.parseFloat(f[1]);
                    r.metrics[1] = Float.parseFloat(f[2]);
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",");
            csv = ",," + rslts[3] + "," + "," + this.test_current_level + "," + rslts[3];
        } else {
            csv = ",,,," + this.test_current_level + ",";
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",");
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 2;
            }
        }
        rpt = new String[num_lines];
        rpt[0] = "BRKDN: " + SiTools.toString(this.test_current_level, "A") + " " + this.minimum_breakdown_voltage + "V - " + this.maximum_breakdown_voltage + "V";
        switch (level) {
            case brief: {
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                rpt[1] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " at " + SiTools.toString(rslts[6], "V");
            }
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        return new String[]{"BRKDN: " + SiTools.toString(this.test_current_level, "A") + " " + this.minimum_breakdown_voltage + "V - " + this.maximum_breakdown_voltage + "V"};
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.test_current_level = Double.parseDouble(settings[1]);
        this.minimum_breakdown_voltage = Double.parseDouble(settings[2]);
        this.maximum_breakdown_voltage = Double.parseDouble(settings[3]);
        this.initial_ramp_rate = Double.parseDouble(settings[4]);
        this.continue_on_failure = settings[5].equals("Y");
        int n = this.grounding = settings[6].equals("Y") ? 1 : 2;
        if (settings.length > 7) {
            this.name = settings[7];
        }
    }
}

