/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class V10xACW_Edit {
    private static Button btnAC30;
    private static Text textLevel;
    private static Text textFrequency;
    private static Text txtUserName;
    private static Text textRampTime;
    private static Text textRampVoltsSec;
    private static Text textDwellTime;
    private static Text textBreakdown;
    private static Button btnUser;
    private static Label lblS_1;
    private static Button buttonRampTime;
    private static Button buttonRampVoltsSec;
    private static Label lblRampSeconds;
    private static Label lblRampVsec;
    private static Combo comboDischarge;
    private static Label lblBreakdownMa;
    private static Label lblLeakage1;
    private static Combo comboLeakage1;
    private static Label lblTo1;
    private static Label lblMinimumLeakagePrefix1;
    private static Label lblMaximumLeakagePrefix1;
    private static Text textMinimumLeakage1;
    private static Text textMaximumLeakage1;
    private static Button btnNoMax1;
    private static Label lblLeakage2;
    private static Combo comboLeakage2;
    private static Label lblTo2;
    private static Label lblMinimumLeakagePrefix2;
    private static Label lblMaximumLeakagePrefix2;
    private static Text textMinimumLeakage2;
    private static Text textMaximumLeakage2;
    private static Button btnNoMax2;
    private static Button btnArcDetect;
    private static Text textArcLimit;
    private static Combo comboArcTimePeriod;
    private static Label lblArcLimitMa;
    private static Button btnDutGrounded;
    private static Button btnContinueOnFailure;

    private static void leakageTranslate(Text w_min_leakage, Text w_max_leakage, Label w_min_prefix, Label w_max_prefix, Button no_max, String u) {
        double lvl = Double.parseDouble(textLevel.getText());
        String min = w_min_leakage.getText();
        String max = w_max_leakage.getText();
        String min_prefix = w_min_prefix.getText();
        String max_prefix = w_max_prefix.getText();
        if (u.equals("A")) {
            double v = no_max.getSelection() ? 0.0 : lvl / SiTools.toReal(max, max_prefix);
            String nt = SiTools.toString(v);
            w_min_leakage.setText(nt);
            String p = SiTools.prefix(v);
            w_min_prefix.setText(String.valueOf(p) + u);
            v = SiTools.toReal(min, min_prefix);
            v = lvl / v;
            nt = SiTools.toString(v);
            w_max_leakage.setText(nt);
            p = SiTools.prefix(v);
            w_max_prefix.setText(String.valueOf(p) + u);
            w_max_leakage.setEnabled(true);
            w_max_prefix.setEnabled(true);
        } else {
            String p;
            String nt;
            double v = SiTools.toReal(min, min_prefix);
            if (v < 1.0E-12) {
                no_max.setSelection(true);
                w_max_leakage.setText("1.0");
                w_max_prefix.setText("G" + u);
                w_max_leakage.setEnabled(false);
                w_max_prefix.setEnabled(false);
            } else {
                no_max.setSelection(false);
                v = lvl / v;
                nt = SiTools.toString(v);
                w_max_leakage.setText(nt);
                p = SiTools.prefix(v);
                w_max_prefix.setText(String.valueOf(p) + u);
            }
            v = SiTools.toReal(max, max_prefix);
            if (v < 1.0E-9) {
                v = 1.0E-9;
            }
            v = lvl / v;
            nt = SiTools.toString(v);
            w_min_leakage.setText(nt);
            p = SiTools.prefix(v);
            w_min_prefix.setText(String.valueOf(p) + u);
        }
    }

    private static String checkToUnits(TestStep.hipot_check_t code) {
        String units = "";
        switch (code) {
            default: {
                units = "";
                break;
            }
            case check_RMSA: {
                units = "A";
                break;
            }
            case check_INPHSA: {
                units = "A";
                break;
            }
            case check_QUADA: {
                units = "A";
                break;
            }
            case check_RMSO: {
                units = "\u2126";
                break;
            }
            case check_INPHSO: {
                units = "\u2126";
                break;
            }
            case check_QUADO: {
                units = "\u2126";
            }
        }
        return units;
    }

    private static String checkToHuman(TestStep.hipot_check_t code) {
        String label = "";
        switch (code) {
            default: {
                label = "None";
                break;
            }
            case check_RMSA: {
                label = "RMSA";
                break;
            }
            case check_INPHSA: {
                label = "INPHSA";
                break;
            }
            case check_QUADA: {
                label = "QUADA";
                break;
            }
            case check_RMSO: {
                label = "RMSO";
                break;
            }
            case check_INPHSO: {
                label = "INPHSO";
                break;
            }
            case check_QUADO: {
                label = "QUADO";
            }
        }
        return label;
    }

    private static TestStep.hipot_check_t toCheckCode(String human) {
        TestStep.hipot_check_t code = TestStep.hipot_check_t.check_NONE;
        switch (human) {
            case "None": {
                code = TestStep.hipot_check_t.check_NONE;
                break;
            }
            case "RMSA": {
                code = TestStep.hipot_check_t.check_RMSA;
                break;
            }
            case "INPHSA": {
                code = TestStep.hipot_check_t.check_INPHSA;
                break;
            }
            case "QUADA": {
                code = TestStep.hipot_check_t.check_QUADA;
                break;
            }
            case "RMSO": {
                code = TestStep.hipot_check_t.check_RMSO;
                break;
            }
            case "INPHSO": {
                code = TestStep.hipot_check_t.check_INPHSO;
                break;
            }
            case "QUADO": {
                code = TestStep.hipot_check_t.check_QUADO;
            }
        }
        return code;
    }

    public static Composite editor(Composite parent, TesterSettings tester, final V10xACW settings) {
        final DecimalFormat df3 = new DecimalFormat("0.000");
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpLevel = new Group(edit_space, 0);
        grpLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLevel.setText("Levels");
        grpLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLevel.setBounds(10, 0, 320, 60);
        btnAC30 = new Button((Composite)grpLevel, 32);
        btnAC30.setBounds(10, 23, 66, 27);
        btnAC30.setText("AC-30");
        if (settings.use_ac30) {
            btnAC30.setSelection(true);
        }
        textLevel = new Text((Composite)grpLevel, 133120);
        textLevel.setToolTipText("Specifies the voltage level for the test.");
        textLevel.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textLevel.setBounds(82, 15, 73, 35);
        textLevel.setText(Double.toString(settings.test_voltage));
        Label lblVolts = new Label((Composite)grpLevel, 0);
        lblVolts.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblVolts.setBounds(161, 15, 53, 35);
        lblVolts.setText("Volts");
        textFrequency = new Text((Composite)grpLevel, 133120);
        textFrequency.setToolTipText("Specifies the test frequency.");
        textFrequency.setText(Double.toString(settings.test_frequency));
        textFrequency.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textFrequency.setBounds(220, 15, 53, 35);
        Label lblHz = new Label((Composite)grpLevel, 0);
        lblHz.setText("Hz");
        lblHz.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblHz.setBounds(279, 15, 31, 35);
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(336, 0, 210, 60);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(10, 25, 184, 21);
        Group groupTiming = new Group(edit_space, 0);
        groupTiming.setToolTipText("");
        groupTiming.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        groupTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupTiming.setText("Timing");
        groupTiming.setBounds(10, 66, 246, 197);
        Label lblRamp = new Label((Composite)groupTiming, 0);
        lblRamp.setBounds(10, 33, 38, 15);
        lblRamp.setText("Ramp");
        buttonRampTime = new Button((Composite)groupTiming, 16);
        buttonRampTime.setToolTipText("Chooses the ramp to be in terms of time.");
        buttonRampTime.setBounds(46, 22, 21, 16);
        buttonRampTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 1;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampVoltsSec.getText());
                    if (t2 < 0.1) {
                        t2 = 0.1;
                    }
                    textRampTime.setText(df3.format(t1 / t2));
                    textRampVoltsSec.setEnabled(false);
                    textRampTime.setEnabled(true);
                    lblRampVsec.setEnabled(false);
                    lblRampSeconds.setEnabled(true);
                    textRampTime.setFocus();
                }
            }
        });
        buttonRampVoltsSec = new Button((Composite)groupTiming, 16);
        buttonRampVoltsSec.setToolTipText("Chooses the ramp to be in terms of volts/second.");
        buttonRampVoltsSec.setBounds(46, 51, 21, 16);
        buttonRampVoltsSec.setText("");
        buttonRampVoltsSec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 2;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampTime.getText());
                    if (t2 < 0.001) {
                        t2 = 0.001;
                    }
                    textRampVoltsSec.setText(df3.format(t1 / t2));
                    textRampTime.setEnabled(false);
                    textRampVoltsSec.setEnabled(true);
                    lblRampSeconds.setEnabled(false);
                    lblRampVsec.setEnabled(true);
                    textRampVoltsSec.setFocus();
                }
            }
        });
        textRampTime = new Text((Composite)groupTiming, 133120);
        textRampTime.setToolTipText("Specifies the voltage ramp in terms of time.");
        textRampTime.setBounds(72, 22, 65, 21);
        textRampVoltsSec = new Text((Composite)groupTiming, 133120);
        textRampVoltsSec.setToolTipText("Specifies the voltage ramp in terms of volts/second.");
        textRampVoltsSec.setBounds(72, 49, 65, 21);
        lblRampSeconds = new Label((Composite)groupTiming, 0);
        lblRampSeconds.setBounds(143, 22, 55, 15);
        lblRampSeconds.setText("seconds");
        lblRampVsec = new Label((Composite)groupTiming, 0);
        lblRampVsec.setEnabled(false);
        lblRampVsec.setText("V/sec");
        lblRampVsec.setBounds(143, 51, 55, 15);
        if (settings.ramp_units == 1) {
            textRampTime.setText(Double.toString(settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setEnabled(false);
            textRampTime.setEnabled(true);
            lblRampVsec.setEnabled(false);
            lblRampSeconds.setEnabled(true);
            buttonRampTime.setSelection(true);
        } else {
            textRampTime.setText(Double.toString(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.ramp_setting));
            textRampTime.setEnabled(false);
            textRampVoltsSec.setEnabled(true);
            lblRampSeconds.setEnabled(false);
            lblRampVsec.setEnabled(true);
            buttonRampVoltsSec.setSelection(true);
        }
        Label lblDwell = new Label((Composite)groupTiming, 0);
        lblDwell.setBounds(10, 91, 55, 15);
        lblDwell.setText("Dwell");
        textDwellTime = new Text((Composite)groupTiming, 133120);
        textDwellTime.setToolTipText("Specifies the dwell time for the test.");
        textDwellTime.setBounds(72, 88, 65, 21);
        textDwellTime.setText(Double.toString(settings.dwell_time));
        btnUser = new Button((Composite)groupTiming, 32);
        btnUser.setBounds(199, 92, 44, 16);
        btnUser.setToolTipText("Allows the test to dwell until ended by the user.");
        btnUser.setText("User");
        btnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUser.getSelection()) {
                    textDwellTime.setEnabled(false);
                    lblS_1.setEnabled(false);
                } else {
                    textDwellTime.setEnabled(true);
                    lblS_1.setEnabled(true);
                }
            }
        });
        lblS_1 = new Label((Composite)groupTiming, 0);
        lblS_1.setText("seconds");
        lblS_1.setBounds(143, 90, 55, 15);
        if (settings.user_terminated) {
            btnUser.setSelection(true);
            textDwellTime.setEnabled(false);
            lblS_1.setEnabled(false);
        }
        Label lblDischarge = new Label((Composite)groupTiming, 0);
        lblDischarge.setBounds(9, 167, 55, 15);
        lblDischarge.setText("Discharge");
        comboDischarge = new Combo((Composite)groupTiming, 0);
        comboDischarge.setToolTipText("Specifies how discharge is processed.");
        comboDischarge.setItems(new String[]{"None", "Fast", "As Ramp"});
        comboDischarge.setBounds(71, 164, 77, 23);
        switch (settings.discharge_ramp_type) {
            case 0: {
                comboDischarge.setText("None");
                break;
            }
            case 1: {
                comboDischarge.setText("Fast");
                break;
            }
            case 2: {
                comboDischarge.setText("As Ramp");
            }
        }
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setText("Test Limits");
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLimits.setBounds(262, 66, 283, 197);
        Label lblBreakdown = new Label((Composite)grpLimits, 0);
        lblBreakdown.setBounds(10, 21, 65, 15);
        lblBreakdown.setText("Breakdown");
        textBreakdown = new Text((Composite)grpLimits, 133120);
        textBreakdown.setToolTipText("Specifies the instantaneous breakdown current limit.");
        textBreakdown.setText(Double.toString(settings.breakdown_limit * 1000.0));
        textBreakdown.setBounds(162, 21, 60, 21);
        lblBreakdownMa = new Label((Composite)grpLimits, 2048);
        lblBreakdownMa.setToolTipText("Double click to change the prefix.");
        lblBreakdownMa.setBounds(230, 23, 46, 19);
        lblBreakdownMa.setText("mA");
        lblBreakdownMa.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (lblBreakdownMa.getText().equals("uA")) {
                    lblBreakdownMa.setText("mA");
                } else {
                    lblBreakdownMa.setText("uA");
                }
            }
        });
        lblLeakage1 = new Label((Composite)grpLimits, 0);
        lblLeakage1.setText("Leakage 1");
        lblLeakage1.setBounds(10, 62, 65, 15);
        lblTo1 = new Label((Composite)grpLimits, 0);
        lblTo1.setText("to");
        lblTo1.setBounds(142, 83, 19, 15);
        comboLeakage1 = new Combo((Composite)grpLimits, 0);
        comboLeakage1.setItems(new String[]{"None", "RMSA", "INPHSA", "QUADA", "RMSO", "INPHSO", "QUADO"});
        comboLeakage1.setBounds(75, 58, 73, 23);
        String leakage_units1 = V10xACW_Edit.checkToUnits(settings.leakage_check1);
        comboLeakage1.setText(V10xACW_Edit.checkToHuman(settings.leakage_check1));
        comboLeakage1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestStep.hipot_check_t code = V10xACW_Edit.toCheckCode(comboLeakage1.getText());
                if (code == TestStep.hipot_check_t.check_NONE) {
                    textMinimumLeakage1.setEnabled(false);
                    lblMinimumLeakagePrefix1.setEnabled(false);
                    textMaximumLeakage1.setEnabled(false);
                    lblMaximumLeakagePrefix1.setEnabled(false);
                    btnNoMax1.setVisible(false);
                } else {
                    textMinimumLeakage1.setEnabled(true);
                    lblMinimumLeakagePrefix1.setEnabled(true);
                    textMaximumLeakage1.setEnabled(true);
                    lblMaximumLeakagePrefix1.setEnabled(true);
                    String to_units = V10xACW_Edit.checkToUnits(code);
                    if (to_units != V10xACW_Edit.checkToUnits(settings.leakage_check1)) {
                        if (to_units.equals("A")) {
                            btnNoMax1.setVisible(false);
                            settings.no_maximum_limit1 = false;
                        } else {
                            btnNoMax1.setVisible(true);
                        }
                        V10xACW_Edit.leakageTranslate(textMinimumLeakage1, textMaximumLeakage1, lblMinimumLeakagePrefix1, lblMaximumLeakagePrefix1, btnNoMax1, to_units);
                    }
                }
                settings.leakage_check1 = code;
            }
        });
        textMinimumLeakage1 = new Text((Composite)grpLimits, 133120);
        textMinimumLeakage1.setToolTipText("Specifies the first lower leakage limit.");
        textMinimumLeakage1.setBounds(162, 58, 60, 21);
        textMinimumLeakage1.setText(SiTools.toString(settings.minimum_leakage_limit1));
        lblMinimumLeakagePrefix1 = new Label((Composite)grpLimits, 2048);
        lblMinimumLeakagePrefix1.setToolTipText("Double click to change the prefix.");
        lblMinimumLeakagePrefix1.setText(String.valueOf(SiTools.prefix(settings.minimum_leakage_limit1)) + leakage_units1);
        lblMinimumLeakagePrefix1.setBounds(230, 58, 46, 19);
        lblMinimumLeakagePrefix1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumLeakagePrefix1);
            }
        });
        textMaximumLeakage1 = new Text((Composite)grpLimits, 133120);
        textMaximumLeakage1.setToolTipText("Specifies the first upper leakage limit.");
        textMaximumLeakage1.setBounds(162, 80, 60, 21);
        if (settings.no_maximum_limit1) {
            textMaximumLeakage1.setText("No limit");
        } else {
            textMaximumLeakage1.setText(SiTools.toString(settings.maximum_leakage_limit1));
        }
        lblMaximumLeakagePrefix1 = new Label((Composite)grpLimits, 2048);
        lblMaximumLeakagePrefix1.setToolTipText("Double click to change the prefix.");
        lblMaximumLeakagePrefix1.setBounds(230, 83, 46, 19);
        lblMaximumLeakagePrefix1.setText(String.valueOf(SiTools.prefix(settings.maximum_leakage_limit1)) + leakage_units1);
        lblMaximumLeakagePrefix1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumLeakagePrefix1);
            }
        });
        btnNoMax1 = new Button((Composite)grpLimits, 32);
        btnNoMax1.setBounds(75, 84, 65, 16);
        btnNoMax1.setText("No Max");
        btnNoMax1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnNoMax1.getSelection()) {
                    textMaximumLeakage1.setEnabled(false);
                    lblMaximumLeakagePrefix1.setEnabled(false);
                } else {
                    textMaximumLeakage1.setEnabled(true);
                    lblMaximumLeakagePrefix1.setEnabled(true);
                }
            }
        });
        btnNoMax1.setSelection(settings.no_maximum_limit1);
        if (settings.leakage_check1 == TestStep.hipot_check_t.check_NONE) {
            textMinimumLeakage1.setEnabled(false);
            lblMinimumLeakagePrefix1.setEnabled(false);
            textMaximumLeakage1.setEnabled(false);
            lblMaximumLeakagePrefix1.setEnabled(false);
            btnNoMax1.setVisible(false);
        } else if (!settings.checkIsImpedance(settings.leakage_check1)) {
            btnNoMax1.setVisible(false);
        }
        lblLeakage2 = new Label((Composite)grpLimits, 0);
        lblLeakage2.setText("Leakage 2");
        lblLeakage2.setBounds(10, 112, 65, 15);
        lblTo2 = new Label((Composite)grpLimits, 0);
        lblTo2.setText("to");
        lblTo2.setBounds(142, 133, 19, 15);
        comboLeakage2 = new Combo((Composite)grpLimits, 0);
        comboLeakage2.setItems(new String[]{"None", "RMSA", "INPHSA", "QUADA", "RMSO", "INPHSO", "QUADO"});
        comboLeakage2.setBounds(75, 108, 73, 23);
        String leakage_units2 = V10xACW_Edit.checkToUnits(settings.leakage_check2);
        comboLeakage2.setText(V10xACW_Edit.checkToHuman(settings.leakage_check2));
        comboLeakage2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestStep.hipot_check_t code = V10xACW_Edit.toCheckCode(comboLeakage2.getText());
                if (code == TestStep.hipot_check_t.check_NONE) {
                    textMinimumLeakage2.setEnabled(false);
                    lblMinimumLeakagePrefix2.setEnabled(false);
                    textMaximumLeakage2.setEnabled(false);
                    lblMaximumLeakagePrefix2.setEnabled(false);
                    btnNoMax2.setVisible(false);
                } else {
                    textMinimumLeakage2.setEnabled(true);
                    lblMinimumLeakagePrefix2.setEnabled(true);
                    textMaximumLeakage2.setEnabled(true);
                    lblMaximumLeakagePrefix2.setEnabled(true);
                    String to_units = V10xACW_Edit.checkToUnits(code);
                    if (to_units != V10xACW_Edit.checkToUnits(settings.leakage_check2)) {
                        if (to_units.equals("A")) {
                            btnNoMax2.setVisible(false);
                            settings.no_maximum_limit2 = false;
                        } else {
                            btnNoMax2.setVisible(true);
                        }
                        V10xACW_Edit.leakageTranslate(textMinimumLeakage2, textMaximumLeakage2, lblMinimumLeakagePrefix2, lblMaximumLeakagePrefix2, btnNoMax2, to_units);
                    }
                }
                settings.leakage_check2 = code;
            }
        });
        textMinimumLeakage2 = new Text((Composite)grpLimits, 133120);
        textMinimumLeakage2.setToolTipText("Specifies the second lower leakage limit.");
        textMinimumLeakage2.setBounds(162, 108, 60, 21);
        textMinimumLeakage2.setText(SiTools.toString(settings.minimum_leakage_limit2));
        lblMinimumLeakagePrefix2 = new Label((Composite)grpLimits, 2048);
        lblMinimumLeakagePrefix2.setToolTipText("Double click to change the prefix.");
        lblMinimumLeakagePrefix2.setText(String.valueOf(SiTools.prefix(settings.minimum_leakage_limit2)) + leakage_units2);
        lblMinimumLeakagePrefix2.setBounds(230, 108, 46, 19);
        lblMinimumLeakagePrefix2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumLeakagePrefix2);
            }
        });
        textMaximumLeakage2 = new Text((Composite)grpLimits, 133120);
        textMaximumLeakage2.setToolTipText("Specifies the second upper leakage limit.");
        textMaximumLeakage2.setBounds(162, 130, 60, 21);
        if (settings.no_maximum_limit2) {
            textMaximumLeakage2.setText("No limit");
        } else {
            textMaximumLeakage2.setText(SiTools.toString(settings.maximum_leakage_limit2));
        }
        lblMaximumLeakagePrefix2 = new Label((Composite)grpLimits, 2048);
        lblMaximumLeakagePrefix2.setToolTipText("Double click to change the prefix.");
        lblMaximumLeakagePrefix2.setBounds(230, 133, 46, 19);
        lblMaximumLeakagePrefix2.setText(String.valueOf(SiTools.prefix(settings.maximum_leakage_limit2)) + leakage_units2);
        lblMaximumLeakagePrefix2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumLeakagePrefix2);
            }
        });
        if (settings.leakage_check2 == TestStep.hipot_check_t.check_NONE) {
            textMinimumLeakage2.setEnabled(false);
            lblMinimumLeakagePrefix2.setEnabled(false);
            textMaximumLeakage2.setEnabled(false);
            lblMaximumLeakagePrefix2.setEnabled(false);
        }
        btnNoMax2 = new Button((Composite)grpLimits, 32);
        btnNoMax2.setText("No Max");
        btnNoMax2.setBounds(75, 133, 65, 16);
        btnNoMax2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnNoMax2.getSelection()) {
                    textMaximumLeakage2.setEnabled(false);
                    lblMaximumLeakagePrefix2.setEnabled(false);
                } else {
                    textMaximumLeakage2.setEnabled(true);
                    lblMaximumLeakagePrefix2.setEnabled(true);
                }
            }
        });
        btnNoMax2.setSelection(settings.no_maximum_limit2);
        if (settings.leakage_check2 == TestStep.hipot_check_t.check_NONE) {
            textMinimumLeakage2.setEnabled(false);
            lblMinimumLeakagePrefix2.setEnabled(false);
            textMaximumLeakage2.setEnabled(false);
            lblMaximumLeakagePrefix2.setEnabled(false);
            btnNoMax2.setVisible(false);
        } else if (!settings.checkIsImpedance(settings.leakage_check2)) {
            btnNoMax2.setVisible(false);
        }
        btnArcDetect = new Button((Composite)grpLimits, 32);
        btnArcDetect.setToolTipText("Check to enable Arc detection.");
        btnArcDetect.setBounds(10, 166, 46, 16);
        btnArcDetect.setText("Arc");
        btnArcDetect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnArcDetect.getSelection()) {
                    textArcLimit.setEnabled(true);
                    lblArcLimitMa.setEnabled(true);
                    comboArcTimePeriod.setEnabled(true);
                } else {
                    textArcLimit.setEnabled(false);
                    lblArcLimitMa.setEnabled(false);
                    comboArcTimePeriod.setEnabled(false);
                }
            }
        });
        textArcLimit = new Text((Composite)grpLimits, 133120);
        textArcLimit.setToolTipText("Arc current limit, 1mA to 30mA.");
        textArcLimit.setText(Integer.toString(settings.arc_settings.arc_detection_limit));
        textArcLimit.setBounds(81, 166, 65, 20);
        lblArcLimitMa = new Label((Composite)grpLimits, 0);
        lblArcLimitMa.setToolTipText("");
        lblArcLimitMa.setText("mA");
        lblArcLimitMa.setBounds(152, 167, 29, 19);
        comboArcTimePeriod = new Combo((Composite)grpLimits, 0);
        comboArcTimePeriod.setToolTipText("Arc time period.");
        comboArcTimePeriod.setItems(new String[]{"4us", "10us", "15us", "20us", "30us", "40us"});
        comboArcTimePeriod.setBounds(206, 164, 54, 23);
        comboArcTimePeriod.setText(String.valueOf(Integer.toString(settings.arc_settings.arc_detection_period)) + "us");
        if (settings.arc_settings.enabled) {
            btnArcDetect.setSelection(true);
            textArcLimit.setEnabled(true);
            lblArcLimitMa.setEnabled(true);
            comboArcTimePeriod.setEnabled(true);
        } else {
            btnArcDetect.setSelection(false);
            textArcLimit.setEnabled(false);
            lblArcLimitMa.setEnabled(false);
            comboArcTimePeriod.setEnabled(false);
        }
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 536, 51);
        btnDutGrounded = new Button((Composite)grpOptions, 32);
        btnDutGrounded.setToolTipText("Set when the DUT is grounded, (only valid if option HSS or HSS-2 is fitted).");
        btnDutGrounded.setBounds(247, 25, 154, 16);
        btnDutGrounded.setText("DUT Grounded");
        if (settings.grounding == 1) {
            btnDutGrounded.setSelection(true);
        }
        btnContinueOnFailure = new Button((Composite)grpOptions, 32);
        btnContinueOnFailure.setToolTipText("The sequence continues even if this step fails.");
        btnContinueOnFailure.setBounds(10, 25, 154, 16);
        btnContinueOnFailure.setText("Continue On Failure");
        if (settings.continue_on_failure) {
            btnContinueOnFailure.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(V10xACW settings) {
        settings.name = txtUserName.getText();
        settings.use_ac30 = btnAC30.getSelection();
        settings.test_voltage = Double.parseDouble(textLevel.getText());
        settings.test_frequency = Double.parseDouble(textFrequency.getText());
        settings.ramp_setting = settings.ramp_units == 1 ? Double.parseDouble(textRampTime.getText()) : Double.parseDouble(textRampVoltsSec.getText());
        settings.dwell_time = Double.parseDouble(textDwellTime.getText());
        settings.user_terminated = btnUser.getSelection();
        switch (comboDischarge.getText()) {
            case "None": {
                settings.discharge_ramp_type = 0;
                break;
            }
            case "Fast": {
                settings.discharge_ramp_type = 1;
                break;
            }
            case "As Ramp": {
                settings.discharge_ramp_type = 2;
            }
        }
        settings.breakdown_limit = SiTools.toReal(textBreakdown.getText(), lblBreakdownMa.getText());
        settings.minimum_leakage_limit1 = SiTools.toReal(textMinimumLeakage1.getText(), lblMinimumLeakagePrefix1.getText());
        settings.maximum_leakage_limit1 = SiTools.toReal(textMaximumLeakage1.getText(), lblMaximumLeakagePrefix1.getText());
        settings.no_maximum_limit1 = btnNoMax1.getSelection();
        settings.minimum_leakage_limit2 = SiTools.toReal(textMinimumLeakage2.getText(), lblMinimumLeakagePrefix2.getText());
        settings.maximum_leakage_limit2 = SiTools.toReal(textMaximumLeakage2.getText(), lblMaximumLeakagePrefix2.getText());
        settings.no_maximum_limit2 = btnNoMax2.getSelection();
        settings.arc_settings.enabled = btnArcDetect.getSelection();
        settings.arc_settings.arc_detection_limit = Integer.valueOf(textArcLimit.getText());
        switch (comboArcTimePeriod.getText()) {
            case "4us": {
                settings.arc_settings.arc_detection_period = 4;
                break;
            }
            case "10us": {
                settings.arc_settings.arc_detection_period = 10;
                break;
            }
            case "15us": {
                settings.arc_settings.arc_detection_period = 15;
                break;
            }
            case "20us": {
                settings.arc_settings.arc_detection_period = 20;
                break;
            }
            case "30us": {
                settings.arc_settings.arc_detection_period = 30;
                break;
            }
            case "40us": {
                settings.arc_settings.arc_detection_period = 40;
                break;
            }
            default: {
                settings.arc_settings.arc_detection_period = 4;
            }
        }
        settings.grounding = btnDutGrounded.getSelection() ? 1 : 2;
        settings.continue_on_failure = btnContinueOnFailure.getSelection();
    }
}

