/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserSettings {
    private static String Hostname_file_path = "c:\\ProgramData\\Vitrek\\QtInsite\\host_name.ini";
    public static Locale real_locale;
    public static String sql_hostname;
    public static int app_x_position;
    public static int app_y_position;
    public static boolean show_registration_warning;
    public static boolean show_registration_error;
    public static String user_name;
    public static String level_name;
    public static String configuration_name;
    public static String test_name;
    public static AccessPermissions permissions;
    private static Preferences prefs_user;

    static {
        level_name = "";
        configuration_name = "";
        test_name = "";
        permissions = new AccessPermissions();
    }

    public static void init() {
        real_locale = Locale.getDefault();
        prefs_user = Preferences.userRoot().node("qtinsite");
    }

    public static void loadHostname() {
        File file = new File(Hostname_file_path);
        sql_hostname = "";
        if (file.exists()) {
            try {
                sql_hostname = new String(Files.readAllBytes(Paths.get(Hostname_file_path, new String[0])));
                sql_hostname.replaceAll("\\R", "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void saveHostname() {
        try {
            File file = new File(Hostname_file_path);
            file.getParentFile().mkdirs();
            Files.write(Paths.get(Hostname_file_path, new String[0]), sql_hostname.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.out.println("Cannot write hostname file");
        }
    }

    public static void loadOsUserSettings() {
        app_x_position = prefs_user.getInt("WX", 50);
        app_y_position = prefs_user.getInt("WY", 50);
        show_registration_warning = prefs_user.getBoolean("RWF", true);
        show_registration_error = prefs_user.getBoolean("REF", true);
    }

    public static void saveOsUserSettings() {
        Display d = Display.getDefault();
        Shell s = d.getActiveShell();
        if (s != null) {
            Point loc = s.getLocation();
            prefs_user.putInt("WX", loc.x);
            prefs_user.putInt("WY", loc.y);
            prefs_user.putBoolean("RWF", show_registration_warning);
            prefs_user.putBoolean("REF", show_registration_error);
            try {
                prefs_user.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    public static int loadUserAppSettings(String n, String p) {
        AnySql sql = new AnySql(sql_hostname);
        if (sql.open() != 0) {
            return 1;
        }
        int status = 2;
        String[] ui = sql.queryRow("select password,level,default_config,default_sequence from users where name='" + n + "'");
        if (ui != null && ui[0].equals(p)) {
            status = 0;
            user_name = n;
            level_name = ui[1];
            configuration_name = ui[2];
            test_name = ui[3];
            String[] ps = sql.queryColumn("select flags from access_levels where name='" + level_name + "'");
            permissions.db_decode(ps[0]);
        }
        sql.close();
        return status;
    }

    public static int checkPrimaryAccount() {
        AnySql sql = new AnySql(sql_hostname);
        if (sql.open() != 0) {
            return 1;
        }
        int status = 2;
        String[] ui = sql.queryRow("select name from users where id='1'");
        if (ui != null) {
            status = 0;
        }
        sql.close();
        return status;
    }

    public static void saveUserAppSettings() {
        AnySql sql = new AnySql(sql_hostname);
        if (sql.open() != 0) {
            return;
        }
        sql.execute("update users set default_config='" + configuration_name + "'" + ",default_sequence='" + test_name + "'" + " where name='" + user_name + "'");
        sql.close();
    }
}

