/*
 * Decompiled with CFR 0.152.
 */
import java.nio.charset.StandardCharsets;

public class UsbInterface
extends Interface {
    Cp2110HidToUart dll;
    long handle;
    String last_error = "";

    public UsbInterface(Cp2110HidToUart dll) {
        this.dll = dll;
    }

    @Override
    public int open(String[] args) {
        long[] udevice = new long[1];
        int[] num_devices = new int[]{99};
        int r = this.dll.HidUart_GetNumDevices(num_devices, (short)4292, (short)-30667);
        if (num_devices[0] <= 0) {
            this.last_error = "No devices";
            return -1;
        }
        int dnum = 0;
        while (dnum < num_devices[0]) {
            byte[] sn = new byte[256];
            r = this.dll.HidUart_GetString(dnum, (short)4292, (short)-30667, sn, 4);
            if (r == 0) {
                int i = 0;
                while (i < sn.length && sn[i] != 0) {
                    ++i;
                }
                String s = new String(sn, 0, i, StandardCharsets.UTF_8);
                if (args[0].equals(s)) break;
            }
            ++dnum;
        }
        if (dnum == num_devices[0]) {
            this.last_error = String.valueOf(args[0]) + " not found";
            return -1;
        }
        r = this.dll.HidUart_Open(udevice, dnum, (short)4292, (short)-30667);
        if (r == 0) {
            this.dll.HidUart_SetUartConfig(udevice[0], 115200, (byte)3, (byte)0, (byte)0, (byte)1);
            this.dll.HidUart_SetTimeouts(udevice[0], 100, 1000);
        }
        this.handle = udevice[0];
        return 0;
    }

    @Override
    public void close() {
        this.dll.HidUart_Close(this.handle);
    }

    @Override
    public int read(byte[] buffer, int max_to_read) {
        int r;
        byte[] xfer = new byte[1];
        int[] nr = new int[1];
        int len = 0;
        do {
            nr[0] = 0;
            r = this.dll.HidUart_Read(this.handle, xfer, 1, nr);
            if (r != 0) break;
            buffer[len] = xfer[0];
        } while (++len < max_to_read);
        if (len > 0) {
            return len;
        }
        if (r != 20) {
            this.last_error = "Error " + Integer.toHexString(r);
        }
        return -1;
    }

    @Override
    public int write(byte[] buffer, int num_to_write) {
        int[] nw = new int[]{0};
        int r = this.dll.HidUart_Write(this.handle, buffer, num_to_write, nw);
        if (r != 0) {
            this.last_error = "Error " + Integer.toHexString(r);
            return -1;
        }
        if (nw[0] != num_to_write) {
            this.last_error = "Write length error";
            return -1;
        }
        return 0;
    }

    @Override
    public String strerror() {
        return this.last_error;
    }
}

