/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import org.eclipse.swt.widgets.Composite;

public abstract class TestStep {
    static final int DISCHARGE_NONE = 0;
    static final int DISCHARGE_FAST = 1;
    static final int DISCHARGE_RAMP = 2;
    static final int DISCHARGE_TIME = 3;
    static final int GROUND_GROUNDED = 1;
    static final int GROUND_ISOLATED = 2;
    static final int RAMP_IS_TIME = 1;
    static final int RAMP_IS_RATE = 2;
    int step_num = 1;
    String name = "";
    boolean continue_on_failure = false;

    public String checkKeyword(hipot_check_t code) {
        String keyword = "";
        switch (code) {
            default: {
                keyword = "none";
                break;
            }
            case check_RMSA: {
                keyword = "rmsa";
                break;
            }
            case check_INPHSA: {
                keyword = "inphsa";
                break;
            }
            case check_QUADA: {
                keyword = "quada";
                break;
            }
            case check_RMSV: {
                keyword = "rmsv";
                break;
            }
            case check_INPHSV: {
                keyword = "inphsv";
                break;
            }
            case check_QUADV: {
                keyword = "quadv";
                break;
            }
            case check_RMSO: {
                keyword = "rmso";
                break;
            }
            case check_INPHSO: {
                keyword = "inphso";
                break;
            }
            case check_QUADO: {
                keyword = "quado";
                break;
            }
            case check_DC_A: {
                keyword = "amps";
                break;
            }
            case check_DC_Z: {
                keyword = "ohms";
            }
        }
        return keyword;
    }

    public boolean checkIsImpedance(hipot_check_t code) {
        boolean flag = false;
        switch (code) {
            default: {
                break;
            }
            case check_RMSO: 
            case check_INPHSO: 
            case check_QUADO: 
            case check_DC_Z: {
                flag = true;
            }
        }
        return flag;
    }

    public String abortKeyword() {
        return this.continue_on_failure ? "cont" : "abort";
    }

    public String dischargeKeyword(int discharge_type) {
        String keyword = "none";
        switch (discharge_type) {
            case 0: {
                keyword = "None";
                break;
            }
            case 1: {
                keyword = "Fast";
                break;
            }
            case 2: {
                keyword = "Ramp";
                break;
            }
            case 3: {
                keyword = "Time";
            }
        }
        return keyword;
    }

    abstract String getType();

    abstract Composite editor(Composite var1, TesterSettings var2);

    abstract void fetch();

    abstract String addStep(TesterSettings var1, Tester var2);

    abstract String stepSummary();

    abstract String[][] labels();

    abstract float[] extractFinal(String var1);

    abstract StepStatus monitor(Interface var1, long var2);

    abstract String makeCsv(TesterSettings var1, String var2);

    abstract String[] report(TesterSettings var1, String var2, ReportSettings.detail_level_t var3);

    abstract String[] report(TesterSettings var1, ReportSettings.detail_level_t var2);

    abstract void importQt(String var1);

    public boolean needsContinue() {
        return false;
    }

    public void fixupSwitch(String series, String model, int num_units, switch_control_t itype) {
    }

    public StepInfo information() {
        return null;
    }

    public String getName() {
        if (this.name.isEmpty()) {
            return this.getType();
        }
        return this.name;
    }

    public String toString() {
        String serialized = new Gson().toJson((Object)this);
        return serialized;
    }

    public StepExport export() {
        StepExport r = new StepExport();
        r.in_json = new Gson().toJson((Object)this);
        r.image = null;
        return r;
    }

    public void importImage(byte[] idata) {
    }

    class ArcSettings {
        boolean enabled = false;
        int arc_detection_period = 4;
        int arc_detection_limit = 10;
    }

    class StepExport {
        String in_json;
        byte[] image;

        StepExport() {
        }
    }

    class StepInfo {
        String paragraph;
        byte[] image;

        StepInfo() {
        }
    }

    public class StepStatus {
        step_status_t status = step_status_t.ok;
        int progress;
        float[] metrics;

        public StepStatus() {
            this.metrics = null;
        }

        public StepStatus(int num_metrics) {
            this.metrics = new float[num_metrics];
        }
    }

    public static enum hipot_check_t {
        check_NONE,
        check_RMSA,
        check_INPHSA,
        check_QUADA,
        check_RMSV,
        check_INPHSV,
        check_QUADV,
        check_RMSO,
        check_INPHSO,
        check_QUADO,
        check_CAP,
        check_DF,
        check_AC_Arms,
        check_DC_A,
        check_DC_Z,
        check_MAXA;

    }

    public static enum step_status_t {
        ok,
        done,
        error;

    }
}

