/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.printing.PDFPageable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public class TestSequence {
    String loaded_name = "";
    String series;
    String switch_model;
    int num_switches;
    switch_control_t switch_interface;
    TesterSettings tester_settings;
    Tester tester;
    DutSettings dut_settings;
    ReportSettings report_settings;
    int num_steps;
    boolean loaded_switch_step;
    ArrayList<TestStep> steps;
    public StepFactory step_factory;

    public TestSequence() {
        this("95x", "", 0);
    }

    public TestSequence(String instrument_series) {
        this(instrument_series, "", 0);
    }

    public TestSequence(String instrument_series, String swtich_model, int num_switches) {
        this.series = instrument_series;
        this.switch_model = swtich_model;
        this.num_switches = num_switches;
        this.tester_settings = TesterSettings.loadTesterSettings(this.series, null);
        this.step_factory = StepFactory.makeStepFactory(this.series);
        this.tester = Tester.makeTester(this.series);
        this.dut_settings = new DutSettings();
        this.report_settings = new ReportSettings();
        this.num_steps = 0;
        this.steps = new ArrayList();
    }

    private TestStep loadStep(String id, String json, byte[] im) {
        TestStep s;
        switch (id) {
            case "Pause": {
                s = (TestStep)new Gson().fromJson(json, PauseStep.class);
                s.importImage(im);
                break;
            }
            case "Hold": {
                s = (TestStep)new Gson().fromJson(json, HoldStep.class);
                s.importImage(im);
                break;
            }
            case "Switch": {
                s = (TestStep)new Gson().fromJson(json, Switch.class);
                s.importImage(im);
                s.fixupSwitch(this.series, this.switch_model, this.num_switches, this.switch_interface);
                this.loaded_switch_step = true;
                break;
            }
            default: {
                s = this.step_factory.loadStep(id, json, im);
            }
        }
        return s;
    }

    public TestStep copyStep(TestStep s) {
        String t = s.getType();
        String json = s.toString();
        TestStep ns = this.loadStep(t, json, null);
        ns.name = "";
        return ns;
    }

    public static TestStep loadStep(StepFactory step_factory, String id, String json) {
        TestStep s;
        switch (id) {
            case "Pause": {
                s = (TestStep)new Gson().fromJson(json, PauseStep.class);
                break;
            }
            case "Hold": {
                s = (TestStep)new Gson().fromJson(json, HoldStep.class);
                break;
            }
            case "Switch": {
                s = (TestStep)new Gson().fromJson(json, Switch.class);
                break;
            }
            default: {
                s = step_factory.loadStep(id, json, null);
            }
        }
        return s;
    }

    public static TestStep loadStep(StepFactory step_factory, String csv, String switch_model, int num_switches, switch_control_t sface) {
        TestStep s;
        String[] f = csv.split(",");
        switch (f[0]) {
            case "PAUSE": {
                s = new PauseStep();
                s.importQt(csv);
                break;
            }
            case "HOLD": {
                s = new HoldStep();
                s.importQt(csv);
                break;
            }
            case "SWITCH": {
                if (!switch_model.isEmpty()) {
                    s = new Switch(step_factory.getSeriesName(), switch_model, num_switches, sface);
                    s.importQt(String.valueOf(switch_model) + "," + csv);
                    break;
                }
                s = new HoldStep();
                break;
            }
            default: {
                s = step_factory.loadStep(csv);
            }
        }
        return s;
    }

    public static boolean valid(String name, String series) {
        boolean r = false;
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        String[] qdata = sql.queryRow("select series from sequence where name='" + name + "'");
        sql.close();
        if (qdata != null && series.equals(qdata[0])) {
            r = true;
        }
        return r;
    }

    public boolean validateSwitchConfiguration(SystemConfiguration config) {
        boolean r = true;
        if (this.loaded_switch_step) {
            if (!config.use_switches) {
                r = false;
            } else if (this.num_switches != config.num_switches) {
                r = false;
            } else if (!this.switch_model.equals(config.switches[0].model)) {
                r = false;
            }
        }
        return r;
    }

    public static TestSequence load(String name) {
        TestSequence seq = new TestSequence();
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        String[] qdata = sql.queryRow("select series,switch_model,num_switches,instrument_settings,dut_settings,report_options from sequence where name='" + name + "'");
        if (qdata != null) {
            seq.loaded_name = name;
            seq.series = qdata[0];
            seq.switch_model = qdata[1];
            seq.num_switches = Integer.valueOf(qdata[2]);
            seq.tester = Tester.makeTester(seq.series);
            seq.tester_settings = TesterSettings.loadTesterSettings(seq.series, qdata[3]);
            seq.dut_settings = (DutSettings)new Gson().fromJson(qdata[4], DutSettings.class);
            seq.report_settings = (ReportSettings)new Gson().fromJson(qdata[5], ReportSettings.class);
            seq.report_settings.banner = ImageTools.fetch("select banner_image from sequence where name='" + name + "'");
        } else {
            seq = new TestSequence();
        }
        seq.step_factory = StepFactory.makeStepFactory(seq.series);
        seq.dut_settings.loadModelMap(name);
        ArrayList<String[]> res = sql.queryRows("select num,class_id,settings from steps where owner_name='" + name + "' order by num");
        for (String[] s : res) {
            byte[] id = ImageTools.fetch("select image from steps where num='" + s[0] + "' and owner_name='" + name + "'");
            TestStep ts = seq.loadStep(s[1], s[2], id);
            seq.steps.add(ts);
            ++seq.num_steps;
        }
        sql.close();
        return seq;
    }

    public static TestSequence load(String name, SystemConfiguration config) {
        TestSequence seq = new TestSequence();
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        String[] qdata = sql.queryRow("select series,switch_model,num_switches,instrument_settings,dut_settings,report_options from sequence where name='" + name + "'");
        if (qdata != null) {
            seq.loaded_name = name;
            seq.series = qdata[0];
            seq.switch_model = qdata[1];
            seq.num_switches = Integer.valueOf(qdata[2]);
            seq.tester = Tester.makeTester(seq.series);
            seq.tester_settings = TesterSettings.loadTesterSettings(seq.series, qdata[3]);
            seq.dut_settings = (DutSettings)new Gson().fromJson(qdata[4], DutSettings.class);
            seq.report_settings = (ReportSettings)new Gson().fromJson(qdata[5], ReportSettings.class);
            seq.report_settings.banner = ImageTools.fetch("select banner_image from sequence where name='" + name + "'");
        } else {
            seq = new TestSequence();
        }
        seq.switch_model = config.switches[0].model;
        seq.num_switches = config.num_switches;
        seq.switch_interface = config.switch_control;
        seq.step_factory = StepFactory.makeStepFactory(seq.series);
        seq.dut_settings.loadModelMap(name);
        ArrayList<String[]> res = sql.queryRows("select num,class_id,settings from steps where owner_name='" + name + "' order by num");
        for (String[] s : res) {
            byte[] id = ImageTools.fetch("select image from steps where num='" + s[0] + "' and owner_name='" + name + "'");
            TestStep ts = seq.loadStep(s[1], s[2], id);
            seq.steps.add(ts);
            ++seq.num_steps;
        }
        sql.close();
        return seq;
    }

    public int save() {
        TestStep step;
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String enc_tester = this.tester_settings.toString();
        String enc_dut = this.dut_settings.toString();
        String enc_report = this.report_settings.toString();
        this.dut_settings.saveModelMap(this.loaded_name);
        sql.open();
        int r = sql.execute("replace into sequence (name,series,switch_model,num_switches,instrument_settings,dut_settings,report_options) values ('" + this.loaded_name + "'," + "'" + this.series + "'," + "'" + this.switch_model + "'," + "'" + Integer.toString(this.num_switches) + "'," + "'" + enc_tester + "'," + "'" + enc_dut + "'," + "'" + enc_report + "'" + ")");
        if (this.report_settings.banner != null) {
            ImageTools.save(this.report_settings.banner, "sequence", "banner_image", "name = '" + this.loaded_name + "'");
        }
        String[] id = sql.queryRow("select id from sequence where name='" + this.loaded_name + "'");
        sql.execute("delete from steps where owner_name='" + this.loaded_name + "'");
        int num = 0;
        while ((step = this.getStep(num)) != null) {
            step.step_num = num;
            TestStep.StepExport se = step.export();
            sql.execute("insert into steps (owner_id,owner_name,num,class_id,settings) values ('" + id[0] + "'," + "'" + this.loaded_name + "'," + "'" + num + "'," + "'" + step.getType() + "'," + "'" + se.in_json + "'" + ")");
            if (se.image != null) {
                ImageTools.save(se.image, "steps", "image", "owner_name='" + this.loaded_name + "' and num='" + num + "'");
            }
            ++num;
        }
        sql.close();
        return r;
    }

    public int saveAs(String name) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        int result = -1;
        String enc_tester = this.tester_settings.toString();
        String enc_dut = this.dut_settings.toString();
        String enc_report = this.report_settings.toString();
        this.dut_settings.saveModelMap(this.loaded_name);
        this.loaded_name = name;
        sql.open();
        int id = sql.insertWithId("insert into sequence (name,series,switch_model,num_switches,instrument_settings,dut_settings,report_options) values ('" + this.loaded_name + "'," + "'" + this.series + "'," + "'" + this.switch_model + "'," + "'" + Integer.toString(this.num_switches) + "'," + "'" + enc_tester + "'," + "'" + enc_dut + "'," + "'" + enc_report + "'" + ")");
        if (id != -1) {
            TestStep step;
            if (this.report_settings.banner != null) {
                ImageTools.save(this.report_settings.banner, "sequence", "banner_image", "name = '" + name + "'");
            }
            int num = 0;
            while ((step = this.getStep(num)) != null) {
                step.step_num = num;
                TestStep.StepExport se = step.export();
                sql.execute("insert into steps (owner_id,owner_name,num,class_id,settings) values ('" + id + "'," + "'" + name + "'," + "'" + num + "'," + "'" + step.getType() + "'," + "'" + se.in_json + "'" + ")");
                if (se.image != null) {
                    ImageTools.save(se.image, "steps", "image", "owner_name='" + this.loaded_name + "' and num='" + num + "'");
                }
                ++num;
            }
            this.dut_settings = (DutSettings)new Gson().fromJson(enc_dut, DutSettings.class);
            result = 0;
        }
        sql.close();
        return result;
    }

    public int delete() {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        this.dut_settings.deleteModelMap(this.loaded_name);
        sql.execute("delete from sequence where name='" + this.loaded_name + "'");
        sql.execute("delete from steps where owner_name='" + this.loaded_name + "'");
        sql.close();
        return 0;
    }

    public String[] getStepTypes() {
        String[] ilist = this.step_factory.getStepTypes();
        String[] flist = new String[ilist.length + 2 + (this.num_switches > 0 ? 1 : 0)];
        int i = 0;
        String[] stringArray = ilist;
        int n = ilist.length;
        int n2 = 0;
        while (n2 < n) {
            String n3;
            flist[i] = n3 = stringArray[n2];
            ++i;
            ++n2;
        }
        flist[i++] = "Pause";
        flist[i++] = "Hold";
        if (this.num_switches > 0) {
            flist[i++] = "Switch";
        }
        return flist;
    }

    public TestStep newStep(String name) {
        TestStep s = this.step_factory.retrieveStep(name);
        if (s != null) {
            return this.copyStep(s);
        }
        switch (name) {
            case "Pause": {
                s = new PauseStep();
                break;
            }
            case "Hold": {
                s = new HoldStep();
                break;
            }
            case "Switch": {
                s = new Switch(this.series, this.switch_model, this.num_switches, this.switch_interface);
                break;
            }
            default: {
                s = this.step_factory.newStep(name);
            }
        }
        return s;
    }

    public void cacheStep(TestStep step) {
        this.step_factory.cacheStep(step);
    }

    public int addStep(TestStep step) {
        this.steps.add(step);
        ++this.num_steps;
        return this.steps.size() - 1;
    }

    public void insertStep(int position, TestStep step) {
        this.steps.add(position, step);
        ++this.num_steps;
    }

    public void replaceStep(int position, TestStep step) {
        this.steps.set(position, step);
    }

    public void deleteStep(TestStep step) {
        boolean r = this.steps.remove(step);
        if (r) {
            --this.num_steps;
        }
    }

    public TestStep getStep(int position) {
        if (position >= this.num_steps) {
            return null;
        }
        int s = this.steps.size();
        if (position >= s) {
            return null;
        }
        return this.steps.get(position);
    }

    public int sendStep(Interface io_handle, int step_num) {
        int err = -1;
        TestStep s = this.getStep(step_num);
        if (s == null) {
            return -1;
        }
        String add = s.addStep(this.tester_settings, this.tester);
        System.out.println(add);
        io_handle.sendCommand(add);
        io_handle.sendCommand("*err?");
        String r = io_handle.getResponse(100);
        if (r != null) {
            err = Integer.valueOf(r);
        }
        return err;
    }

    private float outputStrings(PDPageContentStream stream, float y, String[] a, float h) {
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                stream.beginText();
                stream.newLineAtOffset(54.0f, y);
                stream.showText(s);
                stream.endText();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            y -= 14.0f;
            ++n2;
        }
        return y;
    }

    private PDDocument generateReportAsPdf() {
        PDDocument doc = null;
        try {
            TestStep step;
            doc = new PDDocument();
            PDDocumentInformation pdd = doc.getDocumentInformation();
            String title = "Vitrek QT Insite " + this.series + " Test Sequence";
            pdd.setAuthor(UserSettings.user_name);
            pdd.setTitle(title);
            pdd.setCreator("Vitrek");
            pdd.setSubject("Sequence " + this.loaded_name);
            PDType0Font font1 = PDType0Font.load((PDDocument)doc, (File)new File("fonts/arial.ttf"));
            PDType0Font font2 = PDType0Font.load((PDDocument)doc, (File)new File("fonts/arialbd.ttf"));
            float report_text_height = 14.0f;
            PDPageContentStream stream = null;
            float y = 756.0f;
            int left_margin = 36;
            PDPage page = new PDPage();
            doc.addPage(page);
            stream = new PDPageContentStream(doc, page);
            stream.setFont((PDFont)font2, 12.0f);
            float text_width = font2.getStringWidth(title) / 1000.0f * 12.0f;
            float center_x = (float)((540.0 - (double)text_width) / 2.0);
            stream.beginText();
            stream.newLineAtOffset((float)left_margin + center_x, y);
            stream.showText(title);
            stream.endText();
            stream.moveTo((float)left_margin + center_x, y - 2.0f);
            stream.lineTo((float)left_margin + center_x + text_width, y - 2.0f);
            stream.stroke();
            String gline = "Sequence Settings";
            stream.setFont((PDFont)font2, 12.0f);
            stream.beginText();
            stream.newLineAtOffset((float)left_margin, y -= report_text_height + report_text_height / 8.0f);
            stream.showText(gline);
            stream.endText();
            text_width = font2.getStringWidth(gline) / 1000.0f * 12.0f;
            stream.moveTo((float)left_margin, y - 2.0f);
            stream.lineTo((float)left_margin + text_width, y - 2.0f);
            stream.stroke();
            y -= report_text_height + report_text_height / 8.0f;
            stream.setFont((PDFont)font1, 12.0f);
            y = this.outputStrings(stream, y, this.tester_settings.report(), report_text_height);
            y = this.outputStrings(stream, y, this.dut_settings.report(), report_text_height);
            y = this.outputStrings(stream, y, this.report_settings.report(), report_text_height);
            int step_num = 0;
            while ((step = this.getStep(step_num)) != null) {
                String[] rpt = step.report(this.tester_settings, ReportSettings.detail_level_t.full);
                float height = (float)rpt.length * report_text_height;
                if (height > y) {
                    page = new PDPage();
                    doc.addPage(page);
                    stream.close();
                    stream = new PDPageContentStream(doc, page);
                    y = 756.0f;
                    stream.setFont((PDFont)font2, 12.0f);
                    text_width = font2.getStringWidth(title) / 1000.0f * 12.0f;
                    center_x = (float)((540.0 - (double)text_width) / 2.0);
                    stream.beginText();
                    stream.newLineAtOffset((float)left_margin + center_x, y);
                    stream.showText(title);
                    stream.endText();
                    stream.moveTo((float)left_margin + center_x, y - 2.0f);
                    stream.lineTo((float)left_margin + center_x + text_width, y - 2.0f);
                    stream.stroke();
                    y -= report_text_height + report_text_height / 8.0f;
                }
                stream.setFont((PDFont)font2, 12.0f);
                String fline = "Step #" + (step_num + 1) + (step.name.isEmpty() ? " " : " " + step.name + " ") + rpt[0];
                stream.beginText();
                stream.newLineAtOffset((float)left_margin, y);
                stream.showText(fline);
                stream.endText();
                text_width = font2.getStringWidth(fline) / 1000.0f * 12.0f;
                stream.moveTo((float)left_margin, y - 2.0f);
                stream.lineTo((float)left_margin + text_width, y - 2.0f);
                stream.stroke();
                y -= report_text_height + report_text_height / 8.0f;
                stream.setFont((PDFont)font1, 10.0f);
                int rline = 1;
                while (rline < rpt.length) {
                    stream.beginText();
                    stream.newLineAtOffset((float)(left_margin + 18), y);
                    stream.showText(rpt[rline]);
                    stream.endText();
                    y -= report_text_height;
                    ++rline;
                }
                ++step_num;
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public void print(Composite parent) {
        PDDocument doc = this.generateReportAsPdf();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(doc));
        job.setCopies(1);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException exc) {
                System.out.println(exc);
            }
        }
        try {
            doc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void export(Composite parent) {
        FileDialog dialog = new FileDialog(parent.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.json", "*.*"});
        if (!this.loaded_name.isEmpty()) {
            dialog.setFileName(String.valueOf(this.loaded_name) + ".json");
        } else {
            dialog.setFileName("sequence.json");
        }
        dialog.setOverwrite(true);
        String save_path = dialog.open();
        if (save_path == null) {
            return;
        }
        try {
            TestStep step;
            FileWriter writer = new FileWriter(save_path, false);
            writer.write(String.valueOf(this.series) + "\r\n");
            writer.write(String.valueOf(this.tester_settings.toString()) + "\r\n");
            writer.write(String.valueOf(this.dut_settings.toString()) + "\r\n");
            writer.write(String.valueOf(this.report_settings.toString()) + "\r\n");
            int num = 0;
            while ((step = this.getStep(num)) != null) {
                writer.write(String.valueOf(step.toString()) + "\r\n");
                ++num;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static TestSequence qtImport95x(String first_line, BufferedReader input, String switch_model, int num_switches, switch_control_t sface) {
        TestSequence seq = new TestSequence("95x");
        seq.tester_settings.importQt(first_line);
        seq.dut_settings.importQt(first_line);
        seq.report_settings.importQt(first_line);
        try {
            String step_line;
            while ((step_line = input.readLine()) != null) {
                TestStep ts = TestSequence.loadStep(seq.step_factory, step_line, switch_model, num_switches, sface);
                seq.steps.add(ts);
                ++seq.num_steps;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return seq;
    }

    private static TestSequence qtImportV7x(String first_line, BufferedReader input, String switch_model, int num_switches, switch_control_t sface) {
        TestSequence seq = new TestSequence("V7x");
        seq.tester_settings.importQt(first_line);
        seq.dut_settings.importQt(first_line);
        seq.report_settings.importQt(first_line);
        try {
            String step_line;
            while ((step_line = input.readLine()) != null) {
                TestStep ts = TestSequence.loadStep(seq.step_factory, step_line, switch_model, num_switches, sface);
                seq.steps.add(ts);
                ++seq.num_steps;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return seq;
    }

    private static TestSequence importJson(String first_line, BufferedReader input) {
        TestSequence seq = new TestSequence(first_line);
        try {
            String step_line;
            seq.tester_settings = TesterSettings.loadTesterSettings(seq.series, input.readLine());
            seq.dut_settings = (DutSettings)new Gson().fromJson(input.readLine(), DutSettings.class);
            seq.report_settings = (ReportSettings)new Gson().fromJson(input.readLine(), ReportSettings.class);
            Gson gson = new Gson();
            while ((step_line = input.readLine()) != null) {
                Map map = (Map)gson.fromJson(step_line, Map.class);
                String id = (String)map.get("id");
                TestStep ts = TestSequence.loadStep(seq.step_factory, id, step_line);
                seq.steps.add(ts);
                ++seq.num_steps;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return seq;
    }

    public static TestSequence Import(Composite parent, String switch_model, int num_switches, switch_control_t sface) {
        TestSequence seq = null;
        String oops = null;
        FileDialog dialog = new FileDialog(parent.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.csv;*.json", "*.*"});
        String import_path = dialog.open();
        if (import_path == null) {
            return null;
        }
        try {
            BufferedReader input = new BufferedReader(new FileReader(import_path));
            String line = input.readLine();
            String[] f = line.split(",");
            if (f.length > 1) {
                if (f[0].replaceAll("\\P{Print}", "").equals("950")) {
                    seq = TestSequence.qtImport95x(line, input, switch_model, num_switches, sface);
                } else if (f[0].replaceAll("\\P{Print}", "").equals("V7x")) {
                    seq = TestSequence.qtImportV7x(line, input, switch_model, num_switches, sface);
                } else {
                    oops = "Cannot identify the instrument type";
                }
            } else {
                seq = TestSequence.importJson(line, input);
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageBox ed = new MessageBox(parent.getShell(), 33);
            ed.setText("Error");
            ed.setMessage("Cannot open import file");
            ed.open();
            seq = null;
        }
        if (oops != null) {
            MessageBox ed = new MessageBox(parent.getShell(), 33);
            ed.setText("Error");
            ed.setMessage(oops);
            ed.open();
        }
        return seq;
    }

    public static String[] getNames() {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String[] names = sql.queryColumn("select name from sequence order by name");
        return names;
    }

    public static String[] getNames(String series) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String[] names = sql.queryColumn("select name from sequence where series='" + series + "' order by name");
        return names;
    }
}

