/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.printing.PDFPageable;
import org.eclipse.swt.widgets.Composite;

public class SystemConfiguration {
    String series = "95x";
    String loaded_name = "";
    InterfaceFactory.physical_interface_t pc_interface;
    String[] interface_settings = new String[2];
    boolean use_switches = false;
    int num_switches = 1;
    switch_control_t switch_control;
    SwitchSettings[] switches;

    public SystemConfiguration() {
        this.pc_interface = InterfaceFactory.physical_interface_t.physical_ethernet;
        this.interface_settings = new String[]{"192.168.1.100", ""};
        this.switch_control = switch_control_t.switch_control_tester_RS232;
        this.switches = new SwitchSettings[1];
        this.switches[0] = new SwitchSettings();
    }

    public static SystemConfiguration load(String name) {
        SystemConfiguration result;
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String[] encoded = sql.queryRow("select settings from system_configuration where name='" + name + "'");
        if (encoded != null) {
            result = (SystemConfiguration)new Gson().fromJson(encoded[0], SystemConfiguration.class);
            result.loaded_name = name;
        } else {
            result = new SystemConfiguration();
        }
        return result;
    }

    public boolean verifyInterface(String[] serial_ports, boolean have_gpib, boolean fix_it) {
        boolean status = true;
        boolean have_serial = serial_ports != null && serial_ports.length > 0;
        if (!have_serial && this.pc_interface == InterfaceFactory.physical_interface_t.physical_rs232) {
            status = false;
        } else if (have_serial && this.pc_interface == InterfaceFactory.physical_interface_t.physical_rs232) {
            if (!ArrayUtils.contains((Object[])serial_ports, (Object)this.interface_settings[0])) {
                status = false;
            }
        } else if (!have_gpib && this.pc_interface == InterfaceFactory.physical_interface_t.physical_gpib) {
            status = false;
        }
        if (!status && fix_it) {
            this.pc_interface = InterfaceFactory.physical_interface_t.physical_ethernet;
            this.interface_settings = new String[]{"192.168.1.100", ""};
        }
        return status;
    }

    public boolean verifyInterface(String[] serial_ports, boolean have_gpib) {
        return this.verifyInterface(serial_ports, have_gpib, false);
    }

    public String[] switchModelChoices() {
        String[] models = null;
        switch (this.series) {
            case "V10x": {
                models = new String[]{"948i", "964i", "M10x"};
                break;
            }
            case "95x": 
            case "98x": {
                models = new String[]{"948i", "964i", "M10x"};
                break;
            }
            case "V7x": {
                models = new String[]{"964i", "M10x", "V75/V76/V77"};
                break;
            }
            default: {
                models = new String[]{"964i"};
            }
        }
        return models;
    }

    public String[] switchTopInterfaceChoices(String model) {
        String[] choices = new String[]{"Tester (RS232)", "Computer"};
        switch (this.series) {
            case "V10x": {
                switch (model) {
                    case "948i": {
                        choices = new String[]{"Tester (RS232)", "Computer"};
                        break;
                    }
                    case "964i": {
                        choices = new String[]{"Tester (VICL)", "Tester (RS232)", "Computer"};
                        break;
                    }
                    case "M10x": {
                        choices = new String[]{"Tester (VICL)", "Tester (RS232)", "Tester (TCP/IP)", "Computer"};
                    }
                }
                break;
            }
            case "95x": 
            case "98x": {
                switch (model) {
                    case "948i": {
                        choices = new String[]{"Tester (RS232)", "Computer"};
                        break;
                    }
                    case "964i": {
                        choices = new String[]{"Tester (VICL)", "Tester (RS232)", "Computer"};
                        break;
                    }
                    case "M10x": {
                        choices = new String[]{"Tester (VICL)", "Tester (RS232)", "Computer"};
                    }
                }
                break;
            }
            case "V7x": {
                switch (model) {
                    case "964i": {
                        choices = new String[]{"Tester (VICL)", "Computer"};
                        break;
                    }
                    case "M10x": {
                        choices = new String[]{"Tester (VICL)", "Computer"};
                        break;
                    }
                    case "V75/V76/V77": {
                        choices = new String[]{"Tester (Internal)"};
                    }
                }
                break;
            }
        }
        return choices;
    }

    public String[] switchComputerInterfaceChoices(String model) {
        String[] choices = null;
        switch (model) {
            case "948i": {
                choices = new String[]{"RS232", "GPIB"};
                break;
            }
            case "964i": {
                choices = new String[]{"RS232", "GPIB"};
                break;
            }
            case "M10x": {
                choices = new String[]{"RS232", "GPIB", "TCP/IP"};
            }
        }
        return choices;
    }

    public void resetSwitches(String model, String connection) {
        this.switches = new SwitchSettings[1];
        this.num_switches = 1;
        switch (connection) {
            case "Tester (VICL)": {
                this.switch_control = switch_control_t.switch_control_tester_VICL;
                this.switches[0] = new SwitchSettings(InterfaceFactory.physical_interface_t.physical_rs232, model);
                break;
            }
            case "Tester (RS232)": {
                this.switch_control = switch_control_t.switch_control_tester_RS232;
                this.switches[0] = new SwitchSettings(InterfaceFactory.physical_interface_t.physical_rs232, model);
                break;
            }
            case "Tester (TCP/IP)": {
                this.switch_control = switch_control_t.switch_control_tester_TCPIP;
                this.switches[0] = new SwitchSettings(InterfaceFactory.physical_interface_t.physical_rs232, model);
                break;
            }
            case "Tester (Internal)": {
                this.switch_control = switch_control_t.switch_control_tester_internal;
                this.switches[0] = new SwitchSettings(InterfaceFactory.physical_interface_t.physical_rs232, model);
                break;
            }
            case "Computer": {
                InterfaceFactory.physical_interface_t pi;
                this.switch_control = switch_control_t.switch_control_computer;
                String[] is = new String[2];
                String[] sp = InterfaceFactory.getRs232PortList();
                if (sp != null && sp.length > 0) {
                    pi = InterfaceFactory.physical_interface_t.physical_rs232;
                    is[0] = sp[0];
                    is[1] = "115200";
                } else if (InterfaceFactory.haveGpib()) {
                    pi = InterfaceFactory.physical_interface_t.physical_gpib;
                    is[0] = "2";
                } else {
                    pi = InterfaceFactory.physical_interface_t.physical_ethernet;
                    is[0] = "192.168.1.101";
                }
                this.switches[0] = new SwitchSettings(pi, model, is);
            }
        }
    }

    private int switchLimit() {
        int limit = 1;
        block0 : switch (this.switch_control) {
            case switch_control_tester_VICL: {
                switch (this.series) {
                    case "V10x": {
                        limit = 250;
                        break block0;
                    }
                    case "95x": 
                    case "98x": {
                        limit = 4;
                        break block0;
                    }
                    case "V7x": {
                        limit = 4;
                        break block0;
                    }
                }
                break;
            }
            case switch_control_tester_RS232: {
                limit = 1;
                break;
            }
            case switch_control_tester_TCPIP: {
                limit = 100;
                break;
            }
            case switch_control_tester_internal: {
                limit = 1;
                break;
            }
            case switch_control_computer: {
                limit = this.switches[0].pc_interface == InterfaceFactory.physical_interface_t.physical_gpib ? 30 : 100;
            }
        }
        return limit;
    }

    public void addSwitch() {
        int limit = this.switchLimit();
        if (this.num_switches < limit) {
            ++this.num_switches;
            SwitchSettings[] new_sw = new SwitchSettings[this.num_switches];
            int i = 0;
            SwitchSettings[] switchSettingsArray = this.switches;
            int n = this.switches.length;
            int n2 = 0;
            while (n2 < n) {
                SwitchSettings sc = switchSettingsArray[n2];
                new_sw[i++] = sc;
                ++n2;
            }
            String[] s = new String[]{this.switches[i - 1].isettings[0], this.switches[i - 1].isettings[1]};
            if (this.switch_control == switch_control_t.switch_control_computer) {
                String[] c;
                if (this.switches[0].pc_interface == InterfaceFactory.physical_interface_t.physical_gpib) {
                    int ga = Integer.valueOf(s[1]) + 1;
                    s[1] = Integer.toString(ga);
                } else if (this.switches[0].pc_interface == InterfaceFactory.physical_interface_t.physical_ethernet && (c = s[0].split("\\.")).length >= 4) {
                    int lc = Integer.valueOf(c[3]) + 1;
                    s[0] = String.valueOf(c[0]) + "." + c[1] + "." + c[2] + "." + Integer.toString(lc);
                }
            }
            new_sw[i] = new SwitchSettings(this.switches[i - 1].pc_interface, this.switches[i - 1].model, s);
            this.switches = new_sw;
        }
    }

    public void deleteSwitch() {
        if (this.num_switches > 1) {
            --this.num_switches;
            SwitchSettings[] new_sw = new SwitchSettings[this.num_switches];
            int i = 0;
            while (i < this.num_switches) {
                new_sw[i] = this.switches[i];
                ++i;
            }
            this.switches = new_sw;
        }
    }

    public void deleteSwitch(int switch_index) {
        if (this.num_switches > 1) {
            SwitchSettings[] new_sw = new SwitchSettings[this.num_switches - 1];
            int d = 0;
            int s = 0;
            while (s < this.num_switches) {
                if (s != switch_index) {
                    new_sw[d++] = this.switches[s];
                }
                ++s;
            }
            --this.num_switches;
            this.switches = new_sw;
        }
    }

    public int save() {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String enc = new Gson().toJson((Object)this);
        int r = sql.execute("replace into system_configuration (name,settings) values ('" + this.loaded_name + "'," + "'" + enc + "'" + ")");
        return r;
    }

    public int saveAs(String name) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String enc = new Gson().toJson((Object)this);
        this.loaded_name = name;
        int r = sql.execute("insert into system_configuration (name,settings) values ('" + this.loaded_name + "'," + "'" + enc + "'" + ")");
        return r;
    }

    public int delete(String name) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        int r = sql.execute("delete from system_configuration where name='" + name + "'");
        return r;
    }

    public String export_json() {
        String enc = new Gson().toJson((Object)this);
        return enc;
    }

    public static SystemConfiguration zfromJson(String json) {
        SystemConfiguration jtest = (SystemConfiguration)new Gson().fromJson(json, SystemConfiguration.class);
        return jtest;
    }

    public String toString() {
        String serialized = new Gson().toJson((Object)this);
        return serialized;
    }

    public void import_json(String json) {
    }

    private PDDocument generateConfigurationReportAsPdf() {
        PDDocument doc = null;
        try {
            doc = new PDDocument();
            PDDocumentInformation pdd = doc.getDocumentInformation();
            String title = "Vitrek QT Insite " + this.series + " Configuration Report";
            pdd.setAuthor(UserSettings.user_name);
            pdd.setTitle(title);
            pdd.setCreator("Vitrek");
            pdd.setSubject("Configuration " + this.loaded_name);
            float report_text_height = 14.0f;
            PDPageContentStream stream = null;
            PDPage page = new PDPage();
            doc.addPage(page);
            stream = new PDPageContentStream(doc, page);
            PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD);
            int left_margin = 36;
            float y = 756.0f;
            stream.setFont((PDFont)font, 12.0f);
            float text_width = font.getStringWidth(title) / 1000.0f * 12.0f;
            float center_x = (float)((540.0 - (double)text_width) / 2.0);
            stream.beginText();
            stream.newLineAtOffset((float)left_margin + center_x, y);
            stream.showText(title);
            stream.endText();
            stream.moveTo((float)left_margin + center_x, y - 2.0f);
            stream.lineTo((float)left_margin + center_x + text_width, y - 2.0f);
            stream.stroke();
            font = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
            stream.setFont((PDFont)font, 12.0f);
            stream.beginText();
            stream.newLineAtOffset((float)left_margin, y -= report_text_height + report_text_height / 8.0f);
            String iface = "";
            switch (this.pc_interface) {
                case physical_rs232: {
                    iface = "RS232 on " + this.interface_settings[0] + " @" + this.interface_settings[1] + " baud";
                    break;
                }
                case physical_ethernet: {
                    iface = "Ethernet using address " + this.interface_settings[0];
                    break;
                }
                case physical_usb: {
                    iface = "USB";
                    break;
                }
                case physical_gpib: {
                    iface = "GPIB using address " + this.interface_settings[0];
                }
            }
            stream.showText("Tester interface: " + iface);
            stream.endText();
            y -= report_text_height;
            if (this.use_switches && this.num_switches > 0) {
                int id = 1;
                SwitchSettings[] switchSettingsArray = this.switches;
                int n = this.switches.length;
                int n2 = 0;
                while (n2 < n) {
                    SwitchSettings sc = switchSettingsArray[n2];
                    String model = this.switches[0].model;
                    String conn = "";
                    block7 : switch (this.switch_control) {
                        case switch_control_tester_VICL: {
                            conn = "Tester VICL " + id;
                            break;
                        }
                        case switch_control_tester_RS232: {
                            conn = "Tester RS232";
                            break;
                        }
                        case switch_control_tester_TCPIP: {
                            conn = "Tester TCP/IP";
                            break;
                        }
                        case switch_control_tester_internal: {
                            conn = "Tester internal";
                            break;
                        }
                        case switch_control_computer: {
                            switch (sc.pc_interface) {
                                case physical_rs232: {
                                    conn = "PC " + sc.isettings[0] + " @" + sc.isettings[1];
                                    break block7;
                                }
                                case physical_ethernet: {
                                    conn = "PC TCP/IP @ " + sc.isettings[0];
                                    break block7;
                                }
                                case physical_gpib: {
                                    conn = "PC GPIB @ " + sc.isettings[0];
                                    break block7;
                                }
                            }
                        }
                    }
                    stream.beginText();
                    stream.newLineAtOffset((float)left_margin, y);
                    stream.showText("Switch Unit #" + id + ": Model " + model + " interfaced to " + conn);
                    stream.endText();
                    y -= report_text_height;
                    ++id;
                    ++n2;
                }
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public void print(Composite parent) {
        PDDocument doc = this.generateConfigurationReportAsPdf();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(doc));
        job.setCopies(1);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException exc) {
                System.out.println(exc);
            }
        }
        try {
            doc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String[] getNames() {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String[] configs = sql.queryColumn("select name from system_configuration order by name");
        return configs;
    }
}

