/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class Switch
extends TestStep {
    static final int CARD_NONE = 0;
    static final int CARD_FAST = 1;
    static final int CARD_RAMP = 2;
    static final int CARD_TIME = 3;
    String id = "Switch";
    String model;
    int num_units;
    SwitchUnitInfo[] unit_info;
    double pre_delay;
    double post_delay;
    transient String tester_series;
    transient boolean allow_delays;
    transient switch_phase_t switch_phase;
    transient long post_time;
    static transient Interface[] switch_io;

    public Switch(String series, String model, int num_units, switch_control_t itype) {
        this.model = model;
        this.num_units = num_units;
        this.tester_series = series;
        this.pre_delay = 0.05;
        this.post_delay = 0.25;
        this.unit_info = new SwitchUnitInfo[num_units];
        int i = 0;
        while (i < num_units) {
            this.unit_info[i] = new SwitchUnitInfo();
            ++i;
        }
        boolean can_delay = true;
        if (series.equals("V7x") && itype != switch_control_t.switch_control_computer) {
            can_delay = false;
        }
        this.allow_delays = can_delay;
    }

    @Override
    public String getType() {
        return "Switch";
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        Composite e = null;
        if (this.model == null) {
            this.model = "";
        }
        switch (this.model) {
            case "": {
                e = SwitchNone_Edit.editor(parent, tester, this);
                break;
            }
            case "948i": {
                e = Switch948i_Edit.editor(parent, tester, this);
                break;
            }
            case "964i": {
                e = Switch964i_Edit.editor(parent, tester, this);
                break;
            }
            case "M10x": {
                e = Switch964i_Edit.editor(parent, tester, this);
                break;
            }
            case "V75/V76/V77": {
                e = SwitchV7x_Edit.editor(parent, tester, this);
            }
        }
        return e;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void fetch() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl46 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl46 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String command;
        this.switch_phase = switch_phase_t.switch_phase_PRE;
        if (this.model.isEmpty() || this.num_units == 0) {
            command = tester.addPauseStep(this.pre_delay + 2.0 + this.post_delay, "");
        } else if (switch_io != null) {
            double delay = this.pre_delay + (double)this.num_units * 1.5 + this.post_delay + 100.0;
            command = tester.addHoldStep(delay, "Switching\r\nRelays", true);
            System.out.println("PC Switch: " + command);
        } else if (this.model.equals("V75/V76/V77")) {
            command = "add,switch," + this.unit_info[0].banks[0] + "," + this.unit_info[0].banks[1] + "," + this.unit_info[0].banks[2];
        } else if (this.tester_series.equals("V7x")) {
            command = "add,switch";
            int i = 0;
            while (i < this.num_units) {
                String r = "," + this.unit_info[i].banks[0] + "," + this.unit_info[i].banks[1] + "," + this.unit_info[i].banks[2] + "," + this.unit_info[i].banks[3] + "," + this.unit_info[i].banks[4] + "," + this.unit_info[i].banks[5] + "," + this.unit_info[i].banks[6] + "," + this.unit_info[i].banks[7];
                command = String.valueOf(command) + r;
                ++i;
            }
        } else {
            command = "add,switch," + this.pre_delay + "," + this.post_delay;
            if (this.model.equals("948i")) {
                String r = "," + this.unit_info[0].banks[0] + "," + this.unit_info[0].banks[1] + "," + this.unit_info[0].banks[2] + "," + this.unit_info[0].banks[3] + "," + this.unit_info[0].banks[4] + "," + this.unit_info[0].banks[5] + "," + this.unit_info[0].banks[6];
                command = String.valueOf(command) + r;
            } else {
                int i = 0;
                while (i < this.num_units) {
                    String r = "," + this.unit_info[i].banks[0] + "," + this.unit_info[i].banks[1] + "," + this.unit_info[i].banks[2] + "," + this.unit_info[i].banks[3] + "," + this.unit_info[i].banks[4] + "," + this.unit_info[i].banks[5] + "," + this.unit_info[i].banks[6] + "," + this.unit_info[i].banks[7];
                    command = String.valueOf(command) + r;
                    ++i;
                }
            }
        }
        return command;
    }

    private void sendSwitchCommands() {
        if (this.model.equals("948i")) {
            int i = 0;
            while (i < this.num_units) {
                String cmd = "syst " + this.unit_info[i].banks[7] + "," + this.unit_info[i].banks[6] + "," + this.unit_info[i].banks[5] + "," + this.unit_info[i].banks[4] + "," + this.unit_info[i].banks[3] + "," + this.unit_info[i].banks[2] + ";" + "bank,6," + this.unit_info[i].banks[1];
                System.out.println("948i[" + i + "]:" + cmd);
                switch_io[i].sendCommand(cmd);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.num_units) {
                String cmd = "syst," + this.unit_info[i].banks[7] + "," + this.unit_info[i].banks[6] + "," + this.unit_info[i].banks[5] + "," + this.unit_info[i].banks[4] + "," + this.unit_info[i].banks[3] + "," + this.unit_info[i].banks[2] + "," + this.unit_info[i].banks[1] + "," + this.unit_info[i].banks[0];
                System.out.println("964i[" + i + "]:" + cmd);
                switch_io[i].sendCommand(cmd);
                ++i;
            }
        }
    }

    @Override
    public String stepSummary() {
        return "Switch";
    }

    @Override
    public String[][] labels() {
        return null;
    }

    @Override
    public float[] extractFinal(String steprslt) {
        return null;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus(this);
        if (switch_io != null) {
            io_handle.sendCommand("step?");
            String response = io_handle.getResponse(100);
            if (response == null) {
                r.status = TestStep.step_status_t.error;
            } else {
                long now = System.currentTimeMillis();
                int reported_step = Integer.parseInt(response);
                if (reported_step == 0) {
                    r.status = TestStep.step_status_t.done;
                } else if (reported_step == this.step_num + 1) {
                    switch (this.switch_phase) {
                        case switch_phase_PRE: {
                            long i = now - start_time;
                            double p = 1000.0 * this.pre_delay;
                            if ((double)i >= p) {
                                this.post_time = now;
                                this.switch_phase = switch_phase_t.switch_phase_POST;
                                this.sendSwitchCommands();
                                r.progress = 66;
                                System.out.println("PC Switch POST:" + start_time + "," + now + "," + i + "," + p);
                                break;
                            }
                            r.progress = 33;
                            break;
                        }
                        case switch_phase_POST: {
                            long i = now - this.post_time;
                            double p = 1000.0 * this.post_delay;
                            if ((double)i >= p) {
                                this.switch_phase = switch_phase_t.switch_phase_DONE;
                                io_handle.sendCommand("cont");
                                r.progress = 99;
                                System.out.println("PC Switch DONE" + this.post_time + "," + now + "," + i + "," + p);
                                break;
                            }
                            r.progress = 66;
                            break;
                        }
                        case switch_phase_DONE: {
                            r.progress = 99;
                        }
                    }
                } else if (this.switch_phase != switch_phase_t.switch_phase_DONE) {
                    r.status = TestStep.step_status_t.error;
                } else {
                    r.progress = 100;
                }
            }
        } else if (this.tester_series.equals("V7x")) {
            io_handle.sendCommand("step?");
            String response = io_handle.getResponse(100);
            if (response == null) {
                r.status = TestStep.step_status_t.error;
            } else {
                int reported_step = Integer.parseInt(response);
                if (reported_step == 0) {
                    r.status = TestStep.step_status_t.done;
                } else {
                    r.progress = reported_step == this.step_num + 1 ? 50 : 100;
                }
            }
        } else {
            io_handle.sendCommand("phase?;step?");
            String response = io_handle.getResponse(100);
            if (response == null) {
                r.status = TestStep.step_status_t.error;
            } else {
                String[] f = response.split(",");
                int reported_step = Integer.parseInt(f[1]);
                if (reported_step == 0) {
                    r.status = TestStep.step_status_t.done;
                } else if (reported_step == this.step_num + 1) {
                    int phase = Integer.parseInt(f[0]);
                    switch (phase) {
                        default: {
                            r.progress = 5;
                            break;
                        }
                        case 8: {
                            r.progress = 25;
                            break;
                        }
                        case 9: {
                            r.progress = 50;
                            break;
                        }
                        case 10: {
                            r.progress = 75;
                            break;
                        }
                        case 11: {
                            r.progress = 99;
                            break;
                        }
                    }
                } else {
                    r.progress = 100;
                }
            }
        }
        return r;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        return "";
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] r = null;
        switch (this.model) {
            case "948i": 
            case "964i": 
            case "M10x": {
                r = new String[]{"Switch " + this.model + " Pre-Delay:" + this.pre_delay + " Post-Delay:" + this.post_delay};
                break;
            }
            case "V75/V76/V77": {
                r = new String[]{"Switch V75/V76/V77"};
            }
        }
        return r;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        switch (level) {
            default: {
                rpt = new String[]{"Switch 964i  Pre-Delay:" + this.pre_delay + " Post-Delay:" + this.post_delay};
                break;
            }
            case full: {
                rpt = new String[1 + this.num_units * 9];
                rpt[0] = "Switch 964i  Pre-Delay:" + this.pre_delay + " Post-Delay:" + this.post_delay;
                int u = 0;
                while (u < this.num_units) {
                    rpt[1 + u * 9] = "Unit #" + (u + 1);
                    int b = 0;
                    while (b < 8) {
                        rpt[1 + u * 9 + 1 + b] = "Bank #" + (b + 1) + ": " + this.unit_info[u].banks[7 - b];
                        ++b;
                    }
                    ++u;
                }
                break block0;
            }
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.pre_delay = Double.parseDouble(settings[2]);
        this.post_delay = Double.parseDouble(settings[3]);
        int u = 0;
        while (u < this.num_units) {
            int o = u * 8 + 3;
            int b = 0;
            while (b < 8) {
                this.unit_info[u].banks[7 - b] = Integer.valueOf(settings[o + b + 1]);
                ++b;
            }
            ++u;
        }
        if (settings.length > 132 && settings[0].equals("V75/V76/V77")) {
            this.unit_info[0].sub_type = Integer.valueOf(settings[132]);
            if (this.unit_info[0].sub_type > 2) {
                this.unit_info[0].sub_type = 0;
            }
            this.unit_info[0].banks[0] = Integer.valueOf(settings[133]);
            this.unit_info[0].banks[1] = Integer.valueOf(settings[134]);
            this.unit_info[0].banks[2] = Integer.valueOf(settings[135]);
        }
    }

    @Override
    public void fixupSwitch(String series, String model, int num_units, switch_control_t itype) {
        this.model = model;
        this.tester_series = series;
        if (this.num_units != num_units) {
            SwitchUnitInfo[] new_ui = new SwitchUnitInfo[num_units];
            int i = 0;
            while (i < num_units && i < this.num_units) {
                new_ui[i] = this.unit_info[i];
                ++i;
            }
            while (i < num_units) {
                new_ui[i] = new SwitchUnitInfo();
                ++i;
            }
            this.unit_info = new_ui;
            this.num_units = num_units;
        }
        boolean can_delay = true;
        if (series.equals("V7x") && itype != switch_control_t.switch_control_computer) {
            can_delay = false;
        }
        this.allow_delays = can_delay;
    }

    public static void configureIo(Interface[] switch_interfaces) {
        switch_io = switch_interfaces;
    }

    public static enum switch_phase_t {
        switch_phase_PRE,
        switch_phase_POST,
        switch_phase_DONE;

    }
}

