/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Map;

public abstract class StepFactory {
    Map<String, TestStep> cache = new HashMap<String, TestStep>();

    abstract String getSeriesName();

    abstract String[] getStepTypes();

    abstract TestStep loadStep(String var1, String var2, byte[] var3);

    abstract TestStep loadStep(String var1);

    abstract TestStep newStep(String var1);

    public void cacheStep(TestStep step) {
        this.cache.put(step.getType(), step);
    }

    public TestStep retrieveStep(String name) {
        return this.cache.get(name);
    }

    public static StepFactory makeStepFactory(String series) {
        StepFactory f = null;
        if (series.equals("95x")) {
            f = new Nine5xStepFactory();
        } else if (series.equals("98x")) {
            f = new Nine8xStepFactory();
        } else if (series.equals("V7x")) {
            f = new V7xStepFactory();
        } else if (series.equals("V10x")) {
            f = new V10xStepFactory();
        }
        return f;
    }
}

