/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import org.eclipse.swt.widgets.Label;

public class SiTools {
    static double safeParse(String user_string) {
        double r = 0.0;
        try {
            r = Double.parseDouble(user_string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    static String prefix(double value) {
        String p = "";
        double a = value;
        if (a < 0.0) {
            a = 0.0 - value;
        }
        if (a == 0.0) {
            p = "";
        } else if (a < 1.0E-9) {
            p = "p";
        } else if (a < 1.0E-6) {
            p = "n";
        } else if (a < 0.001) {
            p = "u";
        } else if (a < 1.0) {
            p = "m";
        } else if (a >= 1.0E9) {
            p = "G";
        } else if (a >= 1000000.0) {
            p = "M";
        } else if (a >= 1500.0) {
            p = "k";
        }
        return p;
    }

    static String prefix(float value) {
        return SiTools.prefix((double)value);
    }

    static String toString(double value, String units) {
        String p = "";
        String s = "";
        double a = value;
        if (a < 0.0) {
            a = 0.0 - value;
            s = "-";
        }
        if (a == 0.0) {
            p = "";
        } else if (a < 1.0E-9) {
            p = "p";
            a *= 1.0E12;
        } else if (a < 1.0E-6) {
            p = "n";
            a *= 1.0E9;
        } else if (a < 0.001) {
            p = "u";
            a *= 1000000.0;
        } else if (a < 1.0) {
            p = "m";
            a *= 1000.0;
        } else if (a >= 1.0E9) {
            p = "G";
            a /= 1.0E9;
        } else if (a >= 1000000.0) {
            p = "M";
            a /= 1000000.0;
        } else if (a > 1500.0) {
            p = "k";
            a /= 1000.0;
        }
        DecimalFormat df = new DecimalFormat("0.000");
        if (units.isEmpty()) {
            return String.valueOf(s) + df.format(a);
        }
        return String.valueOf(s) + df.format(a) + p + units;
    }

    static String toString(double value) {
        return SiTools.toString(value, "");
    }

    static String toString(String value, String units) {
        double v = SiTools.safeParse(value);
        return SiTools.toString(v, units);
    }

    static double toReal(String si_value, String suffix) {
        String m;
        double v = SiTools.safeParse(si_value);
        if (suffix.isEmpty()) {
            return v;
        }
        switch (m = suffix.substring(0, 1)) {
            case "p": {
                v *= 1.0E-12;
                break;
            }
            case "n": {
                v *= 1.0E-9;
                break;
            }
            case "u": {
                v *= 1.0E-6;
                break;
            }
            case "m": {
                v *= 0.001;
                break;
            }
            case "k": {
                v *= 1000.0;
                break;
            }
            case "M": {
                v *= 1000000.0;
                break;
            }
            case "G": {
                v *= 1.0E9;
            }
        }
        return v;
    }

    static void shiftPrefix(Label p) {
        String x = p.getText().substring(0, 1);
        if (x.equals("m")) {
            p.setText("u" + p.getText().substring(1));
        } else if (x.equals("u")) {
            p.setText("n" + p.getText().substring(1));
        } else if (x.equals("n")) {
            p.setText("p" + p.getText().substring(1));
        } else if (x.equals("p")) {
            p.setText("m" + p.getText().substring(1));
        } else if (x.equals("k")) {
            p.setText("M" + p.getText().substring(1));
        } else if (x.equals("M")) {
            p.setText("G" + p.getText().substring(1));
        } else if (x.equals("G")) {
            p.setText("k" + p.getText().substring(1));
        } else if (x.equals("A")) {
            p.setText("mA");
        } else if (x.equals("V")) {
            p.setText("mV");
        } else if (x.equals("\u2126")) {
            p.setText("k\u2126");
        } else if (x.equals("D")) {
            p.setText("mD");
        } else if (x.equals("F")) {
            p.setText("mF");
        }
    }

    static void shiftPrefix(Label p, boolean ohms_low) {
        String x = p.getText().substring(0, 1);
        if (x.equals("m")) {
            p.setText("u" + p.getText().substring(1));
        } else if (x.equals("u")) {
            p.setText("n" + p.getText().substring(1));
        } else if (x.equals("n")) {
            p.setText("p" + p.getText().substring(1));
        } else if (x.equals("p")) {
            p.setText("k" + p.getText().substring(1));
        } else if (x.equals("k") && !ohms_low) {
            p.setText("M" + p.getText().substring(1));
        } else if (x.equals("k") && ohms_low) {
            p.setText(p.getText().substring(1));
        } else if (x.equals("M")) {
            p.setText("G" + p.getText().substring(1));
        } else if (x.equals("G")) {
            p.setText("k" + p.getText().substring(1));
        } else if (x.equals("A")) {
            p.setText("mA");
        } else if (x.equals("V")) {
            p.setText("mV");
        } else if (x.equals("\u2126") && !ohms_low) {
            p.setText("k\u2126");
        } else if (x.equals("\u2126") && ohms_low) {
            p.setText("m\u2126");
        } else if (x.equals("D")) {
            p.setText("mD");
        } else if (x.equals("F")) {
            p.setText("mF");
        }
    }
}

