/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.printing.PDFPageable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class SequenceResults
implements Cloneable {
    static final int OPTION_RESULT_PASS = 1;
    static final int OPTION_RESULT_FAIL = 2;
    static final int OPTION_RESULT_ANY = 3;
    static final int BY_TIME = 0;
    static final int BY_SEQUENCE = 1;
    static final int BY_TESTER = 2;
    static final int BY_MODEL = 3;
    static final int BY_SN = 4;
    static final int BY_USER = 5;
    static final int SORT_ASCENDING = 256;
    static final int SORT_DESCENDING = 512;
    static final int pdfLeftMargin = 36;
    static final int pdfTopMargin = 756;
    static final int pdfHeadingTextPosition = 252;
    String series;
    String sequence_name;
    String switch_model;
    int num_switches;
    ReportSettings.detail_level_t detail_level;
    boolean include_step_heading_in_csv;
    String tester_model;
    String tester_sn;
    String tester_firmware;
    String user_name;
    String dut_model;
    String dut_sn;
    String test_notes;
    int num_steps;
    long run_time;
    int status;
    byte[] banner;
    int result_id;
    TesterSettings tester_settings;
    TestStep[] steps;
    StepResults[] step_results;
    Tester tester;

    public SequenceResults() {
    }

    public SequenceResults(TestSequence s, String tester_model, String tester_sn, String tester_firmware, String model, String sn, String notes, byte[] banner) {
        this.sequence_name = s.loaded_name;
        this.series = s.series;
        this.switch_model = s.switch_model;
        this.num_switches = s.num_switches;
        this.run_time = System.currentTimeMillis();
        this.tester_settings = s.tester_settings;
        this.detail_level = s.report_settings.detail_level;
        this.include_step_heading_in_csv = s.report_settings.include_step_heading_in_csv;
        this.tester_model = tester_model;
        this.tester_sn = tester_sn;
        this.tester_firmware = tester_firmware;
        this.user_name = UserSettings.user_name;
        this.dut_model = model;
        this.dut_sn = sn;
        this.test_notes = notes;
        this.num_steps = s.num_steps;
        this.banner = banner;
        this.steps = new TestStep[s.num_steps];
        this.step_results = new StepResults[s.num_steps];
        int i = 0;
        while (i < s.num_steps) {
            this.steps[i] = s.getStep(i);
            String[][] l = this.steps[i].labels();
            this.step_results[i] = l != null ? new StepResults(l.length) : new StepResults(0);
            ++i;
        }
        this.tester = null;
    }

    public void save() {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        int id = sql.insertWithId("insert into results (timestamp,series,instrument_settings,user_name,test_name,detail_level,include_step_heading_in_csv,dut_model,dut_sn,notes,tester_model,tester_serial,tester_version,sequence_status) values ('" + this.run_time + "'," + "'" + this.series + "'," + "'" + this.tester_settings.toString() + "'," + "'" + this.user_name + "'," + "'" + this.sequence_name + "'," + "'" + (Object)((Object)this.detail_level) + "'," + "'" + (this.include_step_heading_in_csv ? 1 : 0) + "'," + "'" + this.dut_model.replace("'", "''") + "'," + "'" + this.dut_sn.replace("'", "''") + "'," + "'" + this.test_notes.replace("'", "''") + "'," + "'" + this.tester_model + "'," + "'" + this.tester_sn + "'," + "'" + this.tester_firmware + "'," + "'" + this.status + "'" + ")");
        if (this.banner != null) {
            sql.updateImage("results", "banner", "result_id=" + id, this.banner);
        }
        int i = 0;
        while (i < this.num_steps) {
            String ch1 = this.step_results[i].chartToString(0);
            String ch2 = this.step_results[i].chartToString(1);
            String ch3 = this.step_results[i].chartToString(2);
            sql.execute("insert into result_steps (result_id,step_num,class_id,settings,step_status,steprslt,chart1,chart2,chart3) values ('" + id + "'," + "'" + i + "'," + "'" + this.steps[i].getType() + "'," + "'" + this.steps[i].toString() + "'," + "'" + this.step_results[i].status + "'," + "'" + this.step_results[i].steprslt + "'," + "'" + ch1 + "'," + "'" + ch2 + "'," + "'" + ch3 + "'" + ")");
            ++i;
        }
        sql.close();
    }

    /*
     * Exception decompiling
     */
    public static SequenceResults[] query(long begin, long end, String user_name, String test_name, String dut_model, String dut_sn_start, String dut_sn_end, String tester_model, String tester_sn, int pass_fail, int ordering) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[14] lbl122 : CaseStatement: default:\u000a, @NONE, blocks:[14] lbl122 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
         *     at java.base/java.util.TimSort.sort(TimSort.java:221)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void delete() {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        sql.execute("delete from results where result_id=" + this.result_id);
        sql.execute("delete from result_steps where result_id=" + this.result_id);
        sql.close();
    }

    public static void delete(SequenceResults[] result_set) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        SequenceResults[] sequenceResultsArray = result_set;
        int n = result_set.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceResults r = sequenceResultsArray[n2];
            sql.execute("delete from results where result_id=" + r.result_id);
            sql.execute("delete from result_steps where result_id=" + r.result_id);
            ++n2;
        }
        sql.close();
    }

    public SequenceResults load() {
        SequenceResults f = null;
        try {
            f = this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        StepFactory step_factory = StepFactory.makeStepFactory(this.series);
        f.tester = Tester.makeTester(this.series);
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        sql.open();
        f.banner = ImageTools.fetch("select banner from results where result_id=" + this.result_id);
        ArrayList<String[]> res = sql.queryRows("select class_id,settings,step_status,steprslt,chart1,chart2,chart3 from result_steps where result_id=" + this.result_id + " order by step_num");
        f.steps = new TestStep[res.size()];
        f.step_results = new StepResults[res.size()];
        for (String[] s : res) {
            TestStep ts;
            f.steps[f.num_steps] = ts = TestSequence.loadStep(step_factory, s[0], s[1]);
            String[][] l = ts.labels();
            f.step_results[f.num_steps] = l != null ? new StepResults(l.length) : new StepResults(0);
            f.step_results[f.num_steps].status = Integer.parseInt(s[2]);
            if ((f.step_results[f.num_steps].status & 0x40000000) == 0) {
                f.step_results[f.num_steps].final_metrics = ts.extractFinal(s[3]);
                if (!s[4].isEmpty()) {
                    f.step_results[f.num_steps].setChart(0, s[4]);
                }
                if (!s[5].isEmpty()) {
                    f.step_results[f.num_steps].setChart(1, s[5]);
                }
                if (!s[6].isEmpty()) {
                    f.step_results[f.num_steps].setChart(2, s[6]);
                }
                f.step_results[f.num_steps].steprslt = s[3];
            }
            ++f.num_steps;
        }
        sql.close();
        return f;
    }

    public SequenceResults clone() throws CloneNotSupportedException {
        SequenceResults result = (SequenceResults)super.clone();
        return result;
    }

    private String mergePathFields(String save_path) {
        String tosub;
        String merged_path = save_path;
        if (merged_path.contains("$M")) {
            tosub = !this.dut_model.isEmpty() ? this.dut_model : "";
            merged_path = merged_path.replace("$M", tosub);
        }
        if (merged_path.contains("$S")) {
            tosub = !this.dut_sn.isEmpty() ? this.dut_sn : "";
            merged_path = merged_path.replace("$S", tosub);
        }
        if (merged_path.contains("$D") || merged_path.contains("$T")) {
            Date date = new Date(this.run_time);
            SimpleDateFormat dt_fmt = new SimpleDateFormat("yyyyMMdd,HHmmss");
            String dt = dt_fmt.format(date);
            if (merged_path.contains("$D")) {
                merged_path = merged_path.replace("$D", dt.split(",")[0]);
            }
            merged_path = merged_path.replace("$T", dt.split(",")[1]);
        }
        return merged_path;
    }

    public void saveAsCsv(String save_path) {
        String real_path = this.mergePathFields(save_path);
        String test_date_time_string = FormatTestTime.format(this.run_time, ",");
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(real_path, true), StandardCharsets.UTF_8));
            writer.write(65279);
            writer.write("HDR," + this.status + "," + this.dut_model + "," + this.dut_sn + "," + this.user_name + "," + test_date_time_string + "," + this.tester_model + "," + this.tester_sn + "," + this.tester_firmware + "," + this.test_notes + "\r\n");
            if (this.include_step_heading_in_csv) {
                if (this.tester == null) {
                    this.tester = Tester.makeTester(this.series);
                }
                writer.write(this.tester.csvStepHeading());
                writer.write("\r\n");
            }
            int i = 0;
            while (i < this.num_steps) {
                writer.write(String.valueOf(this.steps[i].getType()) + "," + (this.step_results[i].status & 0xBFFFFFFF) + "," + ((this.step_results[i].status & 0x40000000) != 0 ? "N," : "Y,"));
                if ((this.step_results[i].status & 0x40000000) == 0) {
                    writer.write(String.valueOf(this.steps[i].makeCsv(this.tester_settings, this.step_results[i].steprslt)) + "\r\n");
                } else {
                    writer.write(String.valueOf(this.steps[i].makeCsv(this.tester_settings, null)) + "\r\n");
                }
                ++i;
            }
            writer.write("END\r\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveAsCsv(Composite parent) {
        Date date = new Date(this.run_time);
        SimpleDateFormat fn_fmt = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String fn_date_time = fn_fmt.format(date);
        String default_fn = !this.dut_model.isEmpty() && !this.dut_sn.isEmpty() ? String.valueOf(this.dut_model) + "-" + this.dut_sn + ".csv" : (!this.dut_model.isEmpty() ? String.valueOf(this.dut_model) + ".csv" : (!this.dut_sn.isEmpty() ? String.valueOf(this.dut_sn) + ".csv" : String.valueOf(fn_date_time) + ".csv"));
        FileDialog dialog = new FileDialog(parent.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        dialog.setFileName(default_fn);
        dialog.setOverwrite(true);
        String save_path = dialog.open();
        if (save_path == null) {
            return;
        }
        File csv_file = new File(save_path);
        csv_file.delete();
        this.saveAsCsv(save_path);
    }

    private float makePdfHeading(PDPageContentStream stream, PDImageXObject banner_image, String run_on, int page_num) {
        PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD);
        float heading_text_height = 14.0f;
        float y = 756.0f - heading_text_height;
        try {
            if (banner_image != null) {
                stream.drawImage(banner_image, 36.0f, 704.0f, 182.0f, 52.0f);
            }
            stream.setFont((PDFont)font, 12.0f);
            String title = "Vitrek QT Insite " + this.series + " Test Report";
            float text_width = font.getStringWidth(title) / 1000.0f * 12.0f;
            stream.beginText();
            stream.newLineAtOffset(252.0f, y);
            stream.showText(title);
            stream.endText();
            stream.moveTo(252.0f, y - 2.0f);
            stream.lineTo(252.0f + text_width, y - 2.0f);
            stream.stroke();
            stream.beginText();
            stream.newLineAtOffset(252.0f, y -= heading_text_height + heading_text_height / 8.0f);
            stream.showText("DUT Model: " + (this.dut_model.isEmpty() ? "<blank>" : this.dut_model));
            stream.endText();
            stream.beginText();
            stream.newLineAtOffset(252.0f, y -= heading_text_height);
            stream.showText("DUT Serial Number: " + (this.dut_sn.isEmpty() ? "<blank>" : this.dut_sn));
            stream.endText();
            y -= heading_text_height;
            if (!this.test_notes.isEmpty()) {
                stream.beginText();
                stream.newLineAtOffset(252.0f, y);
                stream.showText("Notes: " + this.test_notes);
                stream.endText();
                y -= heading_text_height;
            }
            stream.beginText();
            stream.newLineAtOffset(252.0f, y);
            stream.showText("Tested By: " + this.user_name + " on " + run_on);
            stream.endText();
            stream.beginText();
            stream.newLineAtOffset(252.0f, y -= heading_text_height);
            stream.showText("Sequence: " + this.sequence_name + "  Instrument: " + this.tester_model + "   SN: " + this.tester_sn);
            stream.endText();
            stream.beginText();
            stream.newLineAtOffset(252.0f, y -= heading_text_height);
            stream.showText(this.status == 0 ? "Passed all tests" : "FAILED");
            stream.endText();
            y -= heading_text_height;
            String page_no = "Page " + page_num;
            text_width = font.getStringWidth(page_no) / 1000.0f * 12.0f;
            stream.beginText();
            stream.newLineAtOffset(576.0f - text_width, 756.0f - heading_text_height);
            stream.showText(page_no);
            stream.endText();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return y - heading_text_height;
    }

    private XYDataset createDataset(String label, float[] data) {
        XYSeries series1 = new XYSeries((Comparable)((Object)label));
        int i = 0;
        while (i < data.length) {
            series1.add((double)i, (double)data[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        return dataset;
    }

    private JFreeChart createChart(int chart_id, String label, XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, (String)label, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.LEFT);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        if (chart_id == 0) {
            renderer.setSeriesPaint(0, (Paint)new Color(255, 0, 0));
        } else if (chart_id == 1) {
            renderer.setSeriesPaint(0, (Paint)new Color(0, 128, 64));
        } else {
            renderer.setSeriesPaint(0, (Paint)new Color(0, 128, 255));
        }
        plot.setRenderer((XYItemRenderer)renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }

    private PDDocument generateReportAsPdf() {
        PDDocument doc = null;
        String test_date_time_string = FormatTestTime.format(this.run_time, ",");
        byte[] report_banner = this.banner;
        if (report_banner == null) {
            report_banner = ImageTools.fetch("select image from default_banner");
        }
        try {
            doc = new PDDocument();
            PDDocumentInformation pdd = doc.getDocumentInformation();
            PDImageXObject pdImage = null;
            if (report_banner != null) {
                pdImage = PDImageXObject.createFromByteArray((PDDocument)doc, (byte[])report_banner, (String)"banner");
            }
            pdd.setAuthor(this.user_name);
            pdd.setTitle("Vitrek QT Insite " + this.series + " Test Report");
            pdd.setCreator("Vitrek");
            pdd.setSubject("Test results generated by " + this.sequence_name);
            float line_y = 0.0f;
            int page_num = 1;
            PDType0Font font1 = PDType0Font.load((PDDocument)doc, (File)new File("fonts/arial.ttf"));
            PDType0Font font2 = PDType0Font.load((PDDocument)doc, (File)new File("fonts/arialbd.ttf"));
            float report_text_height = 14.0f;
            PDPageContentStream stream = null;
            int st = 0;
            while (st < this.num_steps) {
                String[][] labels = this.steps[st].labels();
                String[] rpt = (this.step_results[st].status & 0x40000000) != 0 ? this.steps[st].report(this.tester_settings, ReportSettings.detail_level_t.brief) : this.steps[st].report(this.tester_settings, this.step_results[st].steprslt, this.detail_level);
                float height = (float)rpt.length * report_text_height;
                if ((this.step_results[st].status & 0x40000000) == 0 && labels != null && this.step_results[st].chart_data.length != 0 && this.step_results[st].chart_data[0].length > 0) {
                    if (this.detail_level == ReportSettings.detail_level_t.full_plus_charts_tall) {
                        height += (float)((double)labels.length * 1.5 * 72.0 + 12.0);
                    } else if (this.detail_level == ReportSettings.detail_level_t.full_plus_charts_wide) {
                        height += 100.0f;
                    }
                }
                if (height > line_y) {
                    PDPage page = new PDPage();
                    doc.addPage(page);
                    if (stream != null) {
                        stream.close();
                    }
                    stream = new PDPageContentStream(doc, page);
                    line_y = this.makePdfHeading(stream, pdImage, test_date_time_string, page_num);
                    ++page_num;
                }
                if (this.detail_level == ReportSettings.detail_level_t.brief) {
                    stream.setFont((PDFont)font1, 10.0f);
                } else {
                    stream.setFont((PDFont)font2, 12.0f);
                }
                String sstring = (this.step_results[st].status & 0x40000000) != 0 ? "NOT RUN" : (this.step_results[st].status != 0 ? "FAILED (code " + Integer.toHexString(this.step_results[st].status) + ")" : "PASSED");
                String fline = "Step #" + (st + 1) + (this.steps[st].name.isEmpty() ? " " : " " + this.steps[st].name + " ") + rpt[0] + " " + sstring;
                stream.beginText();
                stream.newLineAtOffset(36.0f, line_y);
                stream.showText(fline);
                stream.endText();
                if (this.detail_level != ReportSettings.detail_level_t.brief) {
                    float text_width = font2.getStringWidth(fline) / 1000.0f * 12.0f;
                    stream.moveTo(36.0f, line_y - 2.0f);
                    stream.lineTo(36.0f + text_width, line_y - 2.0f);
                    stream.stroke();
                    line_y -= report_text_height + report_text_height / 8.0f;
                } else {
                    line_y -= report_text_height;
                }
                stream.setFont((PDFont)font1, 10.0f);
                int rline = 1;
                while (rline < rpt.length) {
                    stream.beginText();
                    stream.newLineAtOffset(54.0f, line_y);
                    stream.showText(rpt[rline]);
                    stream.endText();
                    line_y -= report_text_height;
                    ++rline;
                }
                if ((this.step_results[st].status & 0x40000000) == 0 && labels != null && this.step_results[st].chart_data.length != 0 && this.step_results[st].chart_data[0].length > 0) {
                    if (this.detail_level == ReportSettings.detail_level_t.full_plus_charts_wide) {
                        float x = 36.0f;
                        int m = 0;
                        while (m < labels.length) {
                            XYDataset dataset = this.createDataset(labels[m][0], this.step_results[st].chart_data[m]);
                            JFreeChart chart = this.createChart(m, labels[m][1], dataset);
                            BufferedImage image = chart.createBufferedImage(324, 180);
                            PDImageXObject pd_image = JPEGFactory.createFromImage((PDDocument)doc, (BufferedImage)image, (float)1.0f);
                            stream.drawImage(pd_image, x, (float)((double)line_y - 90.0), 162.0f, 90.0f);
                            x += 180.0f;
                            ++m;
                        }
                        line_y = (float)((double)line_y - 100.0);
                    } else if (this.detail_level == ReportSettings.detail_level_t.full_plus_charts_tall) {
                        int m = 0;
                        while (m < labels.length) {
                            XYDataset dataset = this.createDataset(labels[m][0], this.step_results[st].chart_data[m]);
                            JFreeChart chart = this.createChart(m, labels[m][1], dataset);
                            BufferedImage image = chart.createBufferedImage(1008, 216);
                            PDImageXObject pd_image = JPEGFactory.createFromImage((PDDocument)doc, (BufferedImage)image, (float)1.0f);
                            stream.drawImage(pd_image, 36.0f, (float)((double)line_y - 108.0), 504.0f, 108.0f);
                            line_y = (float)((double)line_y - 108.0);
                            ++m;
                        }
                        line_y -= 12.0f;
                    }
                }
                ++st;
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public void saveAsPdf(String file_name) {
        String real_path = this.mergePathFields(file_name);
        File pdf_file = new File(real_path);
        pdf_file.delete();
        PDDocument doc = this.generateReportAsPdf();
        try {
            doc.save(pdf_file);
            doc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveAsPdf(Composite parent) {
        Date date = new Date(this.run_time);
        SimpleDateFormat fn_fmt = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String fn_date_time = fn_fmt.format(date);
        String default_fn = !this.dut_model.isEmpty() && !this.dut_sn.isEmpty() ? String.valueOf(this.dut_model) + "-" + this.dut_sn + ".pdf" : (!this.dut_model.isEmpty() ? String.valueOf(this.dut_model) + ".pdf" : (!this.dut_sn.isEmpty() ? String.valueOf(this.dut_sn) + ".pdf" : String.valueOf(fn_date_time) + ".pdf"));
        FileDialog dialog = new FileDialog(parent.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.pdf", "*.*"});
        dialog.setFileName(default_fn);
        dialog.setOverwrite(true);
        String save_path = dialog.open();
        if (save_path == null) {
            return;
        }
        this.saveAsPdf(save_path);
    }

    public void printReport(int num_copies) {
        PDDocument doc = this.generateReportAsPdf();
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable((Pageable)new PDFPageable(doc));
            job.setCopies(num_copies);
            job.print();
            try {
                doc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
    }

    public void printReport(Composite parent) {
        PDDocument doc = this.generateReportAsPdf();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(doc));
        job.setCopies(1);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException exc) {
                System.out.println(exc);
            }
        }
        try {
            doc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveQueryCsv(Composite parent, SequenceResults[] results) {
        FileDialog dialog = new FileDialog(parent.getShell(), 8192);
        dialog.setOverwrite(true);
        String save_path = dialog.open();
        if (save_path == null) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(save_path, false);
            SequenceResults[] sequenceResultsArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                SequenceResults sr = sequenceResultsArray[n2];
                String test_date_time_string = FormatTestTime.format(sr.run_time, ",");
                writer.write(String.valueOf(sr.sequence_name) + "," + test_date_time_string + "," + "\"" + sr.tester_model + "\"," + "\"" + sr.tester_sn + "\"," + "\"" + sr.dut_model + "\"," + "\"" + sr.dut_sn + "\"," + "\"" + sr.user_name + "\"," + (sr.status == 0 ? "Pass" : "Failed") + "\r\n");
                ++n2;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exportChartData(int step_index, Composite parent) {
        TestStep step = null;
        step = this.steps[step_index];
        String[][] labels = step.labels();
        FileDialog dialog = new FileDialog(parent.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.csv;*.txt", "*.*"});
        String save_path = dialog.open();
        if (save_path == null) {
            return;
        }
        File csv_file = new File(save_path);
        try {
            FileWriter writer = new FileWriter(csv_file);
            int m = 0;
            while (m < labels.length) {
                writer.write(labels[m][0]);
                if (m < labels.length - 1) {
                    writer.write(",");
                }
                ++m;
            }
            writer.write("\r\n");
            int r = 0;
            while (r < this.step_results[step_index].chart_data[0].length) {
                int m2 = 0;
                while (m2 < labels.length) {
                    writer.write(String.valueOf(this.step_results[step_index].chart_data[m2][r]));
                    if (m2 < labels.length - 1) {
                        writer.write(",");
                    }
                    ++m2;
                }
                writer.write("\r\n");
                ++r;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

