/*
 * Decompiled with CFR 0.152.
 */
import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;

public class Rs232Interface
extends Interface {
    SerialPort com_port;
    InputStream in_stream;

    @Override
    public int open(String[] args) {
        this.com_port = SerialPort.getCommPort((String)args[0]);
        if (this.com_port == null) {
            return -1;
        }
        boolean s = this.com_port.openPort();
        if (!s) {
            return -1;
        }
        this.com_port.setComPortParameters(Integer.valueOf(args[1]).intValue(), 8, 1, 0);
        this.com_port.setComPortTimeouts(1, 100, 0);
        this.com_port.setFlowControl(4369);
        this.in_stream = this.com_port.getInputStreamWithSuppressedTimeoutExceptions();
        return 0;
    }

    @Override
    public void close() {
        if (this.in_stream != null) {
            try {
                this.in_stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.com_port.closePort();
    }

    @Override
    public int read(byte[] buffer, int max_to_read) {
        try {
            int num = this.in_stream.read(buffer, 0, max_to_read);
            return num;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public int write(byte[] buffer, int num_to_write) {
        int r = this.com_port.writeBytes(buffer, num_to_write);
        if (r == -1) {
            return -1;
        }
        return 0;
    }

    @Override
    public String strerror() {
        return "Some error";
    }
}

