/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import org.eclipse.swt.widgets.Composite;

public class ReportSettings {
    detail_level_t detail_level = detail_level_t.normal;
    boolean fail_auto_print = false;
    boolean pass_auto_print = false;
    boolean use_default_printer = true;
    int num_print_copies = 1;
    boolean fail_auto_save_csv = false;
    boolean pass_auto_save_csv = false;
    boolean fail_auto_save_pdf = false;
    boolean pass_auto_save_pdf = false;
    boolean include_step_heading_in_csv = true;
    String CSV_path = "";
    String PDF_path = "";
    boolean include_model_in_csv_file_name = false;
    boolean include_sn_in_csv_name = false;
    transient byte[] banner = null;

    public Composite editor(Composite parent) {
        return ReportSettings_Edit.editor(parent, this);
    }

    public void fetch() {
        ReportSettings_Edit.fetch(this);
    }

    public String toString() {
        String serialized = new Gson().toJson((Object)this);
        return serialized;
    }

    public String[] report() {
        String[] rpt = new String[5];
        switch (this.detail_level) {
            case brief: {
                rpt[0] = "Detail Level: Brief";
                break;
            }
            case normal: {
                rpt[0] = "Detail Level: Normal";
                break;
            }
            case full: {
                rpt[0] = "Detail Level: Full";
                break;
            }
            case full_plus_charts_wide: {
                rpt[0] = "Detail Level: Full+Charts (wide)";
                break;
            }
            case full_plus_charts_tall: {
                rpt[0] = "Detail Level: Full+Charts (tall)";
                break;
            }
            default: {
                rpt[0] = "Detail Level: Normal";
            }
        }
        rpt[1] = this.fail_auto_print && this.pass_auto_print ? "Automatic print always" : (this.fail_auto_print ? "Automatic print when failed" : (this.pass_auto_print ? "Automatic print when passed" : "Automatic printing is disabled"));
        rpt[2] = this.fail_auto_save_csv && this.pass_auto_save_csv ? "Automatic save CSV always to " + this.CSV_path : (this.fail_auto_save_csv ? "Automatic save CSV when failed to " + this.CSV_path : (this.pass_auto_save_csv ? "Automatic save CSV when passed to " + this.CSV_path : "Automatic CSV saving is disabled"));
        rpt[3] = this.fail_auto_save_pdf && this.pass_auto_save_pdf ? "Automatic save PDF always to " + this.PDF_path : (this.fail_auto_save_pdf ? "Automatic save PDF when failed to " + this.PDF_path : (this.pass_auto_save_pdf ? "Automatic save PDF when passed to " + this.PDF_path : "Automatic PDF saving is disabled"));
        rpt[4] = this.include_step_heading_in_csv ? "The step heading is included in the CSV file" : "No step heading in the CSV file";
        return rpt;
    }

    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.fail_auto_save_csv = settings[3].equals("Y");
        this.pass_auto_save_csv = settings[4].equals("Y");
        this.fail_auto_print = settings[6].equals("Y");
        this.pass_auto_print = settings[7].equals("Y");
        this.CSV_path = settings[5].replaceAll("\\\\", "/");
        switch (Integer.valueOf(settings[9])) {
            default: {
                this.detail_level = detail_level_t.brief;
                break;
            }
            case 1: {
                this.detail_level = detail_level_t.normal;
                break;
            }
            case 2: {
                this.detail_level = detail_level_t.full;
                break;
            }
            case 3: {
                this.detail_level = detail_level_t.full_plus_charts_wide;
            }
        }
    }

    public static enum detail_level_t {
        brief,
        normal,
        full,
        full_plus_charts_wide,
        full_plus_charts_tall;

    }
}

