/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Registration {
    static final int REGISTRATION_GREEN = 0;
    static final int REGISTRATION_YELLOW = 1;
    static final int REGISTRATION_ORANGE = 2;
    static final int REGISTRATION_RED = 3;
    static final long REGISTRATION_YELLOW_LIMIT = 1209600L;
    static final long REGISTRATION_TRIAL_LIMIT = 3888000L;
    static final long REGISTRATION_NO_LIMIT = 4102387200L;
    static String SecretKey = "formulateVitrek!";
    private static long trialExpiration;
    private static int registrationStatus;
    private static ArrayList<InstrumentKey> keyList;
    private static SecretKeySpec secretKey;

    private static void setKey(String myKey) {
        MessageDigest sha = null;
        try {
            byte[] key = myKey.getBytes("UTF-8");
            sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, "AES");
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static String encrypt(String strToEncrypt, String secret) {
        try {
            Registration.setKey(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes("UTF-8")));
        }
        catch (Exception e) {
            System.out.println("Error while encrypting: " + e.toString());
            return null;
        }
    }

    private static String decrypt(String strToDecrypt, String secret) {
        try {
            Registration.setKey(secret);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, secretKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(strToDecrypt)));
        }
        catch (Exception e) {
            System.out.println("Error while decrypting: " + e.toString());
            return null;
        }
    }

    public static InstrumentKey decode(String key) {
        String[] f;
        InstrumentKey info = null;
        long now = System.currentTimeMillis() / 1000L;
        String dec = Registration.decrypt(key, SecretKey);
        if (dec != null && (f = dec.split(","))[0].equals("QT Insite")) {
            info = new InstrumentKey();
            info.model = f[1];
            info.serial_number = f[2];
            info.expiration_time = Long.parseLong(f[3], 10);
            info.status = info.expiration_time > now ? 0 : 3;
        }
        return info;
    }

    public static void init() {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        long now = System.currentTimeMillis() / 1000L;
        registrationStatus = 1;
        if (sql.open() != 0) {
            return;
        }
        String[] row = sql.queryRow("select ikey from tester_keys where id = 1");
        if (row.length > 0) {
            String expiration = Registration.decrypt(row[0], SecretKey);
            if (expiration.equals("0123a7654")) {
                trialExpiration = now + 3888000L;
                String enc = Registration.encrypt(String.valueOf(trialExpiration), SecretKey);
                sql.execute("update tester_keys set ikey='" + enc + "' where id=1");
            } else {
                trialExpiration = Long.parseLong(expiration, 10);
            }
        }
        if (trialExpiration > now) {
            if (trialExpiration - now < 1209600L) {
                registrationStatus = 2;
            } else if (trialExpiration - now < 3888000L) {
                registrationStatus = 1;
            }
        } else {
            registrationStatus = 3;
        }
        if (registrationStatus >= 2) {
            String[] keys;
            String[] stringArray = keys = sql.queryColumn("select ikey from tester_keys where id > 1");
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                InstrumentKey key = Registration.decode(k);
                if (key.expiration_time > now) {
                    registrationStatus = 0;
                    break;
                }
                ++n2;
            }
        }
        sql.close();
    }

    public static int status() {
        return registrationStatus;
    }

    public static void load() {
        String[] keys;
        keyList = new ArrayList();
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String[] stringArray = keys = sql.queryColumn("select ikey from tester_keys where id > 1");
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            InstrumentKey key = Registration.decode(k);
            if (key != null) {
                keyList.add(key);
            }
            ++n2;
        }
    }

    public static ArrayList<InstrumentKey> fetch() {
        return keyList;
    }

    public static boolean validate(String model, String serial_number) {
        boolean v = false;
        long now = System.currentTimeMillis() / 1000L;
        if (trialExpiration > now) {
            v = true;
        } else {
            for (InstrumentKey k : keyList) {
                if (!k.model.equals(model) && !k.model.equals("*") || !k.serial_number.equals(serial_number) && !k.serial_number.equals("*") || k.expiration_time <= now) continue;
                v = true;
                break;
            }
        }
        return v;
    }

    public static void add(String key, String mod, String sn) {
        AnySql sql = new AnySql(UserSettings.sql_hostname);
        String[] keys = sql.queryColumn("select ikey from tester_keys where id > 1");
        int row = 2;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            InstrumentKey ki = Registration.decode(k);
            if (ki.model.equals(mod) && ki.serial_number.equals(sn)) {
                sql.execute("update tester_keys set ikey='" + key + "' where id='" + row + "'");
                return;
            }
            ++row;
            ++n2;
        }
        sql.execute("insert into tester_keys (ikey) values ('" + key + "')");
    }

    static class InstrumentKey {
        String model = "";
        String serial_number = "";
        long expiration_time = 0L;
        int status;
    }
}

