/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import org.eclipse.swt.widgets.Composite;

public class PauseStep
extends TestStep {
    String id = "Pause";
    double pause_time = 5.0;
    String text = "";
    transient byte[] image = null;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return PauseStep_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        PauseStep_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        return tester.addPauseStep(this.pause_time, this.text);
    }

    @Override
    public String stepSummary() {
        return "Pause: " + this.pause_time + "s";
    }

    @Override
    public String[][] labels() {
        return null;
    }

    @Override
    public float[] extractFinal(String steprslt) {
        return null;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus(this);
        io_handle.sendCommand("step?");
        String step = io_handle.getResponse(100);
        if (step == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            int reported_step = Integer.parseInt(step);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (Integer.parseInt(step) == this.step_num + 1) {
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double p = 100.0 * (double)i / (this.pause_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public TestStep.StepInfo information() {
        TestStep.StepInfo i = new TestStep.StepInfo(this);
        i.paragraph = this.text;
        i.image = this.image;
        return i;
    }

    @Override
    public void importImage(byte[] idata) {
        this.image = idata;
    }

    @Override
    public TestStep.StepExport export() {
        TestStep.StepExport r = new TestStep.StepExport(this);
        r.in_json = new Gson().toJson((Object)this);
        r.image = this.image;
        return r;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        return "";
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        return new String[]{"Pause: " + this.pause_time + "s"};
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        switch (level) {
            default: {
                rpt = new String[]{"Pause: " + this.pause_time + "s"};
                break;
            }
            case full: {
                if (!this.text.isEmpty()) {
                    String[] m = this.text.split("\r\n");
                    rpt = new String[1 + m.length];
                    rpt[0] = "Pause: " + this.pause_time + "s";
                    int i = 0;
                    while (i < m.length) {
                        rpt[i + 1] = m[i];
                        ++i;
                    }
                    break;
                }
                rpt = new String[]{"Pause: " + this.pause_time + "s"};
            }
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",");
        this.pause_time = Double.parseDouble(settings[1]);
    }
}

