/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class Nine8xDCIR
extends TestStep {
    static final int DCIR_TERM_PASS = 0;
    static final int DCIR_TERM_FAIL = 1;
    static final int DCIR_TERM_TIME = 2;
    static final int DCIR_TERM_STDY = 3;
    String id = "DCIR";
    double test_voltage = 1000.0;
    double charge_setting = 1.5;
    int charge_units = 1;
    double dwell_time = 60.0;
    double pre_check_delay = 0.0;
    int end_on = 1;
    TestStep.hipot_check_t leakage_check = TestStep.hipot_check_t.check_DC_Z;
    boolean no_maximum_limit = false;
    double minimum_leakage_limit = 1.0E8;
    double maximum_leakage_limit = 1.0E10;
    boolean use_min_load;
    double zero_offset = 0.0;
    double lead_compensation;
    int grounding = 2;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return Nine8xDCIR_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        Nine8xDCIR_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String end_on_keyword;
        switch (this.end_on) {
            default: {
                end_on_keyword = "Pass,";
                break;
            }
            case 1: {
                end_on_keyword = "Fail,";
                break;
            }
            case 2: {
                end_on_keyword = "Time,";
                break;
            }
            case 3: {
                end_on_keyword = "Steady,";
            }
        }
        double charge_time = this.charge_units == 1 ? this.charge_setting : this.test_voltage / this.charge_setting;
        String min = Double.toString(this.minimum_leakage_limit);
        String max = this.leakage_check == TestStep.hipot_check_t.check_DC_A ? Double.toString(this.maximum_leakage_limit) : (this.no_maximum_limit ? "" : Double.toString(this.maximum_leakage_limit));
        String command = "add,IR," + this.test_voltage + "," + charge_time + "," + this.dwell_time + "," + this.pre_check_delay + "," + end_on_keyword + this.checkKeyword(this.leakage_check) + "," + min + "," + max + "," + this.abortKeyword() + "," + this.zero_offset + "," + (this.grounding == 2 ? "iso" : "gnd");
        return command;
    }

    @Override
    public String stepSummary() {
        return "DCIR:" + this.test_voltage + "V";
    }

    @Override
    public String[][] labels() {
        String lu;
        String ll;
        if (this.leakage_check == TestStep.hipot_check_t.check_DC_A) {
            ll = "Amps";
            lu = "A";
        } else {
            ll = "Ohms";
            lu = "\u2126";
        }
        return new String[][]{{"Drive", "Volts", "V"}, {"Leakage", ll, lu}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",", -1);
        rslts[0] = Utils.parseFloat(f[3]);
        rslts[1] = Utils.parseFloat(f[9]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        String lv = this.leakage_check == TestStep.hipot_check_t.check_DC_A ? "amps" : "ohms";
        io_handle.sendCommand("phase?;measrslt?,volts;measrslt?," + lv + ";step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(",", -1);
            int reported_step = Integer.parseInt(f[3]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                int phase;
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double total_step_time = this.charge_units == 1 ? this.dwell_time + this.charge_setting : this.dwell_time + this.test_voltage / this.charge_setting;
                double p = 100.0 * (double)i / (total_step_time * 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                if ((phase = Integer.parseInt(f[0])) >= 1 && phase <= 3) {
                    r.metrics = new float[2];
                    r.metrics[0] = Utils.parseFloat(f[1]);
                    r.metrics[1] = Utils.parseFloat(f[2]);
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return false;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        String min = Double.toString(this.minimum_leakage_limit);
        String max = this.leakage_check == TestStep.hipot_check_t.check_DC_A ? Double.toString(this.maximum_leakage_limit) : (this.no_maximum_limit ? "" : Double.toString(this.maximum_leakage_limit));
        if (steprslt != null) {
            String[] rslts = steprslt.split(",", -1);
            String arc = ",,,,,";
            csv = String.valueOf(this.dwell_time) + "," + this.test_voltage + "," + rslts[3] + "," + "," + "," + rslts[5] + "," + this.checkKeyword(this.leakage_check) + "," + max + "," + min + "," + rslts[7] + "," + rslts[8] + "," + rslts[9] + "," + rslts[10] + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        } else {
            String arc = ",,,,,";
            csv = String.valueOf(this.dwell_time) + "," + this.test_voltage + "," + "," + "," + "," + "," + this.checkKeyword(this.leakage_check) + "," + max + "," + min + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",", -1);
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: {
                num_lines = 2;
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 3;
            }
        }
        rpt = new String[num_lines];
        String delay = this.pre_check_delay > 0.0 ? "  Delay " + this.pre_check_delay + "s" : "";
        rpt[0] = "DCIR @ " + this.test_voltage + "V for " + this.dwell_time + "s" + delay;
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                String lu = "\u2126";
                String min = SiTools.toString(this.minimum_leakage_limit, lu);
                String max = this.no_maximum_limit ? "\u221e" : SiTools.toString(this.maximum_leakage_limit, lu);
                rpt[1] = "Leakage: " + SiTools.toString(rslts[8], lu) + " to " + SiTools.toString(rslts[7], lu) + " (" + min + " to " + max + " limits)";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                rpt[1] = "Ramp: " + this.charge_setting + (this.charge_units == 1 ? "s" : "V/s");
                String lu = "\u2126";
                String min = SiTools.toString(this.minimum_leakage_limit, lu);
                String max = this.no_maximum_limit ? "\u221e" : SiTools.toString(this.maximum_leakage_limit, lu);
                rpt[2] = "Leakage: " + SiTools.toString(rslts[8], lu) + " to " + SiTools.toString(rslts[7], lu) + ", Avg:" + SiTools.toString(rslts[9], lu) + ", Final:" + SiTools.toString(rslts[10], lu) + " (" + min + " to " + max + " limits)";
            }
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 3;
            }
        }
        rpt = new String[num_lines];
        String delay = this.pre_check_delay > 0.0 ? "  Delay " + this.pre_check_delay + "s" : "";
        rpt[0] = "DCIR @ " + this.test_voltage + "V for " + this.dwell_time + "s" + delay;
        if (level != ReportSettings.detail_level_t.brief) {
            rpt[1] = "Ramp: " + this.charge_setting + (this.charge_units == 1 ? "s" : "V/s");
            String lu = "\u2126";
            String min = SiTools.toString(this.minimum_leakage_limit, lu);
            String max = this.no_maximum_limit ? "\u221e" : SiTools.toString(this.maximum_leakage_limit, lu);
            rpt[2] = "Leakage: " + min + " to " + max;
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",", -1);
        this.test_voltage = Double.parseDouble(settings[1]);
        this.charge_units = settings[2].equals("Y") ? 1 : 2;
        this.charge_setting = Double.parseDouble(settings[3]);
        this.dwell_time = Double.parseDouble(settings[4]);
        this.pre_check_delay = Double.parseDouble(settings[5]);
        switch (settings[6]) {
            case "PASS": {
                this.end_on = 0;
                break;
            }
            case "FAIL": {
                this.end_on = 1;
                break;
            }
            case "TIME": {
                this.end_on = 2;
                break;
            }
            case "STDY": {
                this.end_on = 3;
            }
        }
        this.minimum_leakage_limit = Double.parseDouble(settings[9]) * Math.pow(10.0, Double.parseDouble(settings[11]));
        this.maximum_leakage_limit = Double.parseDouble(settings[10]) * Math.pow(10.0, Double.parseDouble(settings[11]));
        this.no_maximum_limit = settings[12].equals("Y");
        this.continue_on_failure = settings[16].equals("Y");
        int n = this.grounding = settings[19].equals("Y") ? 1 : 2;
        if (settings.length > 20) {
            this.name = settings[20];
        }
    }
}

