/*
 * Decompiled with CFR 0.152.
 */
public class Nine5xTester
extends Tester {
    @Override
    void configureRemoteStart(Interface io_handle, boolean flag) {
        io_handle.sendCommand("remstart," + (flag ? "Y" : "N"));
    }

    @Override
    int pollRemoteStart(Interface io_handle) {
        int pressed = 0;
        io_handle.sendCommand("locstart?");
        String response = io_handle.getResponse(100);
        if (response != null) {
            pressed = Integer.parseInt(response);
        }
        return pressed;
    }

    @Override
    String configureSwitches(SystemConfiguration config) {
        String sw_command = "switches,none";
        if (config.use_switches && config.switch_control != switch_control_t.switch_control_computer) {
            sw_command = config.switches[0].model.equals("948i") ? "switches,948" : (config.switch_control == switch_control_t.switch_control_tester_RS232 ? "switches,964SER" : "switches,964VICL" + config.num_switches);
        }
        return sw_command;
    }

    @Override
    String clearSequence() {
        return "noseq";
    }

    @Override
    String runSequence() {
        return "run";
    }

    @Override
    String continueSequence() {
        return "cont";
    }

    @Override
    String saveSequence(String name, String slot) {
        if (name.isEmpty()) {
            return "save," + slot;
        }
        return "name," + name + "\n" + "save," + slot;
    }

    @Override
    String strerror(int err) {
        String s = "";
        switch (err) {
            case 1: {
                s = "Could not be decoded at this time";
                break;
            }
            case 2: {
                s = "Invalid test step number";
                break;
            }
            case 3: {
                s = "Invalid test sequence number";
                break;
            }
            case 4: {
                s = "Not compatible";
                break;
            }
            case 5: {
                s = "Parameter out of range";
                break;
            }
            case 6: {
                s = "Invalid syntax";
                break;
            }
            case 7: {
                s = "Missing field";
                break;
            }
            case 8: {
                s = "Too many fields";
                break;
            }
            case 9: {
                s = "Unecognized command";
                break;
            }
            case 10: {
                s = "Internal memory error";
                break;
            }
            case 11: {
                s = "Response busy";
                break;
            }
            case 12: {
                s = "Command too long";
                break;
            }
            default: {
                s = "Error code " + err;
            }
        }
        return s;
    }

    @Override
    String[] decodeStatusFlags(int status_flags) {
        if (status_flags == 0) {
            return null;
        }
        if ((status_flags & 0x40000000) != 0) {
            return new String[]{"Query error"};
        }
        if ((status_flags & 0x3FFFFF) == 0) {
            return new String[]{"Error fault"};
        }
        int num_flags = 0;
        int f = 0;
        while (f <= 21) {
            if ((status_flags & 1 << f) != 0) {
                ++num_flags;
            }
            ++f;
        }
        String[] hr = new String[]{"95x Internal Fault", "Unstable load", "Breakdown detected", "HOLD Step timeout exceeded", "User abort", "Continuity Sense failure detected", "Wiring fault detected", "Arc detected", "1st check <minimum setting", "1st check >maximum setting", "2nd check <minimum setting", "2nd check >maximum setting", "INTERLOCK failure", "HV TRIP activated", "Switch Matrix error", "Drive limited", "95x Overheated", "Step type incompatible", "Minimum Loading was not detected", "Current limited", "DCIR Unsteady", "User forced abort"};
        String[] fs = new String[num_flags];
        int si = 0;
        int di = 0;
        int f2 = 0;
        while (f2 <= 21) {
            if ((status_flags & 1 << f2) != 0) {
                fs[di++] = hr[si];
            }
            ++si;
            ++f2;
        }
        return fs;
    }

    @Override
    String addHoldStep(double hold_time, String message, boolean disable_local) {
        return "add,hold," + hold_time + "," + (disable_local ? "Y" : "N");
    }

    @Override
    String addPauseStep(double pause_time, String message) {
        return "add,pause," + pause_time;
    }

    @Override
    String csvStepHeading() {
        return "Step Type,Status Flag,Attempted?,Dwell Time (s),Test Drive Level (V/A),Actual Drive Level (V/A),Test Frequency (Hz),Breakdown limit (A),Highest breakdown current,Primary (1st) Check Type,1st Max Limit (V/A/\u2126),1st Min Limit (V/A/\u2126),Highest 1st check (V/A/\u2126),Lowest 1st check (V/A/\u2126),Average 1st check (V/A/\u2126),Last 1st check (V/A/\u2126),Second Check Type,2nd Max Limit (V/A/\u2126),2nd Min Limit (V/A/\u2126),Highest 2nd check (V/A/\u2126),Lowest 2nd check (V/A/\u2126),Average 2nd check (V/A/\u2126),Last 2nd check (V/A/\u2126),ARC limit,ARC Time,Max ARC,Min ARC,Average ARC,Last ARC";
    }
}

