/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;

public class Nine5xStepFactory
extends StepFactory {
    @Override
    public String getSeriesName() {
        return "95x";
    }

    @Override
    public String[] getStepTypes() {
        return new String[]{"ACW", "ACCAP", "DCW", "DCIR", "GB", "LowOhms", "ACI", "DCI", "Pulse", "BRKDN"};
    }

    @Override
    public TestStep newStep(String name) {
        TestStep s = null;
        switch (name) {
            case "ACW": {
                s = new Nine5xACW();
                break;
            }
            case "ACCAP": {
                s = new Nine5xACCAP();
                break;
            }
            case "DCW": {
                s = new Nine5xDCW();
                break;
            }
            case "DCIR": {
                s = new Nine5xDCIR();
                break;
            }
            case "GB": {
                s = new Nine5xGB();
                break;
            }
            case "LowOhms": {
                s = new Nine5xLowOhms();
                break;
            }
            case "ACI": {
                s = new Nine5xACI();
                break;
            }
            case "DCI": {
                s = new Nine5xDCI();
                break;
            }
            case "Pulse": {
                s = new Nine5xPulse();
                break;
            }
            case "BRKDN": {
                s = new Nine5xBRKDN();
            }
        }
        return s;
    }

    @Override
    public TestStep loadStep(String id, String json, byte[] im) {
        TestStep s = null;
        switch (id) {
            case "ACW": {
                s = (TestStep)new Gson().fromJson(json, Nine5xACW.class);
                break;
            }
            case "ACCAP": {
                s = (TestStep)new Gson().fromJson(json, Nine5xACCAP.class);
                break;
            }
            case "DCW": {
                s = (TestStep)new Gson().fromJson(json, Nine5xDCW.class);
                break;
            }
            case "DCIR": {
                s = (TestStep)new Gson().fromJson(json, Nine5xDCIR.class);
                break;
            }
            case "GB": {
                s = (TestStep)new Gson().fromJson(json, Nine5xGB.class);
                break;
            }
            case "LowOhms": {
                s = (TestStep)new Gson().fromJson(json, Nine5xLowOhms.class);
                break;
            }
            case "ACI": {
                s = (TestStep)new Gson().fromJson(json, Nine5xACI.class);
                break;
            }
            case "DCI": {
                s = (TestStep)new Gson().fromJson(json, Nine5xDCI.class);
                break;
            }
            case "Pulse": {
                s = (TestStep)new Gson().fromJson(json, Nine5xPulse.class);
                break;
            }
            case "BRKDN": {
                s = (TestStep)new Gson().fromJson(json, Nine5xBRKDN.class);
            }
        }
        return s;
    }

    @Override
    public TestStep loadStep(String csv) {
        TestStep s = null;
        String[] f = csv.split(",");
        switch (f[0]) {
            case "ACW": {
                s = new Nine5xACW();
                s.importQt(csv);
                break;
            }
            case "BRKDN": {
                s = new Nine5xBRKDN();
                s.importQt(csv);
                break;
            }
            case "DCIR": {
                s = new Nine5xDCIR();
                s.importQt(csv);
                break;
            }
            case "DCW": {
                s = new Nine5xDCW();
                s.importQt(csv);
                break;
            }
            case "GB": {
                s = new Nine5xGB();
                s.importQt(csv);
                break;
            }
            case "GNDLEAKAGE": {
                s = f[1].equals("Y") ? new Nine5xACI() : new Nine5xDCI();
                s.importQt(csv);
                break;
            }
            case "LOWOHMS": {
                s = new Nine5xLowOhms();
                s.importQt(csv);
                break;
            }
            case "PULSE": {
                s = new Nine5xPulse();
                s.importQt(csv);
            }
        }
        return s;
    }
}

