/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class Nine5xDCIR_Edit {
    static Text textLevel;
    static Text txtUserName;
    static Text textRampTime;
    static Text textRampVoltsSec;
    static Text textDwellTime;
    static Text textTestDelay;
    static Text textBreakdown;
    static Button btnUser;
    static Text textMinimumLeakage;
    static Text textMaximumLeakage;
    static Label lblS_1;
    static Button buttonRampTime;
    static Button buttonRampVoltsSec;
    static Label lblRampSeconds;
    static Label lblRampVsec;
    private static Label lblEndon;
    private static Combo comboEndOn;
    static Combo comboDischarge;
    static Label lblBreakdownMa;
    static Label lblMinimumLeakagePrefix;
    static Label lblMaximumLeakagePrefix;
    static Label lblTo;
    static Button btnLeakageInAmps;
    static Button btnLeakageInOhms;
    static Button btnLeakageNoMax;
    static Button btnArcDetect;
    static Text textArcLimit;
    static Combo comboArcTimePeriod;
    static Label lblArcLimitMa;
    static Button btnMinLoadingEnable;
    static Label lblLoadingUf;
    static Text textLoading;
    static Button btnDutGrounded;
    static Button btnContinueOnFailure;

    private static void leakageTranslate(String u) {
        double lvl = Double.parseDouble(textLevel.getText());
        String min = textMinimumLeakage.getText();
        String max = textMaximumLeakage.getText();
        String min_prefix = lblMinimumLeakagePrefix.getText();
        String max_prefix = lblMaximumLeakagePrefix.getText();
        if (u.equals("A")) {
            double v = btnLeakageNoMax.getSelection() ? 0.0 : lvl / SiTools.toReal(max, max_prefix);
            String nt = SiTools.toString(v);
            textMinimumLeakage.setText(nt);
            String p = SiTools.prefix(v);
            lblMinimumLeakagePrefix.setText(String.valueOf(p) + u);
            v = SiTools.toReal(min, min_prefix);
            v = lvl / v;
            nt = SiTools.toString(v);
            textMaximumLeakage.setText(nt);
            p = SiTools.prefix(v);
            lblMaximumLeakagePrefix.setText(String.valueOf(p) + u);
            textMaximumLeakage.setEnabled(true);
            lblMaximumLeakagePrefix.setEnabled(true);
        } else {
            String p;
            String nt;
            double v = SiTools.toReal(min, min_prefix);
            if (v < 1.0E-12) {
                btnLeakageNoMax.setSelection(true);
                textMaximumLeakage.setText("1.0");
                lblMaximumLeakagePrefix.setText("G" + u);
                textMaximumLeakage.setEnabled(false);
                lblMaximumLeakagePrefix.setEnabled(false);
            } else {
                btnLeakageNoMax.setSelection(false);
                v = lvl / v;
                nt = SiTools.toString(v);
                textMaximumLeakage.setText(nt);
                p = SiTools.prefix(v);
                lblMaximumLeakagePrefix.setText(String.valueOf(p) + u);
            }
            v = SiTools.toReal(max, max_prefix);
            if (v < 1.0E-9) {
                v = 1.0E-9;
            }
            v = lvl / v;
            nt = SiTools.toString(v);
            textMinimumLeakage.setText(nt);
            p = SiTools.prefix(v);
            lblMinimumLeakagePrefix.setText(String.valueOf(p) + u);
        }
    }

    public static Composite editor(Composite parent, TesterSettings tester, final Nine5xDCIR settings) {
        Nine5xTesterSettings my_settings = (Nine5xTesterSettings)tester;
        final DecimalFormat df3 = new DecimalFormat("0.000");
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpLevel = new Group(edit_space, 0);
        grpLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLevel.setText("Level");
        grpLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLevel.setBounds(10, 0, 253, 60);
        textLevel = new Text((Composite)grpLevel, 133120);
        textLevel.setToolTipText("Specifies the voltage level for the test.");
        textLevel.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textLevel.setBounds(60, 15, 105, 35);
        textLevel.setText(Double.toString(settings.test_voltage));
        Label lblVolts = new Label((Composite)grpLevel, 0);
        lblVolts.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblVolts.setBounds(166, 15, 52, 35);
        lblVolts.setText("Volts");
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(270, 0, 270, 60);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(32, 25, 208, 21);
        Group groupTiming = new Group(edit_space, 0);
        groupTiming.setToolTipText("");
        groupTiming.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        groupTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupTiming.setText("Timing");
        groupTiming.setBounds(10, 66, 253, 197);
        Label lblRamp = new Label((Composite)groupTiming, 0);
        lblRamp.setBounds(10, 33, 38, 15);
        lblRamp.setText("Ramp");
        buttonRampTime = new Button((Composite)groupTiming, 16);
        buttonRampTime.setToolTipText("Chooses the ramp to be in terms of time.");
        buttonRampTime.setBounds(46, 22, 21, 16);
        buttonRampTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 1;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampVoltsSec.getText());
                    if (t2 < 0.1) {
                        t2 = 0.1;
                    }
                    textRampTime.setText(df3.format(t1 / t2));
                    textRampVoltsSec.setEnabled(false);
                    textRampTime.setEnabled(true);
                    lblRampVsec.setEnabled(false);
                    lblRampSeconds.setEnabled(true);
                    textRampTime.setFocus();
                }
            }
        });
        buttonRampVoltsSec = new Button((Composite)groupTiming, 16);
        buttonRampVoltsSec.setToolTipText("Chooses the ramp to be in terms of volts/second.");
        buttonRampVoltsSec.setBounds(46, 51, 21, 16);
        buttonRampVoltsSec.setText("");
        buttonRampVoltsSec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 2;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampTime.getText());
                    if (t2 < 0.001) {
                        t2 = 0.001;
                    }
                    textRampVoltsSec.setText(df3.format(t1 / t2));
                    textRampTime.setEnabled(false);
                    textRampVoltsSec.setEnabled(true);
                    lblRampSeconds.setEnabled(false);
                    lblRampVsec.setEnabled(true);
                    textRampVoltsSec.setFocus();
                }
            }
        });
        textRampTime = new Text((Composite)groupTiming, 133120);
        textRampTime.setToolTipText("Specifies the voltage ramp in terms of time.");
        textRampTime.setBounds(72, 22, 65, 21);
        textRampVoltsSec = new Text((Composite)groupTiming, 133120);
        textRampVoltsSec.setToolTipText("Specifies the voltage ramp in terms of volts/second.");
        textRampVoltsSec.setBounds(72, 49, 65, 21);
        lblRampSeconds = new Label((Composite)groupTiming, 0);
        lblRampSeconds.setBounds(143, 22, 55, 15);
        lblRampSeconds.setText("seconds");
        lblRampVsec = new Label((Composite)groupTiming, 0);
        lblRampVsec.setEnabled(false);
        lblRampVsec.setText("V/sec");
        lblRampVsec.setBounds(143, 51, 55, 15);
        if (settings.ramp_units == 1) {
            textRampTime.setText(Double.toString(settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setEnabled(false);
            textRampTime.setEnabled(true);
            lblRampVsec.setEnabled(false);
            lblRampSeconds.setEnabled(true);
            buttonRampTime.setSelection(true);
        } else {
            textRampTime.setText(Double.toString(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.ramp_setting));
            textRampTime.setEnabled(false);
            textRampVoltsSec.setEnabled(true);
            lblRampSeconds.setEnabled(false);
            lblRampVsec.setEnabled(true);
            buttonRampVoltsSec.setSelection(true);
        }
        Label lblDwell = new Label((Composite)groupTiming, 0);
        lblDwell.setBounds(10, 91, 55, 15);
        lblDwell.setText("Dwell");
        Label lblTestDelay = new Label((Composite)groupTiming, 0);
        lblTestDelay.setBounds(10, 112, 55, 15);
        lblTestDelay.setText("Test Delay");
        textDwellTime = new Text((Composite)groupTiming, 133120);
        textDwellTime.setToolTipText("Specifies the dwell time for the test.");
        textDwellTime.setBounds(72, 88, 65, 21);
        textDwellTime.setText(Double.toString(settings.dwell_time));
        btnUser = new Button((Composite)groupTiming, 32);
        btnUser.setBounds(204, 92, 39, 16);
        btnUser.setToolTipText("Allows the test to dwell until ended by the user.");
        btnUser.setText("User");
        btnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUser.getSelection()) {
                    textDwellTime.setEnabled(false);
                    lblS_1.setEnabled(false);
                } else {
                    textDwellTime.setEnabled(true);
                    lblS_1.setEnabled(true);
                }
            }
        });
        lblS_1 = new Label((Composite)groupTiming, 0);
        lblS_1.setText("seconds");
        lblS_1.setBounds(143, 90, 55, 15);
        if (settings.user_terminated) {
            btnUser.setSelection(true);
            textDwellTime.setEnabled(false);
            lblS_1.setEnabled(false);
        }
        textTestDelay = new Text((Composite)groupTiming, 133120);
        textTestDelay.setBounds(72, 112, 65, 21);
        textTestDelay.setText(Double.toString(settings.pre_check_delay));
        Label lblS_2 = new Label((Composite)groupTiming, 0);
        lblS_2.setText("seconds");
        lblS_2.setBounds(143, 111, 55, 15);
        lblEndon = new Label((Composite)groupTiming, 0);
        lblEndon.setText("End On");
        lblEndon.setBounds(10, 141, 55, 15);
        comboEndOn = new Combo((Composite)groupTiming, 0);
        comboEndOn.setToolTipText("Select when to terminate the dwell period.");
        comboEndOn.setItems(new String[]{"Pass", "Fail", "Time", "Steady"});
        comboEndOn.setBounds(72, 139, 77, 23);
        switch (settings.end_on) {
            case 0: {
                comboEndOn.setText("Pass");
                break;
            }
            case 1: {
                comboEndOn.setText("Fail");
                break;
            }
            case 2: {
                comboEndOn.setText("Time");
                break;
            }
            case 3: {
                comboEndOn.setText("Steady");
            }
        }
        Label lblDischarge = new Label((Composite)groupTiming, 0);
        lblDischarge.setBounds(9, 167, 55, 15);
        lblDischarge.setText("Discharge");
        comboDischarge = new Combo((Composite)groupTiming, 0);
        comboDischarge.setToolTipText("Specifies how discharge is processed.");
        comboDischarge.setItems(new String[]{"None", "Fast", "As Ramp"});
        comboDischarge.setBounds(71, 164, 77, 23);
        switch (settings.discharge_ramp_type) {
            case 0: {
                comboDischarge.setText("None");
                break;
            }
            case 1: {
                comboDischarge.setText("Fast");
                break;
            }
            case 2: {
                comboDischarge.setText("As Ramp");
            }
        }
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setText("Test Limits");
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLimits.setBounds(269, 66, 270, 197);
        Label lblBreakdown = new Label((Composite)grpLimits, 0);
        lblBreakdown.setBounds(10, 21, 65, 15);
        lblBreakdown.setText("Breakdown");
        textBreakdown = new Text((Composite)grpLimits, 133120);
        textBreakdown.setToolTipText("Specifies the instantaneous breakdown current limit.");
        textBreakdown.setText(Double.toString(settings.breakdown_limit * 1000.0));
        textBreakdown.setBounds(81, 21, 74, 21);
        lblBreakdownMa = new Label((Composite)grpLimits, 2048);
        lblBreakdownMa.setToolTipText("Double click to change the prefix.");
        lblBreakdownMa.setBounds(161, 23, 46, 19);
        lblBreakdownMa.setText("mA");
        lblBreakdownMa.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (lblBreakdownMa.getText().equals("uA")) {
                    lblBreakdownMa.setText("mA");
                } else {
                    lblBreakdownMa.setText("uA");
                }
            }
        });
        Label lblLeakage = new Label((Composite)grpLimits, 0);
        lblLeakage.setBounds(10, 58, 55, 21);
        lblLeakage.setText("Leakage");
        lblTo = new Label((Composite)grpLimits, 0);
        lblTo.setText("to");
        lblTo.setBounds(66, 83, 11, 15);
        String leakage_units = settings.leakage_check == TestStep.hipot_check_t.check_DC_A ? "A" : "\u2126";
        textMinimumLeakage = new Text((Composite)grpLimits, 133120);
        textMinimumLeakage.setToolTipText("Specifies the lower leakage limit.");
        textMinimumLeakage.setBounds(81, 58, 74, 21);
        textMinimumLeakage.setText(SiTools.toString(settings.minimum_leakage_limit));
        lblMinimumLeakagePrefix = new Label((Composite)grpLimits, 2048);
        lblMinimumLeakagePrefix.setToolTipText("Double click to change the prefix.");
        lblMinimumLeakagePrefix.setText(String.valueOf(SiTools.prefix(settings.minimum_leakage_limit)) + leakage_units);
        lblMinimumLeakagePrefix.setBounds(161, 58, 46, 19);
        lblMinimumLeakagePrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumLeakagePrefix);
            }
        });
        textMaximumLeakage = new Text((Composite)grpLimits, 133120);
        textMaximumLeakage.setToolTipText("Specifies the upper leakage limit.");
        textMaximumLeakage.setBounds(81, 80, 76, 21);
        textMaximumLeakage.setText(SiTools.toString(settings.maximum_leakage_limit));
        lblMaximumLeakagePrefix = new Label((Composite)grpLimits, 2048);
        lblMaximumLeakagePrefix.setToolTipText("Double click to change the prefix.");
        lblMaximumLeakagePrefix.setBounds(161, 83, 46, 19);
        lblMaximumLeakagePrefix.setText(String.valueOf(SiTools.prefix(settings.maximum_leakage_limit)) + leakage_units);
        lblMaximumLeakagePrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumLeakagePrefix);
            }
        });
        btnLeakageInAmps = new Button((Composite)grpLimits, 16);
        btnLeakageInAmps.setSelection(true);
        btnLeakageInAmps.setBounds(213, 56, 54, 21);
        btnLeakageInAmps.setText("Amps");
        btnLeakageInAmps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    btnLeakageNoMax.setVisible(false);
                    settings.leakage_check = TestStep.hipot_check_t.check_DC_A;
                    Nine5xDCIR_Edit.leakageTranslate("A");
                }
            }
        });
        btnLeakageInOhms = new Button((Composite)grpLimits, 16);
        btnLeakageInOhms.setText("\u2126");
        btnLeakageInOhms.setBounds(213, 80, 54, 21);
        btnLeakageInOhms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    btnLeakageNoMax.setVisible(true);
                    settings.leakage_check = TestStep.hipot_check_t.check_DC_Z;
                    Nine5xDCIR_Edit.leakageTranslate("\u2126");
                }
            }
        });
        btnLeakageNoMax = new Button((Composite)grpLimits, 32);
        btnLeakageNoMax.setToolTipText("Check to disable the maximum leakage limit.");
        btnLeakageNoMax.setText("No max");
        btnLeakageNoMax.setSelection(true);
        btnLeakageNoMax.setBounds(81, 107, 74, 16);
        btnLeakageNoMax.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnLeakageNoMax.getSelection()) {
                    textMaximumLeakage.setEnabled(false);
                    lblMaximumLeakagePrefix.setEnabled(false);
                } else {
                    textMaximumLeakage.setEnabled(true);
                    lblMaximumLeakagePrefix.setEnabled(true);
                }
            }
        });
        btnLeakageNoMax.setSelection(settings.no_maximum_limit);
        if (settings.leakage_check == TestStep.hipot_check_t.check_DC_A) {
            btnLeakageInAmps.setSelection(true);
            btnLeakageInOhms.setSelection(false);
            btnLeakageNoMax.setVisible(false);
        } else {
            btnLeakageInAmps.setSelection(false);
            btnLeakageInOhms.setSelection(true);
        }
        if (settings.leakage_check == TestStep.hipot_check_t.check_DC_Z && settings.no_maximum_limit) {
            textMaximumLeakage.setEnabled(false);
            lblMaximumLeakagePrefix.setEnabled(false);
        }
        btnArcDetect = new Button((Composite)grpLimits, 32);
        btnArcDetect.setToolTipText("Check to enable Arc detection.");
        btnArcDetect.setBounds(10, 135, 46, 16);
        btnArcDetect.setText("Arc");
        btnArcDetect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnArcDetect.getSelection()) {
                    textArcLimit.setEnabled(true);
                    lblArcLimitMa.setEnabled(true);
                    comboArcTimePeriod.setEnabled(true);
                } else {
                    textArcLimit.setEnabled(false);
                    lblArcLimitMa.setEnabled(false);
                    comboArcTimePeriod.setEnabled(false);
                }
            }
        });
        textArcLimit = new Text((Composite)grpLimits, 133120);
        textArcLimit.setToolTipText("Arc current limit, 1mA to 30mA.");
        textArcLimit.setText(Integer.toString(settings.arc_settings.arc_detection_limit));
        textArcLimit.setBounds(81, 135, 65, 20);
        lblArcLimitMa = new Label((Composite)grpLimits, 0);
        lblArcLimitMa.setToolTipText("");
        lblArcLimitMa.setText("mA");
        lblArcLimitMa.setBounds(152, 136, 29, 19);
        comboArcTimePeriod = new Combo((Composite)grpLimits, 0);
        comboArcTimePeriod.setToolTipText("Arc time period.");
        comboArcTimePeriod.setItems(new String[]{"4us", "10us", "15us", "20us", "30us", "40us"});
        comboArcTimePeriod.setBounds(206, 133, 54, 23);
        comboArcTimePeriod.setText(String.valueOf(Integer.toString(settings.arc_settings.arc_detection_period)) + "us");
        if (settings.arc_settings.enabled) {
            btnArcDetect.setSelection(true);
            textArcLimit.setEnabled(true);
            lblArcLimitMa.setEnabled(true);
            comboArcTimePeriod.setEnabled(true);
        } else {
            btnArcDetect.setSelection(false);
            textArcLimit.setEnabled(false);
            lblArcLimitMa.setEnabled(false);
            comboArcTimePeriod.setEnabled(false);
        }
        textLoading = new Text((Composite)grpLimits, 133120);
        textLoading.setEnabled(false);
        textLoading.setText(Double.toString(settings.minimum_load * 1000000.0));
        textLoading.setBounds(152, 162, 65, 21);
        if (my_settings.enable_dc_min_load) {
            lblLoadingUf = new Label((Composite)grpLimits, 0);
            lblLoadingUf.setToolTipText("");
            lblLoadingUf.setText("uF");
            lblLoadingUf.setEnabled(false);
            lblLoadingUf.setBounds(222, 165, 38, 19);
            btnMinLoadingEnable = new Button((Composite)grpLimits, 32);
            btnMinLoadingEnable.setText("Minimum Loading");
            btnMinLoadingEnable.setSelection(false);
            btnMinLoadingEnable.setBounds(10, 162, 125, 16);
            btnMinLoadingEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnMinLoadingEnable.getSelection()) {
                        textLoading.setEnabled(true);
                        lblLoadingUf.setEnabled(true);
                    } else {
                        textLoading.setEnabled(false);
                        lblLoadingUf.setEnabled(false);
                    }
                }
            });
            if (settings.use_min_load) {
                btnMinLoadingEnable.setSelection(true);
                textLoading.setEnabled(true);
                lblLoadingUf.setEnabled(true);
            } else {
                textLoading.setEnabled(false);
                lblLoadingUf.setEnabled(false);
            }
        } else {
            textLoading.setVisible(false);
        }
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 530, 51);
        btnDutGrounded = new Button((Composite)grpOptions, 32);
        btnDutGrounded.setToolTipText("Set when the DUT is grounded, (only valid if option HSS or HSS-2 is fitted).");
        btnDutGrounded.setBounds(258, 25, 121, 16);
        btnDutGrounded.setText("DUT Grounded");
        if (settings.grounding == 1) {
            btnDutGrounded.setSelection(true);
        }
        btnContinueOnFailure = new Button((Composite)grpOptions, 32);
        btnContinueOnFailure.setToolTipText("The sequence continues even if this step fails.");
        btnContinueOnFailure.setBounds(10, 25, 142, 16);
        btnContinueOnFailure.setText("Continue On Failure");
        if (settings.continue_on_failure) {
            btnContinueOnFailure.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(Nine5xDCIR settings) {
        settings.name = txtUserName.getText();
        settings.test_voltage = Double.parseDouble(textLevel.getText());
        settings.breakdown_limit = SiTools.toReal(textBreakdown.getText(), lblBreakdownMa.getText());
        settings.ramp_setting = settings.ramp_units == 1 ? Double.parseDouble(textRampTime.getText()) : Double.parseDouble(textRampVoltsSec.getText());
        switch (comboDischarge.getText()) {
            case "None": {
                settings.discharge_ramp_type = 0;
                break;
            }
            case "Fast": {
                settings.discharge_ramp_type = 1;
                break;
            }
            case "As Ramp": {
                settings.discharge_ramp_type = 2;
            }
        }
        settings.dwell_time = Double.parseDouble(textDwellTime.getText());
        settings.user_terminated = btnUser.getSelection();
        settings.pre_check_delay = Double.parseDouble(textTestDelay.getText());
        switch (comboEndOn.getText()) {
            case "Pass": {
                settings.end_on = 0;
                break;
            }
            case "Fail": {
                settings.end_on = 1;
                break;
            }
            case "Time": {
                settings.end_on = 2;
                break;
            }
            case "Steady": {
                settings.end_on = 3;
            }
        }
        settings.no_maximum_limit = btnLeakageNoMax.getSelection();
        settings.minimum_leakage_limit = SiTools.toReal(textMinimumLeakage.getText(), lblMinimumLeakagePrefix.getText());
        settings.maximum_leakage_limit = SiTools.toReal(textMaximumLeakage.getText(), lblMaximumLeakagePrefix.getText());
        if (btnMinLoadingEnable != null) {
            settings.use_min_load = btnMinLoadingEnable.getSelection();
        }
        settings.minimum_load = Double.parseDouble(textLoading.getText()) / 1000000.0;
        settings.arc_settings.enabled = btnArcDetect.getSelection();
        settings.arc_settings.arc_detection_limit = Integer.valueOf(textArcLimit.getText());
        switch (comboArcTimePeriod.getText()) {
            case "4us": {
                settings.arc_settings.arc_detection_period = 4;
                break;
            }
            case "10us": {
                settings.arc_settings.arc_detection_period = 10;
                break;
            }
            case "15us": {
                settings.arc_settings.arc_detection_period = 15;
                break;
            }
            case "20us": {
                settings.arc_settings.arc_detection_period = 20;
                break;
            }
            case "30us": {
                settings.arc_settings.arc_detection_period = 30;
                break;
            }
            case "40us": {
                settings.arc_settings.arc_detection_period = 40;
                break;
            }
            default: {
                settings.arc_settings.arc_detection_period = 4;
            }
        }
        settings.grounding = btnDutGrounded.getSelection() ? 1 : 2;
        settings.continue_on_failure = btnContinueOnFailure.getSelection();
    }
}

