/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class Nine5xDCI
extends TestStep {
    String id = "DCI";
    double test_time = 45.0;
    boolean user_terminated = false;
    double delay_time = 0.0;
    double minimum_leakage_current_limit = 0.0;
    double maximum_leakage_current_limit = 1.0E-4;
    TestStep.ArcSettings arc_settings = new TestStep.ArcSettings();

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return Nine5xDCI_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        Nine5xDCI_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        String arc = this.arc_settings.enabled ? String.valueOf(this.arc_settings.arc_detection_period) + "," + this.arc_settings.arc_detection_limit : ",";
        String command = "add,DCI," + (this.user_terminated ? "" : Double.valueOf(this.test_time)) + "," + this.delay_time + "," + this.minimum_leakage_current_limit + "," + this.maximum_leakage_current_limit + "," + arc + "," + this.abortKeyword();
        return command;
    }

    @Override
    public String stepSummary() {
        return "DCI";
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Voltage", "Volts", "V"}, {"Leakage", "Amps", "A"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[2];
        String[] f = steprslt.split(",", -1);
        rslts[0] = Utils.parseFloat(f[3]);
        rslts[1] = Utils.parseFloat(f[9]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus(2);
        io_handle.sendCommand("measrslt?,volts;measrslt?,amps;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            String[] f = response.split(",", -1);
            int reported_step = Integer.parseInt(f[2]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double total_step_time = this.user_terminated ? 9999.0 : this.test_time;
                double p = 100.0 * (double)i / (total_step_time *= 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                r.metrics[0] = Utils.parseFloat(f[0]);
                r.metrics[1] = Utils.parseFloat(f[1]);
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",", -1);
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + rslts[15] + "," + rslts[16] + "," + rslts[17] + "," + rslts[18] : ",,,,,";
            csv = (this.user_terminated ? rslts[1] : Double.valueOf(this.test_time)) + "," + "," + "," + "," + "," + "," + "AMPS," + this.maximum_leakage_current_limit + "," + this.minimum_leakage_current_limit + "," + rslts[7] + "," + rslts[8] + "," + rslts[9] + "," + rslts[10] + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        } else {
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + "," + "," + "," : ",,,,,";
            csv = (this.user_terminated ? "" : Double.valueOf(this.test_time)) + "," + "," + "," + "," + "," + "," + "AMPS," + this.maximum_leakage_current_limit + "," + this.minimum_leakage_current_limit + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + "," + arc;
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",", -1);
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: 
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 2;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        rpt[0] = !this.user_terminated ? "DCI for " + this.test_time + "s" : "DCI for " + rslts[1] + "s";
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                do_arc *= 2;
                rpt[1] = "Leakage: " + SiTools.toString(rslts[8], "A") + " to " + SiTools.toString(rslts[7], "A") + " (" + SiTools.toString(this.minimum_leakage_current_limit, "A") + " to " + SiTools.toString(this.maximum_leakage_current_limit, "A") + " limits)";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                do_arc *= 2;
                rpt[1] = "Leakage: " + SiTools.toString(rslts[8], "A") + " to " + SiTools.toString(rslts[7], "A") + ", Avg:" + SiTools.toString(rslts[9], "A") + ", Final:" + SiTools.toString(rslts[10], "A") + " (" + SiTools.toString(this.minimum_leakage_current_limit, "A") + " to " + SiTools.toString(this.maximum_leakage_current_limit, "A") + " limits)";
            }
        }
        if (do_arc != 0) {
            rpt[do_arc] = "ARC: " + SiTools.toString(rslts[17], "A") + " to " + SiTools.toString(rslts[16], "A") + ", Avg:" + SiTools.toString(rslts[17], "A") + ", Final:" + SiTools.toString(rslts[18], "A") + " (Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us)";
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 2;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        rpt[0] = !this.user_terminated ? "DCI for " + this.test_time + "s" : "DCI user terminated";
        if (level != ReportSettings.detail_level_t.brief) {
            rpt[1] = "Leakage: " + SiTools.toString(this.minimum_leakage_current_limit, "A") + " to " + SiTools.toString(this.maximum_leakage_current_limit, "A");
            if ((do_arc *= 2) != 0) {
                rpt[do_arc] = "ARC: Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us";
            }
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings = csv_data.split(",", -1);
        this.test_time = Double.parseDouble(settings[2]);
        this.delay_time = Double.parseDouble(settings[3]);
        this.minimum_leakage_current_limit = Double.parseDouble(settings[4]) * Math.pow(10.0, Double.parseDouble(settings[6]));
        this.maximum_leakage_current_limit = Double.parseDouble(settings[5]) * Math.pow(10.0, Double.parseDouble(settings[6]));
        this.arc_settings.enabled = settings[7].equals("Y");
        this.arc_settings.arc_detection_limit = Integer.valueOf(settings[8]);
        this.arc_settings.arc_detection_period = Integer.valueOf(settings[9]);
        boolean bl = this.continue_on_failure = settings[10].equals("Y");
        if (settings.length > 11) {
            this.name = settings[11];
        }
    }
}

