/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class Nine5xACW
extends TestStep {
    String id = "ACW";
    double test_voltage = 1000.0;
    double test_frequency = 60.0;
    boolean use_ac30 = false;
    double breakdown_limit = 0.015;
    double ramp_setting = 1.5;
    int ramp_units = 1;
    double dwell_time = 60.0;
    boolean user_terminated = false;
    double discharge_setting = 1.5;
    int discharge_ramp_type = 1;
    TestStep.hipot_check_t leakage_check1 = TestStep.hipot_check_t.check_RMSA;
    double minimum_leakage_limit1 = 0.0;
    double maximum_leakage_limit1 = 0.01;
    boolean no_maximum_limit1 = false;
    TestStep.hipot_check_t leakage_check2 = TestStep.hipot_check_t.check_QUADA;
    double minimum_leakage_limit2 = 0.0;
    double maximum_leakage_limit2 = 2.5E-5;
    boolean no_maximum_limit2 = false;
    TestStep.ArcSettings arc_settings = new TestStep.ArcSettings();
    double lead_compensation;
    int grounding = 2;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return Nine5xACW_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        Nine5xACW_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        double ramp_time = this.ramp_units == 1 ? this.ramp_setting : this.test_voltage / this.ramp_setting;
        String arc = this.arc_settings.enabled ? String.valueOf(this.arc_settings.arc_detection_period) + "," + this.arc_settings.arc_detection_limit : ",";
        String command = "add,ACW," + this.test_voltage + "," + this.test_frequency + "," + this.breakdown_limit + "," + ramp_time + "," + (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.checkKeyword(this.leakage_check1) + "," + this.minimum_leakage_limit1 + "," + (this.no_maximum_limit1 ? "" : Double.valueOf(this.maximum_leakage_limit1)) + "," + this.checkKeyword(this.leakage_check2) + "," + this.minimum_leakage_limit2 + "," + (this.no_maximum_limit2 ? "" : Double.valueOf(this.maximum_leakage_limit2)) + "," + arc + "," + this.dischargeKeyword(this.discharge_ramp_type) + "," + this.abortKeyword() + "," + (this.use_ac30 ? "ext," : "int,") + (this.grounding == 2 ? "iso" : "gnd");
        return command;
    }

    @Override
    public String stepSummary() {
        return "ACW:" + this.test_voltage + "V @ " + this.test_frequency + "Hz";
    }

    @Override
    public String[][] labels() {
        String lu;
        String ll;
        TestStep.hipot_check_t cc = this.leakage_check1 != TestStep.hipot_check_t.check_NONE ? this.leakage_check1 : (this.leakage_check2 != TestStep.hipot_check_t.check_NONE ? this.leakage_check2 : TestStep.hipot_check_t.check_RMSA);
        switch (cc) {
            default: {
                ll = "Leakage";
                lu = "A";
                break;
            }
            case check_INPHSA: {
                ll = "INPHS";
                lu = "A";
                break;
            }
            case check_QUADA: {
                ll = "QUAD";
                lu = "A";
                break;
            }
            case check_RMSO: {
                ll = "Ohms";
                lu = "\u2126";
                break;
            }
            case check_INPHSO: {
                ll = "INPHS";
                lu = "\u2126";
                break;
            }
            case check_QUADO: {
                ll = "QUAD";
                lu = "\u2126";
            }
        }
        return new String[][]{{"Drive", "Volts", "V"}, {"Max Apk", "Apk", "Apk"}, {"Leakage", ll, lu}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[3];
        String[] f = steprslt.split(",", -1);
        rslts[0] = Utils.parseFloat(f[3]);
        rslts[1] = Utils.parseFloat(f[5]);
        rslts[2] = this.leakage_check1 != TestStep.hipot_check_t.check_NONE ? Utils.parseFloat(f[9]) : (this.leakage_check2 != TestStep.hipot_check_t.check_NONE ? Utils.parseFloat(f[13]) : Utils.parseFloat(f[9]));
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        String m3;
        TestStep.StepStatus r = new TestStep.StepStatus();
        TestStep.hipot_check_t cc = this.leakage_check1 != TestStep.hipot_check_t.check_NONE ? this.leakage_check1 : (this.leakage_check2 != TestStep.hipot_check_t.check_NONE ? this.leakage_check2 : TestStep.hipot_check_t.check_RMSA);
        switch (cc) {
            default: {
                m3 = "amps";
                break;
            }
            case check_INPHSA: {
                m3 = "inphsa";
                break;
            }
            case check_QUADA: {
                m3 = "quada";
                break;
            }
            case check_RMSO: {
                m3 = "ohms";
                break;
            }
            case check_INPHSO: {
                m3 = "inphso";
                break;
            }
            case check_QUADO: {
                m3 = "quado";
            }
        }
        io_handle.sendCommand("phase?;measrslt?,volts;measrslt?,brkdn;measrslt?," + m3 + ";step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(",", -1);
            int reported_step = Integer.parseInt(f[4]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                int phase;
                double total_step_time;
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double d = total_step_time = this.user_terminated ? 9999.0 : this.dwell_time;
                total_step_time = this.ramp_units == 1 ? (total_step_time += this.ramp_setting) : (total_step_time += this.test_voltage / this.ramp_setting);
                double p = 100.0 * (double)i / (total_step_time *= 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                if ((phase = Integer.parseInt(f[0])) >= 1 && phase <= 3) {
                    r.metrics = new float[3];
                    r.metrics[0] = Utils.parseFloat(f[1]);
                    r.metrics[1] = Utils.parseFloat(f[2]);
                    r.metrics[2] = Utils.parseFloat(f[3]);
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",", -1);
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + rslts[15] + "," + rslts[16] + "," + rslts[17] + "," + rslts[18] : ",,,,,";
            csv = (this.user_terminated ? rslts[1] : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + rslts[3] + "," + this.test_frequency + "," + this.breakdown_limit + "," + rslts[5] + "," + this.checkKeyword(this.leakage_check1) + "," + (this.no_maximum_limit1 ? "" : Double.valueOf(this.maximum_leakage_limit1)) + "," + this.minimum_leakage_limit1 + "," + rslts[7] + "," + rslts[8] + "," + rslts[9] + "," + rslts[10] + "," + this.checkKeyword(this.leakage_check2) + "," + (this.no_maximum_limit2 ? "" : Double.valueOf(this.maximum_leakage_limit2)) + "," + this.minimum_leakage_limit2 + "," + rslts[11] + "," + rslts[12] + "," + rslts[13] + "," + rslts[14] + "," + arc;
        } else {
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + "," + "," + "," : ",,,,,";
            csv = (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + "," + this.test_frequency + "," + this.breakdown_limit + "," + "," + this.checkKeyword(this.leakage_check1) + "," + (this.no_maximum_limit1 ? "" : Double.valueOf(this.maximum_leakage_limit1)) + "," + this.minimum_leakage_limit1 + "," + "," + "," + "," + "," + this.checkKeyword(this.leakage_check2) + "," + (this.no_maximum_limit2 ? "" : Double.valueOf(this.maximum_leakage_limit2)) + "," + this.minimum_leakage_limit2 + "," + "," + "," + "," + "," + arc;
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",", -1);
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: {
                num_lines = 4;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 5;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        rpt[0] = !this.user_terminated ? "ACW @ " + this.test_voltage + "V/" + this.test_frequency + "Hz for " + this.dwell_time + "s" : "ACW @ " + this.test_voltage + "V/" + this.test_frequency + "Hz for " + rslts[1] + "s";
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                String max;
                String min;
                String lu;
                String ll;
                do_arc *= 4;
                rpt[1] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " @ " + SiTools.toString(rslts[3], "V") + " (" + SiTools.toString(this.breakdown_limit, "A") + " limit)";
                if (this.leakage_check1 != TestStep.hipot_check_t.check_NONE) {
                    switch (this.leakage_check1) {
                        default: {
                            ll = "RMS";
                            lu = "A";
                            break;
                        }
                        case check_INPHSA: {
                            ll = "INPHS";
                            lu = "A";
                            break;
                        }
                        case check_QUADA: {
                            ll = "QUAD";
                            lu = "A";
                            break;
                        }
                        case check_RMSO: {
                            ll = "Ohms";
                            lu = "\u2126";
                            break;
                        }
                        case check_INPHSO: {
                            ll = "INPHS";
                            lu = "\u2126";
                            break;
                        }
                        case check_QUADO: {
                            ll = "QUAD";
                            lu = "\u2126";
                        }
                    }
                    min = SiTools.toString(this.minimum_leakage_limit1, lu);
                    max = this.no_maximum_limit1 ? "\u221e" : SiTools.toString(this.maximum_leakage_limit1, lu);
                    rpt[2] = "Leakage #1: " + ll + " " + SiTools.toString(rslts[8], lu) + " to " + SiTools.toString(rslts[7], lu) + " (" + min + " to " + max + " limits)";
                } else {
                    rpt[2] = "Leakage #1: not checked";
                }
                if (this.leakage_check2 != TestStep.hipot_check_t.check_NONE) {
                    switch (this.leakage_check2) {
                        default: {
                            ll = "RMS";
                            lu = "A";
                            break;
                        }
                        case check_INPHSA: {
                            ll = "INPHS";
                            lu = "A";
                            break;
                        }
                        case check_QUADA: {
                            ll = "QUAD";
                            lu = "A";
                            break;
                        }
                        case check_RMSO: {
                            ll = "Ohms";
                            lu = "\u2126";
                            break;
                        }
                        case check_INPHSO: {
                            ll = "INPHS";
                            lu = "\u2126";
                            break;
                        }
                        case check_QUADO: {
                            ll = "QUAD";
                            lu = "\u2126";
                        }
                    }
                    min = SiTools.toString(this.minimum_leakage_limit2, lu);
                    max = this.no_maximum_limit2 ? "\u221e" : SiTools.toString(this.maximum_leakage_limit2, lu);
                    rpt[3] = "Leakage #2: " + ll + " " + SiTools.toString(rslts[12], lu) + " to " + SiTools.toString(rslts[11], lu) + " (" + min + " to " + max + " limits)";
                    break;
                }
                rpt[3] = "Leakage #2: not checked";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                String max;
                String min;
                String lu;
                String ll;
                do_arc *= 5;
                rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
                rpt[2] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " @ " + SiTools.toString(rslts[3], "V") + " (" + SiTools.toString(this.breakdown_limit, "A") + " limit)";
                if (this.leakage_check1 != TestStep.hipot_check_t.check_NONE) {
                    switch (this.leakage_check1) {
                        default: {
                            ll = "RMS";
                            lu = "A";
                            break;
                        }
                        case check_INPHSA: {
                            ll = "INPHS";
                            lu = "A";
                            break;
                        }
                        case check_QUADA: {
                            ll = "QUAD";
                            lu = "A";
                            break;
                        }
                        case check_RMSO: {
                            ll = "Ohms";
                            lu = "\u2126";
                            break;
                        }
                        case check_INPHSO: {
                            ll = "INPHS";
                            lu = "\u2126";
                            break;
                        }
                        case check_QUADO: {
                            ll = "QUAD";
                            lu = "\u2126";
                        }
                    }
                    min = SiTools.toString(this.minimum_leakage_limit1, lu);
                    max = this.no_maximum_limit1 ? "\u221e" : SiTools.toString(this.maximum_leakage_limit1, lu);
                    rpt[3] = "Leakage #1: " + ll + " " + SiTools.toString(rslts[8], lu) + " to " + SiTools.toString(rslts[7], lu) + ", Avg:" + SiTools.toString(rslts[9], lu) + ", Final:" + SiTools.toString(rslts[10], lu) + " (" + min + " to " + max + " limits)";
                } else {
                    rpt[3] = "Leakage #1: not checked";
                }
                if (this.leakage_check2 != TestStep.hipot_check_t.check_NONE) {
                    switch (this.leakage_check2) {
                        default: {
                            ll = "RMS";
                            lu = "A";
                            break;
                        }
                        case check_INPHSA: {
                            ll = "INPHS";
                            lu = "A";
                            break;
                        }
                        case check_QUADA: {
                            ll = "QUAD";
                            lu = "A";
                            break;
                        }
                        case check_RMSO: {
                            ll = "Ohms";
                            lu = "\u2126";
                            break;
                        }
                        case check_INPHSO: {
                            ll = "INPHS";
                            lu = "\u2126";
                            break;
                        }
                        case check_QUADO: {
                            ll = "QUAD";
                            lu = "\u2126";
                        }
                    }
                    min = SiTools.toString(this.minimum_leakage_limit2, lu);
                    max = this.no_maximum_limit2 ? "\u221e" : SiTools.toString(this.maximum_leakage_limit2, lu);
                    rpt[4] = "Leakage #2: " + ll + " " + SiTools.toString(rslts[12], lu) + " to " + SiTools.toString(rslts[11], lu) + ", Avg:" + SiTools.toString(rslts[13], lu) + ", Final:" + SiTools.toString(rslts[14], lu) + " (" + min + " to " + max + " limits)";
                    break;
                }
                rpt[4] = "Leakage #2: not checked";
            }
        }
        if (do_arc != 0) {
            rpt[do_arc] = "ARC: " + SiTools.toString(rslts[17], "A") + " to " + SiTools.toString(rslts[16], "A") + ", Avg:" + SiTools.toString(rslts[17], "A") + ", Final:" + SiTools.toString(rslts[18], "A") + " (Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us)";
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 5;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        rpt[0] = !this.user_terminated ? "ACW @ " + this.test_voltage + "V/" + this.test_frequency + "Hz for " + this.dwell_time + "s" : "ACW @ " + this.test_voltage + "V/" + this.test_frequency + "Hz user terminated";
        if (level != ReportSettings.detail_level_t.brief) {
            String max;
            String min;
            String lu;
            String ll;
            do_arc *= 5;
            rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
            rpt[2] = "Breakdown: " + SiTools.toString(this.breakdown_limit, "A") + " limit";
            if (this.leakage_check1 != TestStep.hipot_check_t.check_NONE) {
                switch (this.leakage_check1) {
                    default: {
                        ll = "RMS";
                        lu = "A";
                        break;
                    }
                    case check_INPHSA: {
                        ll = "INPHS";
                        lu = "A";
                        break;
                    }
                    case check_QUADA: {
                        ll = "QUAD";
                        lu = "A";
                        break;
                    }
                    case check_RMSO: {
                        ll = "Ohms";
                        lu = "\u2126";
                        break;
                    }
                    case check_INPHSO: {
                        ll = "INPHS";
                        lu = "\u2126";
                        break;
                    }
                    case check_QUADO: {
                        ll = "QUAD";
                        lu = "\u2126";
                    }
                }
                min = SiTools.toString(this.minimum_leakage_limit1, lu);
                max = this.no_maximum_limit1 ? "\u221e" : SiTools.toString(this.maximum_leakage_limit1, lu);
                rpt[3] = "Leakage #1: " + ll + " " + min + " to " + max;
            } else {
                rpt[3] = "Leakage #1: not checked";
            }
            if (this.leakage_check2 != TestStep.hipot_check_t.check_NONE) {
                switch (this.leakage_check2) {
                    default: {
                        ll = "RMS";
                        lu = "A";
                        break;
                    }
                    case check_INPHSA: {
                        ll = "INPHS";
                        lu = "A";
                        break;
                    }
                    case check_QUADA: {
                        ll = "QUAD";
                        lu = "A";
                        break;
                    }
                    case check_RMSO: {
                        ll = "Ohms";
                        lu = "\u2126";
                        break;
                    }
                    case check_INPHSO: {
                        ll = "INPHS";
                        lu = "\u2126";
                        break;
                    }
                    case check_QUADO: {
                        ll = "QUAD";
                        lu = "\u2126";
                    }
                }
                min = SiTools.toString(this.minimum_leakage_limit2, lu);
                max = this.no_maximum_limit2 ? "\u221e" : SiTools.toString(this.maximum_leakage_limit2, lu);
                rpt[4] = "Leakage #2: " + ll + " " + min + " to " + max;
            } else {
                rpt[4] = "Leakage #2: not checked";
            }
            if (do_arc != 0) {
                rpt[do_arc] = "ARC: Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us";
            }
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
        String[] settings;
        block46: {
            block44: {
                block43: {
                    block41: {
                        settings = csv_data.split(",", -1);
                        this.test_voltage = Double.parseDouble(settings[1]);
                        this.test_frequency = Double.parseDouble(settings[2]);
                        this.ramp_units = settings[3].equals("Y") ? 1 : 2;
                        this.ramp_setting = Double.parseDouble(settings[4]);
                        this.dwell_time = Double.parseDouble(settings[5]);
                        switch (settings[6]) {
                            case "NONE": {
                                this.discharge_ramp_type = 0;
                                break;
                            }
                            case "FAST": {
                                this.discharge_ramp_type = 1;
                                break;
                            }
                            case "AS RAMP": {
                                this.discharge_ramp_type = 2;
                            }
                        }
                        this.breakdown_limit = Double.parseDouble(settings[7]);
                        if (!settings[8].equals("Y")) break block41;
                        switch (settings[9]) {
                            case "RMS": {
                                this.leakage_check1 = TestStep.hipot_check_t.check_RMSA;
                                break;
                            }
                            case "INPHS": {
                                this.leakage_check1 = TestStep.hipot_check_t.check_INPHSA;
                                break;
                            }
                            case "QUAD": {
                                this.leakage_check1 = TestStep.hipot_check_t.check_QUADA;
                            }
                        }
                        break block43;
                    }
                    this.leakage_check1 = TestStep.hipot_check_t.check_NONE;
                }
                this.minimum_leakage_limit1 = Double.parseDouble(settings[10]) * Math.pow(10.0, Double.parseDouble(settings[12]));
                this.maximum_leakage_limit1 = Double.parseDouble(settings[11]) * Math.pow(10.0, Double.parseDouble(settings[12]));
                if (!settings[13].equals("Y")) break block44;
                switch (settings[14]) {
                    case "RMS": {
                        this.leakage_check2 = TestStep.hipot_check_t.check_RMSA;
                        break;
                    }
                    case "INPHS": {
                        this.leakage_check2 = TestStep.hipot_check_t.check_INPHSA;
                        break;
                    }
                    case "QUAD": {
                        this.leakage_check2 = TestStep.hipot_check_t.check_QUADA;
                    }
                }
                break block46;
            }
            this.leakage_check2 = TestStep.hipot_check_t.check_NONE;
        }
        this.minimum_leakage_limit2 = Double.parseDouble(settings[15]) * Math.pow(10.0, Double.parseDouble(settings[17]));
        this.maximum_leakage_limit2 = Double.parseDouble(settings[16]) * Math.pow(10.0, Double.parseDouble(settings[17]));
        this.arc_settings.enabled = settings[18].equals("Y");
        this.arc_settings.arc_detection_limit = Integer.valueOf(settings[19]);
        this.arc_settings.arc_detection_period = Integer.valueOf(settings[20]);
        this.continue_on_failure = settings[21].equals("Y");
        this.grounding = settings[22].equals("Y") ? 1 : 2;
        boolean bl = this.use_ac30 = settings[23].equals("Y");
        if (settings.length > 24) {
            this.name = settings[24];
        }
    }
}

