/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class Nine5xACCAP_Edit {
    private static Button btnAC30;
    private static Text textLevel;
    private static Text textFrequency;
    private static Text txtUserName;
    private static Text textRampTime;
    private static Text textRampVoltsSec;
    private static Text textDwellTime;
    private static Text textBreakdown;
    private static Button btnUser;
    private static Label lblS_1;
    private static Button buttonRampTime;
    private static Button buttonRampVoltsSec;
    private static Label lblRampSeconds;
    private static Label lblRampVsec;
    private static Combo comboDischarge;
    private static Label lblBreakdownMa;
    private static Label lblCapacitance;
    private static Label lblTo1;
    private static Label lblMinimumCapPrefix;
    private static Label lblMaximumCapPrefix;
    private static Text txtMinimumCap;
    private static Text txtMaximumCap;
    private static Label lblDissipation;
    private static Label lblTo2;
    private static Label lblMinimumDfPrefix;
    private static Label lblMaximumDfPrefix;
    private static Text txtMinimumDf;
    private static Text txtMaximumDf;
    private static Button btnArcDetect;
    private static Text textArcLimit;
    private static Combo comboArcTimePeriod;
    private static Label lblArcLimitMa;
    private static Button btnDutGrounded;
    private static Button btnContinueOnFailure;

    public static Composite editor(Composite parent, TesterSettings tester, final Nine5xACCAP settings) {
        final DecimalFormat df3 = new DecimalFormat("0.000");
        Composite edit_space = new Composite(parent, 0);
        edit_space.setForeground(SWTResourceManager.getColor(0, 121, 193));
        edit_space.setBackground(SWTResourceManager.getColor(202, 202, 202));
        Group grpLevel = new Group(edit_space, 0);
        grpLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLevel.setText("Levels");
        grpLevel.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLevel.setBounds(10, 0, 320, 60);
        btnAC30 = new Button((Composite)grpLevel, 32);
        btnAC30.setBounds(10, 23, 66, 27);
        btnAC30.setText("AC-30");
        if (settings.use_ac30) {
            btnAC30.setSelection(true);
        }
        textLevel = new Text((Composite)grpLevel, 133120);
        textLevel.setToolTipText("Specifies the voltage level for the test.");
        textLevel.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textLevel.setBounds(82, 15, 73, 35);
        textLevel.setText(Double.toString(settings.test_voltage));
        Label lblVolts = new Label((Composite)grpLevel, 0);
        lblVolts.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblVolts.setBounds(161, 15, 53, 35);
        lblVolts.setText("Volts");
        textFrequency = new Text((Composite)grpLevel, 133120);
        textFrequency.setToolTipText("Specifies the test frequency.");
        textFrequency.setText(Double.toString(settings.test_frequency));
        textFrequency.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        textFrequency.setBounds(220, 15, 53, 35);
        Label lblHz = new Label((Composite)grpLevel, 0);
        lblHz.setText("Hz");
        lblHz.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        lblHz.setBounds(279, 15, 31, 35);
        Group grpName = new Group(edit_space, 0);
        grpName.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpName.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpName.setText("Name");
        grpName.setBounds(336, 0, 210, 60);
        txtUserName = new Text((Composite)grpName, 2048);
        txtUserName.setToolTipText("Sets a friendly name for the test step.");
        txtUserName.setText(settings.name);
        txtUserName.setBounds(10, 25, 184, 21);
        Group groupTiming = new Group(edit_space, 0);
        groupTiming.setToolTipText("");
        groupTiming.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        groupTiming.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupTiming.setText("Timing");
        groupTiming.setBounds(10, 66, 246, 197);
        Label lblRamp = new Label((Composite)groupTiming, 0);
        lblRamp.setBounds(10, 33, 38, 15);
        lblRamp.setText("Ramp");
        buttonRampTime = new Button((Composite)groupTiming, 16);
        buttonRampTime.setToolTipText("Chooses the ramp to be in terms of time.");
        buttonRampTime.setBounds(46, 22, 21, 16);
        buttonRampTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 1;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampVoltsSec.getText());
                    if (t2 < 0.1) {
                        t2 = 0.1;
                    }
                    textRampTime.setText(df3.format(t1 / t2));
                    textRampVoltsSec.setEnabled(false);
                    textRampTime.setEnabled(true);
                    lblRampVsec.setEnabled(false);
                    lblRampSeconds.setEnabled(true);
                    textRampTime.setFocus();
                }
            }
        });
        buttonRampVoltsSec = new Button((Composite)groupTiming, 16);
        buttonRampVoltsSec.setToolTipText("Chooses the ramp to be in terms of volts/second.");
        buttonRampVoltsSec.setBounds(46, 51, 21, 16);
        buttonRampVoltsSec.setText("");
        buttonRampVoltsSec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    settings.ramp_units = 2;
                    double t1 = Double.parseDouble(textLevel.getText());
                    double t2 = Double.parseDouble(textRampTime.getText());
                    if (t2 < 0.001) {
                        t2 = 0.001;
                    }
                    textRampVoltsSec.setText(df3.format(t1 / t2));
                    textRampTime.setEnabled(false);
                    textRampVoltsSec.setEnabled(true);
                    lblRampSeconds.setEnabled(false);
                    lblRampVsec.setEnabled(true);
                    textRampVoltsSec.setFocus();
                }
            }
        });
        textRampTime = new Text((Composite)groupTiming, 133120);
        textRampTime.setToolTipText("Specifies the voltage ramp in terms of time.");
        textRampTime.setBounds(72, 22, 65, 21);
        textRampVoltsSec = new Text((Composite)groupTiming, 133120);
        textRampVoltsSec.setToolTipText("Specifies the voltage ramp in terms of volts/second.");
        textRampVoltsSec.setBounds(72, 49, 65, 21);
        lblRampSeconds = new Label((Composite)groupTiming, 0);
        lblRampSeconds.setBounds(143, 22, 55, 15);
        lblRampSeconds.setText("seconds");
        lblRampVsec = new Label((Composite)groupTiming, 0);
        lblRampVsec.setEnabled(false);
        lblRampVsec.setText("V/sec");
        lblRampVsec.setBounds(143, 51, 55, 15);
        if (settings.ramp_units == 1) {
            textRampTime.setText(Double.toString(settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setEnabled(false);
            textRampTime.setEnabled(true);
            lblRampVsec.setEnabled(false);
            lblRampSeconds.setEnabled(true);
            buttonRampTime.setSelection(true);
        } else {
            textRampTime.setText(Double.toString(settings.test_voltage / settings.ramp_setting));
            textRampVoltsSec.setText(df3.format(settings.ramp_setting));
            textRampTime.setEnabled(false);
            textRampVoltsSec.setEnabled(true);
            lblRampSeconds.setEnabled(false);
            lblRampVsec.setEnabled(true);
            buttonRampVoltsSec.setSelection(true);
        }
        Label lblDwell = new Label((Composite)groupTiming, 0);
        lblDwell.setBounds(10, 91, 55, 15);
        lblDwell.setText("Dwell");
        textDwellTime = new Text((Composite)groupTiming, 133120);
        textDwellTime.setToolTipText("Specifies the dwell time for the test.");
        textDwellTime.setBounds(72, 88, 65, 21);
        textDwellTime.setText(Double.toString(settings.dwell_time));
        btnUser = new Button((Composite)groupTiming, 32);
        btnUser.setBounds(199, 92, 44, 16);
        btnUser.setToolTipText("Allows the test to dwell until ended by the user.");
        btnUser.setText("User");
        btnUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnUser.getSelection()) {
                    textDwellTime.setEnabled(false);
                    lblS_1.setEnabled(false);
                } else {
                    textDwellTime.setEnabled(true);
                    lblS_1.setEnabled(true);
                }
            }
        });
        lblS_1 = new Label((Composite)groupTiming, 0);
        lblS_1.setText("seconds");
        lblS_1.setBounds(143, 90, 55, 15);
        if (settings.user_terminated) {
            btnUser.setSelection(true);
            textDwellTime.setEnabled(false);
            lblS_1.setEnabled(false);
        }
        Label lblDischarge = new Label((Composite)groupTiming, 0);
        lblDischarge.setBounds(9, 167, 55, 15);
        lblDischarge.setText("Discharge");
        comboDischarge = new Combo((Composite)groupTiming, 0);
        comboDischarge.setToolTipText("Specifies how discharge is processed.");
        comboDischarge.setItems(new String[]{"None", "Fast", "As Ramp"});
        comboDischarge.setBounds(71, 164, 77, 23);
        switch (settings.discharge_ramp_type) {
            case 0: {
                comboDischarge.setText("None");
                break;
            }
            case 1: {
                comboDischarge.setText("Fast");
                break;
            }
            case 2: {
                comboDischarge.setText("As Ramp");
            }
        }
        Group grpLimits = new Group(edit_space, 0);
        grpLimits.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpLimits.setText("Test Limits");
        grpLimits.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpLimits.setBounds(262, 66, 283, 197);
        Label lblBreakdown = new Label((Composite)grpLimits, 0);
        lblBreakdown.setBounds(10, 21, 65, 15);
        lblBreakdown.setText("Breakdown");
        textBreakdown = new Text((Composite)grpLimits, 133120);
        textBreakdown.setToolTipText("Specifies the instantaneous breakdown current limit.");
        textBreakdown.setText(Double.toString(settings.breakdown_limit * 1000.0));
        textBreakdown.setBounds(162, 21, 60, 21);
        lblBreakdownMa = new Label((Composite)grpLimits, 2048);
        lblBreakdownMa.setToolTipText("Double click to change the prefix.");
        lblBreakdownMa.setBounds(230, 23, 46, 19);
        lblBreakdownMa.setText("mA");
        lblBreakdownMa.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (lblBreakdownMa.getText().equals("uA")) {
                    lblBreakdownMa.setText("mA");
                } else {
                    lblBreakdownMa.setText("uA");
                }
            }
        });
        lblCapacitance = new Label((Composite)grpLimits, 0);
        lblCapacitance.setText("Capacitance");
        lblCapacitance.setBounds(10, 62, 65, 15);
        lblTo1 = new Label((Composite)grpLimits, 0);
        lblTo1.setText("to");
        lblTo1.setBounds(142, 83, 19, 15);
        txtMinimumCap = new Text((Composite)grpLimits, 133120);
        txtMinimumCap.setToolTipText("Specifies the lower capacitance limit.");
        txtMinimumCap.setBounds(162, 58, 60, 21);
        txtMinimumCap.setText(SiTools.toString(settings.minimum_capacitance_limit));
        lblMinimumCapPrefix = new Label((Composite)grpLimits, 2048);
        lblMinimumCapPrefix.setToolTipText("Double click to change the prefix.");
        lblMinimumCapPrefix.setText(String.valueOf(SiTools.prefix(settings.minimum_capacitance_limit)) + "F");
        lblMinimumCapPrefix.setBounds(230, 58, 46, 19);
        lblMinimumCapPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumCapPrefix);
            }
        });
        txtMaximumCap = new Text((Composite)grpLimits, 133120);
        txtMaximumCap.setToolTipText("Specifies the upper capacitance limit.");
        txtMaximumCap.setBounds(162, 80, 60, 21);
        txtMaximumCap.setText(SiTools.toString(settings.maximum_capacitance_limit));
        lblMaximumCapPrefix = new Label((Composite)grpLimits, 2048);
        lblMaximumCapPrefix.setToolTipText("Double click to change the prefix.");
        lblMaximumCapPrefix.setBounds(230, 83, 46, 19);
        lblMaximumCapPrefix.setText(String.valueOf(SiTools.prefix(settings.maximum_capacitance_limit)) + "F");
        lblMaximumCapPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumCapPrefix);
            }
        });
        lblDissipation = new Label((Composite)grpLimits, 0);
        lblDissipation.setText("Dissipation");
        lblDissipation.setBounds(10, 112, 65, 15);
        lblTo2 = new Label((Composite)grpLimits, 0);
        lblTo2.setText("to");
        lblTo2.setBounds(142, 133, 19, 15);
        txtMinimumDf = new Text((Composite)grpLimits, 133120);
        txtMinimumDf.setToolTipText("Specifies the lower dissipation limit.");
        txtMinimumDf.setBounds(162, 108, 60, 21);
        txtMinimumDf.setText(SiTools.toString(settings.minimum_df_limit));
        lblMinimumDfPrefix = new Label((Composite)grpLimits, 2048);
        lblMinimumDfPrefix.setToolTipText("Double click to change the prefix.");
        lblMinimumDfPrefix.setText(String.valueOf(SiTools.prefix(settings.minimum_df_limit)) + "D");
        lblMinimumDfPrefix.setBounds(230, 108, 46, 19);
        lblMinimumDfPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMinimumDfPrefix);
            }
        });
        txtMaximumDf = new Text((Composite)grpLimits, 133120);
        txtMaximumDf.setToolTipText("Specifies the upper dissipation limit.");
        txtMaximumDf.setBounds(162, 130, 60, 21);
        txtMaximumDf.setText(SiTools.toString(settings.maximum_df_limit));
        lblMaximumDfPrefix = new Label((Composite)grpLimits, 2048);
        lblMaximumDfPrefix.setToolTipText("Double click to change the prefix.");
        lblMaximumDfPrefix.setBounds(230, 133, 46, 19);
        lblMaximumDfPrefix.setText(String.valueOf(SiTools.prefix(settings.maximum_df_limit)) + "D");
        lblMaximumDfPrefix.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SiTools.shiftPrefix(lblMaximumDfPrefix);
            }
        });
        btnArcDetect = new Button((Composite)grpLimits, 32);
        btnArcDetect.setToolTipText("Check to enable Arc detection.");
        btnArcDetect.setBounds(10, 166, 46, 16);
        btnArcDetect.setText("Arc");
        btnArcDetect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnArcDetect.getSelection()) {
                    textArcLimit.setEnabled(true);
                    lblArcLimitMa.setEnabled(true);
                    comboArcTimePeriod.setEnabled(true);
                } else {
                    textArcLimit.setEnabled(false);
                    lblArcLimitMa.setEnabled(false);
                    comboArcTimePeriod.setEnabled(false);
                }
            }
        });
        textArcLimit = new Text((Composite)grpLimits, 133120);
        textArcLimit.setToolTipText("Arc current limit, 1mA to 30mA.");
        textArcLimit.setText(Integer.toString(settings.arc_settings.arc_detection_limit));
        textArcLimit.setBounds(81, 166, 65, 20);
        lblArcLimitMa = new Label((Composite)grpLimits, 0);
        lblArcLimitMa.setToolTipText("");
        lblArcLimitMa.setText("mA");
        lblArcLimitMa.setBounds(152, 167, 29, 19);
        comboArcTimePeriod = new Combo((Composite)grpLimits, 0);
        comboArcTimePeriod.setToolTipText("Arc time period.");
        comboArcTimePeriod.setItems(new String[]{"4us", "10us", "15us", "20us", "30us", "40us"});
        comboArcTimePeriod.setBounds(206, 164, 54, 23);
        comboArcTimePeriod.setText(String.valueOf(Integer.toString(settings.arc_settings.arc_detection_period)) + "us");
        if (settings.arc_settings.enabled) {
            btnArcDetect.setSelection(true);
            textArcLimit.setEnabled(true);
            lblArcLimitMa.setEnabled(true);
            comboArcTimePeriod.setEnabled(true);
        } else {
            btnArcDetect.setSelection(false);
            textArcLimit.setEnabled(false);
            lblArcLimitMa.setEnabled(false);
            comboArcTimePeriod.setEnabled(false);
        }
        Group grpOptions = new Group(edit_space, 0);
        grpOptions.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpOptions.setFont(SWTResourceManager.getFont("Segoe UI", 11, 1));
        grpOptions.setText("Options");
        grpOptions.setBounds(10, 269, 536, 51);
        btnDutGrounded = new Button((Composite)grpOptions, 32);
        btnDutGrounded.setToolTipText("Set when the DUT is grounded, (only valid if option HSS or HSS-2 is fitted).");
        btnDutGrounded.setBounds(247, 25, 154, 16);
        btnDutGrounded.setText("DUT Grounded");
        if (settings.grounding == 1) {
            btnDutGrounded.setSelection(true);
        }
        btnContinueOnFailure = new Button((Composite)grpOptions, 32);
        btnContinueOnFailure.setToolTipText("The sequence continues even if this step fails.");
        btnContinueOnFailure.setBounds(10, 25, 154, 16);
        btnContinueOnFailure.setText("Continue On Failure");
        if (settings.continue_on_failure) {
            btnContinueOnFailure.setSelection(true);
        }
        return edit_space;
    }

    public static void fetch(Nine5xACCAP settings) {
        settings.name = txtUserName.getText();
        settings.use_ac30 = btnAC30.getSelection();
        settings.test_voltage = Double.parseDouble(textLevel.getText());
        settings.test_frequency = Double.parseDouble(textFrequency.getText());
        settings.ramp_setting = settings.ramp_units == 1 ? Double.parseDouble(textRampTime.getText()) : Double.parseDouble(textRampVoltsSec.getText());
        settings.dwell_time = Double.parseDouble(textDwellTime.getText());
        settings.user_terminated = btnUser.getSelection();
        switch (comboDischarge.getText()) {
            case "None": {
                settings.discharge_ramp_type = 0;
                break;
            }
            case "Fast": {
                settings.discharge_ramp_type = 1;
                break;
            }
            case "As Ramp": {
                settings.discharge_ramp_type = 2;
            }
        }
        settings.breakdown_limit = SiTools.toReal(textBreakdown.getText(), lblBreakdownMa.getText());
        settings.minimum_capacitance_limit = SiTools.toReal(txtMinimumCap.getText(), lblMinimumCapPrefix.getText());
        settings.maximum_capacitance_limit = SiTools.toReal(txtMaximumCap.getText(), lblMaximumCapPrefix.getText());
        settings.minimum_df_limit = SiTools.toReal(txtMinimumDf.getText(), lblMinimumDfPrefix.getText());
        settings.maximum_df_limit = SiTools.toReal(txtMaximumDf.getText(), lblMaximumDfPrefix.getText());
        settings.arc_settings.enabled = btnArcDetect.getSelection();
        settings.arc_settings.arc_detection_limit = Integer.valueOf(textArcLimit.getText());
        switch (comboArcTimePeriod.getText()) {
            case "4us": {
                settings.arc_settings.arc_detection_period = 4;
                break;
            }
            case "10us": {
                settings.arc_settings.arc_detection_period = 10;
                break;
            }
            case "15us": {
                settings.arc_settings.arc_detection_period = 15;
                break;
            }
            case "20us": {
                settings.arc_settings.arc_detection_period = 20;
                break;
            }
            case "30us": {
                settings.arc_settings.arc_detection_period = 30;
                break;
            }
            case "40us": {
                settings.arc_settings.arc_detection_period = 40;
                break;
            }
            default: {
                settings.arc_settings.arc_detection_period = 4;
            }
        }
        settings.grounding = btnDutGrounded.getSelection() ? 1 : 2;
        settings.continue_on_failure = btnContinueOnFailure.getSelection();
    }
}

