/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.widgets.Composite;

public class Nine5xACCAP
extends TestStep {
    String id = "ACCAP";
    double test_voltage = 1000.0;
    double test_frequency = 60.0;
    boolean use_ac30;
    double breakdown_limit = 0.015;
    double ramp_setting = 1.5;
    int ramp_units = 1;
    double dwell_time = 60.0;
    boolean user_terminated = false;
    double discharge_setting = 1.5;
    int discharge_ramp_type = 1;
    double minimum_capacitance_limit = 9.0E-10;
    double maximum_capacitance_limit = 1.1E-9;
    double minimum_df_limit = 0.0;
    double maximum_df_limit = 0.5;
    TestStep.ArcSettings arc_settings = new TestStep.ArcSettings();
    double lead_compensation;
    int grounding = 2;

    @Override
    public String getType() {
        return this.id;
    }

    @Override
    public Composite editor(Composite parent, TesterSettings tester) {
        return Nine5xACCAP_Edit.editor(parent, tester, this);
    }

    @Override
    public void fetch() {
        Nine5xACCAP_Edit.fetch(this);
    }

    @Override
    public String addStep(TesterSettings settings, Tester tester) {
        double ramp_time = this.ramp_units == 1 ? this.ramp_setting : this.test_voltage / this.ramp_setting;
        String arc = this.arc_settings.enabled ? String.valueOf(this.arc_settings.arc_detection_period) + "," + this.arc_settings.arc_detection_limit : ",";
        String command = "add,ACCAP," + this.test_voltage + "," + this.test_frequency + "," + this.breakdown_limit + "," + ramp_time + "," + (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.minimum_capacitance_limit + "," + this.maximum_capacitance_limit + "," + this.minimum_df_limit + "," + this.maximum_df_limit + "," + arc + "," + this.dischargeKeyword(this.discharge_ramp_type) + "," + this.abortKeyword() + "," + (this.use_ac30 ? "ext," : "int,") + (this.grounding == 2 ? "iso" : "gnd");
        return command;
    }

    @Override
    public String stepSummary() {
        return "ACCAP:" + this.test_voltage + "V," + this.test_frequency + "Hz";
    }

    @Override
    public String[][] labels() {
        return new String[][]{{"Drive", "Volts", "V"}, {"Capacitance", "F", "F"}, {"DF", "Df", "Df"}};
    }

    @Override
    public float[] extractFinal(String steprslt) {
        float[] rslts = new float[3];
        String[] f = steprslt.split(",", -1);
        rslts[0] = Utils.parseFloat(f[3]);
        rslts[1] = Utils.parseFloat(f[9]);
        rslts[2] = Utils.parseFloat(f[13]);
        return rslts;
    }

    @Override
    public TestStep.StepStatus monitor(Interface io_handle, long start_time) {
        TestStep.StepStatus r = new TestStep.StepStatus();
        io_handle.sendCommand("phase?;measrslt?,volts;measrslt?,cap;measrslt?,df;step?");
        String response = io_handle.getResponse(100);
        if (response == null) {
            r.status = TestStep.step_status_t.error;
        } else {
            System.out.println(String.valueOf(this.id) + ":" + response);
            String[] f = response.split(",", -1);
            int reported_step = Integer.parseInt(f[4]);
            if (reported_step == 0) {
                r.status = TestStep.step_status_t.done;
            } else if (reported_step == this.step_num + 1) {
                int phase;
                double total_step_time;
                long now = System.currentTimeMillis();
                long i = now - start_time;
                double d = total_step_time = this.user_terminated ? 9999.0 : this.dwell_time;
                total_step_time = this.ramp_units == 1 ? (total_step_time += this.ramp_setting) : (total_step_time += this.test_voltage / this.ramp_setting);
                double p = 100.0 * (double)i / (total_step_time *= 1000.0);
                r.progress = (int)p;
                if (r.progress >= 100) {
                    r.progress = 99;
                }
                if ((phase = Integer.parseInt(f[0])) >= 1 && phase <= 3) {
                    r.metrics = new float[3];
                    r.metrics[0] = Utils.parseFloat(f[1]);
                    r.metrics[1] = Utils.parseFloat(f[2]);
                    r.metrics[2] = Utils.parseFloat(f[3]);
                }
            } else {
                r.progress = 100;
            }
        }
        return r;
    }

    @Override
    public boolean needsContinue() {
        return this.user_terminated;
    }

    @Override
    public String makeCsv(TesterSettings ts, String steprslt) {
        String csv;
        if (steprslt != null) {
            String[] rslts = steprslt.split(",", -1);
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + rslts[15] + "," + rslts[16] + "," + rslts[17] + "," + rslts[18] : ",,,,,";
            csv = (this.user_terminated ? rslts[1] : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + rslts[3] + "," + this.test_frequency + "," + this.breakdown_limit + "," + rslts[5] + "," + "cap," + this.maximum_capacitance_limit + "," + this.minimum_capacitance_limit + "," + rslts[7] + "," + rslts[8] + "," + rslts[9] + "," + rslts[10] + "," + "df," + this.maximum_df_limit + "," + this.minimum_df_limit + "," + rslts[11] + "," + rslts[12] + "," + rslts[13] + "," + rslts[14] + "," + arc;
        } else {
            String arc = this.arc_settings.enabled ? String.valueOf((double)this.arc_settings.arc_detection_limit / 1000.0) + "," + this.arc_settings.arc_detection_period + "," + "," + "," + "," : ",,,,,";
            csv = (this.user_terminated ? "" : Double.valueOf(this.dwell_time)) + "," + this.test_voltage + "," + "," + this.test_frequency + "," + this.breakdown_limit + "," + "," + "cap," + this.maximum_capacitance_limit + "," + this.minimum_capacitance_limit + "," + "," + "," + "," + "," + "df," + this.maximum_df_limit + "," + this.minimum_df_limit + "," + "," + "," + "," + "," + arc;
        }
        return csv;
    }

    @Override
    public String[] report(TesterSettings ts, String steprslt, ReportSettings.detail_level_t level) {
        String[] rslts = steprslt.split(",", -1);
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            case normal: {
                num_lines = 4;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                num_lines = 5;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        rpt[0] = !this.user_terminated ? "ACCAP @ " + this.test_voltage + "V/" + this.test_frequency + "Hz for " + this.dwell_time + "s" : "ACCAP @ " + this.test_voltage + "V/" + this.test_frequency + "Hz for " + rslts[1] + "s";
        switch (level) {
            case brief: {
                break;
            }
            case normal: {
                do_arc *= 4;
                rpt[1] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " @ " + SiTools.toString(rslts[3], "V") + " (" + SiTools.toString(this.breakdown_limit, "A") + " limit)";
                rpt[2] = "Capacitance: " + SiTools.toString(rslts[8], "F") + " to " + SiTools.toString(rslts[7], "F") + " (" + SiTools.toString(this.minimum_capacitance_limit, "F") + " to " + SiTools.toString(this.maximum_capacitance_limit, "F") + " limits)";
                rpt[3] = "Dissipation: " + SiTools.toString(rslts[12], "Df") + " to " + SiTools.toString(rslts[11], "Df") + " (" + SiTools.toString(this.minimum_df_limit, "Df") + " to " + SiTools.toString(this.maximum_df_limit, "Df") + " limits)";
                break;
            }
            case full: 
            case full_plus_charts_wide: 
            case full_plus_charts_tall: {
                do_arc *= 5;
                rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
                rpt[2] = "Breakdown: " + SiTools.toString(rslts[5], "A") + " @ " + SiTools.toString(rslts[3], "V") + " (" + SiTools.toString(this.breakdown_limit, "A") + " limit)";
                rpt[3] = "Capacitance: " + SiTools.toString(rslts[8], "F") + " to " + SiTools.toString(rslts[7], "F") + ", Avg:" + SiTools.toString(rslts[9], "F") + ", Final:" + SiTools.toString(rslts[10], "F") + " (" + SiTools.toString(this.minimum_capacitance_limit, "F") + " to " + SiTools.toString(this.maximum_capacitance_limit, "F") + " limits)";
                rpt[4] = "Dissipation: " + SiTools.toString(rslts[12], "Df") + " to " + SiTools.toString(rslts[11], "Df") + ", Avg:" + SiTools.toString(rslts[13], "Df") + ", Final:" + SiTools.toString(rslts[14], "Df") + " (" + SiTools.toString(this.minimum_df_limit, "Df") + " to " + SiTools.toString(this.maximum_df_limit, "Df") + " limits)";
            }
        }
        if (do_arc != 0) {
            rpt[do_arc] = "ARC: " + SiTools.toString(rslts[17], "A") + " to " + SiTools.toString(rslts[16], "A") + ", Avg:" + SiTools.toString(rslts[17], "A") + ", Final:" + SiTools.toString(rslts[18], "A") + " (Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us)";
        }
        return rpt;
    }

    @Override
    public String[] report(TesterSettings ts, ReportSettings.detail_level_t level) {
        String[] rpt = null;
        int num_lines = 0;
        int do_arc = 0;
        switch (level) {
            case brief: {
                num_lines = 1;
                break;
            }
            default: {
                num_lines = 5;
                if (!this.arc_settings.enabled) break;
                do_arc = 1;
            }
        }
        rpt = new String[num_lines + do_arc];
        rpt[0] = !this.user_terminated ? "ACCAP @ " + this.test_voltage + "V/" + this.test_frequency + "Hz for " + this.dwell_time + "s" : "ACCAP @ " + this.test_voltage + "V/" + this.test_frequency + "Hz user terminated";
        if (level != ReportSettings.detail_level_t.brief) {
            rpt[1] = "Ramp: " + this.ramp_setting + (this.ramp_units == 1 ? "s" : "V/s") + ", Discharge: " + this.dischargeKeyword(this.discharge_ramp_type);
            rpt[2] = "Breakdown: " + SiTools.toString(this.breakdown_limit, "A") + " limit";
            rpt[3] = "Capacitance: " + SiTools.toString(this.minimum_capacitance_limit, "F") + " to " + SiTools.toString(this.maximum_capacitance_limit, "F");
            rpt[4] = "Dissipation: " + SiTools.toString(this.minimum_df_limit, "Df") + " to " + SiTools.toString(this.maximum_df_limit, "Df");
            if ((do_arc *= 5) != 0) {
                rpt[do_arc] = "ARC: Limit " + this.arc_settings.arc_detection_limit + "mA for " + this.arc_settings.arc_detection_period + "us";
            }
        }
        return rpt;
    }

    @Override
    public void importQt(String csv_data) {
    }
}

