/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class MainToolsView
extends Composite {
    Display display;
    private Spinner spinner_sequence_number;
    private Text save_sequence_test_name;
    private Boolean have_serial_ports;
    private InterfaceFactory.physical_interface_t interface_type;
    private Button btnRS232;
    private Button btnEthernet;
    private Button btnUsb;
    private Button btnGpib;
    private Combo combo_com_ports;
    private Combo combo_baud_rate;
    private Text ip_address;
    private Combo combo_usb_devices;
    private Label usb_status_label;
    private Label lblGpibController;
    private Label lblGpibAddress;
    private Spinner spinnerGpibController;
    private Spinner spinnerGpibAddress;
    private Button btnConnect;
    private Button btnSendCommand;
    private Button btnSaveResponseText;
    private Label label_interface_error;
    private Text command_text;
    private Text response_text;
    SystemConfiguration system_configuration;
    private String[] sequence_names;
    TestSequence sequence;
    Interface comm_io;
    Thread com_worker;
    volatile int com_worker_state = 0;
    private Label lblIconSaveOk;
    private Label lblIconSaveError;
    private Label lblSaveErrorText;
    private ProgressBar progressBarSendFile;
    private ProgressBar progressBarSendSequence;
    Thread comm_worker;

    private void handleSendFile(String path) {
        this.progressBarSendFile.setVisible(true);
        this.progressBarSendFile.setState(0);
        byte[] f_data = null;
        try {
            f_data = Files.readAllBytes(Paths.get(path, new String[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f_data == null) {
            this.progressBarSendFile.setSelection(25);
            this.progressBarSendFile.setState(4);
            return;
        }
        this.progressBarSendFile.setSelection(25);
        this.comm_io = InterfaceFactory.getIo(this.system_configuration.pc_interface);
        final byte[] to_write = f_data;
        this.comm_worker = new Thread(){

            @Override
            public void run() {
                if (MainToolsView.this.comm_io.open(MainToolsView.this.system_configuration.interface_settings) == 0) {
                    MainToolsView.this.comm_io.sendCommand("*idn?");
                    String resp = MainToolsView.this.comm_io.getResponse(100);
                    if (resp != null) {
                        MainToolsView.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MainToolsView.this.progressBarSendFile.setSelection(50);
                            }
                        });
                        MainToolsView.this.comm_io.write(to_write, to_write.length);
                        MainToolsView.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MainToolsView.this.progressBarSendFile.setSelection(75);
                            }
                        });
                        MainToolsView.this.comm_io.sendCommand("*idn?");
                        resp = MainToolsView.this.comm_io.getResponse(10000);
                        if (resp != null) {
                            MainToolsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MainToolsView.this.progressBarSendFile.setSelection(100);
                                }
                            });
                        } else {
                            MainToolsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MainToolsView.this.progressBarSendSequence.setState(1);
                                    MainToolsView.this.progressBarSendFile.setSelection(100);
                                }
                            });
                        }
                        MainToolsView.this.comm_io.close();
                        MainToolsView.this.comm_io = null;
                    } else {
                        MainToolsView.this.comm_io.close();
                        MainToolsView.this.comm_io = null;
                        MainToolsView.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MainToolsView.this.progressBarSendFile.setSelection(50);
                                MainToolsView.this.progressBarSendFile.setState(1);
                            }
                        });
                    }
                } else {
                    MainToolsView.this.comm_io.close();
                    MainToolsView.this.comm_io = null;
                    MainToolsView.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MainToolsView.this.progressBarSendFile.setSelection(25);
                            MainToolsView.this.progressBarSendFile.setState(1);
                        }
                    });
                }
            }
        };
        this.comm_worker.start();
    }

    private void handleSendSequence() {
        this.lblIconSaveOk.setVisible(false);
        this.lblIconSaveError.setVisible(false);
        this.lblSaveErrorText.setVisible(false);
        this.progressBarSendSequence.setVisible(false);
        if (this.system_configuration.loaded_name.isEmpty()) {
            this.lblSaveErrorText.setText("The system has not been configured");
            this.lblSaveErrorText.setVisible(true);
            this.lblIconSaveError.setVisible(true);
            return;
        }
        if (this.system_configuration.use_switches && this.system_configuration.switch_control == switch_control_t.switch_control_computer) {
            this.lblSaveErrorText.setText("The switch interface is incompatible");
            this.lblSaveErrorText.setVisible(true);
            this.lblIconSaveError.setVisible(true);
            return;
        }
        if (this.system_configuration.loaded_name.isEmpty() || this.sequence == null) {
            this.lblSaveErrorText.setText("No sequence is available");
            this.lblSaveErrorText.setVisible(true);
            this.lblIconSaveError.setVisible(true);
            return;
        }
        if (this.sequence.num_steps == 0) {
            this.lblSaveErrorText.setText("The sequence has no steps");
            this.lblSaveErrorText.setVisible(true);
            this.lblIconSaveError.setVisible(true);
            return;
        }
        this.progressBarSendSequence.setVisible(true);
        this.progressBarSendSequence.setState(0);
        this.progressBarSendSequence.setMaximum(this.sequence.num_steps + 2);
        this.progressBarSendSequence.setSelection(1);
        this.comm_io = InterfaceFactory.getIo(this.system_configuration.pc_interface);
        final String tn = this.save_sequence_test_name.getText();
        final String sn = this.spinner_sequence_number.getText();
        this.comm_worker = new Thread(){

            @Override
            public void run() {
                if (MainToolsView.this.comm_io.open(MainToolsView.this.system_configuration.interface_settings) == 0) {
                    MainToolsView.this.comm_io.sendCommand("*idn?");
                    String idn = MainToolsView.this.comm_io.getResponse(100);
                    if (idn != null) {
                        String cmd = MainToolsView.this.sequence.tester_settings.configurationCommands();
                        System.out.println(cmd);
                        MainToolsView.this.comm_io.sendCommand(cmd);
                        String swcmd = MainToolsView.this.sequence.tester.configureSwitches(MainToolsView.this.system_configuration);
                        if (!swcmd.isEmpty()) {
                            System.out.println(swcmd);
                            MainToolsView.this.comm_io.sendCommand(swcmd);
                        }
                        cmd = MainToolsView.this.sequence.tester.clearSequence();
                        System.out.println(cmd);
                        MainToolsView.this.comm_io.sendCommand(cmd);
                        int step_err = 0;
                        int step_num = 0;
                        while (step_num < MainToolsView.this.sequence.num_steps) {
                            final int p = step_num + 1;
                            MainToolsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MainToolsView.this.progressBarSendSequence.setSelection(p);
                                }
                            });
                            step_err = MainToolsView.this.sequence.sendStep(MainToolsView.this.comm_io, step_num);
                            if (step_err != 0) break;
                            ++step_num;
                        }
                        if (step_err == 0) {
                            cmd = MainToolsView.this.sequence.tester.saveSequence(tn, sn);
                            System.out.println(cmd);
                            MainToolsView.this.comm_io.sendCommand(cmd);
                            final int pf = MainToolsView.this.sequence.num_steps + 2;
                            MainToolsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MainToolsView.this.progressBarSendSequence.setSelection(pf);
                                    MainToolsView.this.lblIconSaveOk.setVisible(true);
                                }
                            });
                        } else {
                            final String err = "Error on step #" + (step_num + 1) + ":" + MainToolsView.this.sequence.tester.strerror(step_err);
                            MainToolsView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MainToolsView.this.progressBarSendSequence.setState(1);
                                    MainToolsView.this.lblSaveErrorText.setText(err);
                                    MainToolsView.this.lblSaveErrorText.setVisible(true);
                                    MainToolsView.this.lblIconSaveError.setVisible(true);
                                }
                            });
                        }
                        MainToolsView.this.comm_io.close();
                        MainToolsView.this.comm_io = null;
                    } else {
                        MainToolsView.this.comm_io.close();
                        MainToolsView.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MainToolsView.this.progressBarSendSequence.setMaximum(100);
                                MainToolsView.this.progressBarSendSequence.setSelection(33);
                                MainToolsView.this.progressBarSendSequence.setState(1);
                                MainToolsView.this.lblSaveErrorText.setText("No instrument");
                                MainToolsView.this.lblSaveErrorText.setVisible(true);
                                MainToolsView.this.lblIconSaveError.setVisible(true);
                            }
                        });
                    }
                } else {
                    MainToolsView.this.comm_io.close();
                    MainToolsView.this.comm_io = null;
                    MainToolsView.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MainToolsView.this.progressBarSendSequence.setMaximum(100);
                            MainToolsView.this.progressBarSendSequence.setSelection(33);
                            MainToolsView.this.progressBarSendSequence.setState(1);
                            MainToolsView.this.lblSaveErrorText.setText("Cannot connect");
                            MainToolsView.this.lblSaveErrorText.setVisible(true);
                            MainToolsView.this.lblIconSaveError.setVisible(true);
                        }
                    });
                }
            }
        };
        this.comm_worker.start();
    }

    public MainToolsView(final Composite parent, int style) {
        super(parent, style);
        String[] config_names;
        this.display = parent.getDisplay();
        String[] sports = InterfaceFactory.getRs232PortList();
        this.have_serial_ports = sports != null && sports.length > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        Group grpSendFileToTester = new Group((Composite)this, 0);
        grpSendFileToTester.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpSendFileToTester.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpSendFileToTester.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpSendFileToTester.setText("Send File to the Instrument");
        grpSendFileToTester.setBounds(10, 0, 388, 162);
        Button btnBrowseAndSend = new Button((Composite)grpSendFileToTester, 0);
        btnBrowseAndSend.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        btnBrowseAndSend.setBounds(121, 92, 143, 31);
        btnBrowseAndSend.setText("Browse and Send");
        btnBrowseAndSend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainToolsView.this.progressBarSendFile.setVisible(false);
                FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.txt", "*.*"});
                String file_path = dialog.open();
                if (file_path != null) {
                    MainToolsView.this.handleSendFile(file_path);
                }
            }
        });
        Label lblSendFileHints = new Label((Composite)grpSendFileToTester, 0);
        lblSendFileHints.setBounds(10, 37, 368, 55);
        lblSendFileHints.setText("Send a file to the instrument. The contents must comply with the\r\ncommand interface documentation or be a firmware update image.\r\nThe present system settings configure the communications channel.");
        this.progressBarSendFile = new ProgressBar((Composite)grpSendFileToTester, 0);
        this.progressBarSendFile.setBounds(10, 129, 368, 19);
        this.progressBarSendFile.setVisible(false);
        if (!UserSettings.permissions.send_file_to_tester) {
            grpSendFileToTester.setEnabled(false);
        }
        this.system_configuration = !UserSettings.configuration_name.isEmpty() ? SystemConfiguration.load(UserSettings.configuration_name) : ((config_names = SystemConfiguration.getNames()).length > 0 ? SystemConfiguration.load(config_names[0]) : new SystemConfiguration());
        if (!this.system_configuration.series.isEmpty()) {
            this.sequence_names = TestSequence.getNames(this.system_configuration.series);
        }
        Group grpSaveSequenceInTester = new Group((Composite)this, 0);
        grpSaveSequenceInTester.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpSaveSequenceInTester.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpSaveSequenceInTester.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpSaveSequenceInTester.setText("Save Sequence in the Instrument");
        grpSaveSequenceInTester.setBounds(10, 168, 388, 295);
        Label lblSaveSequenceHints = new Label((Composite)grpSaveSequenceInTester, 0);
        lblSaveSequenceHints.setBounds(10, 33, 368, 54);
        lblSaveSequenceHints.setText("The active test sequence is sent to the tester and saved in the selected\r\nslot. The test can have an optional name. The present system settings\r\nconfigure the communications channel and switch matrix.");
        Label lblStore = new Label((Composite)grpSaveSequenceInTester, 0);
        lblStore.setBounds(20, 131, 49, 22);
        lblStore.setText("Store #:");
        this.spinner_sequence_number = new Spinner((Composite)grpSaveSequenceInTester, 2048);
        this.spinner_sequence_number.setMinimum(1);
        this.spinner_sequence_number.setBounds(71, 128, 49, 22);
        Label lblName = new Label((Composite)grpSaveSequenceInTester, 0);
        lblName.setBounds(126, 128, 42, 22);
        lblName.setText("Name:");
        this.save_sequence_test_name = new Text((Composite)grpSaveSequenceInTester, 2048);
        this.save_sequence_test_name.setBounds(168, 128, 198, 22);
        Button btnSendSequence = new Button((Composite)grpSaveSequenceInTester, 0);
        btnSendSequence.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        btnSendSequence.setBounds(148, 156, 91, 31);
        btnSendSequence.setText("Send");
        btnSendSequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainToolsView.this.handleSendSequence();
            }
        });
        Label lblChooseSequence = new Label((Composite)grpSaveSequenceInTester, 0);
        lblChooseSequence.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        lblChooseSequence.setBounds(49, 94, 75, 22);
        lblChooseSequence.setText("Sequence:");
        final Combo comboSequenceChoice = new Combo((Composite)grpSaveSequenceInTester, 0);
        comboSequenceChoice.setFont(SWTResourceManager.getFont("Segoe UI", 11, 0));
        comboSequenceChoice.setBounds(148, 93, 190, 28);
        comboSequenceChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainToolsView.this.sequence = TestSequence.load(comboSequenceChoice.getText());
            }
        });
        comboSequenceChoice.setItems(this.sequence_names);
        if (!UserSettings.test_name.isEmpty()) {
            comboSequenceChoice.setText(UserSettings.test_name);
            this.sequence = TestSequence.load(UserSettings.test_name);
        } else if (this.sequence_names.length > 0) {
            comboSequenceChoice.setText(this.sequence_names[0]);
            this.sequence = TestSequence.load(this.sequence_names[0]);
        }
        this.progressBarSendSequence = new ProgressBar((Composite)grpSaveSequenceInTester, 0);
        this.progressBarSendSequence.setBounds(10, 197, 368, 19);
        this.progressBarSendSequence.setMinimum(0);
        this.progressBarSendSequence.setVisible(false);
        this.lblIconSaveOk = new Label((Composite)grpSaveSequenceInTester, 0);
        this.lblIconSaveOk.setBounds(10, 235, 50, 50);
        this.lblIconSaveOk.setImage(SWTResourceManager.getImage("images/ok_pass.png"));
        this.lblIconSaveOk.setVisible(false);
        this.lblIconSaveError = new Label((Composite)grpSaveSequenceInTester, 0);
        this.lblIconSaveError.setBounds(10, 235, 50, 50);
        this.lblIconSaveError.setImage(SWTResourceManager.getImage("images/error_fail.png"));
        this.lblIconSaveError.setVisible(false);
        this.lblSaveErrorText = new Label((Composite)grpSaveSequenceInTester, 0);
        this.lblSaveErrorText.setBounds(71, 246, 307, 22);
        this.lblSaveErrorText.setForeground(SWTResourceManager.getColor(255, 0, 0));
        this.lblSaveErrorText.setText("Some Error");
        this.lblSaveErrorText.setVisible(false);
        if (!UserSettings.permissions.save_sequence_in_tester) {
            grpSaveSequenceInTester.setEnabled(false);
        }
        Group grpCommandresponseTool = new Group((Composite)this, 0);
        grpCommandresponseTool.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpCommandresponseTool.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpCommandresponseTool.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpCommandresponseTool.setText("Command/Response Tool");
        grpCommandresponseTool.setBounds(415, 0, 575, 463);
        this.btnRS232 = new Button((Composite)grpCommandresponseTool, 16);
        this.btnRS232.setBounds(21, 36, 90, 16);
        this.btnRS232.setText("RS232");
        this.btnRS232.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainToolsView.this.label_interface_error.setVisible(false);
                    MainToolsView.this.interface_type = InterfaceFactory.physical_interface_t.physical_rs232;
                    MainToolsView.this.combo_com_ports.setVisible(true);
                    MainToolsView.this.combo_baud_rate.setVisible(true);
                    MainToolsView.this.ip_address.setVisible(false);
                    MainToolsView.this.combo_usb_devices.setVisible(false);
                    MainToolsView.this.lblGpibController.setVisible(false);
                    MainToolsView.this.lblGpibAddress.setVisible(false);
                    MainToolsView.this.spinnerGpibController.setVisible(false);
                    MainToolsView.this.spinnerGpibAddress.setVisible(false);
                    MainToolsView.this.usb_status_label.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.have_serial_ports.booleanValue()) {
            this.interface_type = InterfaceFactory.physical_interface_t.physical_rs232;
            this.btnRS232.setSelection(true);
        } else {
            this.btnRS232.setEnabled(false);
        }
        this.btnEthernet = new Button((Composite)grpCommandresponseTool, 16);
        this.btnEthernet.setBounds(21, 58, 90, 16);
        this.btnEthernet.setText("Ethernet");
        this.btnEthernet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainToolsView.this.label_interface_error.setVisible(false);
                    MainToolsView.this.interface_type = InterfaceFactory.physical_interface_t.physical_ethernet;
                    MainToolsView.this.combo_com_ports.setVisible(false);
                    MainToolsView.this.combo_baud_rate.setVisible(false);
                    MainToolsView.this.ip_address.setVisible(true);
                    MainToolsView.this.combo_usb_devices.setVisible(false);
                    MainToolsView.this.lblGpibController.setVisible(false);
                    MainToolsView.this.lblGpibAddress.setVisible(false);
                    MainToolsView.this.spinnerGpibController.setVisible(false);
                    MainToolsView.this.spinnerGpibAddress.setVisible(false);
                    MainToolsView.this.usb_status_label.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!this.have_serial_ports.booleanValue()) {
            this.interface_type = InterfaceFactory.physical_interface_t.physical_ethernet;
            this.btnEthernet.setSelection(true);
        }
        this.btnUsb = new Button((Composite)grpCommandresponseTool, 16);
        this.btnUsb.setBounds(21, 80, 90, 16);
        this.btnUsb.setText("USB");
        this.btnUsb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainToolsView.this.label_interface_error.setVisible(false);
                    MainToolsView.this.interface_type = InterfaceFactory.physical_interface_t.physical_usb;
                    MainToolsView.this.usb_status_label.setVisible(true);
                    MainToolsView.this.combo_com_ports.setVisible(false);
                    MainToolsView.this.combo_baud_rate.setVisible(false);
                    MainToolsView.this.ip_address.setVisible(false);
                    MainToolsView.this.lblGpibController.setVisible(false);
                    MainToolsView.this.lblGpibAddress.setVisible(false);
                    MainToolsView.this.spinnerGpibController.setVisible(false);
                    MainToolsView.this.spinnerGpibAddress.setVisible(false);
                    String[] dlist = InterfaceFactory.getUsbDeviceList();
                    if (dlist.length > 0) {
                        MainToolsView.this.combo_usb_devices.setItems(dlist);
                        MainToolsView.this.combo_usb_devices.setText(dlist[0]);
                        MainToolsView.this.combo_usb_devices.setVisible(true);
                    } else {
                        MainToolsView.this.usb_status_label.setText("None found");
                        MainToolsView.this.usb_status_label.setVisible(true);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnGpib = new Button((Composite)grpCommandresponseTool, 16);
        this.btnGpib.setBounds(21, 102, 90, 16);
        this.btnGpib.setText("GPIB");
        this.btnGpib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainToolsView.this.label_interface_error.setVisible(false);
                    MainToolsView.this.interface_type = InterfaceFactory.physical_interface_t.physical_gpib;
                    MainToolsView.this.combo_com_ports.setVisible(false);
                    MainToolsView.this.combo_baud_rate.setVisible(false);
                    MainToolsView.this.ip_address.setVisible(false);
                    MainToolsView.this.combo_usb_devices.setVisible(false);
                    MainToolsView.this.lblGpibController.setVisible(true);
                    MainToolsView.this.lblGpibAddress.setVisible(true);
                    MainToolsView.this.spinnerGpibController.setVisible(true);
                    MainToolsView.this.spinnerGpibAddress.setVisible(true);
                    MainToolsView.this.usb_status_label.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!InterfaceFactory.haveGpib()) {
            this.btnGpib.setEnabled(false);
        }
        this.combo_com_ports = new Combo((Composite)grpCommandresponseTool, 8);
        this.combo_com_ports.setBounds(117, 36, 91, 23);
        if (this.have_serial_ports.booleanValue()) {
            this.combo_com_ports.setItems(sports);
            this.combo_com_ports.setText(sports[0]);
        }
        this.combo_baud_rate = new Combo((Composite)grpCommandresponseTool, 0);
        this.combo_baud_rate.setItems(new String[]{"9600", "19200", "57600", "115200"});
        this.combo_baud_rate.setBounds(220, 34, 91, 23);
        this.combo_baud_rate.setText("115200");
        this.ip_address = new Text((Composite)grpCommandresponseTool, 2048);
        this.ip_address.setVisible(false);
        this.ip_address.setBounds(117, 58, 91, 21);
        this.ip_address.setText("192.168.1.100");
        this.combo_usb_devices = new Combo((Composite)grpCommandresponseTool, 0);
        this.combo_usb_devices.setVisible(false);
        this.combo_usb_devices.setBounds(117, 80, 91, 23);
        this.usb_status_label = new Label((Composite)grpCommandresponseTool, 0);
        this.usb_status_label.setVisible(false);
        this.usb_status_label.setBounds(117, 81, 70, 15);
        this.usb_status_label.setText("Scanning");
        this.lblGpibController = new Label((Composite)grpCommandresponseTool, 0);
        this.lblGpibController.setVisible(false);
        this.lblGpibController.setBounds(117, 102, 59, 15);
        this.lblGpibController.setText("Controller");
        this.spinnerGpibController = new Spinner((Composite)grpCommandresponseTool, 2048);
        this.spinnerGpibController.setVisible(false);
        this.spinnerGpibController.setMaximum(7);
        this.spinnerGpibController.setMinimum(0);
        this.spinnerGpibController.setBounds(180, 100, 47, 22);
        this.lblGpibAddress = new Label((Composite)grpCommandresponseTool, 0);
        this.lblGpibAddress.setVisible(false);
        this.lblGpibAddress.setBounds(238, 102, 47, 15);
        this.lblGpibAddress.setText("Address");
        this.spinnerGpibAddress = new Spinner((Composite)grpCommandresponseTool, 2048);
        this.spinnerGpibAddress.setVisible(false);
        this.spinnerGpibAddress.setMaximum(32);
        this.spinnerGpibAddress.setMinimum(1);
        this.spinnerGpibAddress.setBounds(291, 100, 47, 22);
        this.label_interface_error = new Label((Composite)grpCommandresponseTool, 0);
        this.label_interface_error.setForeground(SWTResourceManager.getColor(255, 0, 0));
        this.label_interface_error.setBounds(102, 130, 261, 16);
        this.label_interface_error.setText("Some Error");
        this.label_interface_error.setVisible(false);
        this.btnConnect = new Button((Composite)grpCommandresponseTool, 0);
        this.btnConnect.setFont(SWTResourceManager.getFont("Segoe UI", 18, 0));
        this.btnConnect.setBounds(367, 36, 144, 82);
        this.btnConnect.setText("Connect");
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (MainToolsView.this.btnConnect.getText() == "Connect") {
                    MainToolsView.this.label_interface_error.setVisible(false);
                    MainToolsView.this.response_text.setText("");
                    String[] comm_args = new String[2];
                    switch (MainToolsView.this.interface_type) {
                        case physical_rs232: {
                            comm_args[0] = MainToolsView.this.combo_com_ports.getText();
                            comm_args[1] = MainToolsView.this.combo_baud_rate.getText();
                            break;
                        }
                        case physical_ethernet: {
                            comm_args[0] = MainToolsView.this.ip_address.getText();
                            break;
                        }
                        case physical_usb: {
                            comm_args[0] = MainToolsView.this.combo_usb_devices.getText();
                            break;
                        }
                        case physical_gpib: {
                            comm_args[0] = MainToolsView.this.spinnerGpibController.getText();
                            comm_args[1] = MainToolsView.this.spinnerGpibAddress.getText();
                        }
                    }
                    MainToolsView.this.comm_io = InterfaceFactory.getIo(MainToolsView.this.interface_type);
                    if (MainToolsView.this.comm_io.open(comm_args) == 0) {
                        MainToolsView.this.btnRS232.setEnabled(false);
                        MainToolsView.this.btnEthernet.setEnabled(false);
                        MainToolsView.this.btnUsb.setEnabled(false);
                        MainToolsView.this.btnGpib.setEnabled(false);
                        MainToolsView.this.combo_com_ports.setVisible(false);
                        MainToolsView.this.combo_baud_rate.setVisible(false);
                        MainToolsView.this.ip_address.setVisible(false);
                        MainToolsView.this.combo_usb_devices.setVisible(false);
                        MainToolsView.this.lblGpibController.setVisible(false);
                        MainToolsView.this.lblGpibAddress.setVisible(false);
                        MainToolsView.this.spinnerGpibController.setVisible(false);
                        MainToolsView.this.spinnerGpibAddress.setVisible(false);
                        MainToolsView.this.usb_status_label.setVisible(false);
                        MainToolsView.this.btnConnect.setText("Disconnect");
                        MainToolsView.this.command_text.setEnabled(true);
                        MainToolsView.this.response_text.setEnabled(true);
                        MainToolsView.this.btnSendCommand.setEnabled(true);
                        MainToolsView.this.btnSaveResponseText.setEnabled(true);
                        if (MainToolsView.this.comm_io.isByteStream()) {
                            MainToolsView.this.com_worker_state = 1;
                            MainToolsView.this.com_worker = new Thread(){

                                @Override
                                public void run() {
                                    byte[] rbuf = new byte[1024];
                                    while ((this).MainToolsView.this.com_worker_state == 1) {
                                        int num = (this).MainToolsView.this.comm_io.read(rbuf, rbuf.length);
                                        if (num <= 0) continue;
                                        final String s = new String(rbuf, 0, num, StandardCharsets.UTF_8);
                                        (this).MainToolsView.this.display.asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                String p = MainToolsView.this.response_text.getText();
                                                MainToolsView.this.response_text.setText(String.valueOf(p) + s);
                                            }
                                        });
                                    }
                                    (this).MainToolsView.this.com_worker_state = 3;
                                }
                            };
                            MainToolsView.this.com_worker.start();
                        }
                    } else {
                        MainToolsView.this.label_interface_error.setText("Cannot open");
                        MainToolsView.this.label_interface_error.setVisible(true);
                    }
                } else {
                    if (MainToolsView.this.comm_io.isByteStream()) {
                        MainToolsView.this.com_worker_state = 2;
                        try {
                            MainToolsView.this.com_worker.join();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    MainToolsView.this.comm_io.close();
                    MainToolsView.this.comm_io = null;
                    MainToolsView.this.label_interface_error.setVisible(false);
                    MainToolsView.this.btnConnect.setText("Connect");
                    MainToolsView.this.btnSendCommand.setEnabled(false);
                    MainToolsView.this.btnSaveResponseText.setEnabled(false);
                    MainToolsView.this.btnRS232.setEnabled(true);
                    MainToolsView.this.btnEthernet.setEnabled(true);
                    MainToolsView.this.btnUsb.setEnabled(true);
                    MainToolsView.this.btnGpib.setEnabled(true);
                    switch (MainToolsView.this.interface_type) {
                        case physical_rs232: {
                            MainToolsView.this.combo_com_ports.setVisible(true);
                            MainToolsView.this.combo_baud_rate.setVisible(true);
                            break;
                        }
                        case physical_ethernet: {
                            MainToolsView.this.ip_address.setVisible(true);
                            break;
                        }
                        case physical_usb: {
                            MainToolsView.this.combo_usb_devices.setVisible(true);
                            break;
                        }
                        case physical_gpib: {
                            MainToolsView.this.lblGpibController.setVisible(true);
                            MainToolsView.this.lblGpibAddress.setVisible(true);
                            MainToolsView.this.spinnerGpibController.setVisible(true);
                            MainToolsView.this.spinnerGpibAddress.setVisible(true);
                        }
                    }
                }
            }
        });
        Label label = new Label((Composite)grpCommandresponseTool, 258);
        label.setBounds(10, 145, 555, 9);
        this.command_text = new Text((Composite)grpCommandresponseTool, 2048);
        this.command_text.setBackground(SWTResourceManager.getColor(240, 240, 240));
        this.command_text.setBounds(21, 161, 463, 21);
        this.command_text.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                String data;
                e.doit = false;
                int k = e.stateMask + e.keyCode;
                if (k == 13 && (data = MainToolsView.this.command_text.getText()) != "") {
                    String resp;
                    int r = MainToolsView.this.comm_io.sendCommand(data);
                    if (r != 0) {
                        MessageBox ed = new MessageBox(parent.getShell(), 33);
                        ed.setText("Error");
                        ed.setMessage("Cannot write.");
                        ed.open();
                    } else if (!MainToolsView.this.comm_io.isByteStream() && data.indexOf(63) != -1 && (resp = MainToolsView.this.comm_io.getResponse(100)) != null) {
                        String p = MainToolsView.this.response_text.getText();
                        MainToolsView.this.response_text.setText(String.valueOf(p) + resp + "\r\n");
                    }
                }
            }
        });
        this.command_text.setEnabled(false);
        this.btnSendCommand = new Button((Composite)grpCommandresponseTool, 0);
        this.btnSendCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnSendCommand.setEnabled(false);
        this.btnSendCommand.setBounds(490, 159, 75, 25);
        this.btnSendCommand.setText("Send");
        this.btnSendCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String data = MainToolsView.this.command_text.getText();
                if (data != "") {
                    String resp;
                    int r = MainToolsView.this.comm_io.sendCommand(data);
                    if (r != 0) {
                        MessageBox ed = new MessageBox(parent.getShell(), 33);
                        ed.setText("Error");
                        ed.setMessage("Cannot write.");
                        ed.open();
                    } else if (!MainToolsView.this.comm_io.isByteStream() && data.indexOf(63) != -1 && (resp = MainToolsView.this.comm_io.getResponse(100)) != null) {
                        String p = MainToolsView.this.response_text.getText();
                        MainToolsView.this.response_text.setText(String.valueOf(p) + resp + "\r\n");
                    }
                }
            }
        });
        this.response_text = new Text((Composite)grpCommandresponseTool, 520);
        this.response_text.setBackground(SWTResourceManager.getColor(240, 240, 240));
        this.response_text.setBounds(21, 195, 463, 223);
        this.response_text.setEnabled(false);
        this.btnSaveResponseText = new Button((Composite)grpCommandresponseTool, 64);
        this.btnSaveResponseText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.txt", "*.*"});
                dialog.setFileName("response.txt");
                dialog.setOverwrite(true);
                String save_path = dialog.open();
                if (save_path != null) {
                    try {
                        FileWriter writer = new FileWriter(save_path, false);
                        writer.write(MainToolsView.this.response_text.getText());
                        writer.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.btnSaveResponseText.setEnabled(false);
        this.btnSaveResponseText.setBounds(490, 257, 75, 93);
        this.btnSaveResponseText.setText("Save\nResponse\nText");
        if (!UserSettings.permissions.run_the_command_response_tool) {
            grpCommandresponseTool.setEnabled(false);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                System.out.println("tools disposing");
                if (MainToolsView.this.comm_io != null) {
                    if (MainToolsView.this.comm_io.isByteStream()) {
                        MainToolsView.this.com_worker_state = 2;
                        try {
                            MainToolsView.this.com_worker.join();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    MainToolsView.this.comm_io.close();
                    MainToolsView.this.comm_io = null;
                }
            }
        });
    }

    protected void checkSubclass() {
    }
}

