/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class MainSequencesView
extends Composite {
    Display display;
    String config_name;
    SystemConfiguration system_configuration;
    private String[] sequence_names;
    Table tableSequenceList;
    Label lblBusyWorking;
    TestSequence sequence;
    Composite composite_0;
    Composite composite_1;
    Composite composite_2;
    Composite composite_3;
    private Table tableSteps;
    Composite groupStepSettings;
    TestStep working_step;
    int working_index;
    Composite step_editor;
    Composite tester_settings_editor;
    Composite dut_settings_editor;
    Composite report_settings_editor;
    Combo comboStepTypes;
    int active_tab;

    private void loadConfiguration() {
        if (!UserSettings.configuration_name.isEmpty()) {
            this.config_name = UserSettings.configuration_name;
            this.system_configuration = SystemConfiguration.load(this.config_name);
        } else {
            String[] config_names = SystemConfiguration.getNames();
            if (config_names.length > 0) {
                this.config_name = config_names[0];
                this.system_configuration = SystemConfiguration.load(this.config_name);
            } else {
                this.config_name = "";
                this.system_configuration = new SystemConfiguration();
            }
        }
        if (this.config_name.isEmpty()) {
            this.system_configuration = new SystemConfiguration();
            this.config_name = "<default>";
        } else {
            this.system_configuration = SystemConfiguration.load(this.config_name);
        }
        if (!this.system_configuration.use_switches) {
            this.system_configuration.num_switches = 0;
            this.system_configuration.switches[0].model = "";
        }
    }

    private void loadSequence(String name) {
        TestStep step;
        if (this.working_step != null) {
            this.step_editor.dispose();
        }
        this.working_step = null;
        this.working_index = 0;
        this.step_editor = null;
        this.tableSteps.removeAll();
        if (this.tester_settings_editor != null) {
            this.tester_settings_editor.dispose();
        }
        if (this.dut_settings_editor != null) {
            this.dut_settings_editor.dispose();
        }
        if (this.report_settings_editor != null) {
            this.report_settings_editor.dispose();
        }
        this.tester_settings_editor = null;
        this.dut_settings_editor = null;
        this.report_settings_editor = null;
        if (name.isEmpty()) {
            this.sequence = new TestSequence(this.system_configuration.series, this.system_configuration.switches[0].model, this.system_configuration.num_switches);
        } else if (TestSequence.valid(name, this.system_configuration.series)) {
            this.sequence = TestSequence.load(name, this.system_configuration);
            UserSettings.test_name = name;
        } else {
            this.sequence = new TestSequence(this.system_configuration.series, this.system_configuration.switches[0].model, this.system_configuration.num_switches);
        }
        int sid = 0;
        while ((step = this.sequence.getStep(sid)) != null) {
            TableItem n_item = new TableItem(this.tableSteps, 0);
            n_item.setText(new String[]{"#" + (sid + 1), step.getName()});
            ++sid;
        }
        this.comboStepTypes.setItems(this.sequence.getStepTypes());
        this.working_step = this.sequence.getStep(0);
        if (this.working_step != null) {
            this.tableSteps.setSelection(0);
            this.comboStepTypes.setText(this.working_step.getType());
            this.step_editor = this.working_step.editor(this.groupStepSettings, this.sequence.tester_settings);
            this.step_editor.setBounds(4, 10, 550, 326);
        } else {
            this.comboStepTypes.setText("");
        }
        this.tester_settings_editor = this.sequence.tester_settings.editor(this.composite_1);
        this.tester_settings_editor.setBounds(4, 10, 550, 326);
        this.dut_settings_editor = this.sequence.dut_settings.editor(this.composite_2, this.sequence.loaded_name);
        this.dut_settings_editor.setBounds(4, 5, 745, 430);
        this.report_settings_editor = this.sequence.report_settings.editor(this.composite_3);
        this.report_settings_editor.setBounds(4, 5, 745, 430);
    }

    private void fetchActiveTabWidgets() {
        switch (this.active_tab) {
            case 0: {
                if (this.working_step == null) break;
                this.working_step.fetch();
                this.sequence.cacheStep(this.working_step);
                TableItem item = this.tableSteps.getItem(this.working_index);
                item.setText(new String[]{"#" + (this.working_index + 1), this.working_step.getName()});
                System.out.println("tab-step:" + this.working_step.toString());
                System.out.println("add:" + this.working_step.addStep(this.sequence.tester_settings, this.sequence.tester));
                break;
            }
            case 1: {
                this.sequence.tester_settings.fetch();
                System.out.println("Instrument:" + this.sequence.tester_settings.toString());
                break;
            }
            case 2: {
                this.sequence.dut_settings.fetch();
                System.out.println("DUT:" + this.sequence.dut_settings.toString());
                break;
            }
            case 3: {
                this.sequence.report_settings.fetch();
                System.out.println("RPT:" + this.sequence.report_settings.toString());
            }
        }
    }

    private String saveAs(TestSequence to_save, Shell sh) {
        String the_name = null;
        ConfigurationPromptName dialog = new ConfigurationPromptName(sh);
        if (dialog.open() == 32) {
            String name = dialog.getName();
            if (name != "") {
                int ii = Utils.indexOf(this.sequence_names, name);
                if (ii == -1) {
                    int r = to_save.saveAs(name);
                    if (r != 0) {
                        MessageBox ed = new MessageBox(sh, 33);
                        ed.setText("Error");
                        ed.setMessage("Cannot save.");
                        ed.open();
                    } else {
                        the_name = name;
                        UserSettings.test_name = name;
                        this.sequence_names = TestSequence.getNames(this.system_configuration.series);
                        this.tableSequenceList.removeAll();
                        String[] stringArray = this.sequence_names;
                        int n = this.sequence_names.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String c = stringArray[n2];
                            TableItem n_item = new TableItem(this.tableSequenceList, 0);
                            n_item.setText(c);
                            ++n2;
                        }
                        ii = Utils.indexOf(this.sequence_names, to_save.loaded_name);
                        this.tableSequenceList.setSelection(ii);
                    }
                } else {
                    MessageBox ed = new MessageBox(sh, 40);
                    ed.setText("Information");
                    ed.setMessage("The sequence name already exists.");
                    ed.open();
                }
            } else {
                MessageBox ed = new MessageBox(sh, 40);
                ed.setText("Information");
                ed.setMessage("Cannot have a sequence without a name.");
                ed.open();
            }
        }
        dialog.close();
        return the_name;
    }

    public MainSequencesView(final Composite parent, int style) {
        super(parent, style);
        this.display = parent.getDisplay();
        this.loadConfiguration();
        this.working_step = null;
        this.working_index = 0;
        this.sequence_names = TestSequence.getNames(this.system_configuration.series);
        Group groupLabelConfiguration = new Group((Composite)this, 0);
        groupLabelConfiguration.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupLabelConfiguration.setBackground(SWTResourceManager.getColor(192, 192, 192));
        groupLabelConfiguration.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        groupLabelConfiguration.setText("Configuration");
        groupLabelConfiguration.setBounds(0, 0, 233, 64);
        Label lblConfiguration = new Label((Composite)groupLabelConfiguration, 0);
        lblConfiguration.setFont(SWTResourceManager.getFont("Arial", 11, 2));
        lblConfiguration.setBounds(10, 28, 157, 23);
        lblConfiguration.setText(String.valueOf(this.config_name) + " (" + this.system_configuration.series + ")");
        Group groupSequenceList = new Group((Composite)this, 0);
        groupSequenceList.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        groupSequenceList.setText("Sequences");
        groupSequenceList.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupSequenceList.setBackground(SWTResourceManager.getColor(192, 192, 192));
        groupSequenceList.setBounds(0, 70, 233, 380);
        this.tableSequenceList = new Table((Composite)groupSequenceList, 68112);
        this.tableSequenceList.setBounds(5, 30, 160, 241);
        this.tableSequenceList.setLinesVisible(true);
        TableColumn tblclmnNewColumn = new TableColumn(this.tableSequenceList, 0);
        tblclmnNewColumn.setWidth(160);
        this.tableSequenceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = MainSequencesView.this.tableSequenceList.getSelectionIndex();
                if (si != -1 && !MainSequencesView.this.sequence.loaded_name.equals(MainSequencesView.this.sequence_names[si])) {
                    MainSequencesView.this.loadSequence(MainSequencesView.this.sequence_names[si]);
                }
            }
        });
        String[] stringArray = this.sequence_names;
        int n = this.sequence_names.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            TableItem n_item = new TableItem(this.tableSequenceList, 0);
            n_item.setText(c);
            ++n2;
        }
        Button btnNew = new Button((Composite)groupSequenceList, 0);
        btnNew.setText("New");
        btnNew.setBounds(170, 30, 60, 25);
        btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainSequencesView.this.loadSequence("");
                MainSequencesView.this.tableSequenceList.deselectAll();
            }
        });
        Button btnSave = new Button((Composite)groupSequenceList, 0);
        btnSave.setText("Save");
        btnSave.setBounds(170, 61, 60, 25);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainSequencesView.this.fetchActiveTabWidgets();
                if (MainSequencesView.this.sequence.loaded_name.isEmpty()) {
                    MainSequencesView.this.saveAs(MainSequencesView.this.sequence, parent.getShell());
                } else {
                    MainSequencesView.this.sequence.save();
                }
            }
        });
        Button btnSaveAs = new Button((Composite)groupSequenceList, 0);
        btnSaveAs.setBounds(170, 91, 60, 25);
        btnSaveAs.setText("Save As");
        btnSaveAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainSequencesView.this.fetchActiveTabWidgets();
                String nn = MainSequencesView.this.saveAs(MainSequencesView.this.sequence, parent.getShell());
                if (nn != null && MainSequencesView.this.active_tab == 2) {
                    if (MainSequencesView.this.dut_settings_editor != null) {
                        MainSequencesView.this.dut_settings_editor.dispose();
                    }
                    MainSequencesView.this.dut_settings_editor = MainSequencesView.this.sequence.dut_settings.editor(MainSequencesView.this.composite_2, MainSequencesView.this.sequence.loaded_name);
                    MainSequencesView.this.dut_settings_editor.setBounds(4, 5, 745, 430);
                }
            }
        });
        Button btnDelete = new Button((Composite)groupSequenceList, 0);
        btnDelete.setBounds(170, 122, 60, 25);
        btnDelete.setText("Delete");
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainSequencesView.this.sequence.delete();
                MainSequencesView.this.sequence_names = TestSequence.getNames(MainSequencesView.this.system_configuration.series);
                MainSequencesView.this.tableSequenceList.removeAll();
                String[] stringArray = MainSequencesView.this.sequence_names;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    TableItem n_item = new TableItem(MainSequencesView.this.tableSequenceList, 0);
                    n_item.setText(c);
                    ++n2;
                }
                if (MainSequencesView.this.sequence_names.length > 0) {
                    MainSequencesView.this.tableSequenceList.setSelection(0);
                    MainSequencesView.this.loadSequence(MainSequencesView.this.sequence_names[0]);
                } else {
                    MainSequencesView.this.loadSequence("");
                }
            }
        });
        Button btnPrint = new Button((Composite)groupSequenceList, 0);
        btnPrint.setBounds(170, 153, 60, 25);
        btnPrint.setText("Print");
        btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainSequencesView.this.fetchActiveTabWidgets();
                MainSequencesView.this.sequence.print(parent);
            }
        });
        Button btnImport = new Button((Composite)groupSequenceList, 0);
        btnImport.setText("Import");
        btnImport.setBounds(170, 184, 60, 25);
        btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String n;
                TestSequence seq = TestSequence.Import(parent, MainSequencesView.this.system_configuration.switches[0].model, MainSequencesView.this.system_configuration.num_switches, MainSequencesView.this.system_configuration.switch_control);
                if (seq != null && (n = MainSequencesView.this.saveAs(seq, parent.getShell())) != null) {
                    MainSequencesView.this.loadSequence(n);
                }
            }
        });
        Button btnExport = new Button((Composite)groupSequenceList, 0);
        btnExport.setText("Export");
        btnExport.setBounds(170, 215, 60, 25);
        btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainSequencesView.this.fetchActiveTabWidgets();
                MainSequencesView.this.sequence.export(parent);
            }
        });
        this.lblBusyWorking = new Label((Composite)groupSequenceList, 0);
        this.lblBusyWorking.setBounds(76, 290, 70, 70);
        this.lblBusyWorking.setVisible(false);
        this.active_tab = 0;
        final TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.setForeground(SWTResourceManager.getColor(0, 121, 193));
        tabFolder.setBackground(SWTResourceManager.getColor(192, 192, 192));
        tabFolder.setBounds(239, 0, 755, 450);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.stateMask != 0) {
                    MainSequencesView.this.fetchActiveTabWidgets();
                    switch (tabFolder.getSelectionIndex()) {
                        case 0: {
                            if (MainSequencesView.this.working_step != null) {
                                MainSequencesView.this.step_editor.dispose();
                                MainSequencesView.this.step_editor = MainSequencesView.this.working_step.editor(MainSequencesView.this.groupStepSettings, MainSequencesView.this.sequence.tester_settings);
                                MainSequencesView.this.step_editor.setBounds(4, 10, 550, 326);
                            }
                            MainSequencesView.this.active_tab = 0;
                            break;
                        }
                        case 1: {
                            MainSequencesView.this.active_tab = 1;
                            break;
                        }
                        case 2: {
                            MainSequencesView.this.active_tab = 2;
                            break;
                        }
                        case 3: {
                            MainSequencesView.this.active_tab = 3;
                        }
                    }
                }
            }
        });
        TabItem tbtmSteps = new TabItem(tabFolder, 0);
        tbtmSteps.setText("Steps");
        this.composite_0 = new Composite((Composite)tabFolder, 0);
        this.composite_0.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.composite_0.setBackground(SWTResourceManager.getColor(192, 192, 192));
        tbtmSteps.setControl((Control)this.composite_0);
        Group groupStepList = new Group(this.composite_0, 0);
        groupStepList.setBounds(10, 0, 162, 402);
        groupStepList.setText("Steps");
        groupStepList.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupStepList.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        groupStepList.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.tableSteps = new Table((Composite)groupStepList, 68112);
        this.tableSteps.setBounds(10, 25, 142, 367);
        this.tableSteps.setForeground(SWTResourceManager.getColor(0, 0, 0));
        this.tableSteps.setLinesVisible(true);
        TableColumn tblColStepNum = new TableColumn(this.tableSteps, 0);
        tblColStepNum.setWidth(38);
        tblColStepNum.setText("#");
        TableColumn tblColStepInfo = new TableColumn(this.tableSteps, 0);
        tblColStepInfo.setWidth(100);
        tblColStepInfo.setText("Steps");
        this.tableSteps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = MainSequencesView.this.tableSteps.getSelectionIndex();
                if (si != -1) {
                    if (MainSequencesView.this.working_step != null) {
                        MainSequencesView.this.working_step.fetch();
                        MainSequencesView.this.sequence.cacheStep(MainSequencesView.this.working_step);
                        TableItem item = MainSequencesView.this.tableSteps.getItem(MainSequencesView.this.working_index);
                        item.setText(new String[]{"#" + (MainSequencesView.this.working_index + 1), MainSequencesView.this.working_step.getName()});
                        System.out.println("sel-step-fetch:" + MainSequencesView.this.working_step.toString());
                        MainSequencesView.this.step_editor.dispose();
                    }
                    MainSequencesView.this.working_step = MainSequencesView.this.sequence.getStep(si);
                    MainSequencesView.this.working_index = si;
                    System.out.println("step[" + si + "]" + MainSequencesView.this.working_step.toString());
                    MainSequencesView.this.comboStepTypes.setText(MainSequencesView.this.working_step.getType());
                    MainSequencesView.this.step_editor = MainSequencesView.this.working_step.editor(MainSequencesView.this.groupStepSettings, MainSequencesView.this.sequence.tester_settings);
                    MainSequencesView.this.step_editor.setBounds(4, 10, 550, 326);
                }
            }
        });
        this.groupStepSettings = new Composite(this.composite_0, 0);
        this.groupStepSettings.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupStepSettings.setBounds(178, 62, 560, 340);
        Group group = new Group(this.composite_0, 0);
        group.setBounds(178, 5, 560, 52);
        this.comboStepTypes = new Combo((Composite)group, 0);
        this.comboStepTypes.setBounds(21, 19, 91, 23);
        this.comboStepTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String name;
                if (event.stateMask == 0 && !(name = MainSequencesView.this.comboStepTypes.getText()).isEmpty()) {
                    if (MainSequencesView.this.working_step != null) {
                        MainSequencesView.this.working_step.fetch();
                        MainSequencesView.this.sequence.cacheStep(MainSequencesView.this.working_step);
                        MainSequencesView.this.step_editor.dispose();
                        MainSequencesView.this.working_step = MainSequencesView.this.sequence.newStep(name);
                        MainSequencesView.this.sequence.replaceStep(MainSequencesView.this.working_index, MainSequencesView.this.working_step);
                        TableItem item = MainSequencesView.this.tableSteps.getItem(MainSequencesView.this.working_index);
                        item.setText(new String[]{"#" + (MainSequencesView.this.working_index + 1), name});
                    } else {
                        MainSequencesView.this.working_step = MainSequencesView.this.sequence.newStep(name);
                        MainSequencesView.this.working_index = MainSequencesView.this.sequence.addStep(MainSequencesView.this.working_step);
                        TableItem tableItem = new TableItem(MainSequencesView.this.tableSteps, 0);
                        tableItem.setText(new String[]{"#1", name});
                    }
                    System.out.println("combo:" + MainSequencesView.this.working_step.toString());
                    MainSequencesView.this.step_editor = MainSequencesView.this.working_step.editor(MainSequencesView.this.groupStepSettings, MainSequencesView.this.sequence.tester_settings);
                    MainSequencesView.this.step_editor.setBounds(4, 10, 550, 326);
                }
            }
        });
        Button btnNewStep = new Button((Composite)group, 0);
        btnNewStep.setBounds(148, 19, 75, 25);
        btnNewStep.setText("New");
        btnNewStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainSequencesView.this.working_step == null) {
                    MainSequencesView.this.working_step = MainSequencesView.this.sequence.newStep(MainSequencesView.this.comboStepTypes.getItems()[0]);
                    MainSequencesView.this.working_index = MainSequencesView.this.sequence.addStep(MainSequencesView.this.working_step);
                    MainSequencesView.this.comboStepTypes.setText(MainSequencesView.this.comboStepTypes.getItems()[0]);
                    TableItem tableItem = new TableItem(MainSequencesView.this.tableSteps, 0);
                    tableItem.setText(new String[]{"#1", MainSequencesView.this.comboStepTypes.getItems()[0]});
                } else {
                    MainSequencesView.this.working_step.fetch();
                    MainSequencesView.this.sequence.cacheStep(MainSequencesView.this.working_step);
                    MainSequencesView.this.step_editor.dispose();
                    TableItem item = MainSequencesView.this.tableSteps.getItem(MainSequencesView.this.working_index);
                    item.setText(new String[]{"#" + (MainSequencesView.this.working_index + 1), MainSequencesView.this.working_step.getName()});
                    MainSequencesView.this.working_step = MainSequencesView.this.sequence.copyStep(MainSequencesView.this.working_step);
                    MainSequencesView.this.working_index = MainSequencesView.this.sequence.addStep(MainSequencesView.this.working_step);
                    item = new TableItem(MainSequencesView.this.tableSteps, 0);
                    item.setText(new String[]{"#" + (MainSequencesView.this.working_index + 1), MainSequencesView.this.working_step.getName()});
                }
                MainSequencesView.this.tableSteps.setSelection(MainSequencesView.this.working_index);
                System.out.println("new-step:" + MainSequencesView.this.working_step.toString());
                MainSequencesView.this.step_editor = MainSequencesView.this.working_step.editor(MainSequencesView.this.groupStepSettings, MainSequencesView.this.sequence.tester_settings);
                MainSequencesView.this.step_editor.setBounds(4, 10, 550, 326);
            }
        });
        Button btnDeleteStep = new Button((Composite)group, 0);
        btnDeleteStep.setBounds(257, 17, 75, 25);
        btnDeleteStep.setText("Delete");
        btnDeleteStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = MainSequencesView.this.tableSteps.getSelectionIndex();
                if (si != -1) {
                    TestStep step;
                    if (MainSequencesView.this.working_step != null) {
                        MainSequencesView.this.step_editor.dispose();
                        MainSequencesView.this.step_editor = null;
                    }
                    MainSequencesView.this.sequence.deleteStep(MainSequencesView.this.working_step);
                    MainSequencesView.this.working_step = null;
                    MainSequencesView.this.tableSteps.removeAll();
                    int sid = 0;
                    while ((step = MainSequencesView.this.sequence.getStep(sid)) != null) {
                        TableItem n_item = new TableItem(MainSequencesView.this.tableSteps, 0);
                        n_item.setText(new String[]{"#" + (sid + 1), step.getName()});
                        ++sid;
                    }
                    if (MainSequencesView.this.sequence.num_steps > 0) {
                        if (MainSequencesView.this.working_index >= MainSequencesView.this.sequence.num_steps - 1) {
                            MainSequencesView.this.working_index = MainSequencesView.this.sequence.num_steps - 1;
                        }
                        MainSequencesView.this.working_step = MainSequencesView.this.sequence.getStep(MainSequencesView.this.working_index);
                        if (MainSequencesView.this.working_step != null) {
                            MainSequencesView.this.tableSteps.setSelection(MainSequencesView.this.working_index);
                            System.out.println("insert-step:" + MainSequencesView.this.working_step.toString());
                            MainSequencesView.this.step_editor = MainSequencesView.this.working_step.editor(MainSequencesView.this.groupStepSettings, MainSequencesView.this.sequence.tester_settings);
                            MainSequencesView.this.step_editor.setBounds(4, 10, 550, 326);
                        }
                    } else {
                        MainSequencesView.this.comboStepTypes.setText("");
                        MainSequencesView.this.working_index = 0;
                    }
                }
            }
        });
        Button btnInsertStep = new Button((Composite)group, 0);
        btnInsertStep.setBounds(356, 17, 75, 25);
        btnInsertStep.setText("Insert");
        btnInsertStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestStep step;
                if (MainSequencesView.this.working_step == null) {
                    MainSequencesView.this.working_step = MainSequencesView.this.sequence.newStep(MainSequencesView.this.comboStepTypes.getItems()[0]);
                    MainSequencesView.this.working_index = MainSequencesView.this.sequence.addStep(MainSequencesView.this.working_step);
                    MainSequencesView.this.comboStepTypes.setText(MainSequencesView.this.comboStepTypes.getItems()[0]);
                } else {
                    MainSequencesView.this.working_step.fetch();
                    MainSequencesView.this.sequence.cacheStep(MainSequencesView.this.working_step);
                    MainSequencesView.this.step_editor.dispose();
                    MainSequencesView.this.working_step = MainSequencesView.this.sequence.copyStep(MainSequencesView.this.working_step);
                    ++MainSequencesView.this.working_index;
                    MainSequencesView.this.sequence.insertStep(MainSequencesView.this.working_index, MainSequencesView.this.working_step);
                }
                MainSequencesView.this.tableSteps.removeAll();
                int sid = 0;
                while ((step = MainSequencesView.this.sequence.getStep(sid)) != null) {
                    TableItem n_item = new TableItem(MainSequencesView.this.tableSteps, 0);
                    n_item.setText(new String[]{"#" + (sid + 1), step.getName()});
                    ++sid;
                }
                MainSequencesView.this.tableSteps.setSelection(MainSequencesView.this.working_index);
                System.out.println("insert-step:" + MainSequencesView.this.working_step.toString());
                MainSequencesView.this.step_editor = MainSequencesView.this.working_step.editor(MainSequencesView.this.groupStepSettings, MainSequencesView.this.sequence.tester_settings);
                MainSequencesView.this.step_editor.setBounds(4, 10, 550, 326);
            }
        });
        TabItem tbtmInstrument = new TabItem(tabFolder, 0);
        tbtmInstrument.setText("Instrument");
        this.composite_1 = new Composite((Composite)tabFolder, 0);
        tbtmInstrument.setControl((Control)this.composite_1);
        TabItem tbtmDut = new TabItem(tabFolder, 0);
        tbtmDut.setText("DUT");
        this.composite_2 = new Composite((Composite)tabFolder, 0);
        tbtmDut.setControl((Control)this.composite_2);
        TabItem tbtmReporting = new TabItem(tabFolder, 0);
        tbtmReporting.setText("Reporting");
        this.composite_3 = new Composite((Composite)tabFolder, 0);
        tbtmReporting.setControl((Control)this.composite_3);
        if (!UserSettings.test_name.isEmpty()) {
            this.loadSequence(UserSettings.test_name);
        } else if (this.sequence_names.length > 0) {
            this.loadSequence(this.sequence_names[0]);
        } else {
            this.loadSequence("");
        }
        if (!this.sequence.loaded_name.isEmpty()) {
            int ii = Utils.indexOf(this.sequence_names, this.sequence.loaded_name);
            this.tableSequenceList.setSelection(ii);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                System.out.println("run disposed");
                BusySpinner.stop(true);
            }
        });
    }

    protected void checkSubclass() {
    }
}

