/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.wb.swt.SWTResourceManager;

public class MainRunView
extends Composite {
    Display display;
    Color passColor = SWTResourceManager.getColor(51, 170, 51);
    Color failColor = SWTResourceManager.getColor(255, 51, 51);
    SystemConfiguration system_configuration;
    Label lblConfiguration;
    Label lblTesterIdn;
    String tester_model;
    String tester_sn;
    String tester_firmware;
    Combo comboSequenceList;
    private String[] sequence_names;
    TestSequence sequence;
    Button btnCheckFastRestart;
    boolean fast_restart;
    private Table tableStepList;
    private boolean sequence_switching_valid;
    Random rgen;
    String sequence_key;
    private Text textDutModel;
    private Text textDutSerialNumber;
    private Text textNotes;
    String dut_model;
    String dut_serial_number;
    String user_notes;
    Button btnRunUntilFail;
    boolean run_until_fail;
    Label lblConnecting;
    Label lblStartButton;
    Label lblStopButton;
    Label lblConectionError;
    Label lblKeyError;
    private Button btnContinue;
    Label lblBusyWorking;
    ProgressBar progressBarSequence;
    ProgressBar progressBarStep;
    Label lblSequenceProgress;
    Label lblProgramActivity;
    Label lblStepProgress;
    Label lblSequenceResult;
    Label lblStepResult;
    Group grpSequenceErrors;
    Label lblSequenceErrors;
    Button btnExportChartData;
    Group groupMetric1;
    Group groupMetric2;
    Group groupMetric3;
    Label lblMetricValue1;
    Label lblMetricValue2;
    Label lblMetricValue3;
    Composite compChart1;
    Composite compChart2;
    Composite compChart3;
    MetricDisplay[] metricDisplays;
    Color[] chartLineColors;
    Label lblInfoText;
    Label lblInfoGraphic;
    Button btnSaveCsv;
    Button btnSavePdf;
    Button btnPrint;
    Interface tester_io;
    Interface[] switch_io;
    Thread run_sequence_worker;
    volatile worker_state_t sequence_worker_state = worker_state_t.worker_state_NONE;
    volatile boolean sequence_loading;
    volatile boolean sequence_loading_acknowledged;
    volatile boolean sequence_running;
    volatile boolean signal_start;
    volatile boolean signal_continue;
    volatile boolean signal_abort;
    SequenceResults results;
    int working_step_index;

    private void displayStepResults(int index) {
        boolean have_charts = false;
        TestStep step = this.sequence.getStep(index);
        if (step == null) {
            return;
        }
        this.working_step_index = index;
        String[][] labels = step.labels();
        if (this.results.step_results[index].status == 0) {
            this.lblStepResult.setText("Step Passed");
            this.lblStepResult.setForeground(this.passColor);
        } else if ((this.results.step_results[index].status & 0x40000000) != 0) {
            this.lblStepResult.setText("Not Run");
            this.lblStepResult.setForeground(this.failColor);
            labels = null;
        } else {
            String[] errs = this.sequence.tester.decodeStatusFlags(this.results.step_results[index].status);
            this.lblStepResult.setText(errs[0]);
            this.lblStepResult.setForeground(this.failColor);
        }
        int m = 0;
        if (labels != null && this.results.step_results[index].final_metrics != null) {
            m = 0;
            while (m < labels.length) {
                this.metricDisplays[m].group.setText(labels[m][0]);
                String vd = SiTools.toString(this.results.step_results[index].final_metrics[m], labels[m][2]);
                this.metricDisplays[m].value.setText(vd);
                this.metricDisplays[m].group.setVisible(true);
                this.metricDisplays[m].chart.getAxisSet().getYAxis(0).getTitle().setText(labels[m][1]);
                if (this.results.step_results[index].chart_data[m].length > 0) {
                    have_charts = true;
                    double[] chart_data = new double[this.results.step_results[index].chart_data[m].length];
                    int i = 0;
                    while (i < chart_data.length) {
                        chart_data[i] = this.results.step_results[index].chart_data[m][i];
                        ++i;
                    }
                    ISeries isr = this.metricDisplays[m].chart.getSeriesSet().getSeries("series");
                    isr.setYSeries(chart_data);
                    this.metricDisplays[m].chart.getAxisSet().adjustRange();
                    this.metricDisplays[m].chart.redraw();
                    this.metricDisplays[m].comp.setVisible(true);
                    this.metricDisplays[m].chart.setVisible(true);
                    this.metricDisplays[m].data = new double[0];
                } else {
                    this.metricDisplays[m].comp.setVisible(false);
                    this.metricDisplays[m].chart.setVisible(false);
                }
                ++m;
            }
        }
        while (m < 3) {
            this.metricDisplays[m].group.setVisible(false);
            this.metricDisplays[m].comp.setVisible(false);
            this.metricDisplays[m].chart.setVisible(false);
            ++m;
        }
        if (have_charts) {
            this.btnExportChartData.setVisible(true);
        } else {
            this.btnExportChartData.setVisible(false);
        }
    }

    private int sendTestSequence() {
        int status = -1;
        boolean load_it = true;
        if (this.fast_restart && !this.sequence_key.isEmpty()) {
            this.tester_io.sendCommand("name?");
            String n = this.tester_io.getResponse(100);
            if (n != null && this.sequence_key.equals(n)) {
                load_it = false;
            }
        }
        if (!load_it) {
            return 0;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MainRunView.this.progressBarSequence.setMaximum(MainRunView.this.sequence.num_steps + 2);
                MainRunView.this.progressBarSequence.setSelection(1);
            }
        });
        String cmd = this.sequence.tester_settings.configurationCommands();
        System.out.println(cmd);
        this.tester_io.sendCommand(cmd);
        this.tester_io.sendCommand("*err?");
        String r = this.tester_io.getResponse(100);
        if (r != null) {
            status = Integer.valueOf(r);
        }
        if (status != 0) {
            final String err = "Configuration error: " + this.sequence.tester.strerror(status);
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.progressBarSequence.setState(1);
                    MainRunView.this.lblProgramActivity.setText(err);
                }
            });
            return -1;
        }
        String swcmd = this.sequence.tester.configureSwitches(this.system_configuration);
        if (!swcmd.isEmpty()) {
            System.out.println(swcmd);
            this.tester_io.sendCommand(swcmd);
        }
        cmd = this.sequence.tester.clearSequence();
        System.out.println(cmd);
        this.tester_io.sendCommand(cmd);
        int step_err = 0;
        int step_num = 0;
        while (step_num < this.sequence.num_steps) {
            final int p = step_num + 1;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.progressBarSequence.setSelection(p);
                }
            });
            step_err = this.sequence.sendStep(this.tester_io, step_num);
            if (step_err != 0) break;
            ++step_num;
        }
        if (step_err == 0) {
            status = 0;
            final int pf = this.sequence.num_steps + 2;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.progressBarSequence.setSelection(pf);
                }
            });
        } else {
            status = -1;
            final String err = "Error on step #" + (step_num + 1) + ":" + this.sequence.tester.strerror(step_err);
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.progressBarSequence.setState(1);
                    MainRunView.this.lblProgramActivity.setText(err);
                }
            });
        }
        if (status == 0) {
            int k = this.rgen.nextInt(100000) + 100000;
            this.sequence_key = String.format("R%06d", k);
            System.out.println("name," + this.sequence_key);
            this.tester_io.sendCommand("name," + this.sequence_key);
        }
        return status;
    }

    private void updateRunningMeasurements(int step, String[][] labels, float[] values) {
        if (labels != null && values != null) {
            int m = 0;
            while (m < labels.length) {
                String vd = SiTools.toString(values[m], labels[m][2]);
                this.metricDisplays[m].value.setText(vd);
                this.results.step_results[step].chart_data[m] = ArrayUtils.add((float[])this.results.step_results[step].chart_data[m], (float)values[m]);
                this.metricDisplays[m].data = ArrayUtils.add((double[])this.metricDisplays[m].data, (double)values[m]);
                if (this.metricDisplays[m].data.length > 2) {
                    ISeries isr = this.metricDisplays[m].chart.getSeriesSet().getSeries("series");
                    isr.setYSeries(this.metricDisplays[m].data);
                    this.metricDisplays[m].chart.getAxisSet().adjustRange();
                    this.metricDisplays[m].chart.redraw();
                }
                ++m;
            }
        }
    }

    private int executeTestSequence() {
        int complete = 0;
        boolean running = false;
        this.results = new SequenceResults(this.sequence, this.tester_model, this.tester_sn, this.tester_firmware, this.dut_model, this.dut_serial_number, this.user_notes, this.sequence.report_settings.banner);
        this.sequence_running = true;
        this.tester_io.sendCommand(this.sequence.tester.runSequence());
        long step_start_time = System.currentTimeMillis() + 1000L;
        do {
            int rs;
            this.tester_io.sendCommand("run?");
            String r = this.tester_io.getResponse(100);
            if (r == null || (rs = Integer.valueOf(r).intValue()) == 0) continue;
            running = true;
            break;
        } while (step_start_time > System.currentTimeMillis());
        int step_ii = 0;
        while (step_ii < this.sequence.num_steps && running && !this.signal_abort) {
            this.results.step_results[step_ii].status = 0;
            step_start_time = System.currentTimeMillis();
            final TestStep step = this.sequence.getStep(step_ii);
            if (step == null) break;
            final String[][] labels = step.labels();
            final String msg = "#" + (step_ii + 1) + " " + step.stepSummary();
            final int progress = step_ii + 1;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TestStep.StepInfo info;
                    if (step.needsContinue()) {
                        MainRunView.this.btnContinue.setVisible(true);
                    } else {
                        MainRunView.this.btnContinue.setVisible(false);
                    }
                    MainRunView.this.lblInfoText.setVisible(false);
                    MainRunView.this.lblInfoGraphic.setVisible(false);
                    MainRunView.this.tableStepList.setSelection(progress - 1);
                    MainRunView.this.lblProgramActivity.setText(msg);
                    MainRunView.this.progressBarSequence.setSelection(progress);
                    MainRunView.this.progressBarStep.setSelection(0);
                    double[] fake_data = new double[]{0.0, 0.0};
                    int m = 0;
                    if (labels != null) {
                        m = 0;
                        while (m < labels.length) {
                            MainRunView.this.metricDisplays[m].group.setText(labels[m][0]);
                            MainRunView.this.metricDisplays[m].value.setText(labels[m][2]);
                            MainRunView.this.metricDisplays[m].group.setVisible(true);
                            MainRunView.this.metricDisplays[m].chart.getAxisSet().getYAxis(0).getTitle().setText(labels[m][1]);
                            ISeries isr = MainRunView.this.metricDisplays[m].chart.getSeriesSet().getSeries("series");
                            isr.setYSeries(fake_data);
                            MainRunView.this.metricDisplays[m].chart.getAxisSet().adjustRange();
                            MainRunView.this.metricDisplays[m].chart.redraw();
                            MainRunView.this.metricDisplays[m].comp.setVisible(true);
                            MainRunView.this.metricDisplays[m].chart.setVisible(true);
                            MainRunView.this.metricDisplays[m].data = new double[0];
                            ++m;
                        }
                    }
                    while (m < 3) {
                        MainRunView.this.metricDisplays[m].group.setVisible(false);
                        MainRunView.this.metricDisplays[m].comp.setVisible(false);
                        MainRunView.this.metricDisplays[m].chart.setVisible(false);
                        ++m;
                    }
                    if (labels == null && (info = step.information()) != null) {
                        if (!info.paragraph.isEmpty()) {
                            MainRunView.this.lblInfoText.setText(info.paragraph);
                            MainRunView.this.lblInfoText.setVisible(true);
                        }
                        if (info.image != null) {
                            ImageTools.draw(MainRunView.this.lblInfoGraphic, info.image);
                            MainRunView.this.lblInfoGraphic.setVisible(true);
                        }
                    }
                }
            });
            while (!this.signal_abort) {
                if (this.signal_continue) {
                    this.signal_continue = false;
                    this.tester_io.sendCommand(this.sequence.tester.continueSequence());
                }
                long ms_t1 = System.currentTimeMillis();
                TestStep.StepStatus s = step.monitor(this.tester_io, step_start_time);
                if (s.status == TestStep.step_status_t.error) {
                    System.out.println("error on " + (step_ii + 1) + " at " + (System.currentTimeMillis() - step_start_time));
                    this.signal_abort = true;
                    running = false;
                    break;
                }
                if (s.status == TestStep.step_status_t.done) {
                    System.out.println("done " + (step_ii + 1) + " at " + (System.currentTimeMillis() - step_start_time));
                    running = false;
                    break;
                }
                if (s.progress >= 100) {
                    System.out.println("next " + (step_ii + 1) + " at " + (System.currentTimeMillis() - step_start_time));
                    break;
                }
                final int step_num = step_ii;
                final int sp = s.progress;
                final TestStep.StepStatus fs = s;
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MainRunView.this.progressBarStep.setSelection(sp);
                        MainRunView.this.updateRunningMeasurements(step_num, labels, fs.metrics);
                    }
                });
                long ms_int = System.currentTimeMillis() - ms_t1;
                if (ms_int >= 50L) continue;
                try {
                    Thread.sleep(50L - ms_int);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.btnContinue.setVisible(false);
                    MainRunView.this.lblInfoText.setVisible(false);
                    MainRunView.this.lblInfoGraphic.setVisible(false);
                }
            });
            ++step_ii;
        }
        this.sequence_running = false;
        this.signal_continue = false;
        if (this.signal_abort) {
            this.signal_abort = false;
            this.tester_io.sendCommand("abort");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            complete = -1;
        }
        return complete;
    }

    private void fetchSequenceResults() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MainRunView.this.lblProgramActivity.setText("Getting results");
            }
        });
        this.tester_io.sendCommand("rslt?");
        String response = this.tester_io.getResponse(100);
        this.results.status = response != null ? Integer.parseInt(response) : 0x40000000;
        int step_num = 0;
        StepResults[] stepResultsArray = this.results.step_results;
        int n = this.results.step_results.length;
        int n2 = 0;
        while (n2 < n) {
            StepResults rslt = stepResultsArray[n2];
            if (rslt.status == 0) {
                this.tester_io.sendCommand("steprslt?," + (step_num + 1));
                response = this.tester_io.getResponse(300);
                if (response == null) {
                    this.tester_io.sendCommand("steprslt?," + (step_num + 1));
                    response = this.tester_io.getResponse(300);
                }
                if (response != null) {
                    TestStep step = this.sequence.getStep(step_num);
                    rslt.steprslt = response;
                    String[] f = response.split(",");
                    rslt.status = Integer.parseInt(f[2]);
                    rslt.final_metrics = step.extractFinal(response);
                    if (rslt.status != 0) {
                        final int sn = step_num;
                        this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TableItem ti = MainRunView.this.tableStepList.getItem(sn);
                                ti.setForeground(SWTResourceManager.getColor(255, 0, 0));
                            }
                        });
                    }
                    if (step.getType().equals("Pulse")) {
                        rslt.chart_data[0] = new float[]{0.0f, rslt.final_metrics[0]};
                        rslt.chart_data[1] = new float[]{0.0f, rslt.final_metrics[1]};
                    }
                } else {
                    rslt.steprslt = "";
                    rslt.status = 0x40000000;
                }
            } else {
                rslt.steprslt = "";
                rslt.status = 0x40000000;
                final int sn1 = step_num;
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TableItem itemToColor = MainRunView.this.tableStepList.getItem(sn1);
                        itemToColor.setForeground(SWTResourceManager.getColor(255, 0, 0));
                    }
                });
            }
            ++step_num;
            ++n2;
        }
    }

    private void resultsSaveAndGenerateOutputs() {
        boolean ok = this.results.status == 0;
        BusySpinner.start(this.display, this.lblBusyWorking);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MainRunView.this.lblProgramActivity.setText("Saving");
            }
        });
        this.results.save();
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MainRunView.this.lblProgramActivity.setText("Preparing reports");
            }
        });
        if (this.sequence.report_settings.fail_auto_print && !ok) {
            this.results.printReport(this.sequence.report_settings.num_print_copies);
        } else if (this.sequence.report_settings.pass_auto_print && ok) {
            this.results.printReport(this.sequence.report_settings.num_print_copies);
        }
        if (!this.sequence.report_settings.CSV_path.isEmpty()) {
            if (this.sequence.report_settings.fail_auto_save_csv && !ok) {
                this.results.saveAsCsv(this.sequence.report_settings.CSV_path);
            } else if (this.sequence.report_settings.pass_auto_save_csv && ok) {
                this.results.saveAsCsv(this.sequence.report_settings.CSV_path);
            }
        }
        if (!this.sequence.report_settings.PDF_path.isEmpty()) {
            if (this.sequence.report_settings.fail_auto_save_pdf && !ok) {
                this.results.saveAsPdf(this.sequence.report_settings.PDF_path);
            } else if (this.sequence.report_settings.pass_auto_save_pdf && ok) {
                this.results.saveAsPdf(this.sequence.report_settings.PDF_path);
            }
        }
        BusySpinner.stop(false);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MainRunView.this.sequence.dut_settings.select_model_after_test) {
                    MainRunView.this.textDutModel.setFocus();
                    MainRunView.this.textDutModel.setSelection(0, 99);
                } else {
                    MainRunView.this.textDutSerialNumber.setFocus();
                    MainRunView.this.textDutSerialNumber.setSelection(0, 99);
                }
            }
        });
    }

    private void closeConnections() {
        this.tester_io.close();
        if (this.switch_io != null) {
            Interface[] interfaceArray = this.switch_io;
            int n = this.switch_io.length;
            int n2 = 0;
            while (n2 < n) {
                Interface i = interfaceArray[n2];
                if (i != null) {
                    i.close();
                }
                ++n2;
            }
        }
        this.switch_io = null;
    }

    private void runTestSequence() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MainRunView.this.dut_model = MainRunView.this.textDutModel.getText();
                MainRunView.this.dut_serial_number = MainRunView.this.textDutSerialNumber.getText();
                MainRunView.this.user_notes = MainRunView.this.textNotes.getText();
                MainRunView.this.run_until_fail = MainRunView.this.btnRunUntilFail.getSelection();
            }
        });
        if (this.sequence.dut_settings.require_model && this.dut_model.isEmpty()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.lblProgramActivity.setText("No Model String");
                    MainRunView.this.lblProgramActivity.setVisible(true);
                }
            });
            return;
        }
        if (this.sequence.dut_settings.require_serial_number && this.dut_serial_number.isEmpty()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.lblProgramActivity.setText("No Serial Number");
                    MainRunView.this.lblProgramActivity.setVisible(true);
                }
            });
            return;
        }
        if (this.sequence.num_steps == 0) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.lblProgramActivity.setText("No Steps");
                    MainRunView.this.lblProgramActivity.setVisible(true);
                }
            });
            return;
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MainRunView.this.lblStartButton.setVisible(false);
                int i = 0;
                while (i < MainRunView.this.sequence.num_steps) {
                    TableItem ti = MainRunView.this.tableStepList.getItem(i);
                    ti.setForeground(SWTResourceManager.getColor(0, 0, 0));
                    ++i;
                }
                int m = 0;
                while (m < 3) {
                    MainRunView.this.metricDisplays[m].group.setVisible(false);
                    MainRunView.this.metricDisplays[m].chart.setVisible(false);
                    ++m;
                }
                MainRunView.this.grpSequenceErrors.setVisible(false);
                MainRunView.this.lblSequenceResult.setVisible(false);
                MainRunView.this.lblStepResult.setVisible(false);
                MainRunView.this.btnSaveCsv.setVisible(false);
                MainRunView.this.btnSavePdf.setVisible(false);
                MainRunView.this.btnPrint.setVisible(false);
                MainRunView.this.btnExportChartData.setVisible(false);
                MainRunView.this.progressBarSequence.setState(0);
                MainRunView.this.lblProgramActivity.setText("");
                MainRunView.this.lblProgramActivity.setVisible(true);
            }
        });
        QtInsite.setBusy(true);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MainRunView.this.lblSequenceProgress.setText("Loading Sequence");
                MainRunView.this.lblSequenceProgress.setVisible(true);
                MainRunView.this.progressBarSequence.setVisible(true);
            }
        });
        this.sequence_worker_state = worker_state_t.worker_state_IDLE;
        if (this.sendTestSequence() == 0) {
            int r;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.lblSequenceProgress.setText("Sequence progress");
                    MainRunView.this.progressBarSequence.setMaximum(MainRunView.this.sequence.num_steps + 1);
                    MainRunView.this.progressBarSequence.setSelection(0);
                    MainRunView.this.progressBarStep.setSelection(0);
                    MainRunView.this.progressBarStep.setVisible(true);
                    MainRunView.this.lblStepProgress.setVisible(true);
                    MainRunView.this.lblStopButton.setVisible(true);
                    MainRunView.this.comboSequenceList.setEnabled(false);
                }
            });
            this.sequence_worker_state = worker_state_t.worker_state_BUSY;
            do {
                r = this.executeTestSequence();
                this.fetchSequenceResults();
                this.resultsSaveAndGenerateOutputs();
            } while (r == 0 && this.run_until_fail);
            this.sequence_worker_state = worker_state_t.worker_state_IDLE;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.lblProgramActivity.setVisible(false);
                    MainRunView.this.lblStopButton.setVisible(false);
                    MainRunView.this.lblStartButton.setVisible(true);
                    MainRunView.this.progressBarSequence.setVisible(false);
                    MainRunView.this.lblSequenceProgress.setVisible(false);
                    MainRunView.this.progressBarStep.setVisible(false);
                    MainRunView.this.lblStepProgress.setVisible(false);
                    if (MainRunView.this.results.status == 0) {
                        MainRunView.this.lblSequenceResult.setForeground(MainRunView.this.passColor);
                        MainRunView.this.lblSequenceResult.setText("Sequence Passed");
                    } else {
                        MainRunView.this.lblSequenceResult.setForeground(MainRunView.this.failColor);
                        MainRunView.this.lblSequenceResult.setText("Sequence Failed");
                    }
                    MainRunView.this.lblSequenceResult.setVisible(true);
                    MainRunView.this.lblStepResult.setVisible(true);
                    MainRunView.this.tableStepList.setSelection(0);
                    MainRunView.this.displayStepResults(0);
                    if (MainRunView.this.results.status != 0) {
                        String[] errs = MainRunView.this.sequence.tester.decodeStatusFlags(MainRunView.this.results.status);
                        String lbl = "";
                        int i = 0;
                        while (i < errs.length) {
                            lbl = String.valueOf(lbl) + errs[i] + "\r\n";
                            ++i;
                        }
                        MainRunView.this.grpSequenceErrors.setVisible(true);
                        MainRunView.this.lblSequenceErrors.setText(lbl);
                    }
                    if (UserSettings.permissions.select_sequence) {
                        MainRunView.this.comboSequenceList.setEnabled(true);
                    }
                    MainRunView.this.btnSaveCsv.setVisible(true);
                    MainRunView.this.btnSavePdf.setVisible(true);
                    MainRunView.this.btnPrint.setVisible(true);
                }
            });
        } else {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.lblStartButton.setVisible(true);
                }
            });
        }
        QtInsite.setBusy(false);
        this.sequence_worker_state = worker_state_t.worker_state_IDLE;
    }

    private void manageTestStart() {
        int start = 0;
        boolean eval_remote_start = true;
        this.sequence_worker_state = worker_state_t.worker_state_IDLE;
        while (this.sequence_worker_state != worker_state_t.worker_state_EXIT) {
            if (this.sequence_loading) {
                this.sequence_loading_acknowledged = true;
                this.sequence.tester.configureRemoteStart(this.tester_io, false);
                while (this.sequence_loading) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                eval_remote_start = true;
            }
            if (eval_remote_start) {
                if (this.sequence.tester_settings.enable_tester_start) {
                    System.out.println("has tester-start");
                    this.sequence.tester.configureRemoteStart(this.tester_io, true);
                } else {
                    System.out.println("no tester-start");
                }
                eval_remote_start = false;
            }
            if (this.signal_start) {
                start = 1;
                this.signal_start = false;
            } else if (this.sequence.tester_settings.enable_tester_start) {
                start = this.sequence.tester.pollRemoteStart(this.tester_io);
            }
            if (start == 1) {
                start = 0;
                this.runTestSequence();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.sequence.tester.configureRemoteStart(this.tester_io, false);
        this.closeConnections();
    }

    private connections_status_t makeConnections() {
        connections_status_t rslt = connections_status_t.connections_OK;
        this.tester_io = InterfaceFactory.getIo(this.system_configuration.pc_interface);
        if (this.tester_io.open(this.system_configuration.interface_settings) == 0) {
            this.tester_io.sendCommand("*idn?");
            String resp = this.tester_io.getResponse(100);
            if (resp == null) {
                this.tester_io.close();
                rslt = connections_status_t.connections_NO_RESPONSE;
            } else if (this.system_configuration.switch_control == switch_control_t.switch_control_computer) {
                this.switch_io = new Interface[this.system_configuration.num_switches];
                int i = 0;
                SwitchSettings[] switchSettingsArray = this.system_configuration.switches;
                int n = this.system_configuration.switches.length;
                int n2 = 0;
                while (n2 < n) {
                    SwitchSettings sc = switchSettingsArray[n2];
                    this.switch_io[i] = InterfaceFactory.getIo(sc.pc_interface);
                    if (this.switch_io[i].open(sc.isettings) == 0) {
                        this.switch_io[i].sendCommand("*idn?");
                        resp = this.switch_io[i].getResponse(100);
                        if (resp == null) {
                            rslt = connections_status_t.connections_NO_RESPONSE;
                            break;
                        }
                    } else {
                        rslt = connections_status_t.connections_ERROR;
                        break;
                    }
                    ++i;
                    ++n2;
                }
                if (rslt != connections_status_t.connections_OK) {
                    this.closeConnections();
                    rslt = connections_status_t.connections_ERROR;
                }
            }
        } else {
            rslt = connections_status_t.connections_ERROR;
        }
        return rslt;
    }

    private connections_status_t validateTester() {
        connections_status_t rslt = connections_status_t.connections_NO_RESPONSE;
        this.tester_io.sendCommand("*idn?");
        String idn = this.tester_io.getResponse(100);
        if (idn != null) {
            String[] f = idn.split(",");
            this.tester_model = f[1];
            this.tester_sn = f[2];
            this.tester_firmware = f[3];
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MainRunView.this.lblTesterIdn.setText("Tester:" + MainRunView.this.tester_model + " " + MainRunView.this.tester_sn);
                }
            });
            rslt = Registration.validate(f[1], f[2]) ? connections_status_t.connections_OK : connections_status_t.connections_NO_KEY;
        }
        return rslt;
    }

    private void launchTestControl() {
        this.lblConectionError.setVisible(false);
        this.lblConnecting.setVisible(true);
        BusySpinner.start(this.display, this.lblBusyWorking);
        Registration.load();
        this.run_sequence_worker = new Thread(){

            @Override
            public void run() {
                QtInsite.setBusy(true);
                connections_status_t result = MainRunView.this.makeConnections();
                if (result == connections_status_t.connections_OK && (result = MainRunView.this.validateTester()) != connections_status_t.connections_OK) {
                    MainRunView.this.closeConnections();
                }
                BusySpinner.stop(false);
                QtInsite.setBusy(false);
                if (result == connections_status_t.connections_OK) {
                    MainRunView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).MainRunView.this.lblConnecting.setVisible(false);
                            if (UserSettings.permissions.select_sequence) {
                                (this).MainRunView.this.comboSequenceList.setEnabled(true);
                            }
                            (this).MainRunView.this.lblStartButton.setVisible(true);
                        }
                    });
                    Switch.configureIo(MainRunView.this.switch_io);
                    MainRunView.this.manageTestStart();
                } else {
                    final connections_status_t aresult = result;
                    MainRunView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).MainRunView.this.lblConnecting.setVisible(false);
                            switch (aresult) {
                                case connections_OK: {
                                    break;
                                }
                                case connections_ERROR: 
                                case connections_NO_RESPONSE: {
                                    (this).MainRunView.this.lblConectionError.setVisible(true);
                                    break;
                                }
                                case connections_NO_KEY: {
                                    (this).MainRunView.this.lblKeyError.setVisible(true);
                                }
                            }
                        }
                    });
                }
                System.out.println("worker exiting");
            }
        };
        this.run_sequence_worker.start();
    }

    private void loadConfiguration() {
        String[] config_names;
        this.system_configuration = !UserSettings.configuration_name.isEmpty() ? SystemConfiguration.load(UserSettings.configuration_name) : ((config_names = SystemConfiguration.getNames()).length > 0 ? SystemConfiguration.load(config_names[0]) : new SystemConfiguration());
        if (!this.system_configuration.use_switches) {
            this.system_configuration.num_switches = 0;
            this.system_configuration.switches[0].model = "";
        }
    }

    private void loadSequence(String name, boolean use_sync) {
        TestStep step;
        if (use_sync) {
            this.sequence_loading = true;
            int limit = 0;
            while (!this.sequence_loading_acknowledged && limit < 20) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++limit;
            }
            this.sequence_loading_acknowledged = false;
        }
        this.sequence = TestSequence.load(name);
        UserSettings.test_name = name;
        this.sequence_switching_valid = this.sequence.validateSwitchConfiguration(this.system_configuration);
        if (!this.sequence_switching_valid) {
            System.out.println("switch configuration invalid");
        }
        this.results = null;
        this.grpSequenceErrors.setVisible(false);
        this.lblSequenceResult.setVisible(false);
        this.lblStepResult.setVisible(false);
        this.grpSequenceErrors.setVisible(false);
        this.btnSaveCsv.setVisible(false);
        this.btnSavePdf.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnExportChartData.setVisible(false);
        int m = 0;
        while (m < 3) {
            this.metricDisplays[m].group.setVisible(false);
            this.metricDisplays[m].chart.setVisible(false);
            ++m;
        }
        if (!this.sequence.dut_settings.model.isEmpty()) {
            this.textDutModel.setText(this.sequence.dut_settings.model);
        }
        this.tableStepList.removeAll();
        int sid = 0;
        while ((step = this.sequence.getStep(sid)) != null) {
            TableItem n_item = new TableItem(this.tableStepList, 0);
            n_item.setText(new String[]{"#" + (sid + 1), step.getName()});
            ++sid;
        }
        this.lblSequenceProgress.setVisible(false);
        this.progressBarSequence.setVisible(false);
        this.lblProgramActivity.setVisible(false);
        this.sequence_key = "";
        this.sequence_loading = false;
    }

    private Chart blankChart(Composite c, String title, String ylabel, Color lcolor) {
        Chart chart = new Chart(c, 0);
        chart.setBackground(SWTResourceManager.getColor(220, 220, 220));
        chart.setBackgroundInPlotArea(SWTResourceManager.getColor(230, 230, 230));
        ILegend legend = chart.getLegend();
        legend.setVisible(false);
        chart.getTitle().setText(title);
        chart.getTitle().setVisible(false);
        chart.getAxisSet().getXAxis(0).getTitle().setText("Time Index");
        chart.getAxisSet().getYAxis(0).getTitle().setText(ylabel);
        Font font = new Font((Device)Display.getDefault(), "Tahoma", 8, 2);
        Color tcolor = new Color((Device)Display.getDefault(), 0, 121, 193);
        chart.getTitle().setFont(font);
        chart.getAxisSet().getXAxis(0).getTitle().setFont(font);
        chart.getAxisSet().getYAxis(0).getTitle().setFont(font);
        chart.getAxisSet().getXAxis(0).getTick().setFont(font);
        chart.getAxisSet().getYAxis(0).getTick().setFont(font);
        chart.getAxisSet().getXAxis(0).getTitle().setForeground(tcolor);
        chart.getAxisSet().getYAxis(0).getTitle().setForeground(tcolor);
        chart.getAxisSet().getXAxis(0).getTick().setForeground(tcolor);
        chart.getAxisSet().getYAxis(0).getTick().setForeground(tcolor);
        ILineSeries lineSeries = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, "series");
        lineSeries.setLineStyle(LineStyle.SOLID);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineWidth(3);
        lineSeries.setLineColor(lcolor);
        double[] fake_data = new double[]{0.0, 0.0};
        lineSeries.setYSeries(fake_data);
        chart.getAxisSet().adjustRange();
        c.layout(true, true);
        c.setLayout((Layout)new FillLayout());
        return chart;
    }

    public MainRunView(final Composite parent, int style) {
        super(parent, style);
        this.setBackground(SWTResourceManager.getColor(240, 240, 240));
        this.display = parent.getDisplay();
        this.loadConfiguration();
        this.working_step_index = 0;
        if (!this.system_configuration.series.isEmpty()) {
            this.sequence_names = TestSequence.getNames(this.system_configuration.series);
        }
        Group groupLabelConfiguration = new Group((Composite)this, 0);
        groupLabelConfiguration.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupLabelConfiguration.setBackground(SWTResourceManager.getColor(192, 192, 192));
        groupLabelConfiguration.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        groupLabelConfiguration.setText("Configuration");
        groupLabelConfiguration.setBounds(10, 0, 223, 70);
        this.lblConfiguration = new Label((Composite)groupLabelConfiguration, 0);
        this.lblConfiguration.setFont(SWTResourceManager.getFont("Arial", 9, 2));
        this.lblConfiguration.setBounds(10, 26, 157, 15);
        if (!this.system_configuration.loaded_name.isEmpty()) {
            this.lblConfiguration.setText(String.valueOf(this.system_configuration.loaded_name) + " (" + this.system_configuration.series + ")");
        }
        this.lblTesterIdn = new Label((Composite)groupLabelConfiguration, 0);
        this.lblTesterIdn.setBounds(10, 44, 157, 23);
        Group grpSequenceSelect = new Group((Composite)this, 0);
        grpSequenceSelect.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpSequenceSelect.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpSequenceSelect.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpSequenceSelect.setText("Sequence");
        grpSequenceSelect.setBounds(257, 0, 174, 70);
        this.comboSequenceList = new Combo((Composite)grpSequenceSelect, 0);
        this.comboSequenceList.setToolTipText("Selects the sequence to execute.");
        this.comboSequenceList.setBounds(10, 26, 154, 23);
        this.comboSequenceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.stateMask == 0 && !MainRunView.this.sequence_running) {
                    MainRunView.this.loadSequence(MainRunView.this.comboSequenceList.getText(), true);
                }
            }
        });
        this.comboSequenceList.setItems(this.sequence_names);
        this.comboSequenceList.setEnabled(false);
        this.btnCheckFastRestart = new Button((Composite)grpSequenceSelect, 32);
        this.btnCheckFastRestart.setSelection(true);
        this.btnCheckFastRestart.setBounds(10, 50, 93, 16);
        this.btnCheckFastRestart.setText("Fast Restart");
        Group grpDut = new Group((Composite)this, 0);
        grpDut.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpDut.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpDut.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpDut.setText("DUT");
        grpDut.setBounds(459, 0, 460, 70);
        Label lblModel = new Label((Composite)grpDut, 0);
        lblModel.setBounds(10, 25, 43, 15);
        lblModel.setText("Model");
        this.textDutModel = new Text((Composite)grpDut, 2048);
        this.textDutModel.setToolTipText("Specify the model name to record with the test result.");
        this.textDutModel.setBounds(61, 22, 159, 21);
        this.textDutModel.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                e.doit = false;
                int k = e.stateMask + e.keyCode;
                if (k == 13) {
                    String s = DutSettings.modelToSequence(MainRunView.this.textDutModel.getText());
                    if (s != null && TestSequence.valid(s, MainRunView.this.system_configuration.series)) {
                        MainRunView.this.loadSequence(s, true);
                        MainRunView.this.comboSequenceList.setText(s);
                    }
                    MainRunView.this.textDutSerialNumber.setFocus();
                    MainRunView.this.textDutSerialNumber.setSelection(0, 99);
                }
            }
        });
        Label lblSerial = new Label((Composite)grpDut, 0);
        lblSerial.setBounds(226, 25, 43, 15);
        lblSerial.setText("Serial #");
        this.textDutSerialNumber = new Text((Composite)grpDut, 2048);
        this.textDutSerialNumber.setToolTipText("Specify the serial number to record with the test results.");
        this.textDutSerialNumber.setBounds(275, 22, 176, 21);
        this.textDutSerialNumber.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                e.doit = false;
                int k = e.stateMask + e.keyCode;
                if (k == 13 && MainRunView.this.sequence.dut_settings.serial_number_enter_starts) {
                    MainRunView.this.signal_start = true;
                }
            }
        });
        Label lblNotes = new Label((Composite)grpDut, 0);
        lblNotes.setText("Notes");
        lblNotes.setBounds(10, 46, 43, 15);
        this.textNotes = new Text((Composite)grpDut, 2048);
        this.textNotes.setToolTipText("Specify notes  to record with the test results.");
        this.textNotes.setBounds(61, 46, 159, 21);
        this.btnRunUntilFail = new Button((Composite)grpDut, 32);
        this.btnRunUntilFail.setBounds(275, 50, 176, 16);
        this.btnRunUntilFail.setText("Continuously run until fail");
        this.lblStartButton = new Label((Composite)this, 0);
        this.lblStartButton.setToolTipText("Double click to start the test.");
        this.lblStartButton.setImage(SWTResourceManager.getImage("images/start_button.png"));
        this.lblStartButton.setBounds(945, 10, 50, 50);
        this.lblStartButton.setVisible(false);
        this.lblStartButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (MainRunView.this.sequence.loaded_switch_step) {
                    if (MainRunView.this.sequence_switching_valid && MainRunView.this.sequence.tester.switchingValid(MainRunView.this.tester_model, MainRunView.this.system_configuration)) {
                        MainRunView.this.signal_start = true;
                    } else {
                        MainRunView.this.lblSequenceErrors.setText("Switch settings mismatch");
                        MainRunView.this.grpSequenceErrors.setVisible(true);
                    }
                } else {
                    MainRunView.this.fast_restart = MainRunView.this.btnCheckFastRestart.getSelection();
                    MainRunView.this.signal_start = true;
                }
            }
        });
        this.lblStopButton = new Label((Composite)this, 0);
        this.lblStartButton.setToolTipText("Double click to halt the test.");
        this.lblStopButton.setImage(SWTResourceManager.getImage("images/stop_button.png"));
        this.lblStopButton.setBounds(945, 10, 50, 50);
        this.lblStopButton.setVisible(false);
        this.lblStopButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MainRunView.this.signal_abort = true;
            }
        });
        this.lblConectionError = new Label((Composite)this, 0);
        this.lblConectionError.setVisible(false);
        this.lblConectionError.setImage(SWTResourceManager.getImage("images/connection_error_label.png"));
        this.lblConectionError.setBounds(945, 10, 50, 50);
        this.lblConectionError.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MainRunView.this.launchTestControl();
            }
        });
        this.lblKeyError = new Label((Composite)this, 0);
        this.lblKeyError.setVisible(false);
        this.lblKeyError.setImage(SWTResourceManager.getImage("images/key_error_label.png"));
        this.lblKeyError.setBounds(945, 10, 50, 50);
        this.lblBusyWorking = new Label((Composite)this, 0);
        this.lblBusyWorking.setBounds(925, 88, 70, 70);
        this.lblSequenceProgress = new Label((Composite)this, 0);
        this.lblSequenceProgress.setAlignment(131072);
        this.lblSequenceProgress.setBounds(10, 76, 104, 19);
        this.lblSequenceProgress.setText("Sequence progress");
        this.progressBarSequence = new ProgressBar((Composite)this, 0);
        this.progressBarSequence.setBounds(120, 76, 311, 19);
        this.lblSequenceProgress.setVisible(false);
        this.progressBarSequence.setVisible(false);
        this.lblSequenceResult = new Label((Composite)this, 0);
        this.lblSequenceResult.setForeground(SWTResourceManager.getColor(51, 170, 51));
        this.lblSequenceResult.setBackground(SWTResourceManager.getColor(245, 245, 245));
        this.lblSequenceResult.setBounds(257, 76, 124, 19);
        this.lblSequenceResult.setText("Sequence Result: Pass");
        this.lblSequenceResult.setVisible(false);
        this.lblProgramActivity = new Label((Composite)this, 2052);
        this.lblProgramActivity.setText("Some activity");
        this.lblProgramActivity.setBounds(120, 101, 311, 29);
        this.lblProgramActivity.setVisible(false);
        this.lblStepProgress = new Label((Composite)this, 0);
        this.lblStepProgress.setAlignment(131072);
        this.lblStepProgress.setText("Step Progress");
        this.lblStepProgress.setBounds(10, 139, 104, 19);
        this.progressBarStep = new ProgressBar((Composite)this, 0);
        this.progressBarStep.setBounds(120, 139, 165, 19);
        this.lblStepProgress.setVisible(false);
        this.progressBarStep.setVisible(false);
        this.lblStepResult = new Label((Composite)this, 0);
        this.lblStepResult.setForeground(SWTResourceManager.getColor(255, 51, 51));
        this.lblStepResult.setBackground(SWTResourceManager.getColor(245, 245, 245));
        this.lblStepResult.setText("Step Result: Pass");
        this.lblStepResult.setBounds(10, 136, 160, 19);
        this.lblStepResult.setVisible(false);
        this.btnExportChartData = new Button((Composite)this, 0);
        this.btnExportChartData.setToolTipText("Click to save the charted measurement data in a CSV file.");
        this.btnExportChartData.setBounds(291, 129, 109, 29);
        this.btnExportChartData.setText("Export Chart Data");
        this.btnExportChartData.setVisible(false);
        this.btnExportChartData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainRunView.this.results.exportChartData(MainRunView.this.working_step_index, parent);
            }
        });
        this.btnContinue = new Button((Composite)this, 0);
        this.btnContinue.setFont(SWTResourceManager.getFont("Segoe UI", 22, 0));
        this.btnContinue.setBounds(459, 88, 136, 50);
        this.btnContinue.setText("Continue");
        this.btnContinue.setVisible(false);
        this.btnContinue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainRunView.this.btnContinue.setVisible(false);
                MainRunView.this.signal_continue = true;
            }
        });
        this.grpSequenceErrors = new Group((Composite)this, 0);
        this.grpSequenceErrors.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.grpSequenceErrors.setText("Sequence Errors");
        this.grpSequenceErrors.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.grpSequenceErrors.setBounds(459, 77, 301, 82);
        this.grpSequenceErrors.setVisible(false);
        this.lblSequenceErrors = new Label((Composite)this.grpSequenceErrors, 592);
        this.lblSequenceErrors.setVisible(true);
        this.lblSequenceErrors.setFont(SWTResourceManager.getFont("Segoe UI", 8, 0));
        this.lblSequenceErrors.setBounds(10, 15, 281, 67);
        this.btnSavePdf = new Button((Composite)this, 0);
        this.btnSavePdf.setToolTipText("Save the test results as a formatted report in a PDF file.");
        this.btnSavePdf.setBounds(845, 75, 75, 25);
        this.btnSavePdf.setText("Save PDF");
        this.btnSavePdf.setVisible(false);
        this.btnSavePdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainRunView.this.results.saveAsPdf(parent);
            }
        });
        this.btnSaveCsv = new Button((Composite)this, 0);
        this.btnSaveCsv.setToolTipText("Save the test results in a CSV file.");
        this.btnSaveCsv.setBounds(845, 105, 75, 25);
        this.btnSaveCsv.setText("Save CSV");
        this.btnSaveCsv.setVisible(false);
        this.btnSaveCsv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainRunView.this.results.saveAsCsv(parent);
            }
        });
        this.btnPrint = new Button((Composite)this, 0);
        this.btnPrint.setToolTipText("Print the test results.");
        this.btnPrint.setBounds(845, 133, 75, 25);
        this.btnPrint.setText("Print");
        this.btnPrint.setVisible(false);
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainRunView.this.results.printReport(parent);
            }
        });
        Group groupStepList = new Group((Composite)this, 0);
        groupStepList.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        groupStepList.setText("Steps");
        groupStepList.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupStepList.setBackground(SWTResourceManager.getColor(192, 192, 192));
        groupStepList.setBounds(10, 164, 159, 336);
        this.tableStepList = new Table((Composite)groupStepList, 68112);
        this.tableStepList.setBounds(10, 30, 137, 296);
        this.tableStepList.setLinesVisible(true);
        this.tableStepList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = MainRunView.this.tableStepList.getSelectionIndex();
                if (si != -1 && MainRunView.this.results != null) {
                    MainRunView.this.displayStepResults(si);
                }
            }
        });
        TableColumn tblColStepNum = new TableColumn(this.tableStepList, 0);
        tblColStepNum.setWidth(37);
        tblColStepNum.setText("#");
        TableColumn tblColStepInfo = new TableColumn(this.tableStepList, 0);
        tblColStepInfo.setWidth(100);
        tblColStepInfo.setText("Steps");
        this.groupMetric1 = new Group((Composite)this, 0);
        this.groupMetric1.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        this.groupMetric1.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.groupMetric1.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupMetric1.setBounds(175, 164, 110, 110);
        this.groupMetric1.setVisible(false);
        this.lblMetricValue1 = new Label((Composite)this.groupMetric1, 0);
        this.lblMetricValue1.setAlignment(131072);
        this.lblMetricValue1.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        this.lblMetricValue1.setBounds(5, 42, 100, 26);
        this.compChart1 = new Composite((Composite)this, 0x1000000);
        this.compChart1.setBounds(291, 164, 704, 110);
        this.compChart1.setVisible(false);
        this.groupMetric2 = new Group((Composite)this, 0);
        this.groupMetric2.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.groupMetric2.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        this.groupMetric2.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupMetric2.setBounds(175, 276, 110, 110);
        this.groupMetric2.setVisible(false);
        this.lblMetricValue2 = new Label((Composite)this.groupMetric2, 0);
        this.lblMetricValue2.setAlignment(131072);
        this.lblMetricValue2.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        this.lblMetricValue2.setBounds(5, 42, 100, 26);
        this.compChart2 = new Composite((Composite)this, 0x1000000);
        this.compChart2.setBounds(291, 276, 704, 110);
        this.compChart2.setVisible(false);
        this.groupMetric3 = new Group((Composite)this, 0);
        this.groupMetric3.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.groupMetric3.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        this.groupMetric3.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupMetric3.setBounds(175, 388, 110, 110);
        this.groupMetric3.setVisible(false);
        this.lblMetricValue3 = new Label((Composite)this.groupMetric3, 0);
        this.lblMetricValue3.setAlignment(131072);
        this.lblMetricValue3.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        this.lblMetricValue3.setBounds(5, 42, 100, 26);
        this.compChart3 = new Composite((Composite)this, 0x1000000);
        this.compChart3.setBounds(291, 388, 704, 110);
        this.compChart3.setVisible(false);
        this.chartLineColors = new Color[3];
        this.chartLineColors[0] = new Color((Device)Display.getDefault(), 255, 0, 0);
        this.chartLineColors[1] = new Color((Device)Display.getDefault(), 0, 128, 64);
        this.chartLineColors[2] = new Color((Device)Display.getDefault(), 0, 128, 255);
        this.metricDisplays = new MetricDisplay[3];
        this.metricDisplays[0] = new MetricDisplay();
        this.metricDisplays[1] = new MetricDisplay();
        this.metricDisplays[2] = new MetricDisplay();
        this.metricDisplays[0].group = this.groupMetric1;
        this.metricDisplays[0].value = this.lblMetricValue1;
        this.metricDisplays[0].comp = this.compChart1;
        this.metricDisplays[1].group = this.groupMetric2;
        this.metricDisplays[1].value = this.lblMetricValue2;
        this.metricDisplays[1].comp = this.compChart2;
        this.metricDisplays[2].group = this.groupMetric3;
        this.metricDisplays[2].value = this.lblMetricValue3;
        this.metricDisplays[2].comp = this.compChart3;
        Chart ch = this.blankChart(this.compChart1, "Chart 1", "Units", new Color((Device)Display.getDefault(), 255, 0, 0));
        ch.setVisible(false);
        this.metricDisplays[0].chart = ch;
        ch = this.blankChart(this.compChart2, "Chart 2", "Units", new Color((Device)Display.getDefault(), 0, 128, 64));
        ch.setVisible(false);
        this.metricDisplays[1].chart = ch;
        ch = this.blankChart(this.compChart3, "Chart 3", "Units", new Color((Device)Display.getDefault(), 0, 128, 255));
        ch.setVisible(false);
        this.metricDisplays[2].chart = ch;
        this.lblInfoText = new Label((Composite)this, 2112);
        this.lblInfoText.setBounds(175, 164, 300, 300);
        this.lblInfoText.setVisible(false);
        this.lblInfoGraphic = new Label((Composite)this, 0);
        this.lblInfoGraphic.setBounds(480, 164, 515, 300);
        this.lblInfoGraphic.setVisible(false);
        this.rgen = new Random(System.currentTimeMillis());
        if (!UserSettings.test_name.isEmpty() && TestSequence.valid(UserSettings.test_name, this.system_configuration.series)) {
            this.comboSequenceList.setText(UserSettings.test_name);
            this.loadSequence(UserSettings.test_name, false);
        } else if (this.sequence_names.length > 0) {
            this.comboSequenceList.setText(this.sequence_names[0]);
            this.loadSequence(this.sequence_names[0], false);
        }
        if (this.sequence != null && !this.sequence.loaded_name.isEmpty()) {
            this.comboSequenceList.setText(this.sequence.loaded_name);
        }
        this.lblConnecting = new Label((Composite)this, 0);
        this.lblConnecting.setAlignment(0x1000000);
        this.lblConnecting.setBounds(926, 66, 70, 15);
        this.lblConnecting.setText("Connecting");
        this.lblConnecting.setVisible(false);
        if (!this.system_configuration.loaded_name.isEmpty() && this.sequence != null) {
            this.launchTestControl();
        } else {
            MessageBox wd = new MessageBox(this.display.getActiveShell(), 40);
            wd.setText("Information");
            if (!this.system_configuration.loaded_name.isEmpty() && this.sequence != null) {
                wd.setMessage("The system has not been configured.");
            } else {
                wd.setMessage("No sequence is available.");
            }
            wd.open();
        }
        this.textDutModel.setFocus();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                System.out.println("run disposing");
                if (MainRunView.this.run_sequence_worker != null) {
                    if (MainRunView.this.run_sequence_worker.getState() != Thread.State.TERMINATED) {
                        System.out.println("must halt worker thread");
                    } else {
                        System.out.println("worker thread idle");
                    }
                } else {
                    System.out.println("no worker thread");
                }
                if (MainRunView.this.sequence_worker_state != worker_state_t.worker_state_NONE) {
                    MainRunView.this.sequence_worker_state = worker_state_t.worker_state_EXIT;
                    try {
                        MainRunView.this.run_sequence_worker.join(10000L);
                    }
                    catch (InterruptedException e1) {
                        System.out.println("join error");
                    }
                    System.out.println("worker joined");
                }
            }
        });
    }

    protected void checkSubclass() {
    }

    public static enum connections_status_t {
        connections_OK,
        connections_ERROR,
        connections_NO_RESPONSE,
        connections_NO_KEY;

    }

    public static enum worker_state_t {
        worker_state_NONE,
        worker_state_IDLE,
        worker_state_BUSY,
        worker_state_EXIT;

    }
}

