/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.wb.swt.SWTResourceManager;

public class MainReportsView
extends Composite {
    static final String upTriangle = "\u25b2";
    static final String downTriangle = "\u25bc";
    static Calendar calQueryFrom;
    static Calendar calQueryTo;
    Display display;
    Color passColor = SWTResourceManager.getColor(51, 170, 51);
    Color failColor = SWTResourceManager.getColor(255, 51, 51);
    SystemConfiguration system_configuration;
    private String[] sequence_names;
    Group grpQueryFilters;
    Combo comboSequenceList;
    private DateTime queryFromDate;
    private DateTime queryToDate;
    private Text textDutModel;
    private Text textUser;
    private Text textDutSnStart;
    private Text textDutSnEnd;
    private Text textTesterModel;
    private Text textTesterSn;
    private Button btnQueryPass;
    private Button btnQueryFail;
    int order_by = 0;
    int order_order = 256;
    private Button btnRunQuery;
    private Button btnExportQuery;
    private Button btnDeleteAll;
    private Button btnBack;
    private Button btnDeleteRecord;
    Label lblBusyWorking;
    private Table tableQueryResults;
    private TableColumn tblclmnSequence;
    private TableColumn tblclmnRunOn;
    private TableColumn tblclmnTester;
    private TableColumn tblclmnDutModel;
    private TableColumn tblclmnDut;
    private TableColumn tblclmnUser;
    private TableColumn tblclmnResult;
    SequenceResults[] result_list;
    Group groupStepList;
    private Table tableStepList;
    Label lblSequenceResult;
    Label lblStepResult;
    Group grpSequenceErrors;
    Label lblSequenceErrors;
    Button btnExportChartData;
    Group groupMetric1;
    Group groupMetric2;
    Group groupMetric3;
    Label lblMetricValue1;
    Label lblMetricValue2;
    Label lblMetricValue3;
    Composite compChart1;
    Composite compChart2;
    Composite compChart3;
    MetricDisplay[] metricDisplays;
    Color[] chartLineColors;
    private Group grpDutDetails;
    private Label lblShowModel;
    private Label lblShowSerial;
    private Label lblShowNotes;
    private Group grpReportDetailLevel;
    private static Combo comboLevel;
    Button btnSaveCsv;
    Button btnSavePdf;
    Button btnPrint;
    SequenceResults result;
    int working_index;

    private void loadConfiguration() {
        String[] config_names;
        this.system_configuration = !UserSettings.configuration_name.isEmpty() ? SystemConfiguration.load(UserSettings.configuration_name) : ((config_names = SystemConfiguration.getNames()).length > 0 ? SystemConfiguration.load(config_names[0]) : new SystemConfiguration());
    }

    private void displayStepResults(int index) {
        boolean have_charts = false;
        TestStep step = this.result.steps[index];
        this.working_index = index;
        String[][] labels = step.labels();
        if (this.result.step_results[index].status == 0) {
            this.lblStepResult.setText("Step Passed");
            this.lblStepResult.setForeground(this.passColor);
        } else if ((this.result.step_results[index].status & 0x40000000) != 0) {
            this.lblStepResult.setText("Not Run");
            this.lblStepResult.setForeground(this.failColor);
            labels = null;
        } else {
            String[] errs = this.result.tester.decodeStatusFlags(this.result.step_results[index].status);
            this.lblStepResult.setText(errs[0]);
            this.lblStepResult.setForeground(this.failColor);
        }
        int m = 0;
        if (labels != null && this.result.step_results[index].final_metrics != null) {
            m = 0;
            while (m < labels.length) {
                this.metricDisplays[m].group.setText(labels[m][0]);
                String vd = SiTools.toString(this.result.step_results[index].final_metrics[m], labels[m][2]);
                this.metricDisplays[m].value.setText(vd);
                this.metricDisplays[m].group.setVisible(true);
                this.metricDisplays[m].chart.getAxisSet().getYAxis(0).getTitle().setText(labels[m][1]);
                if (this.result.step_results[index].chart_data[m].length > 0) {
                    have_charts = true;
                    double[] chart_data = new double[this.result.step_results[index].chart_data[m].length];
                    int i = 0;
                    while (i < chart_data.length) {
                        chart_data[i] = this.result.step_results[index].chart_data[m][i];
                        ++i;
                    }
                    ISeries isr = this.metricDisplays[m].chart.getSeriesSet().getSeries("series");
                    isr.setYSeries(chart_data);
                    this.metricDisplays[m].chart.getAxisSet().adjustRange();
                    this.metricDisplays[m].chart.redraw();
                    this.metricDisplays[m].comp.setVisible(true);
                    this.metricDisplays[m].chart.setVisible(true);
                    this.metricDisplays[m].data = new double[0];
                } else {
                    this.metricDisplays[m].comp.setVisible(false);
                    this.metricDisplays[m].chart.setVisible(false);
                }
                ++m;
            }
        }
        while (m < 3) {
            this.metricDisplays[m].group.setVisible(false);
            this.metricDisplays[m].comp.setVisible(false);
            this.metricDisplays[m].chart.setVisible(false);
            ++m;
        }
        if (have_charts) {
            this.btnExportChartData.setVisible(true);
        } else {
            this.btnExportChartData.setVisible(false);
        }
    }

    private Chart blankChart(Composite c, String title, String ylabel, Color lcolor) {
        Chart chart = new Chart(c, 0);
        chart.setBackground(SWTResourceManager.getColor(220, 220, 220));
        chart.setBackgroundInPlotArea(SWTResourceManager.getColor(230, 230, 230));
        ILegend legend = chart.getLegend();
        legend.setVisible(false);
        chart.getTitle().setText(title);
        chart.getTitle().setVisible(false);
        chart.getAxisSet().getXAxis(0).getTitle().setText("Time Index");
        chart.getAxisSet().getYAxis(0).getTitle().setText(ylabel);
        Font font = new Font((Device)Display.getDefault(), "Tahoma", 8, 2);
        Color tcolor = new Color((Device)Display.getDefault(), 0, 121, 193);
        chart.getTitle().setFont(font);
        chart.getAxisSet().getXAxis(0).getTitle().setFont(font);
        chart.getAxisSet().getYAxis(0).getTitle().setFont(font);
        chart.getAxisSet().getXAxis(0).getTick().setFont(font);
        chart.getAxisSet().getYAxis(0).getTick().setFont(font);
        chart.getAxisSet().getXAxis(0).getTitle().setForeground(tcolor);
        chart.getAxisSet().getYAxis(0).getTitle().setForeground(tcolor);
        chart.getAxisSet().getXAxis(0).getTick().setForeground(tcolor);
        chart.getAxisSet().getYAxis(0).getTick().setForeground(tcolor);
        ILineSeries lineSeries = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, "series");
        lineSeries.setLineStyle(LineStyle.SOLID);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineWidth(3);
        lineSeries.setLineColor(lcolor);
        double[] fake_data = new double[]{0.0, 0.0};
        lineSeries.setYSeries(fake_data);
        chart.getAxisSet().adjustRange();
        c.layout(true, true);
        c.setLayout((Layout)new FillLayout());
        return chart;
    }

    private void runResultsQuery() {
        int options = 0;
        BusySpinner.start(this.display, this.lblBusyWorking);
        if (this.btnQueryPass.getSelection()) {
            options = 1;
        }
        if (this.btnQueryFail.getSelection()) {
            options |= 2;
        }
        if (options == 0) {
            this.btnQueryPass.setSelection(true);
            this.btnQueryFail.setSelection(true);
        }
        this.result_list = SequenceResults.query(calQueryFrom.getTimeInMillis(), calQueryTo.getTimeInMillis(), this.textUser.getText(), this.comboSequenceList.getText(), this.textDutModel.getText(), this.textDutSnStart.getText(), this.textDutSnEnd.getText(), this.textTesterModel.getText(), this.textTesterSn.getText(), options, this.order_by | this.order_order);
        if (this.result_list.length > 0) {
            this.btnDeleteAll.setVisible(UserSettings.permissions.delete_reports);
        } else {
            this.btnDeleteAll.setVisible(false);
        }
        this.tableQueryResults.removeAll();
        SequenceResults[] sequenceResultsArray = this.result_list;
        int n = this.result_list.length;
        int n2 = 0;
        while (n2 < n) {
            SequenceResults sr = sequenceResultsArray[n2];
            TableItem n_item = new TableItem(this.tableQueryResults, 0);
            n_item.setText(new String[]{sr.sequence_name, FormatTestTime.format(sr.run_time, " "), String.valueOf(sr.tester_model) + " #" + sr.tester_sn, sr.dut_model, sr.dut_sn, sr.user_name, sr.status == 0 ? "Pass" : "Failed"});
            ++n2;
        }
        BusySpinner.stop(false);
    }

    private void selectSorting(TableColumn c) {
        int new_order_by = this.order_by;
        String label = "";
        this.tblclmnSequence.setText("Sequence");
        this.tblclmnRunOn.setText("Run Date/Time");
        this.tblclmnTester.setText("Tester");
        this.tblclmnDutModel.setText("DUT Model");
        this.tblclmnDut.setText("DUT Serial Number");
        this.tblclmnUser.setText("User");
        if (c == this.tblclmnSequence) {
            label = "Sequence";
            new_order_by = 1;
        } else if (c == this.tblclmnRunOn) {
            label = "Run Date/Time";
            new_order_by = 0;
        } else if (c == this.tblclmnTester) {
            label = "Tester";
            new_order_by = 2;
        } else if (c == this.tblclmnDutModel) {
            label = "DUT Model";
            new_order_by = 3;
        } else if (c == this.tblclmnDut) {
            label = "DUT Serial Number";
            new_order_by = 4;
        } else {
            label = "User";
            new_order_by = 5;
        }
        String dir = upTriangle;
        if (new_order_by == this.order_by) {
            if (this.order_order == 256) {
                this.order_order = 512;
                dir = downTriangle;
            } else {
                this.order_order = 256;
                dir = upTriangle;
            }
        } else {
            this.order_order = 256;
            dir = upTriangle;
        }
        this.order_by = new_order_by;
        c.setText(String.valueOf(label) + dir);
        this.runResultsQuery();
    }

    private void displaySelectedResult() {
        this.grpQueryFilters.setEnabled(false);
        this.tableQueryResults.setVisible(false);
        this.btnRunQuery.setVisible(false);
        this.btnExportQuery.setVisible(false);
        this.btnDeleteAll.setVisible(false);
        this.btnBack.setVisible(true);
        if (this.result.status == 0) {
            this.lblSequenceResult.setForeground(this.passColor);
            this.lblSequenceResult.setText("Sequence Passed");
        } else {
            this.lblSequenceResult.setForeground(this.failColor);
            this.lblSequenceResult.setText("Sequence Failed");
        }
        this.lblSequenceResult.setVisible(true);
        this.lblStepResult.setVisible(true);
        this.tableStepList.removeAll();
        int i = 0;
        while (i < this.result.num_steps) {
            TableItem n_item = new TableItem(this.tableStepList, 0);
            n_item.setText(new String[]{"#" + (i + 1), this.result.steps[i].getName()});
            if (this.result.step_results[i].status == 0) {
                n_item.setForeground(SWTResourceManager.getColor(0, 0, 0));
            } else {
                n_item.setForeground(SWTResourceManager.getColor(255, 0, 0));
            }
            ++i;
        }
        this.tableStepList.setSelection(0);
        this.groupStepList.setVisible(true);
        this.displayStepResults(0);
        if (this.result.status != 0) {
            String[] errs = this.result.tester.decodeStatusFlags(this.result.status);
            String lbl = "";
            int i2 = 0;
            while (i2 < errs.length) {
                lbl = String.valueOf(lbl) + errs[i2] + "\r\n";
                ++i2;
            }
            this.grpSequenceErrors.setVisible(true);
            this.lblSequenceErrors.setText(lbl);
        }
        switch (this.result.detail_level) {
            case brief: {
                comboLevel.setText("Brief");
                break;
            }
            case normal: {
                comboLevel.setText("Normal");
                break;
            }
            case full: {
                comboLevel.setText("Full");
                break;
            }
            case full_plus_charts_wide: {
                comboLevel.setText("Full+Charts (wide)");
                break;
            }
            case full_plus_charts_tall: {
                comboLevel.setText("Full+Charts (tall)");
                break;
            }
            default: {
                comboLevel.setText("Normal");
            }
        }
        this.lblShowModel.setText(this.result.dut_model);
        this.lblShowSerial.setText(this.result.dut_sn);
        this.lblShowNotes.setText(this.result.test_notes);
        this.grpDutDetails.setVisible(true);
        this.grpReportDetailLevel.setVisible(true);
        this.btnDeleteRecord.setVisible(UserSettings.permissions.delete_reports);
        this.btnSaveCsv.setVisible(true);
        this.btnSavePdf.setVisible(true);
        this.btnPrint.setVisible(true);
    }

    private void displayQueryView() {
        int m = 0;
        while (m < 3) {
            this.metricDisplays[m].group.setVisible(false);
            this.metricDisplays[m].comp.setVisible(false);
            this.metricDisplays[m].chart.setVisible(false);
            ++m;
        }
        this.btnExportChartData.setVisible(false);
        this.grpDutDetails.setVisible(false);
        this.grpReportDetailLevel.setVisible(false);
        this.btnDeleteRecord.setVisible(false);
        this.btnSaveCsv.setVisible(false);
        this.btnSavePdf.setVisible(false);
        this.btnPrint.setVisible(false);
        this.grpSequenceErrors.setVisible(false);
        this.groupStepList.setVisible(false);
        this.lblSequenceResult.setVisible(false);
        this.lblStepResult.setVisible(false);
        this.btnBack.setVisible(false);
        this.tableQueryResults.setVisible(true);
        this.btnRunQuery.setVisible(true);
        this.btnExportQuery.setVisible(true);
        this.btnDeleteAll.setVisible(true);
        this.grpQueryFilters.setEnabled(true);
    }

    public MainReportsView(final Composite parent, int style) {
        super(parent, style);
        this.setBackground(SWTResourceManager.getColor(240, 240, 240));
        this.display = parent.getDisplay();
        if (calQueryFrom == null) {
            long tnow = System.currentTimeMillis();
            calQueryFrom = new GregorianCalendar();
            calQueryTo = new GregorianCalendar();
            calQueryFrom.setTimeInMillis(tnow);
            calQueryTo.setTimeInMillis(tnow);
            calQueryFrom.set(11, 0);
            calQueryFrom.set(12, 0);
            calQueryFrom.set(13, 0);
            calQueryTo.set(11, 23);
            calQueryTo.set(12, 59);
            calQueryTo.set(13, 59);
        }
        this.loadConfiguration();
        this.working_index = 0;
        if (!this.system_configuration.series.isEmpty()) {
            this.sequence_names = TestSequence.getNames(this.system_configuration.series);
        }
        this.grpDutDetails = new Group((Composite)this, 0);
        this.grpDutDetails.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.grpDutDetails.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.grpDutDetails.setBackground(SWTResourceManager.getColor(225, 225, 225));
        this.grpDutDetails.setText("DUT Information");
        this.grpDutDetails.setBounds(350, 10, 490, 58);
        this.grpDutDetails.setVisible(false);
        Label lblModel = new Label((Composite)this.grpDutDetails, 0);
        lblModel.setBounds(10, 20, 43, 15);
        lblModel.setText("Model:");
        Label lblSerial = new Label((Composite)this.grpDutDetails, 0);
        lblSerial.setBounds(226, 20, 43, 15);
        lblSerial.setText("Serial #:");
        Label lblNotes = new Label((Composite)this.grpDutDetails, 0);
        lblNotes.setText("Notes:");
        lblNotes.setBounds(10, 40, 43, 15);
        this.lblShowModel = new Label((Composite)this.grpDutDetails, 0);
        this.lblShowModel.setBounds(53, 20, 159, 15);
        this.lblShowModel.setText("___Model___");
        this.lblShowSerial = new Label((Composite)this.grpDutDetails, 0);
        this.lblShowSerial.setBounds(273, 20, 176, 15);
        this.lblShowSerial.setText("___Serial #___");
        this.lblShowNotes = new Label((Composite)this.grpDutDetails, 0);
        this.lblShowNotes.setText("___Notes___");
        this.lblShowNotes.setBounds(53, 40, 159, 15);
        this.grpReportDetailLevel = new Group((Composite)this, 0);
        this.grpReportDetailLevel.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.grpReportDetailLevel.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.grpReportDetailLevel.setBackground(SWTResourceManager.getColor(225, 225, 225));
        this.grpReportDetailLevel.setText("Report Detail Level");
        this.grpReportDetailLevel.setBounds(845, 10, 150, 58);
        this.grpReportDetailLevel.setVisible(false);
        comboLevel = new Combo((Composite)this.grpReportDetailLevel, 0);
        comboLevel.setBounds(10, 25, 123, 23);
        comboLevel.setItems(new String[]{"Brief", "Normal", "Full", "Full+Charts (wide)", "Full+Charts (tall)"});
        comboLevel.setToolTipText("Selects the level of detail in the test report.");
        this.grpQueryFilters = new Group((Composite)this, 0);
        this.grpQueryFilters.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.grpQueryFilters.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.grpQueryFilters.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        this.grpQueryFilters.setText("Query Filters");
        this.grpQueryFilters.setBounds(10, 0, 985, 70);
        Label lblTest = new Label((Composite)this.grpQueryFilters, 0);
        lblTest.setBounds(10, 27, 27, 15);
        lblTest.setText("Test");
        this.comboSequenceList = new Combo((Composite)this.grpQueryFilters, 0);
        this.comboSequenceList.setToolTipText("Filter the results by a selected sequence name.");
        this.comboSequenceList.setBounds(38, 23, 150, 23);
        this.comboSequenceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        this.comboSequenceList.setItems(this.sequence_names);
        Label lblFrom = new Label((Composite)this.grpQueryFilters, 0);
        lblFrom.setBounds(214, 21, 32, 15);
        lblFrom.setText("From");
        this.queryFromDate = new DateTime((Composite)this.grpQueryFilters, 2052);
        this.queryFromDate.setToolTipText("This specifies the beginning date for the result set, inclusive of.");
        this.queryFromDate.setBounds(246, 18, 80, 24);
        this.queryFromDate.setDate(calQueryFrom.get(1), calQueryFrom.get(2), calQueryFrom.get(5));
        this.queryFromDate.setTime(0, 0, 0);
        this.queryFromDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                calQueryFrom.set(MainReportsView.this.queryFromDate.getYear(), MainReportsView.this.queryFromDate.getMonth(), MainReportsView.this.queryFromDate.getDay());
            }
        });
        Label lblTo = new Label((Composite)this.grpQueryFilters, 0);
        lblTo.setBounds(230, 45, 12, 15);
        lblTo.setText("To");
        this.queryToDate = new DateTime((Composite)this.grpQueryFilters, 2052);
        this.queryToDate.setToolTipText("This specifies the ending date for the result set, inclusive of.");
        this.queryToDate.setBounds(246, 42, 80, 24);
        this.queryToDate.setDate(calQueryTo.get(1), calQueryTo.get(2), calQueryTo.get(5));
        this.queryToDate.setTime(23, 59, 59);
        this.queryToDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                calQueryTo.set(MainReportsView.this.queryToDate.getYear(), MainReportsView.this.queryToDate.getMonth(), MainReportsView.this.queryToDate.getDay());
            }
        });
        this.btnQueryPass = new Button((Composite)this.grpQueryFilters, 32);
        this.btnQueryPass.setToolTipText("Check to include passing tests in the results.");
        this.btnQueryPass.setBounds(354, 20, 46, 16);
        this.btnQueryPass.setText("Pass");
        this.btnQueryPass.setSelection(true);
        this.btnQueryFail = new Button((Composite)this.grpQueryFilters, 32);
        this.btnQueryFail.setToolTipText("Check to include failing tests in the results.");
        this.btnQueryFail.setText("Fail");
        this.btnQueryFail.setBounds(354, 43, 46, 16);
        this.btnQueryFail.setSelection(true);
        Label lblDutModel = new Label((Composite)this.grpQueryFilters, 0);
        lblDutModel.setBounds(472, 17, 62, 15);
        lblDutModel.setText("DUT Model");
        this.textDutModel = new Text((Composite)this.grpQueryFilters, 2048);
        this.textDutModel.setToolTipText("Filter by a specific model or a wildcard pattern using '*'.");
        this.textDutModel.setBounds(543, 17, 111, 21);
        Label lblUser = new Label((Composite)this.grpQueryFilters, 0);
        lblUser.setText("User");
        lblUser.setBounds(472, 38, 62, 22);
        this.textUser = new Text((Composite)this.grpQueryFilters, 2048);
        this.textUser.setToolTipText("Filer the results by a user name.");
        this.textUser.setBounds(543, 40, 111, 23);
        Label lblSerialRange = new Label((Composite)this.grpQueryFilters, 0);
        lblSerialRange.setBounds(660, 18, 43, 42);
        lblSerialRange.setText("         \u2192\r\nSerial #\r\n         \u2192");
        this.textDutSnStart = new Text((Composite)this.grpQueryFilters, 2048);
        this.textDutSnStart.setToolTipText("Filter with a serial number range or wildcard pattern using '*'.");
        this.textDutSnStart.setBounds(703, 17, 145, 21);
        this.textDutSnEnd = new Text((Composite)this.grpQueryFilters, 2048);
        this.textDutSnEnd.setToolTipText("The ending serial number when using a range.");
        this.textDutSnEnd.setBounds(703, 40, 145, 23);
        Label lblTesterNumber = new Label((Composite)this.grpQueryFilters, 0);
        lblTesterNumber.setText("Tester #");
        lblTesterNumber.setBounds(854, 43, 62, 15);
        Label lblTesterModel = new Label((Composite)this.grpQueryFilters, 0);
        lblTesterModel.setText("Tester Model");
        lblTesterModel.setBounds(854, 20, 72, 15);
        this.textTesterModel = new Text((Composite)this.grpQueryFilters, 2048);
        this.textTesterModel.setToolTipText("Filter by a specific tester model.");
        this.textTesterModel.setBounds(929, 20, 46, 21);
        this.textTesterSn = new Text((Composite)this.grpQueryFilters, 2048);
        this.textTesterSn.setToolTipText("Filter by a specific tester serial number.");
        this.textTesterSn.setBounds(929, 40, 46, 23);
        this.lblBusyWorking = new Label((Composite)this, 0);
        this.lblBusyWorking.setBounds(925, 88, 70, 70);
        this.lblSequenceResult = new Label((Composite)this, 0);
        this.lblSequenceResult.setForeground(SWTResourceManager.getColor(51, 170, 51));
        this.lblSequenceResult.setBackground(SWTResourceManager.getColor(245, 245, 245));
        this.lblSequenceResult.setBounds(257, 76, 124, 19);
        this.lblSequenceResult.setText("Sequence Result: Pass");
        this.lblSequenceResult.setVisible(false);
        this.lblStepResult = new Label((Composite)this, 0);
        this.lblStepResult.setForeground(SWTResourceManager.getColor(255, 51, 51));
        this.lblStepResult.setBackground(SWTResourceManager.getColor(245, 245, 245));
        this.lblStepResult.setText("Step Result: Pass");
        this.lblStepResult.setBounds(10, 136, 160, 19);
        this.lblStepResult.setVisible(false);
        this.btnExportChartData = new Button((Composite)this, 0);
        this.btnExportChartData.setToolTipText("Click to save the charted measurement data in a CSV file.");
        this.btnExportChartData.setBounds(291, 129, 109, 29);
        this.btnExportChartData.setText("Export Chart Data");
        this.btnExportChartData.setVisible(false);
        this.btnExportChartData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainReportsView.this.result.exportChartData(MainReportsView.this.working_index, parent);
            }
        });
        this.grpSequenceErrors = new Group((Composite)this, 0);
        this.grpSequenceErrors.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.grpSequenceErrors.setText("Sequence Errors");
        this.grpSequenceErrors.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.grpSequenceErrors.setBounds(459, 77, 301, 82);
        this.grpSequenceErrors.setVisible(false);
        this.lblSequenceErrors = new Label((Composite)this.grpSequenceErrors, 592);
        this.lblSequenceErrors.setVisible(true);
        this.lblSequenceErrors.setFont(SWTResourceManager.getFont("Segoe UI", 8, 0));
        this.lblSequenceErrors.setBounds(10, 15, 281, 55);
        this.btnSavePdf = new Button((Composite)this, 0);
        this.btnSavePdf.setToolTipText("Save the test results as a formatted report in a PDF file.");
        this.btnSavePdf.setBounds(845, 75, 75, 25);
        this.btnSavePdf.setText("Save PDF");
        this.btnSavePdf.setVisible(false);
        this.btnSavePdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Exception decompiling
             */
            public void widgetSelected(SelectionEvent e) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl32 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl32 : CaseStatement: default:\u000a]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
                 *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
                 *     at java.base/java.util.TimSort.sort(TimSort.java:221)
                 *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
                 *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
                 *     at java.base/java.util.Collections.sort(Collections.java:178)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.btnSaveCsv = new Button((Composite)this, 0);
        this.btnSaveCsv.setToolTipText("Save the test results in a CSV file.");
        this.btnSaveCsv.setBounds(845, 105, 75, 25);
        this.btnSaveCsv.setText("Save CSV");
        this.btnSaveCsv.setVisible(false);
        this.btnSaveCsv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainReportsView.this.result.saveAsCsv(parent);
            }
        });
        this.btnPrint = new Button((Composite)this, 0);
        this.btnPrint.setToolTipText("Print the test results.");
        this.btnPrint.setBounds(845, 133, 75, 25);
        this.btnPrint.setText("Print");
        this.btnPrint.setVisible(false);
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Exception decompiling
             */
            public void widgetSelected(SelectionEvent e) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl32 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl32 : CaseStatement: default:\u000a]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
                 *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
                 *     at java.base/java.util.TimSort.sort(TimSort.java:221)
                 *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
                 *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
                 *     at java.base/java.util.Collections.sort(Collections.java:178)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.groupStepList = new Group((Composite)this, 0);
        this.groupStepList.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        this.groupStepList.setText("Steps");
        this.groupStepList.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.groupStepList.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupStepList.setBounds(10, 164, 159, 336);
        this.groupStepList.setVisible(false);
        this.tableStepList = new Table((Composite)this.groupStepList, 68112);
        this.tableStepList.setBounds(10, 30, 137, 296);
        this.tableStepList.setLinesVisible(true);
        this.tableStepList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = MainReportsView.this.tableStepList.getSelectionIndex();
                if (si != -1 && MainReportsView.this.result != null) {
                    MainReportsView.this.displayStepResults(si);
                }
            }
        });
        TableColumn tblColStepNum = new TableColumn(this.tableStepList, 0);
        tblColStepNum.setWidth(37);
        tblColStepNum.setText("#");
        TableColumn tblColStepInfo = new TableColumn(this.tableStepList, 0);
        tblColStepInfo.setWidth(100);
        tblColStepInfo.setText("Steps");
        this.groupMetric1 = new Group((Composite)this, 0);
        this.groupMetric1.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        this.groupMetric1.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.groupMetric1.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupMetric1.setBounds(175, 164, 110, 110);
        this.groupMetric1.setVisible(false);
        this.lblMetricValue1 = new Label((Composite)this.groupMetric1, 0);
        this.lblMetricValue1.setAlignment(131072);
        this.lblMetricValue1.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        this.lblMetricValue1.setBounds(5, 42, 100, 26);
        this.compChart1 = new Composite((Composite)this, 0x1000000);
        this.compChart1.setBounds(291, 164, 704, 110);
        this.compChart1.setVisible(false);
        this.groupMetric2 = new Group((Composite)this, 0);
        this.groupMetric2.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.groupMetric2.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        this.groupMetric2.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupMetric2.setBounds(175, 276, 110, 110);
        this.groupMetric2.setVisible(false);
        this.lblMetricValue2 = new Label((Composite)this.groupMetric2, 0);
        this.lblMetricValue2.setAlignment(131072);
        this.lblMetricValue2.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        this.lblMetricValue2.setBounds(5, 42, 100, 26);
        this.compChart2 = new Composite((Composite)this, 0x1000000);
        this.compChart2.setBounds(291, 276, 704, 110);
        this.compChart2.setVisible(false);
        this.groupMetric3 = new Group((Composite)this, 0);
        this.groupMetric3.setForeground(SWTResourceManager.getColor(0, 121, 193));
        this.groupMetric3.setFont(SWTResourceManager.getFont("Segoe UI", 12, 1));
        this.groupMetric3.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.groupMetric3.setBounds(175, 388, 110, 110);
        this.groupMetric3.setVisible(false);
        this.lblMetricValue3 = new Label((Composite)this.groupMetric3, 0);
        this.lblMetricValue3.setAlignment(131072);
        this.lblMetricValue3.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        this.lblMetricValue3.setBounds(5, 42, 100, 26);
        this.compChart3 = new Composite((Composite)this, 0x1000000);
        this.compChart3.setBounds(291, 388, 704, 110);
        this.compChart3.setVisible(false);
        this.chartLineColors = new Color[3];
        this.chartLineColors[0] = new Color((Device)Display.getDefault(), 255, 0, 0);
        this.chartLineColors[1] = new Color((Device)Display.getDefault(), 0, 128, 64);
        this.chartLineColors[2] = new Color((Device)Display.getDefault(), 0, 128, 255);
        this.metricDisplays = new MetricDisplay[3];
        this.metricDisplays[0] = new MetricDisplay();
        this.metricDisplays[1] = new MetricDisplay();
        this.metricDisplays[2] = new MetricDisplay();
        this.metricDisplays[0].group = this.groupMetric1;
        this.metricDisplays[0].value = this.lblMetricValue1;
        this.metricDisplays[0].comp = this.compChart1;
        this.metricDisplays[1].group = this.groupMetric2;
        this.metricDisplays[1].value = this.lblMetricValue2;
        this.metricDisplays[1].comp = this.compChart2;
        this.metricDisplays[2].group = this.groupMetric3;
        this.metricDisplays[2].value = this.lblMetricValue3;
        this.metricDisplays[2].comp = this.compChart3;
        Chart ch = this.blankChart(this.compChart1, "Chart 1", "Units", new Color((Device)Display.getDefault(), 255, 0, 0));
        ch.setVisible(false);
        this.metricDisplays[0].chart = ch;
        ch = this.blankChart(this.compChart2, "Chart 2", "Units", new Color((Device)Display.getDefault(), 0, 128, 64));
        ch.setVisible(false);
        this.metricDisplays[1].chart = ch;
        ch = this.blankChart(this.compChart3, "Chart 3", "Units", new Color((Device)Display.getDefault(), 0, 128, 255));
        ch.setVisible(false);
        this.metricDisplays[2].chart = ch;
        this.btnRunQuery = new Button((Composite)this, 0);
        this.btnRunQuery.setToolTipText("Click to query the filtered results.");
        this.btnRunQuery.setBounds(10, 76, 75, 25);
        this.btnRunQuery.setText("Query");
        this.btnRunQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainReportsView.this.runResultsQuery();
            }
        });
        this.btnBack = new Button((Composite)this, 0);
        this.btnBack.setToolTipText("Click to return to the query results.");
        this.btnBack.setText("Back");
        this.btnBack.setBounds(10, 76, 75, 25);
        this.btnBack.setVisible(false);
        this.btnBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainReportsView.this.displayQueryView();
            }
        });
        this.btnExportQuery = new Button((Composite)this, 0);
        this.btnExportQuery.setToolTipText("Click to export the result set to a CSV formatted file.");
        this.btnExportQuery.setText("Export");
        this.btnExportQuery.setBounds(106, 76, 75, 25);
        this.btnExportQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SequenceResults.saveQueryCsv(parent, MainReportsView.this.result_list);
            }
        });
        this.btnDeleteAll = new Button((Composite)this, 0);
        this.btnDeleteAll.setToolTipText("Click to permanently delete the result set.");
        this.btnDeleteAll.setBackground(SWTResourceManager.getColor(0, 0, 64));
        this.btnDeleteAll.setForeground(SWTResourceManager.getColor(255, 0, 0));
        this.btnDeleteAll.setText("Delete");
        this.btnDeleteAll.setBounds(201, 75, 75, 25);
        this.btnDeleteAll.setVisible(false);
        this.btnDeleteAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean yes_delete = true;
                if (MainReportsView.this.result_list.length > 1) {
                    MessageBox mb = new MessageBox(parent.getShell(), 65736);
                    mb.setText("Are you sure");
                    mb.setMessage("You are about to delete " + MainReportsView.this.result_list.length + " record(s)");
                    boolean bl = yes_delete = mb.open() == 64;
                    if (yes_delete && MainReportsView.this.result_list.length > 3) {
                        mb.setText("Are you REALLY sure");
                        mb.setMessage("You are about to delete " + MainReportsView.this.result_list.length + " record(s)");
                        boolean bl2 = yes_delete = mb.open() == 64;
                    }
                }
                if (yes_delete) {
                    SequenceResults.delete(MainReportsView.this.result_list);
                    MainReportsView.this.btnDeleteAll.setVisible(false);
                    MainReportsView.this.tableQueryResults.removeAll();
                }
            }
        });
        this.btnDeleteRecord = new Button((Composite)this, 0);
        this.btnDeleteRecord.setToolTipText("Click to permanently delete this record.");
        this.btnDeleteRecord.setBackground(SWTResourceManager.getColor(0, 0, 64));
        this.btnDeleteRecord.setForeground(SWTResourceManager.getColor(255, 0, 0));
        this.btnDeleteRecord.setText("Delete");
        this.btnDeleteRecord.setBounds(106, 76, 75, 25);
        this.btnDeleteRecord.setVisible(false);
        this.btnDeleteRecord.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainReportsView.this.result.delete();
                MainReportsView.this.tableQueryResults.remove(MainReportsView.this.tableQueryResults.getSelectionIndex());
                MainReportsView.this.displayQueryView();
            }
        });
        this.tableQueryResults = new Table((Composite)this, 68112);
        this.tableQueryResults.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.tableQueryResults.setHeaderForeground(SWTResourceManager.getColor(0, 121, 193));
        this.tableQueryResults.setHeaderBackground(SWTResourceManager.getColor(220, 220, 220));
        this.tableQueryResults.setBounds(10, 136, 802, 350);
        this.tableQueryResults.setHeaderVisible(true);
        this.tableQueryResults.setLinesVisible(true);
        this.tblclmnSequence = new TableColumn(this.tableQueryResults, 0);
        this.tblclmnSequence.setWidth(100);
        this.tblclmnSequence.setText("Sequence");
        this.tblclmnSequence.addListener(13, event -> this.selectSorting(this.tblclmnSequence));
        this.tblclmnRunOn = new TableColumn(this.tableQueryResults, 0);
        this.tblclmnRunOn.setWidth(129);
        this.tblclmnRunOn.setText("Run Date/Time\u25b2");
        this.tblclmnRunOn.addListener(13, event -> this.selectSorting(this.tblclmnRunOn));
        this.tblclmnTester = new TableColumn(this.tableQueryResults, 0);
        this.tblclmnTester.setWidth(100);
        this.tblclmnTester.setText("Tester");
        this.tblclmnTester.addListener(13, event -> this.selectSorting(this.tblclmnTester));
        this.tblclmnDutModel = new TableColumn(this.tableQueryResults, 0);
        this.tblclmnDutModel.setWidth(139);
        this.tblclmnDutModel.setText("DUT Model");
        this.tblclmnDutModel.addListener(13, event -> this.selectSorting(this.tblclmnDutModel));
        this.tblclmnDut = new TableColumn(this.tableQueryResults, 0);
        this.tblclmnDut.setWidth(154);
        this.tblclmnDut.setText("DUT Serial Number");
        this.tblclmnDut.addListener(13, event -> this.selectSorting(this.tblclmnDut));
        this.tblclmnUser = new TableColumn(this.tableQueryResults, 0);
        this.tblclmnUser.setWidth(96);
        this.tblclmnUser.setText("User");
        this.tblclmnUser.addListener(13, event -> this.selectSorting(this.tblclmnUser));
        this.tblclmnResult = new TableColumn(this.tableQueryResults, 0);
        this.tblclmnResult.setWidth(63);
        this.tblclmnResult.setText("Result");
        this.tableQueryResults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = MainReportsView.this.tableQueryResults.getSelectionIndex();
                if (si != -1) {
                    MainReportsView.this.result = MainReportsView.this.result_list[si].load();
                    MainReportsView.this.displaySelectedResult();
                    MainReportsView.this.working_index = 0;
                }
            }
        });
        this.runResultsQuery();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                System.out.println("reports disposed");
                BusySpinner.stop(true);
            }
        });
    }

    protected void checkSubclass() {
    }

    static /* synthetic */ Combo access$3() {
        return comboLevel;
    }
}

