/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class MainConfigurationView
extends Composite {
    Display display;
    SystemConfiguration settings;
    SystemConfiguration jtest;
    private Table tableConfigList;
    String[] serial_port_list;
    private String[] config_names;
    private Boolean have_serial_ports;
    private Button btnRS232;
    private Button btnEthernet;
    private Button btnUsb;
    private Button btnGpib;
    private Combo combo_com_ports;
    private Combo combo_baud_rate;
    private Text ip_address;
    private Combo combo_usb_devices;
    private Label usb_status_label;
    private Label lbl_gpib_controller;
    private Label lbl_gpib_address;
    private Spinner tester_gpib_controller;
    private Spinner tester_gpib_address;
    private Label lblInterfaceErrorText;
    private Label lblVerifyPassedIcon;
    private Label lblVerifyFailedIcon;
    private Button btnEnableSwitches;
    private Label lblModel;
    private Label lblConnectedTo;
    private Combo comboSwitchModel;
    private Combo comboSwitchConnection;
    private Interface comm_io;
    private Thread com_worker;
    private Combo comboSelectSeries;
    private Table tableSwitches;
    private Button btnAddSwitch;
    private Button btnDeleteSwitch;
    private Label lblNumSwitches;
    private TableColumn tblclmnNewColumn;

    private void fetchWidgetContents() {
        this.settings.series = this.comboSelectSeries.getText();
        switch (this.settings.pc_interface) {
            case physical_rs232: {
                this.settings.interface_settings[0] = this.combo_com_ports.getText();
                this.settings.interface_settings[1] = this.combo_baud_rate.getText();
                break;
            }
            case physical_ethernet: {
                this.settings.interface_settings[0] = this.ip_address.getText();
                break;
            }
            case physical_usb: {
                this.settings.interface_settings[0] = this.combo_usb_devices.getText();
                break;
            }
            case physical_gpib: {
                this.settings.interface_settings[0] = this.tester_gpib_controller.getText();
                this.settings.interface_settings[1] = this.tester_gpib_address.getText();
            }
        }
        this.settings.use_switches = this.btnEnableSwitches.getSelection();
    }

    private void populateSwitchList() {
        this.lblNumSwitches.setText("Switches:" + Integer.toString(this.settings.num_switches));
        this.tableSwitches.removeAll();
        int max_rows = this.settings.num_switches <= 15 ? this.settings.num_switches : 15;
        this.tableSwitches.setBounds(99, 100, 160, 31 + max_rows * 20);
        int id = 1;
        SwitchSettings[] switchSettingsArray = this.settings.switches;
        int n = this.settings.switches.length;
        int n2 = 0;
        while (n2 < n) {
            SwitchSettings sc = switchSettingsArray[n2];
            String connection = "";
            String label = "#" + id;
            block0 : switch (this.settings.switch_control) {
                case switch_control_tester_VICL: {
                    connection = "VICL " + id;
                    break;
                }
                case switch_control_tester_RS232: {
                    connection = "RS232";
                    break;
                }
                case switch_control_tester_TCPIP: {
                    connection = "TCP/IP";
                    break;
                }
                case switch_control_tester_internal: {
                    connection = "Tester";
                    break;
                }
                case switch_control_computer: {
                    switch (sc.pc_interface) {
                        case physical_rs232: {
                            connection = String.valueOf(sc.isettings[0]) + "," + sc.isettings[1];
                            break block0;
                        }
                        case physical_ethernet: {
                            connection = sc.isettings[0];
                            break block0;
                        }
                        case physical_gpib: {
                            connection = "GPIB " + sc.isettings[0] + ":" + sc.isettings[1];
                            break block0;
                        }
                    }
                }
            }
            TableItem n_item = new TableItem(this.tableSwitches, 0);
            n_item.setText(new String[]{label, connection});
            ++id;
            ++n2;
        }
    }

    private void loadConfiguration(String config_name) {
        if (config_name.isEmpty()) {
            this.settings = new SystemConfiguration();
        } else {
            this.settings = SystemConfiguration.load(config_name);
            UserSettings.configuration_name = config_name;
        }
        boolean cr = this.settings.verifyInterface(this.serial_port_list, InterfaceFactory.haveGpib(), true);
        if (!cr) {
            MessageBox ed = new MessageBox(this.display.getActiveShell(), 40);
            ed.setText("Information");
            ed.setMessage("The saved configuration interface is invalid.");
            ed.open();
        }
        this.comboSelectSeries.setText(this.settings.series);
        this.btnRS232.setSelection(false);
        this.btnEthernet.setSelection(false);
        this.btnUsb.setSelection(false);
        this.btnGpib.setSelection(false);
        this.combo_com_ports.setVisible(false);
        this.combo_baud_rate.setVisible(false);
        this.ip_address.setVisible(false);
        this.combo_usb_devices.setVisible(false);
        this.lbl_gpib_controller.setVisible(false);
        this.lbl_gpib_address.setVisible(false);
        this.tester_gpib_controller.setVisible(false);
        this.tester_gpib_address.setVisible(false);
        this.usb_status_label.setVisible(false);
        if (this.have_serial_ports.booleanValue()) {
            this.combo_com_ports.setText(this.serial_port_list[0]);
        }
        this.combo_baud_rate.setText("115200");
        this.ip_address.setText("192.168.1.100");
        this.tester_gpib_controller.setSelection(0);
        this.tester_gpib_address.setSelection(1);
        switch (this.settings.pc_interface) {
            case physical_rs232: {
                this.combo_com_ports.setText(this.settings.interface_settings[0]);
                this.combo_baud_rate.setText(this.settings.interface_settings[1]);
                this.btnRS232.setSelection(true);
                this.combo_com_ports.setVisible(true);
                this.combo_baud_rate.setVisible(true);
                break;
            }
            case physical_ethernet: {
                this.ip_address.setText(this.settings.interface_settings[0]);
                this.btnEthernet.setSelection(true);
                this.ip_address.setVisible(true);
                break;
            }
            case physical_gpib: {
                this.tester_gpib_controller.setSelection(Integer.valueOf(this.settings.interface_settings[0]).intValue());
                this.tester_gpib_address.setSelection(Integer.valueOf(this.settings.interface_settings[1]).intValue());
                this.btnGpib.setSelection(true);
                this.lbl_gpib_controller.setVisible(true);
                this.lbl_gpib_address.setVisible(true);
                this.tester_gpib_controller.setVisible(true);
                this.tester_gpib_address.setVisible(true);
                break;
            }
            case physical_usb: {
                this.btnUsb.setSelection(true);
                String[] dlist = InterfaceFactory.getUsbDeviceList();
                if (dlist != null) {
                    this.combo_usb_devices.setItems(dlist);
                    this.combo_usb_devices.setText(this.settings.interface_settings[0]);
                    this.combo_usb_devices.setVisible(true);
                    if (Arrays.asList(dlist).contains(this.settings.interface_settings[0])) {
                        this.combo_usb_devices.setForeground(SWTResourceManager.getColor(0, 0, 0));
                        break;
                    }
                    this.combo_usb_devices.setForeground(SWTResourceManager.getColor(255, 0, 0));
                    break;
                }
                this.usb_status_label.setText("None found");
                this.usb_status_label.setVisible(true);
            }
        }
        String[] models = this.settings.switchModelChoices();
        this.comboSwitchModel.setItems(models);
        if (this.settings.use_switches) {
            this.comboSwitchModel.setText(this.settings.switches[0].model);
            String[] choices = this.settings.switchTopInterfaceChoices(this.settings.switches[0].model);
            this.comboSwitchConnection.setItems(choices);
            switch (this.settings.switch_control) {
                case switch_control_tester_VICL: {
                    this.comboSwitchConnection.setText("Tester (VICL)");
                    break;
                }
                case switch_control_tester_RS232: {
                    this.comboSwitchConnection.setText("Tester (RS232)");
                    break;
                }
                case switch_control_tester_TCPIP: {
                    this.comboSwitchConnection.setText("Tester (TCP/IP)");
                    break;
                }
                case switch_control_tester_internal: {
                    this.comboSwitchConnection.setText("Tester (Internal)");
                    break;
                }
                case switch_control_computer: {
                    this.comboSwitchConnection.setText("Computer");
                }
            }
            this.btnEnableSwitches.setSelection(true);
            this.lblModel.setVisible(true);
            this.lblConnectedTo.setVisible(true);
            this.comboSwitchModel.setVisible(true);
            this.comboSwitchConnection.setVisible(true);
            this.tableSwitches.setVisible(true);
            this.btnAddSwitch.setVisible(true);
            this.btnDeleteSwitch.setVisible(true);
            this.lblNumSwitches.setVisible(true);
        } else {
            this.comboSwitchModel.setText(models[0]);
            String[] choices = this.settings.switchTopInterfaceChoices(models[0]);
            this.comboSwitchConnection.setItems(choices);
            this.comboSwitchConnection.setText(choices[0]);
            this.btnEnableSwitches.setSelection(false);
            this.lblModel.setVisible(false);
            this.lblConnectedTo.setVisible(false);
            this.comboSwitchModel.setVisible(false);
            this.comboSwitchConnection.setVisible(false);
            this.tableSwitches.setVisible(false);
            this.btnAddSwitch.setVisible(false);
            this.btnDeleteSwitch.setVisible(false);
            this.lblNumSwitches.setVisible(false);
        }
        this.populateSwitchList();
    }

    private void saveAs(Shell sh) {
        ConfigurationPromptName dialog = new ConfigurationPromptName(sh);
        if (dialog.open() == 32) {
            String name = dialog.getName();
            if (name != "") {
                int ii = Utils.indexOf(this.config_names, name);
                if (ii == -1) {
                    this.fetchWidgetContents();
                    int r = this.settings.saveAs(name);
                    if (r != 0) {
                        MessageBox ed = new MessageBox(sh, 33);
                        ed.setText("Error");
                        ed.setMessage("Cannot save.");
                        ed.open();
                    } else {
                        UserSettings.configuration_name = name;
                    }
                    this.config_names = SystemConfiguration.getNames();
                    this.tableConfigList.removeAll();
                    String[] stringArray = this.config_names;
                    int n = this.config_names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String c = stringArray[n2];
                        TableItem n_item = new TableItem(this.tableConfigList, 0);
                        n_item.setText(c);
                        ++n2;
                    }
                    ii = Utils.indexOf(this.config_names, this.settings.loaded_name);
                    this.tableConfigList.setSelection(ii);
                } else {
                    MessageBox ed = new MessageBox(sh, 40);
                    ed.setText("Information");
                    ed.setMessage("The configuration name already exists.");
                    ed.open();
                }
            } else {
                MessageBox ed = new MessageBox(sh, 40);
                ed.setText("Information");
                ed.setMessage("Cannot have a configuration without a name.");
                ed.open();
            }
        }
        dialog.close();
    }

    public MainConfigurationView(final Composite parent, int style) {
        super(parent, style);
        this.display = parent.getDisplay();
        this.config_names = SystemConfiguration.getNames();
        this.serial_port_list = InterfaceFactory.getRs232PortList();
        this.have_serial_ports = this.serial_port_list != null && this.serial_port_list.length > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        Group grpConfigurationsList = new Group((Composite)this, 2048);
        grpConfigurationsList.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpConfigurationsList.setText("Configuration List");
        grpConfigurationsList.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpConfigurationsList.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpConfigurationsList.setBounds(10, 0, 275, 454);
        this.tableConfigList = new Table((Composite)grpConfigurationsList, 68112);
        this.tableConfigList.setLinesVisible(true);
        this.tableConfigList.setToolTipText("List of configurations.");
        this.tableConfigList.setBounds(10, 25, 165, 399);
        this.tableConfigList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ci = MainConfigurationView.this.tableConfigList.getSelectionIndex();
                if (ci != -1 && !MainConfigurationView.this.settings.loaded_name.equals(MainConfigurationView.this.config_names[ci])) {
                    MainConfigurationView.this.loadConfiguration(MainConfigurationView.this.config_names[ci]);
                }
            }
        });
        this.tblclmnNewColumn = new TableColumn(this.tableConfigList, 0);
        this.tblclmnNewColumn.setWidth(165);
        this.tblclmnNewColumn.setText("Name");
        String[] stringArray = this.config_names;
        int n = this.config_names.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            TableItem n_item = new TableItem(this.tableConfigList, 0);
            n_item.setText(c);
            ++n2;
        }
        Button btnConfigurationSave = new Button((Composite)grpConfigurationsList, 0);
        btnConfigurationSave.setBounds(197, 25, 63, 25);
        btnConfigurationSave.setText("Save");
        btnConfigurationSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainConfigurationView.this.combo_usb_devices.setForeground(SWTResourceManager.getColor(0, 0, 0));
                MainConfigurationView.this.fetchWidgetContents();
                if (MainConfigurationView.this.settings.loaded_name.isEmpty()) {
                    MainConfigurationView.this.saveAs(parent.getShell());
                } else {
                    MainConfigurationView.this.settings.save();
                }
            }
        });
        Button btnConfigurationSaveAs = new Button((Composite)grpConfigurationsList, 0);
        btnConfigurationSaveAs.setText("Save As");
        btnConfigurationSaveAs.setBounds(197, 56, 63, 25);
        btnConfigurationSaveAs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainConfigurationView.this.combo_usb_devices.setForeground(SWTResourceManager.getColor(0, 0, 0));
                MainConfigurationView.this.saveAs(parent.getShell());
            }
        });
        Button btnConfigurationDelete = new Button((Composite)grpConfigurationsList, 0);
        btnConfigurationDelete.setText("Delete");
        btnConfigurationDelete.setBounds(197, 87, 63, 25);
        btnConfigurationDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ci = MainConfigurationView.this.tableConfigList.getSelectionIndex();
                if (ci != -1) {
                    MainConfigurationView.this.settings.delete(MainConfigurationView.this.config_names[ci]);
                    MainConfigurationView.this.config_names = SystemConfiguration.getNames();
                    MainConfigurationView.this.tableConfigList.removeAll();
                    String[] stringArray = MainConfigurationView.this.config_names;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String c = stringArray[n2];
                        TableItem n_item = new TableItem(MainConfigurationView.this.tableConfigList, 0);
                        n_item.setText(c);
                        ++n2;
                    }
                    if (!MainConfigurationView.this.config_names[0].isEmpty()) {
                        MainConfigurationView.this.loadConfiguration(MainConfigurationView.this.config_names[0]);
                        MainConfigurationView.this.tableConfigList.setSelection(0);
                    } else {
                        MainConfigurationView.this.loadConfiguration("");
                    }
                }
            }
        });
        Button btnConfigurationPrint = new Button((Composite)grpConfigurationsList, 0);
        btnConfigurationPrint.setBounds(197, 118, 63, 25);
        btnConfigurationPrint.setText("Print");
        btnConfigurationPrint.setVisible(true);
        btnConfigurationPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainConfigurationView.this.settings.print(parent);
            }
        });
        if (!UserSettings.permissions.create_edit_configuration) {
            btnConfigurationSave.setVisible(false);
            btnConfigurationSaveAs.setVisible(false);
            btnConfigurationDelete.setVisible(false);
        }
        if (!UserSettings.permissions.select_configuration) {
            this.tableConfigList.setEnabled(false);
        }
        Group groupChooseTester = new Group((Composite)this, 0);
        groupChooseTester.setBackground(SWTResourceManager.getColor(192, 192, 192));
        groupChooseTester.setForeground(SWTResourceManager.getColor(0, 121, 193));
        groupChooseTester.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        groupChooseTester.setText("Instrument");
        groupChooseTester.setBounds(291, 0, 328, 220);
        this.comboSelectSeries = new Combo((Composite)groupChooseTester, 0);
        this.comboSelectSeries.setItems(Tester.getTesterSeriesList());
        this.comboSelectSeries.setToolTipText("Select the HIPOT tester.");
        this.comboSelectSeries.setFont(SWTResourceManager.getFont("Segoe UI", 32, 0));
        this.comboSelectSeries.setBounds(84, 64, 159, 48);
        this.comboSelectSeries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainConfigurationView.this.settings.series = MainConfigurationView.this.comboSelectSeries.getText();
                String[] models = MainConfigurationView.this.settings.switchModelChoices();
                MainConfigurationView.this.comboSwitchModel.setItems(models);
                MainConfigurationView.this.comboSwitchModel.setText(models[0]);
                String[] choices = MainConfigurationView.this.settings.switchTopInterfaceChoices(models[0]);
                MainConfigurationView.this.comboSwitchConnection.setItems(choices);
                MainConfigurationView.this.comboSwitchConnection.setText(choices[0]);
                MainConfigurationView.this.settings.resetSwitches(models[0], choices[0]);
                MainConfigurationView.this.populateSwitchList();
            }
        });
        if (!UserSettings.permissions.create_edit_configuration) {
            this.comboSelectSeries.setEnabled(false);
        }
        Group grpTesterInterface = new Group((Composite)this, 0);
        grpTesterInterface.setToolTipText("Configure the tester interface.");
        grpTesterInterface.setBounds(291, 226, 328, 228);
        grpTesterInterface.setText("Tester Interface");
        grpTesterInterface.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpTesterInterface.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpTesterInterface.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.btnRS232 = new Button((Composite)grpTesterInterface, 16);
        this.btnRS232.setBounds(21, 36, 90, 16);
        this.btnRS232.setText("RS232");
        this.btnRS232.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainConfigurationView.this.lblVerifyPassedIcon.setVisible(false);
                    MainConfigurationView.this.lblVerifyFailedIcon.setVisible(false);
                    MainConfigurationView.this.lblInterfaceErrorText.setVisible(false);
                    MainConfigurationView.this.settings.pc_interface = InterfaceFactory.physical_interface_t.physical_rs232;
                    MainConfigurationView.this.combo_com_ports.setVisible(true);
                    MainConfigurationView.this.combo_baud_rate.setVisible(true);
                    MainConfigurationView.this.ip_address.setVisible(false);
                    MainConfigurationView.this.combo_usb_devices.setVisible(false);
                    MainConfigurationView.this.usb_status_label.setVisible(false);
                    MainConfigurationView.this.lbl_gpib_controller.setVisible(false);
                    MainConfigurationView.this.lbl_gpib_address.setVisible(false);
                    MainConfigurationView.this.tester_gpib_controller.setVisible(false);
                    MainConfigurationView.this.tester_gpib_address.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!this.have_serial_ports.booleanValue()) {
            this.btnRS232.setEnabled(false);
        }
        this.btnEthernet = new Button((Composite)grpTesterInterface, 16);
        this.btnEthernet.setBounds(21, 58, 90, 16);
        this.btnEthernet.setText("Ethernet");
        this.btnEthernet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainConfigurationView.this.lblVerifyPassedIcon.setVisible(false);
                    MainConfigurationView.this.lblVerifyFailedIcon.setVisible(false);
                    MainConfigurationView.this.lblInterfaceErrorText.setVisible(false);
                    MainConfigurationView.this.settings.pc_interface = InterfaceFactory.physical_interface_t.physical_ethernet;
                    MainConfigurationView.this.combo_com_ports.setVisible(false);
                    MainConfigurationView.this.combo_baud_rate.setVisible(false);
                    MainConfigurationView.this.ip_address.setVisible(true);
                    MainConfigurationView.this.combo_usb_devices.setVisible(false);
                    MainConfigurationView.this.lbl_gpib_controller.setVisible(false);
                    MainConfigurationView.this.lbl_gpib_address.setVisible(false);
                    MainConfigurationView.this.tester_gpib_controller.setVisible(false);
                    MainConfigurationView.this.tester_gpib_address.setVisible(false);
                    MainConfigurationView.this.usb_status_label.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnUsb = new Button((Composite)grpTesterInterface, 16);
        this.btnUsb.setBounds(21, 80, 90, 16);
        this.btnUsb.setText("USB");
        this.btnUsb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainConfigurationView.this.lblVerifyPassedIcon.setVisible(false);
                    MainConfigurationView.this.lblVerifyFailedIcon.setVisible(false);
                    MainConfigurationView.this.lblInterfaceErrorText.setVisible(false);
                    MainConfigurationView.this.settings.pc_interface = InterfaceFactory.physical_interface_t.physical_usb;
                    MainConfigurationView.this.usb_status_label.setVisible(true);
                    MainConfigurationView.this.combo_com_ports.setVisible(false);
                    MainConfigurationView.this.combo_baud_rate.setVisible(false);
                    MainConfigurationView.this.ip_address.setVisible(false);
                    MainConfigurationView.this.lbl_gpib_controller.setVisible(false);
                    MainConfigurationView.this.lbl_gpib_address.setVisible(false);
                    MainConfigurationView.this.tester_gpib_controller.setVisible(false);
                    MainConfigurationView.this.tester_gpib_address.setVisible(false);
                    String[] dlist = InterfaceFactory.getUsbDeviceList();
                    if (dlist != null) {
                        MainConfigurationView.this.combo_usb_devices.setItems(dlist);
                        MainConfigurationView.this.combo_usb_devices.setText(dlist[0]);
                        MainConfigurationView.this.combo_usb_devices.setVisible(true);
                        MainConfigurationView.this.combo_usb_devices.setForeground(SWTResourceManager.getColor(0, 0, 0));
                    } else {
                        MainConfigurationView.this.usb_status_label.setText("None found");
                        MainConfigurationView.this.usb_status_label.setVisible(true);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnGpib = new Button((Composite)grpTesterInterface, 16);
        this.btnGpib.setBounds(21, 102, 59, 16);
        this.btnGpib.setText("GPIB");
        this.btnGpib.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    MainConfigurationView.this.lblVerifyPassedIcon.setVisible(false);
                    MainConfigurationView.this.lblVerifyFailedIcon.setVisible(false);
                    MainConfigurationView.this.lblInterfaceErrorText.setVisible(false);
                    MainConfigurationView.this.settings.pc_interface = InterfaceFactory.physical_interface_t.physical_gpib;
                    MainConfigurationView.this.combo_com_ports.setVisible(false);
                    MainConfigurationView.this.combo_baud_rate.setVisible(false);
                    MainConfigurationView.this.ip_address.setVisible(false);
                    MainConfigurationView.this.combo_usb_devices.setVisible(false);
                    MainConfigurationView.this.lbl_gpib_controller.setVisible(true);
                    MainConfigurationView.this.lbl_gpib_address.setVisible(true);
                    MainConfigurationView.this.tester_gpib_controller.setVisible(true);
                    MainConfigurationView.this.tester_gpib_address.setVisible(true);
                    MainConfigurationView.this.usb_status_label.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!InterfaceFactory.haveGpib()) {
            this.btnGpib.setEnabled(false);
        }
        this.combo_com_ports = new Combo((Composite)grpTesterInterface, 8);
        this.combo_com_ports.setBounds(117, 34, 91, 23);
        if (this.have_serial_ports.booleanValue()) {
            this.combo_com_ports.setItems(this.serial_port_list);
        }
        this.combo_baud_rate = new Combo((Composite)grpTesterInterface, 0);
        this.combo_baud_rate.setItems(new String[]{"9600", "19200", "57600", "115200"});
        this.combo_baud_rate.setBounds(220, 34, 91, 23);
        this.combo_baud_rate.setText("115200");
        this.ip_address = new Text((Composite)grpTesterInterface, 2048);
        this.ip_address.setVisible(false);
        this.ip_address.setBounds(117, 58, 91, 21);
        this.ip_address.setText("192.168.1.100");
        this.combo_usb_devices = new Combo((Composite)grpTesterInterface, 8);
        this.combo_usb_devices.setVisible(false);
        this.combo_usb_devices.setBounds(117, 80, 91, 23);
        this.usb_status_label = new Label((Composite)grpTesterInterface, 0);
        this.usb_status_label.setVisible(false);
        this.usb_status_label.setBounds(117, 81, 70, 15);
        this.usb_status_label.setText("Scanning");
        this.lbl_gpib_controller = new Label((Composite)grpTesterInterface, 0);
        this.lbl_gpib_controller.setVisible(false);
        this.lbl_gpib_controller.setBounds(96, 102, 59, 15);
        this.lbl_gpib_controller.setText("Controller");
        this.tester_gpib_controller = new Spinner((Composite)grpTesterInterface, 2048);
        this.tester_gpib_controller.setVisible(false);
        this.tester_gpib_controller.setMaximum(7);
        this.tester_gpib_controller.setMinimum(0);
        this.tester_gpib_controller.setBounds(159, 100, 47, 22);
        this.lbl_gpib_address = new Label((Composite)grpTesterInterface, 0);
        this.lbl_gpib_address.setVisible(false);
        this.lbl_gpib_address.setBounds(217, 102, 47, 15);
        this.lbl_gpib_address.setText("Address");
        this.tester_gpib_address = new Spinner((Composite)grpTesterInterface, 2048);
        this.tester_gpib_address.setVisible(false);
        this.tester_gpib_address.setMaximum(32);
        this.tester_gpib_address.setMinimum(1);
        this.tester_gpib_address.setBounds(270, 100, 41, 22);
        this.lblInterfaceErrorText = new Label((Composite)grpTesterInterface, 0);
        this.lblInterfaceErrorText.setFont(SWTResourceManager.getFont("Segoe UI", 10, 0));
        this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(255, 0, 0));
        this.lblInterfaceErrorText.setBounds(94, 134, 217, 23);
        this.lblInterfaceErrorText.setText("Error");
        this.lblInterfaceErrorText.setVisible(false);
        Button btnVerifyTester = new Button((Composite)grpTesterInterface, 0);
        btnVerifyTester.setFont(SWTResourceManager.getFont("Segoe UI", 14, 0));
        btnVerifyTester.setBounds(21, 166, 75, 41);
        btnVerifyTester.setText("Verify");
        btnVerifyTester.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainConfigurationView.this.lblVerifyPassedIcon.setVisible(false);
                MainConfigurationView.this.lblVerifyFailedIcon.setVisible(false);
                MainConfigurationView.this.lblInterfaceErrorText.setVisible(false);
                final String[] comm_args = new String[2];
                switch (MainConfigurationView.this.settings.pc_interface) {
                    case physical_rs232: {
                        comm_args[0] = MainConfigurationView.this.combo_com_ports.getText();
                        comm_args[1] = MainConfigurationView.this.combo_baud_rate.getText();
                        break;
                    }
                    case physical_ethernet: {
                        comm_args[0] = MainConfigurationView.this.ip_address.getText();
                        break;
                    }
                    case physical_usb: {
                        if (MainConfigurationView.this.combo_usb_devices.getItemCount() > 0) {
                            comm_args[0] = MainConfigurationView.this.combo_usb_devices.getText();
                            break;
                        }
                        comm_args[0] = "000000";
                        break;
                    }
                    case physical_gpib: {
                        comm_args[0] = MainConfigurationView.this.tester_gpib_controller.getText();
                        comm_args[1] = MainConfigurationView.this.tester_gpib_address.getText();
                    }
                }
                MainConfigurationView.this.com_worker = new Thread(){

                    @Override
                    public void run() {
                        MainConfigurationView.this.comm_io = InterfaceFactory.getIo((this).MainConfigurationView.this.settings.pc_interface);
                        if (MainConfigurationView.this.comm_io.open(comm_args) == 0) {
                            MainConfigurationView.this.comm_io.sendCommand("*idn?");
                            final String reply = MainConfigurationView.this.comm_io.getResponse(100);
                            MainConfigurationView.this.comm_io.close();
                            (this).MainConfigurationView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (reply != null) {
                                        String[] f = reply.split(",");
                                        if (f.length >= 3) {
                                            String d = "Model:" + f[1] + " SN:" + f[2];
                                            MainConfigurationView.this.lblVerifyPassedIcon.setVisible(true);
                                            MainConfigurationView.this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(0, 0, 0));
                                            MainConfigurationView.this.lblInterfaceErrorText.setText(d);
                                        } else {
                                            MainConfigurationView.this.lblVerifyFailedIcon.setVisible(true);
                                            MainConfigurationView.this.lblInterfaceErrorText.setText("Reply:" + reply);
                                            MainConfigurationView.this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(255, 0, 0));
                                        }
                                        MainConfigurationView.this.lblInterfaceErrorText.setVisible(true);
                                    } else {
                                        MainConfigurationView.this.lblVerifyFailedIcon.setVisible(true);
                                    }
                                }
                            });
                        } else {
                            (this).MainConfigurationView.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MainConfigurationView.this.lblInterfaceErrorText.setText(MainConfigurationView.this.comm_io.strerror());
                                    MainConfigurationView.this.lblInterfaceErrorText.setForeground(SWTResourceManager.getColor(255, 0, 0));
                                    MainConfigurationView.this.lblInterfaceErrorText.setVisible(true);
                                    MainConfigurationView.this.lblVerifyFailedIcon.setVisible(true);
                                }
                            });
                        }
                    }
                };
                MainConfigurationView.this.com_worker.start();
            }
        });
        if (!UserSettings.permissions.create_edit_configuration) {
            this.btnRS232.setEnabled(false);
            this.btnEthernet.setEnabled(false);
            this.btnUsb.setEnabled(false);
            this.btnGpib.setEnabled(false);
            this.combo_com_ports.setEnabled(false);
            this.combo_baud_rate.setEnabled(false);
            this.ip_address.setEnabled(false);
            this.tester_gpib_address.setEnabled(false);
        }
        if (!UserSettings.permissions.test_communications) {
            btnVerifyTester.setEnabled(false);
        }
        this.lblVerifyPassedIcon = new Label((Composite)grpTesterInterface, 0);
        this.lblVerifyPassedIcon.setImage(SWTResourceManager.getImage("images/ok_pass.png"));
        this.lblVerifyPassedIcon.setBounds(138, 163, 50, 50);
        this.lblVerifyPassedIcon.setVisible(false);
        this.lblVerifyFailedIcon = new Label((Composite)grpTesterInterface, 0);
        this.lblVerifyFailedIcon.setImage(SWTResourceManager.getImage("images/error_fail.png"));
        this.lblVerifyFailedIcon.setBounds(217, 163, 50, 50);
        this.lblVerifyFailedIcon.setVisible(false);
        Group grpSwitchConfiguration = new Group((Composite)this, 0);
        grpSwitchConfiguration.setToolTipText("Configure switches.");
        grpSwitchConfiguration.setText("Switch Matrix Units");
        grpSwitchConfiguration.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpSwitchConfiguration.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpSwitchConfiguration.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpSwitchConfiguration.setBounds(625, 0, 351, 454);
        this.btnEnableSwitches = new Button((Composite)grpSwitchConfiguration, 32);
        this.btnEnableSwitches.setFont(SWTResourceManager.getFont("Segoe UI", 12, 0));
        this.btnEnableSwitches.setBounds(10, 35, 72, 23);
        this.btnEnableSwitches.setText("Enable");
        this.btnEnableSwitches.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainConfigurationView.this.btnEnableSwitches.getSelection()) {
                    MainConfigurationView.this.lblModel.setVisible(true);
                    MainConfigurationView.this.lblConnectedTo.setVisible(true);
                    MainConfigurationView.this.comboSwitchModel.setVisible(true);
                    MainConfigurationView.this.comboSwitchConnection.setVisible(true);
                    MainConfigurationView.this.tableSwitches.setVisible(true);
                    MainConfigurationView.this.btnAddSwitch.setVisible(true);
                    MainConfigurationView.this.btnDeleteSwitch.setVisible(true);
                    MainConfigurationView.this.lblNumSwitches.setVisible(true);
                } else {
                    MainConfigurationView.this.lblModel.setVisible(false);
                    MainConfigurationView.this.lblConnectedTo.setVisible(false);
                    MainConfigurationView.this.comboSwitchModel.setVisible(false);
                    MainConfigurationView.this.comboSwitchConnection.setVisible(false);
                    MainConfigurationView.this.tableSwitches.setVisible(false);
                    MainConfigurationView.this.btnAddSwitch.setVisible(false);
                    MainConfigurationView.this.btnDeleteSwitch.setVisible(false);
                    MainConfigurationView.this.lblNumSwitches.setVisible(false);
                }
            }
        });
        this.lblModel = new Label((Composite)grpSwitchConfiguration, 0);
        this.lblModel.setFont(SWTResourceManager.getFont("Segoe UI", 8, 0));
        this.lblModel.setBounds(95, 22, 55, 15);
        this.lblModel.setText("Model");
        this.lblConnectedTo = new Label((Composite)grpSwitchConfiguration, 0);
        this.lblConnectedTo.setFont(SWTResourceManager.getFont("Segoe UI", 8, 0));
        this.lblConnectedTo.setBounds(209, 22, 72, 15);
        this.lblConnectedTo.setText("Connected to");
        this.comboSwitchModel = new Combo((Composite)grpSwitchConfiguration, 0);
        this.comboSwitchModel.setItems(new String[]{"948i", "964i", "M10x"});
        this.comboSwitchModel.setBounds(95, 40, 95, 23);
        this.comboSwitchModel.setText("964i");
        this.comboSwitchModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.stateMask == 0) {
                    String[] choices = MainConfigurationView.this.settings.switchTopInterfaceChoices(MainConfigurationView.this.comboSwitchModel.getText());
                    MainConfigurationView.this.comboSwitchConnection.setItems(choices);
                    MainConfigurationView.this.comboSwitchConnection.setText(choices[0]);
                    MainConfigurationView.this.settings.resetSwitches(MainConfigurationView.this.comboSwitchModel.getText(), choices[0]);
                    MainConfigurationView.this.populateSwitchList();
                }
            }
        });
        this.comboSwitchConnection = new Combo((Composite)grpSwitchConfiguration, 0);
        this.comboSwitchConnection.setItems(new String[]{"Tester (VICL)", "Tester (RS232)", "Tester (TCP/IP)", "Computer"});
        this.comboSwitchConnection.setToolTipText("Select the switch connection.");
        this.comboSwitchConnection.setBounds(209, 40, 132, 23);
        this.comboSwitchConnection.setText("Tester (VICL)");
        this.comboSwitchConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainConfigurationView.this.settings.resetSwitches(MainConfigurationView.this.comboSwitchModel.getText(), MainConfigurationView.this.comboSwitchConnection.getText());
                MainConfigurationView.this.populateSwitchList();
            }
        });
        this.tableSwitches = new Table((Composite)grpSwitchConfiguration, 68112);
        this.tableSwitches.setBounds(99, 100, 160, 71);
        this.tableSwitches.setHeaderVisible(true);
        this.tableSwitches.setLinesVisible(true);
        this.tableSwitches.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int si = MainConfigurationView.this.tableSwitches.getSelectionIndex();
                if (si != -1 && MainConfigurationView.this.settings.switch_control == switch_control_t.switch_control_computer) {
                    ConfigurationEditSwitch dlog = new ConfigurationEditSwitch(parent.getShell(), MainConfigurationView.this.serial_port_list, MainConfigurationView.this.comboSwitchModel.getText(), si + 1, MainConfigurationView.this.settings.switches[si].pc_interface, MainConfigurationView.this.settings.switches[si].isettings);
                    int dr = dlog.open();
                    if (dr == 32) {
                        MainConfigurationView.this.settings.switches[si].pc_interface = dlog.getInterface();
                        MainConfigurationView.this.settings.switches[si].isettings = dlog.getSettings();
                        MainConfigurationView.this.populateSwitchList();
                    } else if (dr == 127) {
                        MainConfigurationView.this.settings.deleteSwitch(si);
                        MainConfigurationView.this.populateSwitchList();
                    }
                    dlog.close();
                }
            }
        });
        TableColumn tblclmnNum = new TableColumn(this.tableSwitches, 0);
        tblclmnNum.setWidth(40);
        tblclmnNum.setText("#");
        TableColumn tblclmnConnection = new TableColumn(this.tableSwitches, 0);
        tblclmnConnection.setWidth(120);
        tblclmnConnection.setText("Connection");
        this.btnAddSwitch = new Button((Composite)grpSwitchConfiguration, 0);
        this.btnAddSwitch.setBounds(17, 100, 75, 25);
        this.btnAddSwitch.setText("Add");
        this.btnAddSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainConfigurationView.this.settings.addSwitch();
                MainConfigurationView.this.populateSwitchList();
            }
        });
        this.btnDeleteSwitch = new Button((Composite)grpSwitchConfiguration, 0);
        this.btnDeleteSwitch.setBounds(266, 100, 75, 25);
        this.btnDeleteSwitch.setText("Delete");
        this.btnDeleteSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MainConfigurationView.this.settings.switch_control == switch_control_t.switch_control_computer) {
                    int si = MainConfigurationView.this.tableSwitches.getSelectionIndex();
                    if (si != -1) {
                        MainConfigurationView.this.settings.deleteSwitch(si);
                    }
                } else {
                    MainConfigurationView.this.settings.deleteSwitch();
                }
                MainConfigurationView.this.populateSwitchList();
            }
        });
        this.lblNumSwitches = new Label((Composite)grpSwitchConfiguration, 0x1000000);
        this.lblNumSwitches.setText("Switches: 1");
        this.lblNumSwitches.setFont(SWTResourceManager.getFont("Segoe UI", 16, 0));
        this.lblNumSwitches.setBounds(99, 69, 160, 30);
        if (!UserSettings.permissions.create_edit_configuration) {
            grpSwitchConfiguration.setEnabled(false);
        }
        if (!UserSettings.configuration_name.isEmpty()) {
            this.loadConfiguration(UserSettings.configuration_name);
        } else if (this.config_names.length > 0) {
            this.loadConfiguration(this.config_names[0]);
        } else {
            this.loadConfiguration("");
        }
        if (!this.settings.loaded_name.isEmpty()) {
            int ii = Utils.indexOf(this.config_names, this.settings.loaded_name);
            this.tableConfigList.setSelection(ii);
        }
    }

    protected void checkSubclass() {
    }
}

