/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class MainAdminView
extends Composite {
    private Table tableUserList;
    private Table tableProductKeys;
    private Combo levels_combo;
    private Label lblBannerImagePreview;
    private Button btnEditLevel;
    private Button btnAdministration;
    private Button btnCreateEditConfiguration;
    private Button btnTestCommunications;
    private Button btnCreateEditSequences;
    private Button btnSelectConfiguration;
    private Button btnRunTheCommandResponseTool;
    private Button btnSelectSequence;
    private Button btnRunTest;
    private Button btnSaveSequenceInTester;
    private Button btnSendFileToTester;
    private Button btnViewReports;
    private Button btnDeleteReports;
    private String[] access_levels;
    private AccessPermissions perms = new AccessPermissions();
    private AnySql sql = new AnySql(UserSettings.sql_hostname);
    private ArrayList<String[]> user_list;

    private void updatePermissions(String level_name) {
        String[] ps = this.sql.queryColumn("select flags from access_levels where name='" + level_name + "'");
        this.perms.db_decode(ps[0]);
        this.btnAdministration.setSelection(this.perms.allow_admin);
        this.btnCreateEditConfiguration.setSelection(this.perms.create_edit_configuration);
        this.btnTestCommunications.setSelection(this.perms.test_communications);
        this.btnCreateEditSequences.setSelection(this.perms.create_edit_sequences);
        this.btnRunTest.setSelection(this.perms.run_test);
        this.btnSendFileToTester.setSelection(this.perms.send_file_to_tester);
        this.btnRunTheCommandResponseTool.setSelection(this.perms.run_the_command_response_tool);
        this.btnSelectConfiguration.setSelection(this.perms.select_configuration);
        this.btnViewReports.setSelection(this.perms.view_reports);
        this.btnSelectSequence.setSelection(this.perms.select_sequence);
        this.btnSaveSequenceInTester.setSelection(this.perms.save_sequence_in_tester);
        this.btnDeleteReports.setSelection(this.perms.delete_reports);
    }

    private boolean newNameOk(String new_name) {
        if (this.user_list == null) {
            return true;
        }
        if (this.user_list.size() == 0) {
            return true;
        }
        for (String[] n : this.user_list) {
            if (!n[0].equals(new_name)) continue;
            return false;
        }
        return true;
    }

    public MainAdminView(final Composite parent, int style) {
        super(parent, style);
        if (this.sql.open() != 0) {
            MessageBox ed = new MessageBox(parent.getShell(), 33);
            ed.setText("Error");
            ed.setMessage("Cannot open database");
            ed.open();
            return;
        }
        this.access_levels = this.sql.queryColumn("select name from access_levels order by id");
        this.user_list = this.sql.queryRows("select id,name,password,level,default_config,default_sequence from users order by name");
        this.sql.close();
        Group grpUserList = new Group((Composite)this, 2048);
        grpUserList.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpUserList.setText("User List");
        grpUserList.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpUserList.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpUserList.setBounds(10, 0, 258, 454);
        this.tableUserList = new Table((Composite)grpUserList, 68112);
        this.tableUserList.setToolTipText("Add, modify, and delete users.");
        this.tableUserList.setBounds(10, 25, 234, 320);
        this.tableUserList.setHeaderVisible(true);
        this.tableUserList.setLinesVisible(true);
        this.tableUserList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ui = MainAdminView.this.tableUserList.getSelectionIndex();
                if (ui != -1) {
                    AdminEditUser dialog = new AdminEditUser(parent.getShell(), MainAdminView.this.access_levels, (String[])MainAdminView.this.user_list.get(ui));
                    int dr = dialog.open();
                    String user = dialog.getUser();
                    String pw = dialog.getPassword();
                    String level = dialog.getAccessLevel();
                    String cfg = dialog.getConfiguration();
                    String seq = dialog.getSequence();
                    if (dr != 256) {
                        if (dr == 32) {
                            if (AdminEditUser.validatePasswordChoice(pw)) {
                                MainAdminView.this.sql.execute("update users set password='" + pw + "'," + "level='" + level + "'," + "default_config='" + cfg + "'," + "default_sequence='" + seq + "'" + "where name='" + user + "'");
                            } else {
                                MessageBox ed = new MessageBox(parent.getShell(), 40);
                                ed.setText("Information");
                                ed.setMessage("Not a valid password.");
                                ed.open();
                            }
                        } else if (dr == 127) {
                            MainAdminView.this.sql.execute("delete from users where name='" + user + "'");
                        }
                        MainAdminView.this.tableUserList.removeAll();
                        MainAdminView.this.user_list = MainAdminView.this.sql.queryRows("select id,name,password,level,default_config,default_sequence from users order by name");
                        for (String[] n : MainAdminView.this.user_list) {
                            TableItem n_item = new TableItem(MainAdminView.this.tableUserList, 0);
                            n_item.setText(new String[]{n[1], n[3]});
                        }
                    }
                    dialog.close();
                }
            }
        });
        TableColumn tblclmnName = new TableColumn(this.tableUserList, 0);
        tblclmnName.setWidth(149);
        tblclmnName.setText("Name");
        TableColumn tblclmnLevel = new TableColumn(this.tableUserList, 0);
        tblclmnLevel.setWidth(79);
        tblclmnLevel.setText("Level");
        for (String[] n : this.user_list) {
            TableItem n_item = new TableItem(this.tableUserList, 0);
            n_item.setText(new String[]{n[1], n[3]});
        }
        Button btnUserListAdd = new Button((Composite)grpUserList, 0);
        btnUserListAdd.setBounds(74, 372, 100, 25);
        btnUserListAdd.setText("Add");
        btnUserListAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdminEditUser dialog = new AdminEditUser(parent.getShell(), MainAdminView.this.access_levels);
                int dr = dialog.open();
                if (dr == 32) {
                    String user = dialog.getUser();
                    String pw = dialog.getPassword();
                    String level = dialog.getAccessLevel();
                    String cfg = dialog.getConfiguration();
                    String seq = dialog.getSequence();
                    if (AdminEditUser.validateUserNameChoice(user) && AdminEditUser.validatePasswordChoice(pw)) {
                        if (MainAdminView.this.newNameOk(user)) {
                            MainAdminView.this.tableUserList.removeAll();
                            int r = MainAdminView.this.sql.execute("insert into users (name,password,level,default_config,default_sequence) values ('" + user + "'," + "'" + pw + "'," + "'" + level + "'," + "'" + cfg + "'," + "'" + seq + "'" + ")");
                            if (r != 0) {
                                MessageBox ed = new MessageBox(parent.getShell(), 33);
                                ed.setText("Error");
                                ed.setMessage("Cannot add user.");
                                ed.open();
                            }
                            MainAdminView.this.user_list = MainAdminView.this.sql.queryRows("select id,name,password,level,default_config,default_sequence from users order by name");
                            for (String[] n : MainAdminView.this.user_list) {
                                TableItem n_item = new TableItem(MainAdminView.this.tableUserList, 0);
                                n_item.setText(new String[]{n[1], n[3]});
                            }
                        } else {
                            MessageBox ed = new MessageBox(parent.getShell(), 40);
                            ed.setText("Information");
                            ed.setMessage("User name already exists.");
                            ed.open();
                        }
                    } else {
                        MessageBox ed = new MessageBox(parent.getShell(), 40);
                        ed.setText("Information");
                        ed.setMessage("Invalid user name or password.");
                        ed.open();
                    }
                }
                dialog.close();
            }
        });
        Button btnUserListPrint = new Button((Composite)grpUserList, 0);
        btnUserListPrint.setBounds(144, 372, 100, 25);
        btnUserListPrint.setText("Print");
        btnUserListPrint.setVisible(false);
        btnUserListPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Group grpAccessLevels = new Group((Composite)this, 0);
        grpAccessLevels.setToolTipText("View and configure the user levels.");
        grpAccessLevels.setBounds(291, 0, 406, 229);
        grpAccessLevels.setText("Access Levels");
        grpAccessLevels.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpAccessLevels.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpAccessLevels.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.levels_combo = new Combo((Composite)grpAccessLevels, 8);
        this.levels_combo.setToolTipText("Select level to view.");
        this.levels_combo.setBounds(10, 36, 107, 23);
        this.levels_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainAdminView.this.updatePermissions(MainAdminView.this.levels_combo.getText());
                if (MainAdminView.this.levels_combo.getSelectionIndex() >= 3) {
                    MainAdminView.this.btnEditLevel.setVisible(true);
                } else {
                    MainAdminView.this.btnEditLevel.setVisible(false);
                }
            }
        });
        if (this.access_levels.length > 0) {
            this.levels_combo.setItems(this.access_levels);
            this.levels_combo.setText(this.access_levels[0]);
        }
        this.btnAdministration = new Button((Composite)grpAccessLevels, 32);
        this.btnAdministration.setEnabled(false);
        this.btnAdministration.setBounds(10, 80, 121, 16);
        this.btnAdministration.setText("Administration");
        this.btnCreateEditConfiguration = new Button((Composite)grpAccessLevels, 32);
        this.btnCreateEditConfiguration.setEnabled(false);
        this.btnCreateEditConfiguration.setBounds(10, 102, 183, 16);
        this.btnCreateEditConfiguration.setText("Create/Edit Configuration");
        this.btnTestCommunications = new Button((Composite)grpAccessLevels, 32);
        this.btnTestCommunications.setEnabled(false);
        this.btnTestCommunications.setBounds(10, 124, 147, 16);
        this.btnTestCommunications.setText("Test Communications");
        this.btnCreateEditSequences = new Button((Composite)grpAccessLevels, 32);
        this.btnCreateEditSequences.setEnabled(false);
        this.btnCreateEditSequences.setBounds(10, 146, 133, 16);
        this.btnCreateEditSequences.setText("Create/Edit Sequences");
        this.btnSelectConfiguration = new Button((Composite)grpAccessLevels, 32);
        this.btnSelectConfiguration.setEnabled(false);
        this.btnSelectConfiguration.setBounds(10, 168, 147, 16);
        this.btnSelectConfiguration.setText("Select Configuration");
        this.btnRunTheCommandResponseTool = new Button((Composite)grpAccessLevels, 32);
        this.btnRunTheCommandResponseTool.setEnabled(false);
        this.btnRunTheCommandResponseTool.setBounds(10, 190, 204, 16);
        this.btnRunTheCommandResponseTool.setText("Run the Command/Response Tool");
        this.btnSelectSequence = new Button((Composite)grpAccessLevels, 32);
        this.btnSelectSequence.setEnabled(false);
        this.btnSelectSequence.setBounds(245, 80, 121, 16);
        this.btnSelectSequence.setText("Select Sequence");
        this.btnRunTest = new Button((Composite)grpAccessLevels, 32);
        this.btnRunTest.setEnabled(false);
        this.btnRunTest.setBounds(245, 102, 93, 16);
        this.btnRunTest.setText("Run Test");
        this.btnSaveSequenceInTester = new Button((Composite)grpAccessLevels, 32);
        this.btnSaveSequenceInTester.setEnabled(false);
        this.btnSaveSequenceInTester.setBounds(245, 124, 147, 16);
        this.btnSaveSequenceInTester.setText("Save Sequence in Tester");
        this.btnSendFileToTester = new Button((Composite)grpAccessLevels, 32);
        this.btnSendFileToTester.setEnabled(false);
        this.btnSendFileToTester.setBounds(245, 146, 121, 16);
        this.btnSendFileToTester.setText("Send File to Tester");
        this.btnViewReports = new Button((Composite)grpAccessLevels, 32);
        this.btnViewReports.setEnabled(false);
        this.btnViewReports.setBounds(245, 168, 93, 16);
        this.btnViewReports.setText("View Reports");
        this.btnDeleteReports = new Button((Composite)grpAccessLevels, 32);
        this.btnDeleteReports.setEnabled(false);
        this.btnDeleteReports.setBounds(245, 190, 93, 16);
        this.btnDeleteReports.setText("Delete Reports");
        if (this.access_levels.length > 0) {
            this.updatePermissions(this.access_levels[0]);
        }
        Button btnAddLevel = new Button((Composite)grpAccessLevels, 0);
        btnAddLevel.setBounds(148, 34, 42, 25);
        btnAddLevel.setText("Add");
        btnAddLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdminEditAccessLevel dialog = new AdminEditAccessLevel(parent.getShell(), "", null);
                if (dialog.open() == 32) {
                    String name = dialog.getLevelName();
                    String flags = dialog.getAccessFlags();
                    if (name != "") {
                        if (!Arrays.asList(MainAdminView.this.access_levels).contains(name)) {
                            int r = MainAdminView.this.sql.execute("insert into access_levels (name,flags) values ('" + name + "'," + "'" + flags + "'" + ")");
                            if (r != 0) {
                                MessageBox ed = new MessageBox(parent.getShell(), 33);
                                ed.setText("Error");
                                ed.setMessage("Cannot add level.");
                                ed.open();
                            }
                            MainAdminView.this.access_levels = MainAdminView.this.sql.queryColumn("select name from access_levels order by id");
                            if (MainAdminView.this.access_levels.length > 0) {
                                MainAdminView.this.levels_combo.setItems(MainAdminView.this.access_levels);
                                MainAdminView.this.levels_combo.setText(name);
                                MainAdminView.this.updatePermissions(name);
                            }
                        } else {
                            MessageBox ed = new MessageBox(parent.getShell(), 40);
                            ed.setText("Information");
                            ed.setMessage("Level already exists.");
                            ed.open();
                        }
                    } else {
                        MessageBox ed = new MessageBox(parent.getShell(), 40);
                        ed.setText("Information");
                        ed.setMessage("Cannot have a level without a name.");
                        ed.open();
                    }
                }
                dialog.close();
            }
        });
        this.btnEditLevel = new Button((Composite)grpAccessLevels, 0);
        this.btnEditLevel.setBounds(196, 34, 42, 25);
        this.btnEditLevel.setText("Edit");
        this.btnEditLevel.setVisible(false);
        this.btnEditLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdminEditAccessLevel dialog = new AdminEditAccessLevel(parent.getShell(), MainAdminView.this.levels_combo.getText(), MainAdminView.this.perms);
                int dr = dialog.open();
                if (dr == 32) {
                    String flags = dialog.getAccessFlags();
                    int r = MainAdminView.this.sql.execute("update access_levels set flags='" + flags + "' where name='" + MainAdminView.this.levels_combo.getText() + "'");
                    if (r != 0) {
                        MessageBox ed = new MessageBox(parent.getShell(), 33);
                        ed.setText("Error");
                        ed.setMessage("Cannot update level.");
                        ed.open();
                    }
                    MainAdminView.this.updatePermissions(MainAdminView.this.levels_combo.getText());
                } else if (dr == 127) {
                    MainAdminView.this.sql.execute("delete from access_levels where name='" + MainAdminView.this.levels_combo.getText() + "'");
                    MainAdminView.this.access_levels = MainAdminView.this.sql.queryColumn("select name from access_levels order by id");
                    if (MainAdminView.this.access_levels.length > 0) {
                        MainAdminView.this.levels_combo.setItems(MainAdminView.this.access_levels);
                        MainAdminView.this.levels_combo.setText(MainAdminView.this.access_levels[0]);
                        MainAdminView.this.updatePermissions(MainAdminView.this.access_levels[0]);
                    }
                }
                dialog.close();
            }
        });
        Group grpInstrumentKeys = new Group((Composite)this, 0);
        grpInstrumentKeys.setToolTipText("View and configure product keys.");
        grpInstrumentKeys.setText("Registered Keys");
        grpInstrumentKeys.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpInstrumentKeys.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpInstrumentKeys.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpInstrumentKeys.setBounds(718, 0, 258, 229);
        this.tableProductKeys = new Table((Composite)grpInstrumentKeys, 68112);
        this.tableProductKeys.setBounds(10, 24, 175, 185);
        this.tableProductKeys.setHeaderVisible(true);
        this.tableProductKeys.setLinesVisible(true);
        TableColumn tblclmnModel = new TableColumn(this.tableProductKeys, 0);
        tblclmnModel.setWidth(71);
        tblclmnModel.setText("Model");
        TableColumn tblclmnSerialNumber = new TableColumn(this.tableProductKeys, 0);
        tblclmnSerialNumber.setWidth(100);
        tblclmnSerialNumber.setText("Serial #");
        Registration.load();
        ArrayList<Registration.InstrumentKey> keys = Registration.fetch();
        for (Registration.InstrumentKey k : keys) {
            TableItem n_item = new TableItem(this.tableProductKeys, 0);
            if (k.status == 0) {
                n_item.setForeground(SWTResourceManager.getColor(0, 0, 0));
            } else {
                n_item.setForeground(SWTResourceManager.getColor(255, 0, 0));
            }
            n_item.setText(new String[]{k.model, k.serial_number});
        }
        Button btnAddKey = new Button((Composite)grpInstrumentKeys, 0);
        btnAddKey.setBounds(196, 24, 52, 25);
        btnAddKey.setText("Add");
        btnAddKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdminAddKey dialog = new AdminAddKey(parent.getShell());
                if (dialog.open() == 32) {
                    String model = dialog.getModel();
                    String sn = dialog.getSerialNumber();
                    if (model != "" && sn != "") {
                        Registration.add(dialog.getKey(), model, sn);
                        MainAdminView.this.tableProductKeys.removeAll();
                        Registration.load();
                        ArrayList<Registration.InstrumentKey> keys = Registration.fetch();
                        for (Registration.InstrumentKey k : keys) {
                            TableItem n_item = new TableItem(MainAdminView.this.tableProductKeys, 0);
                            if (k.status == 0) {
                                n_item.setForeground(SWTResourceManager.getColor(0, 0, 0));
                            } else {
                                n_item.setForeground(SWTResourceManager.getColor(255, 0, 0));
                            }
                            n_item.setText(new String[]{k.model, k.serial_number});
                        }
                    }
                    dialog.close();
                } else {
                    dialog.close();
                }
            }
        });
        Group grpUserDefaltReportBanner = new Group((Composite)this, 0);
        grpUserDefaltReportBanner.setToolTipText("Configure the default report banner.");
        grpUserDefaltReportBanner.setText("Default Report Banner");
        grpUserDefaltReportBanner.setForeground(SWTResourceManager.getColor(0, 121, 193));
        grpUserDefaltReportBanner.setFont(SWTResourceManager.getFont("Segoe UI", 14, 1));
        grpUserDefaltReportBanner.setBackground(SWTResourceManager.getColor(192, 192, 192));
        grpUserDefaltReportBanner.setBounds(291, 235, 685, 219);
        this.lblBannerImagePreview = new Label((Composite)grpUserDefaltReportBanner, 2052);
        this.lblBannerImagePreview.setBackground(SWTResourceManager.getColor(192, 192, 192));
        this.lblBannerImagePreview.setText("Default Report Banner\r\n910 x 260 pixels recommended");
        this.lblBannerImagePreview.setAlignment(0x1000000);
        this.lblBannerImagePreview.setImage(null);
        this.lblBannerImagePreview.setBounds(5, 40, 670, 170);
        ImageTools.fetchAndDraw("select image from default_banner", this.lblBannerImagePreview);
        Button btnChooseBanner = new Button((Composite)grpUserDefaltReportBanner, 0);
        btnChooseBanner.setBounds(485, 10, 92, 25);
        btnChooseBanner.setText("Choose Banner");
        btnChooseBanner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.png;*.jpg;*.jpeg;*.gif", "*.*"});
                String image_path = dialog.open();
                if (image_path != null) {
                    ImageTools.loadDrawAndSave(image_path, MainAdminView.this.lblBannerImagePreview, "default_banner", "image", "id = 1");
                }
            }
        });
        Button btnDeleteBanner = new Button((Composite)grpUserDefaltReportBanner, 0);
        btnDeleteBanner.setText("Delete Banner");
        btnDeleteBanner.setBounds(583, 10, 92, 25);
        btnDeleteBanner.setForeground(SWTResourceManager.getColor(255, 0, 0));
        btnDeleteBanner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnySql sql = new AnySql(UserSettings.sql_hostname);
                sql.execute("update default_banner set image=NULL where id=1");
                MainAdminView.this.lblBannerImagePreview.setImage(null);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                System.out.println("admin disposing");
                MainAdminView.this.sql.close();
                MainAdminView.this.sql = null;
            }
        });
    }

    protected void checkSubclass() {
    }
}

