/*
 * Decompiled with CFR 0.152.
 */
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginPreferences
extends Dialog {
    protected Shell shl_preferences;
    int exit_code;
    private Text host_name;
    boolean needs_validation;
    boolean connection_bad;
    Label label_status;

    public LoginPreferences(Shell parent, int style) {
        super(parent, style);
        this.setText("SWT Dialog");
        this.needs_validation = false;
        this.connection_bad = false;
    }

    public int open() {
        this.createContents();
        this.exit_code = -1;
        this.shl_preferences.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\u001b') {
                    LoginPreferences.this.exit_code = 256;
                    event.doit = false;
                }
            }
        });
        this.shl_preferences.open();
        this.shl_preferences.layout();
        Display display = this.getParent().getDisplay();
        while (this.exit_code == -1) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.exit_code;
    }

    public void close() {
        this.shl_preferences.dispose();
    }

    public int validate() {
        this.label_status.setText("Checking....");
        int r = AnySql.probe(this.host_name.getText());
        if (r > 0) {
            this.label_status.setText("Validated");
            this.needs_validation = false;
        } else {
            this.label_status.setText("Invalid");
            this.connection_bad = true;
        }
        return r;
    }

    private void createContents() {
        this.shl_preferences = new Shell(this.getParent(), this.getStyle());
        this.shl_preferences.setSize(386, 235);
        this.shl_preferences.setText("Connection Settings");
        Display d = Display.getDefault();
        Point loc = d.getActiveShell().getLocation();
        this.shl_preferences.setLocation(loc.x + 100, loc.y + 100);
        Label lbl_host = new Label((Composite)this.shl_preferences, 0);
        lbl_host.setBounds(26, 10, 41, 15);
        lbl_host.setText("Host:");
        this.host_name = new Text((Composite)this.shl_preferences, 2048);
        this.host_name.setBounds(72, 10, 273, 21);
        this.host_name.addListener(2, new Listener(){

            public void handleEvent(Event e) {
                LoginPreferences.this.label_status.setText("");
                e.doit = false;
                int k = e.stateMask + e.keyCode;
                if (k == 13) {
                    LoginPreferences.this.validate();
                } else {
                    LoginPreferences.this.needs_validation = true;
                }
            }
        });
        Button btnCancel = new Button((Composite)this.shl_preferences, 0);
        btnCancel.setBounds(282, 159, 75, 25);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginPreferences.this.exit_code = 256;
            }
        });
        Button btnOk = new Button((Composite)this.shl_preferences, 0);
        btnOk.setBounds(175, 159, 75, 25);
        btnOk.setText("OK");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LoginPreferences.this.needs_validation) {
                    int r = LoginPreferences.this.validate();
                    if (r > 0) {
                        LoginPreferences.this.exit_code = 32;
                    } else {
                        e.doit = false;
                    }
                } else {
                    LoginPreferences.this.exit_code = 32;
                }
            }
        });
        Button btnValidate = new Button((Composite)this.shl_preferences, 0);
        btnValidate.setBounds(147, 48, 75, 25);
        btnValidate.setText("Validate");
        btnValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginPreferences.this.validate();
            }
        });
        this.label_status = new Label((Composite)this.shl_preferences, 0x1000000);
        this.label_status.setBounds(63, 104, 244, 15);
    }

    public String getHostname() {
        return this.host_name.getText();
    }
}

